/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.util;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.DataSourceType;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.BizDataTypeEnum;
import com.kingdee.eas.base.uict.DataSourceEnum;
import com.kingdee.eas.base.uict.client.BizConfigureTreeNode;
import com.kingdee.eas.base.uict.client.util.BizConfigureHelper;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class UictEntityProxy {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.uict.client.util.UictEntityProxy");
    private BizUnitInfo bizUnit = null;
    private static final String DATA_SOURCE_TYPE = "DataSourceType";
    private static final String DATA_FIELD = "dataField";

    public UictEntityProxy(BizUnitInfo bizUnit) {
        this.bizUnit = bizUnit;
    }

    public PropertyInfo createProperty(BizConfigureItemInfo item, BizConfigureTreeNode node) {
        if (item == null) {
            logger.error((Object)"BizConfigureItemInfo \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521b\u5efa\u5b9e\u4f53\u5c5e\u6027");
            return null;
        }
        if (BizDataTypeEnum.OBJECT.equals((Object)item.getDataType()) && item.getDataSource() != null) {
            LinkPropertyInfo lkprop = this.createLinkProperty(item, node);
            if (lkprop != null) {
                lkprop.setConfigured(true);
            }
            return lkprop;
        }
        OwnPropertyInfo ownprop = this.createOwnProperty(item);
        if (ownprop != null) {
            ownprop.setConfigured(true);
        }
        return ownprop;
    }

    public void updateProperty(BizConfigureItemInfo item) {
        if (item == null) {
            logger.error((Object)"BizConfigureItemInfo \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0\u5b9e\u4f53\u5c5e\u6027");
            return;
        }
        if (BizDataTypeEnum.OBJECT.equals((Object)item.getDataType()) && item.getDataSource() != null) {
            this.updateLinkProperty(item);
        } else {
            this.updateOwnProperty(item);
        }
    }

    private OwnPropertyInfo createOwnProperty(BizConfigureItemInfo item) {
        OwnPropertyInfo prop = new OwnPropertyInfo();
        prop.setName(item.getName());
        item.setPropertyName(prop.getName());
        prop.setDataType(UictEntityProxy.getPropertyType(item.getDataType()));
        prop.getExtendedProperties().put("bizDataType", item.getDataType().getName());
        if (item.getDataType().equals((Object)BizDataTypeEnum.ENUM)) {
            BizEnumInfo bizenum = item.getEnumType();
            if (bizenum == null) {
                logger.error((Object)"!!!!!  bizData has enum type, but without enum info");
                return null;
            }
            prop.setMetadataRef(bizenum.getFullName());
        }
        prop.setPrecision(item.getPrecision());
        prop.setDecimalDigits(item.getScale());
        if (item.getDefaultValue() != null) {
            prop.setDefaultValue(item.getDefaultValue());
        }
        prop.setLength(item.getLength());
        if (item.getMappingField() == null && item.getExtendedFieldInfo() == null) {
            logger.error((Object)"mappingField and extendedFieldInfo is null");
            return null;
        }
        if (item.getMappingField() != null) {
            prop.setMappingField(item.getMappingField());
        } else {
            prop.setExtendedField(item.getExtendedFieldInfo());
        }
        prop.setAlias(item.getAlias() == null ? "" : item.getAlias());
        if (item.getDataSourceType() != null && item.getDataSourceType().equals((Object)DataSourceEnum.BASEDATAEXT)) {
            prop.getExtendedProperties().put(DATA_SOURCE_TYPE, UictEntityProxy.getDataSourceType(item.getDataSourceType()).getName());
            prop.getExtendedProperties().put(DATA_FIELD, item.getDataField());
        }
        if (item.getDataSourceType() != null && (item.getDataSourceType().equals((Object)DataSourceEnum.SELF) || item.getDataSourceType().equals((Object)DataSourceEnum.LIST))) {
            prop.setExtendedProperty("isInCode", "true");
        }
        if (item.getDataSourceType() != null && !item.getDataSourceType().equals((Object)DataSourceEnum.BASEDATA)) {
            prop.setExtendedProperty("isForMapping", "true");
            prop.setExtendedProperty("isForGrouping", "true");
            prop.setExtendedProperty("isForMatching", "true");
        }
        if (DataType.DECIMAL.equals((Object)prop.getDataType()) || DataType.DOUBLE.equals((Object)prop.getDataType()) || DataType.FLOAT.equals((Object)prop.getDataType()) || DataType.INTEGER.equals((Object)prop.getDataType()) || DataType.LONG.equals((Object)prop.getDataType()) || DataType.SHORT.equals((Object)prop.getDataType())) {
            prop.setExtendedProperty("isForWrittenBack", "true");
        }
        prop.setExtendedProperty("enableFieldPermission", String.valueOf(true));
        if (item.isSum() || !StringUtils.isEmpty((String)prop.getExtendedProperty("needSum"))) {
            ConvertUtils.setExtendedPropertyBooelanValue((IObjectValue)prop, (String)"needSum", (boolean)item.isSum());
        }
        return prop;
    }

    private LinkPropertyInfo createLinkProperty(BizConfigureItemInfo item, BizConfigureTreeNode node) {
        EntityObjectInfo entityInfo = null;
        entityInfo = UictEntityProxy.isEntry(node) ? BizConfigureHelper.getSubEntityByComponentInfo(this.bizUnit, (ComponentInfo)node.getUserObject()) : this.bizUnit.getEntity();
        if (entityInfo == null) {
            logger.warn((Object)"DataSource \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521b\u5efa\u5173\u8054\u5c5e\u6027\uff0cin UictEntityProxy createLinkProperty");
            return null;
        }
        LinkPropertyInfo linkprop = new LinkPropertyInfo();
        linkprop.setUserDefined(true);
        if (item.getDataField() != null) {
            linkprop.getExtendedProperties().put(DATA_FIELD, item.getDataField());
        }
        linkprop.setName(item.getName());
        item.setPropertyName(linkprop.getName());
        RelationshipInfo relation = new RelationshipInfo();
        relation.setPackage(this.bizUnit.getEntity().getPackage());
        String relationName = "R_" + entityInfo.getName() + "_" + item.getDataSource().getName() + "_" + item.getName();
        relation.setName(relationName);
        relation.setType(RelationshipType.ASSOCIATION);
        relation.setClientCardinality(CardinalityType.ONE);
        relation.setSupplierCardinality(CardinalityType.ZERO_TO_ONE);
        relation.setClientObject(entityInfo);
        relation.setSupplierObject(item.getDataSource());
        relation.setUserDefined(true);
        linkprop.setRelationship(relation);
        EntityViewInfo defaultView = entityInfo.getDefaultView();
        if (defaultView == null) {
            defaultView = new EntityViewInfo();
            entityInfo.setDefaultView(defaultView);
        }
        if (item.getMappingField() == null && item.getExtendedFieldInfo() == null) {
            logger.error((Object)"mappingField and extendedFieldInfo is null");
            return null;
        }
        if (item.getMappingField() != null) {
            linkprop.setMappingField(item.getMappingField());
        } else {
            linkprop.setExtendedField(item.getExtendedFieldInfo());
        }
        item.setPropertyName(linkprop.getName());
        linkprop.setAlias(item.getAlias() == null ? "" : item.getAlias());
        return linkprop;
    }

    public static DataType getPropertyType(BizDataTypeEnum bizType) {
        DataType dataType = null;
        if (bizType.equals((Object)BizDataTypeEnum.STRING)) {
            dataType = DataType.STRING;
        } else if (bizType.equals((Object)BizDataTypeEnum.DATE)) {
            dataType = DataType.DATE;
        } else if (bizType.equals((Object)BizDataTypeEnum.INTEGER)) {
            dataType = DataType.INTEGER;
        } else if (bizType.equals((Object)BizDataTypeEnum.QUANTITY)) {
            dataType = DataType.DECIMAL;
        } else if (bizType.equals((Object)BizDataTypeEnum.AMOUNT)) {
            dataType = DataType.DECIMAL;
        } else if (bizType.equals((Object)BizDataTypeEnum.PRICE)) {
            dataType = DataType.DECIMAL;
        } else if (bizType.equals((Object)BizDataTypeEnum.NOTE)) {
            dataType = DataType.STRING;
        } else if (bizType.equals((Object)BizDataTypeEnum.BOOLEAN)) {
            dataType = DataType.BOOLEAN;
        } else if (bizType.equals((Object)BizDataTypeEnum.DECIMAL)) {
            dataType = DataType.DECIMAL;
        } else if (bizType.equals((Object)BizDataTypeEnum.IMAGE)) {
            dataType = DataType.BYTEARRAY;
        } else if (bizType.equals((Object)BizDataTypeEnum.ENUM)) {
            dataType = DataType.ENUM;
        } else if (bizType.equals((Object)BizDataTypeEnum.TIME)) {
            dataType = DataType.TIME;
        }
        return dataType;
    }

    private void updateOwnProperty(BizConfigureItemInfo item) {
        OwnPropertyInfo prop = (OwnPropertyInfo)item.getProperty();
        if (prop == null) {
            return;
        }
        prop.getExtendedProperties().put("bizDataType", item.getDataType().getName());
        if (item.getDataType().equals((Object)BizDataTypeEnum.ENUM)) {
            BizEnumInfo bizenum = item.getEnumType();
            if (bizenum == null) {
                logger.error((Object)"!!!!!  bizData has enum type, but without enum info");
                return;
            }
            prop.setMetadataRef(bizenum.getFullName());
            if (!StringUtils.isEmpty((String)item.getDefaultValue()) || !StringUtils.isEmpty((String)prop.getExtendedProperty("defaultValue"))) {
                prop.setExtendedProperty("defaultValue", item.getDefaultValue());
            }
        }
        prop.setPrecision(item.getPrecision());
        prop.setDecimalDigits(item.getScale());
        if (item.getDefaultValue() != null) {
            prop.setDefaultValue(item.getDefaultValue());
        }
        prop.setLength(item.getLength());
        prop.setAlias(item.getAlias() == null ? "" : item.getAlias());
        if (item.getDataSourceType() != null && item.getDataSourceType().equals((Object)DataSourceEnum.BASEDATAEXT)) {
            prop.getExtendedProperties().put(DATA_SOURCE_TYPE, item.getDataSourceType().getName());
            prop.getExtendedProperties().put(DATA_FIELD, item.getDataField());
        }
        prop.setExtendedProperty("ColWidthInKDTable", item.getExtendedProperty("ColWidthInKDTable") == null ? "50" : item.getExtendedProperty("ColWidthInKDTable"));
        prop.setExtendedProperty("enableFieldPermission", String.valueOf(true));
        if (item.isSum() || !StringUtils.isEmpty((String)prop.getExtendedProperty("needSum"))) {
            ConvertUtils.setExtendedPropertyBooelanValue((IObjectValue)prop, (String)"needSum", (boolean)item.isSum());
        }
    }

    private void updateLinkProperty(BizConfigureItemInfo item) {
        LinkPropertyInfo prop = (LinkPropertyInfo)item.getProperty();
        prop.setAlias(item.getAlias());
        if (item.getDataField() != null) {
            prop.getExtendedProperties().put(DATA_FIELD, item.getDataField());
        }
        if (!StringUtils.isEmpty((String)item.getDefaultValue()) || !StringUtils.isEmpty((String)prop.getExtendedProperty("defaultValue"))) {
            prop.setExtendedProperty("defaultValue", item.getDefaultValue());
        }
    }

    public static DataSourceType getDataSourceType(DataSourceEnum type) {
        if (type == null) {
            return DataSourceType.MANAUL;
        }
        if (type.equals((Object)DataSourceEnum.SELF)) {
            return DataSourceType.MANAUL;
        }
        if (type.equals((Object)DataSourceEnum.BASEDATA)) {
            return DataSourceType.BASEDATA;
        }
        if (type.equals((Object)DataSourceEnum.BASEDATAEXT)) {
            return DataSourceType.BASEDATAEXT;
        }
        if (type.equals((Object)DataSourceEnum.LIST)) {
            return DataSourceType.ENUMLIST;
        }
        return DataSourceType.MANAUL;
    }

    private static boolean isEntry(BizConfigureTreeNode node) {
        ComponentInfo component;
        if (node == null) {
            return false;
        }
        return node.getUserObject() instanceof ComponentInfo && "com.kingdee.bos.ctrl.kdf.table.KDTable".equals((component = (ComponentInfo)node.getUserObject()).getClassType());
    }
}

