/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.util;

import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.BizDataTypeEnum;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UictListUIProxy {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.uict.client.util.UictListUIProxy");
    private String dataObjectName = null;
    private ComponentInfo table = null;

    public UictListUIProxy(UIObjectInfo uiModel, ComponentInfo table) {
        if (uiModel != null && table != null) {
            if (uiModel.getDataObjects() != null && uiModel.getDataObjects().size() > 0) {
                this.dataObjectName = uiModel.getDataObjects().get(0).getName();
            }
            this.table = table;
        }
    }

    public void createKDTableProperty(BizConfigureItemInfo item) {
        if (item == null || this.table == null) {
            logger.warn((Object)"BizConfigureItemInfo \u6216 table \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6dfb\u52a0TableProperty");
            return;
        }
        TableInfo tableInfo = null;
        PropertyInfo property = this.table.getProperties().get("formatXml");
        if (property == null) {
            return;
        }
        tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)property.getValue());
        if (tableInfo == null) {
            tableInfo = new TableInfo();
            HeaderInfo headerInfo = new HeaderInfo();
            headerInfo.setName("header");
            tableInfo.addHeader(headerInfo);
        }
        this.addKDTableColumn(tableInfo, item);
        PropertyInfo propInfo = new PropertyInfo();
        propInfo.setName("formatXml");
        propInfo.setType(String.class.getName());
        propInfo.setMultiLanguage(true);
        propInfo.setValue(KDTableDesignerHelper.getXmlFrom((TableInfo)tableInfo));
        this.table.getProperties().add(propInfo);
    }

    public void updateKDTableProperty(BizConfigureItemInfo item) {
        if (item == null || this.table == null) {
            logger.warn((Object)"BizConfigureItemInfo \u6216 table \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0TableProperty");
            return;
        }
        TableInfo tableInfo = null;
        PropertyInfo property = this.table.getProperties().get("formatXml");
        if (property == null) {
            return;
        }
        tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)property.getValue());
        List columns = tableInfo.getColumns();
        String bindFieldName = item.getListItemName();
        Map columnNameMap = this.getColumnNameMap(this.table);
        String columnName = (String)columnNameMap.get(bindFieldName);
        int[] indexs = new int[]{-1};
        ColumnInfo column = UictListUIProxy.findColumn(columns, columnName = StringUtils.isEmpty((String)columnName) ? bindFieldName : columnName, indexs);
        if (column != null) {
            column.setHide(!item.isListVisible());
            column.setWidth(-1);
            if (tableInfo.getHeaderCount() > 0) {
                String cellName;
                HeaderInfo headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
                int columnIndex = columns.indexOf(column);
                if (headerInfo.getCells().size() > columnIndex && !StringUtils.isEmpty((String)(cellName = item.getLabel()))) {
                    ((CellInfo)headerInfo.getCells().get(columnIndex)).setName(cellName);
                }
            }
            PropertyInfo propInfo = new PropertyInfo();
            propInfo.setName("formatXml");
            propInfo.setType(String.class.getName());
            propInfo.setMultiLanguage(true);
            propInfo.setValue(KDTableDesignerHelper.getXmlFrom((TableInfo)tableInfo));
            this.table.getProperties().add(propInfo);
        }
    }

    private void addKDTableColumn(TableInfo tableInfo, BizConfigureItemInfo item) {
        int[] indexs;
        HeaderInfo headerInfo;
        if (this.table == null || tableInfo == null || item == null || StringUtils.isEmpty((String)this.dataObjectName)) {
            return;
        }
        if (tableInfo.getHeaderCount() == 0) {
            headerInfo = new HeaderInfo();
            headerInfo.setName("header");
            tableInfo.addHeader(headerInfo);
        } else {
            headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
        }
        String name = item.getQueryFieldName();
        String tempQueryFieldName = item.getQueryFieldName();
        if (StringUtils.isEmpty((String)tempQueryFieldName)) {
            return;
        }
        String colName = name;
        List columns = tableInfo.getColumns();
        ColumnInfo existCol = UictListUIProxy.findColumn(columns, colName, indexs = new int[]{-1});
        if (existCol != null) {
            tableInfo.removeColumn(existCol);
            if (headerInfo != null && headerInfo.getCellCount() > indexs[0]) {
                headerInfo.removeCell((CellInfo)headerInfo.getCells().get(indexs[0]));
            }
        }
        ColumnInfo column = new ColumnInfo();
        column.setName(colName);
        column.setHide(!item.isListVisible());
        if (item.getDataType() == BizDataTypeEnum.DATE) {
            column.setFormatString("yyyy-M-d");
        } else if (item.getDataType() == BizDataTypeEnum.TIME) {
            column.setFormatString("h:mm:ss");
        }
        item.setListItemName(colName);
        tableInfo.addColumn(column);
        CellInfo cell = new CellInfo();
        String cellName = item.getLabel();
        if (StringUtils.isEmpty((String)cellName)) {
            cell.setName(name);
        } else {
            cell.setName(cellName);
        }
        cell.setColSpan(0);
        cell.setRowSpan(0);
        headerInfo.addCell(cell);
        PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
        propertyBindingInfo.setPropertyName(colName + ".text");
        propertyBindingInfo.setPropertyType(Object.class.getName());
        propertyBindingInfo.setAccessType(2);
        propertyBindingInfo.setAutoMode(false);
        propertyBindingInfo.setBindingObject(this.dataObjectName);
        propertyBindingInfo.setBingdingField(tempQueryFieldName);
        propertyBindingInfo.setFieldType(String.class.getName());
        propertyBindingInfo.setOverride(true);
        this.table.getPropertyBindings().add(propertyBindingInfo);
    }

    public void delKDTableColumn(BizConfigureItemInfo item) {
        if (this.table == null || item == null) {
            return;
        }
        TableInfo tableInfo = null;
        PropertyInfo property = this.table.getProperties().get("formatXml");
        if (property != null) {
            tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)property.getValue());
        }
        if (tableInfo != null) {
            int[] indexs;
            String colName;
            List columns;
            ColumnInfo column;
            HeaderInfo headerInfo = null;
            if (tableInfo.getHeaderCount() != 0) {
                headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
            }
            if ((column = UictListUIProxy.findColumn(columns = tableInfo.getColumns(), colName = item.getListItemName(), indexs = new int[]{-1})) != null) {
                tableInfo.removeColumn(column);
                if (headerInfo != null && headerInfo.getCellCount() > indexs[0]) {
                    logger.info((Object)("\u5220\u9664ListUI\u7684\u5217:" + colName + "..."));
                    headerInfo.removeCell((CellInfo)headerInfo.getCells().get(indexs[0]));
                }
                property.setValue(KDTableDesignerHelper.getXmlFrom((TableInfo)tableInfo));
            }
        }
        this.table.getPropertyBindings().removeObject((Object)(item.getListItemName() + ".text"));
    }

    private static ColumnInfo findColumn(List columns, String columnName, int[] indexs) {
        if (columns == null || columns.isEmpty() || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        ColumnInfo colInfo = null;
        Iterator iter = columns.iterator();
        indexs[0] = -1;
        while (iter.hasNext()) {
            indexs[0] = indexs[0] + 1;
            colInfo = (ColumnInfo)iter.next();
            if (!columnName.equals(colInfo.getName())) continue;
            return colInfo;
        }
        return null;
    }

    public Map getColumnNameMap(ComponentInfo table) {
        HashMap<String, String> pm = new HashMap<String, String>();
        if (table != null) {
            int n = table.getPropertyBindings().size();
            for (int j = 0; j < n; ++j) {
                PropertyBindingInfo pbInfo = table.getPropertyBindings().get(j);
                if (pbInfo.getPropertyName().indexOf(".text") < 0) continue;
                String columnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"");
                String sbindField = pbInfo.getBingdingField();
                pm.put(sbindField, columnName);
            }
        }
        return pm;
    }
}

