/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.query.util.JoinType;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.Token;
import com.kingdee.eas.base.uict.BizConfigureItemInfo;
import com.kingdee.eas.base.uict.BizDataTypeEnum;
import com.kingdee.eas.base.uict.DataSourceEnum;
import com.kingdee.eas.base.uict.client.BizConfigureTreeNode;
import com.kingdee.eas.base.uict.client.util.BizConfigureHelper;
import org.apache.log4j.Logger;

public class UictQueryProxy {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.uict.client.util.UictQueryProxy");
    private BizUnitInfo bizUnit = null;
    private PropertyUnitCollection propCol = null;

    public UictQueryProxy(BizUnitInfo bizUnit) {
        this.bizUnit = bizUnit;
        if (bizUnit != null && bizUnit.getQuery() != null) {
            this.propCol = bizUnit.getQuery().getUnits();
        }
    }

    public void createQueryField(BizConfigureItemInfo item) {
        this.addPropertyUnit(item, this.propCol, this.bizUnit.getEntity(), this.bizUnit.getQuery(), null);
    }

    public void deleteQueryField(BizConfigureItemInfo item) {
        this.deletePropertyUnit(item, this.propCol, this.bizUnit.getQuery());
    }

    public void createEntryQueryField(BizConfigureItemInfo item, BizConfigureTreeNode node) {
        EntityObjectInfo subEntity = BizConfigureHelper.getSubEntityByComponentInfo(this.bizUnit, (ComponentInfo)node.getUserObject());
        this.addPropertyUnit(item, this.propCol, subEntity, this.bizUnit.getQuery(), node.getName());
    }

    public void updateQueryField(BizConfigureItemInfo item) {
        if (item == null || this.bizUnit.getQuery() == null) {
            return;
        }
        PropertyUnitInfo prop = null;
        prop = UictQueryProxy.getPropertyUnitByName(this.propCol, item.getQueryFieldName());
        if (prop != null) {
            String display = "";
            if (!StringUtils.isEmpty((String)item.getLabel())) {
                display = item.getLabel();
            }
            String oldDisplay = prop.getDisplayName();
            if (!"".equals(display) && !display.equals(oldDisplay)) {
                prop.setDisplayName(display);
                logger.info((Object)("change query field display name to '" + display + "'"));
            }
            prop.setIsSelector(item.isListVisible());
        }
    }

    private void addPropertyUnit(BizConfigureItemInfo bf, PropertyUnitCollection propCol, EntityObjectInfo entity, JoinQueryInfo query, String parentName) {
        if (query == null) {
            logger.info((Object)"JoinQueryInfo is null...");
            return;
        }
        QueryFieldInfo prop = null;
        if (BizDataTypeEnum.OBJECT.equals((Object)bf.getDataType())) {
            EntityObjectInfo subEntity = bf.getDataSource();
            String lnkPropertyName = bf.getDataField();
            if (!StringUtils.isEmpty((String)lnkPropertyName)) {
                if (subEntity == null) {
                    logger.error((Object)("BizGroupField: " + bf.getName() + "'s entity is null,Please check BizGroupField!"));
                    return;
                }
                this.addSubEntityToQuery(bf, subEntity, query, parentName);
                LinkPropertyInfo lnkProp = (LinkPropertyInfo)entity.getPropertyByName(bf.getPropertyName());
                String displayName = this.getDisplayName(lnkPropertyName);
                if (!StringUtils.isEmpty((String)displayName)) {
                    QueryFieldInfo field = this.newQueryField(bf, subEntity, (OwnPropertyInfo)subEntity.getPropertyByName(displayName), query, parentName);
                    query.getUnits().add((PropertyUnitInfo)field);
                    if (StringUtils.isEmpty((String)bf.getQueryFieldName())) {
                        bf.setQueryFieldName(field.getName());
                    }
                    if ("false".equalsIgnoreCase(bf.getExtendedProperty("isCommonQueryFilter"))) {
                        field.setExtendedProperty("isCommonQueryFilter", "false");
                    } else {
                        field.setExtendedProperty("isCommonQueryFilter", "true");
                    }
                    if ("false".equalsIgnoreCase(bf.getExtendedProperty("isCommonQuerySorter"))) {
                        field.setExtendedProperty("isCommonQuerySorter", "false");
                    } else {
                        field.setExtendedProperty("isCommonQuerySorter", "true");
                    }
                    if (BizDataTypeEnum.OBJECT.equals((Object)bf.getDataType()) && bf.getDataSource() != null && DataSourceEnum.BASEDATA.equals((Object)bf.getDataSourceType())) {
                        field.setExtendedProperty("isUsingF7", "true");
                    } else {
                        field.setExtendedProperty("isUsingF7", "false");
                    }
                } else {
                    logger.error((Object)"The propertyInfo is not a LinkPropertyInfo!");
                    return;
                }
                this.processJoin(bf, lnkProp, query, parentName, entity);
            }
        } else {
            prop = new QueryFieldInfo((QueryInfo)query);
            prop.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            this.updateQueryField(bf, (PropertyUnitInfo)prop, entity, query, true, parentName);
        }
        if (prop != null) {
            propCol.add((PropertyUnitInfo)prop);
        }
    }

    private void deletePropertyUnit(BizConfigureItemInfo bf, PropertyUnitCollection propCol, JoinQueryInfo query) {
        if (query == null) {
            logger.info((Object)"JoinQueryInfo is null...");
            return;
        }
        if (bf.getDataType() != null && bf.getDataType().equals((Object)BizDataTypeEnum.OBJECT)) {
            this.deleteSubObject(bf, propCol, query);
        } else {
            PropertyUnitInfo prop = null;
            prop = UictQueryProxy.getPropertyUnitByName(propCol, bf.getQueryFieldName());
            if (prop != null) {
                logger.info((Object)("\u5220\u9664QueryField:" + prop.getName() + "..."));
                propCol.remove(prop);
            }
        }
    }

    private void deleteSubObject(BizConfigureItemInfo bf, PropertyUnitCollection fields, JoinQueryInfo query) {
        boolean isDelete = false;
        String subEntityName = bf.getName();
        try {
            int n = query.getSubObjects().size();
            for (int i = 0; i < n; ++i) {
                String fieldName;
                if (!(query.getSubObjects().get(i) instanceof SubEntityInfo) || !bf.getDataType().equals((Object)BizDataTypeEnum.OBJECT) || StringUtils.isEmpty((String)(fieldName = bf.getQueryFieldName())) || !fields.contains(fieldName)) continue;
                isDelete = true;
                subEntityName = fields.get(fieldName).getPropertyRefs().get(0).getSubEntity().getName();
                break;
            }
            if (isDelete) {
                logger.info((Object)("\u5220\u9664Query\u7684SubObject:" + subEntityName + "..."));
                query.removeSubObject(subEntityName);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"BOSException in UictQueryProxy deleteSubObject()", (Throwable)e);
        }
    }

    private SubEntityInfo addSubEntityToQuery(BizConfigureItemInfo bf, EntityObjectInfo entity, JoinQueryInfo query, String parentName) {
        SubEntityInfo subEntity = new SubEntityInfo((QueryInfo)query, entity);
        if (BizDataTypeEnum.OBJECT.equals((Object)bf.getDataType()) && bf.getDataSource() != null) {
            if (parentName != null) {
                subEntity.setName(parentName + "_" + bf.getName());
            } else {
                subEntity.setName(bf.getName());
            }
        }
        if (!query.getSubObjects().contains((SubObjectInfo)subEntity)) {
            query.getSubObjects().add((SubObjectInfo)subEntity);
            return subEntity;
        }
        return null;
    }

    private String getDisplayName(String name) {
        String displayName = "";
        if (!StringUtils.isEmpty((String)name)) {
            int iPos = name.indexOf("+");
            displayName = iPos > 0 ? name.substring(0, iPos).trim() : name;
        }
        return displayName;
    }

    private QueryFieldInfo newQueryField(BizConfigureItemInfo bf, EntityObjectInfo entity, OwnPropertyInfo prop, JoinQueryInfo query, String parentName) {
        if (prop != null) {
            QueryFieldInfo field = new QueryFieldInfo((QueryInfo)query);
            if (this.isMainEntity(entity, query)) {
                field.setName(prop.getName());
            } else if (BizDataTypeEnum.OBJECT.equals((Object)bf.getDataType()) && bf.getDataSource() != null) {
                if (!StringUtils.isEmpty((String)parentName)) {
                    field.setName(parentName + "." + bf.getName() + "." + prop.getName());
                } else {
                    field.setName(bf.getName() + "." + prop.getName());
                }
            } else {
                field.setName(this.findSubEntityName(entity, query) + "." + prop.getName());
            }
            field.setReturnType(QueryUtil.getConstDataType((DataType)prop.getDataType()));
            String disName = bf.getLabel();
            disName = StringUtils.isEmpty((String)disName) ? bf.getAlias() : disName;
            field.setDisplayName(disName);
            field.setFormulaString("#0");
            field.setIsSelector(bf.isListVisible());
            field.setIsFilter(true);
            field.setIsSorter(true);
            field.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            PropertyRefInfo ref = new PropertyRefInfo((PropertyUnitInfo)field, this.getMultiSubEntity(bf.getName(), entity.getName(), query, parentName), entity.getPropertyByName(prop.getName()));
            field.getPropertyRefs().add(ref);
            return field;
        }
        logger.error((Object)"The propertyinfo is not a OwnPropertyInfo!");
        return null;
    }

    private boolean isMainEntity(EntityObjectInfo entity, JoinQueryInfo query) {
        try {
            EntityObjectInfo mainEntity;
            SubObjectInfo subObj = query.getMainObject();
            return subObj instanceof SubEntityInfo && (mainEntity = ((SubEntityInfo)subObj).getEntityRef()) != null && mainEntity.equals((Object)entity);
        }
        catch (Exception e) {
            return false;
        }
    }

    private String findSubEntityName(EntityObjectInfo entity, JoinQueryInfo query) {
        int n = query.getSubObjects().size();
        for (int i = 0; i < n; ++i) {
            SubEntityInfo subEntity;
            if (!(query.getSubObjects().get(i) instanceof SubEntityInfo) || (subEntity = (SubEntityInfo)query.getSubObjects().get(i)).getEntityRef() == null || !subEntity.getEntityRef().equals((Object)entity)) continue;
            return subEntity.getName();
        }
        return entity.getName();
    }

    private void processJoin(BizConfigureItemInfo bf, LinkPropertyInfo lnkProp, JoinQueryInfo query, String parentName, EntityObjectInfo entity) {
        if (lnkProp != null) {
            SubEntityInfo left = this.getSubEntity(lnkProp.getRelationship().getClientObject().getName(), query);
            if (left == null) {
                left = this.addSubEntityToQuery(bf, entity, query, parentName);
            }
            left.setEntityRef(entity);
            SubEntityInfo right = this.getMultiSubEntity(bf.getName(), lnkProp.getRelationship().getSupplierObject().getName(), query, parentName);
            String leftSubEntityName = left.getName();
            String rightSubEntityName = right.getName();
            try {
                JoinType type = this.getJoinType(lnkProp.getRelationship());
                JoinInfo join = query.getJoinWithEntities(left, right, type, lnkProp);
                left.setName(leftSubEntityName);
                right.setName(rightSubEntityName);
                query.getJoins().add(join);
            }
            catch (BOSException e) {
                logger.error((Object)"BOSException in UictQueryProxy processJoin()", (Throwable)e);
            }
        } else {
            logger.error((Object)"The propertyInfo is not a LinkPropertyInfo!");
            return;
        }
    }

    private SubEntityInfo getSubEntity(String subEntityName, JoinQueryInfo query) {
        SubObjectInfo obj = null;
        SubEntityInfo subEntity = null;
        SubEntityInfo returnEntity = null;
        int n = query.getSubObjects().size();
        for (int i = 0; i < n; ++i) {
            EntityObjectInfo entity;
            obj = query.getSubObjects().get(i);
            if (!(obj instanceof SubEntityInfo) || !StringUtils.equalsIgnoreCase((String)(entity = (subEntity = (SubEntityInfo)obj).getEntityRef()).getName().trim(), (String)subEntityName.trim())) continue;
            returnEntity = subEntity;
            break;
        }
        if (returnEntity != null) {
            return returnEntity;
        }
        logger.error((Object)("Can't found SubEntity: [" + subEntityName + "] in Query :" + query.getPackage() + "." + query.getName()));
        return null;
    }

    private SubEntityInfo getMultiSubEntity(String subEntityName, String entityName, JoinQueryInfo query, String parentName) {
        SubObjectInfo obj = null;
        SubEntityInfo subEntity = null;
        SubEntityInfo returnEntity = null;
        String subEntityName1 = subEntityName;
        if (parentName != null) {
            subEntityName1 = parentName + "_" + subEntityName;
        }
        int n = query.getSubObjects().size();
        for (int i = 0; i < n; ++i) {
            obj = query.getSubObjects().get(i);
            if (!(obj instanceof SubEntityInfo)) continue;
            subEntity = (SubEntityInfo)obj;
            EntityObjectInfo entity = subEntity.getEntityRef();
            if (!StringUtils.equalsIgnoreCase((String)subEntity.getName().trim(), (String)subEntityName1.trim()) || !StringUtils.equalsIgnoreCase((String)entity.getName().trim(), (String)entityName.trim())) continue;
            returnEntity = subEntity;
            break;
        }
        if (returnEntity != null) {
            return returnEntity;
        }
        logger.error((Object)("Can't found SubEntity: [" + subEntityName + "] in Query :" + query.getPackage() + "." + query.getName()));
        return null;
    }

    private JoinType getJoinType(RelationshipInfo rel) {
        JoinType type = JoinType.INNERJOIN;
        if (rel.getClientCardinality().equals((Object)CardinalityType.ONE)) {
            if (rel.getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_ONE) || rel.getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) {
                // empty if block
            }
            type = JoinType.LEFTJOIN;
        } else if (rel.getClientCardinality().equals((Object)CardinalityType.ZERO_TO_ONE) || rel.getClientCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) {
            type = JoinType.RIGHTJOIN;
        } else if (rel.getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_ONE)) {
            type = JoinType.LEFTJOIN;
        }
        return type;
    }

    private PropertyUnitInfo updateQueryField(BizConfigureItemInfo bf, PropertyUnitInfo field, EntityObjectInfo entity, JoinQueryInfo query, boolean isNew, String parentName) {
        if (field == null) {
            field = new QueryFieldInfo((QueryInfo)query);
            field.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        }
        if (StringUtils.isEmpty((String)field.getName())) {
            String name = UictQueryProxy.generatePropName(bf, query.getUnits());
            if (this.isMainEntity(entity, query)) {
                field.setName(name);
            } else {
                field.setName(this.findSubEntityName(entity, query) + "." + name);
            }
        }
        if (StringUtils.isEmpty((String)bf.getQueryFieldName())) {
            bf.setQueryFieldName(field.getName());
        }
        ConstDataType type = ConstDataType.STRING;
        if (BizDataTypeEnum.OBJECT.equals((Object)bf.getDataType()) && bf.getDataSource() != null) {
            PropertyInfo prop = bf.getDataSource().getPropertyByName(this.getDisplayName(bf.getDataField()), true);
            if (prop != null && prop instanceof OwnPropertyInfo) {
                type = QueryUtil.getConstDataType((DataType)((OwnPropertyInfo)prop).getDataType());
            }
        } else {
            type = UictQueryProxy.getQueryType(bf.getDataType());
            if (bf.getDataType() == BizDataTypeEnum.ENUM && bf.getEnumType() != null) {
                type = UictQueryProxy.getQueryType(bf.getEnumType().getDataType());
            }
        }
        if (isNew) {
            field.setReturnType(type);
            String disName = bf.getLabel();
            disName = StringUtils.isEmpty((String)disName) ? bf.getAlias() : disName;
            field.setDisplayName(disName);
            if (type == ConstDataType.UNKNOWN) {
                field.setIsSelector(false);
            } else {
                field.setIsSelector(bf.isListVisible());
            }
            field.setIsFilter(true);
            field.setIsSorter(true);
            PropertyRefInfo ref = null;
            field.getPropertyRefs().clear();
            if (BizDataTypeEnum.OBJECT.equals((Object)bf.getDataType()) && bf.getDataSource() != null) {
                String[] data = this.parseStrToDisplayField(bf.getDataField());
                ref = new PropertyRefInfo(field, this.getMultiSubEntity(bf.getName(), bf.getDataSource().getName(), query, parentName), bf.getDataSource().getPropertyByName(data[0].trim(), true));
                field.getPropertyRefs().add(ref);
                if (!StringUtils.isEmpty((String)data[1])) {
                    ref = new PropertyRefInfo(field, this.getMultiSubEntity(bf.getName(), bf.getDataSource().getName(), query, parentName), bf.getDataSource().getPropertyByName(data[1].trim(), true));
                    field.getPropertyRefs().add(ref);
                }
                field.setFormulaString(data[2]);
                field.setExtendedProperty("defaultF7Query", "");
                field.setExtendedProperty("displayFormat", "");
                field.setExtendedProperty("editFormat", "");
                field.setExtendedProperty("commitFormat", "");
            } else {
                SubEntityInfo subEntity = this.getSubEntity(entity.getName(), query);
                if (subEntity == null) {
                    subEntity = this.addSubEntityToQuery(bf, entity, query, parentName);
                }
                ref = new PropertyRefInfo(field, subEntity, entity.getPropertyByName(bf.getPropertyName()));
                field.getPropertyRefs().add(ref);
                field.setFormulaString("#0");
            }
        }
        if ("false".equalsIgnoreCase(bf.getExtendedProperty("isCommonQueryFilter"))) {
            field.setExtendedProperty("isCommonQueryFilter", "false");
        } else {
            field.setExtendedProperty("isCommonQueryFilter", "true");
        }
        if ("false".equalsIgnoreCase(bf.getExtendedProperty("isCommonQuerySorter"))) {
            field.setExtendedProperty("isCommonQuerySorter", "false");
        } else {
            field.setExtendedProperty("isCommonQuerySorter", "true");
        }
        field.setExtendedProperty("isSumField", "false");
        return field;
    }

    public static String generatePropName(BizConfigureItemInfo bf, PropertyUnitCollection propCol) {
        String name = bf.getName();
        PropertyUnitInfo prop = UictQueryProxy.getPropertyUnitByName(propCol, name);
        if (prop != null) {
            int i = 0;
            while (prop != null) {
                name = bf.getName() + i++;
                prop = UictQueryProxy.getPropertyUnitByName(propCol, name);
            }
        }
        return name;
    }

    public static PropertyUnitInfo getPropertyUnitByName(PropertyUnitCollection propCol, String propName) {
        PropertyUnitInfo prop = null;
        int n = propCol.size();
        for (int i = 0; i < n; ++i) {
            if (!propCol.get(i).getName().equals(propName)) continue;
            prop = propCol.get(i);
            break;
        }
        return prop;
    }

    private String[] parseStrToDisplayField(String sDisField) {
        String[] data = new String[3];
        StringBuffer formual = new StringBuffer();
        String strFirst = "";
        String strLeft = "";
        String strSecond = "";
        String strRight = "";
        String strTemp = "";
        if (StringUtils.isEmpty((String)sDisField)) {
            return data;
        }
        int iPos = sDisField.indexOf("+");
        if (iPos > 0) {
            data[0] = strFirst = sDisField.substring(0, iPos).trim();
            formual.append("#0");
            strTemp = sDisField.substring(iPos + 2);
            if (sDisField.trim().length() > iPos && strTemp.trim().length() > 0 && (iPos = strTemp.indexOf("+")) > 0) {
                strLeft = strTemp.substring(0, iPos);
                if (!StringUtils.isEmpty((String)(strLeft = strLeft.replaceAll("\"", "")))) {
                    formual.append(" || '" + strLeft + "'");
                }
                if (strTemp.trim().length() > iPos + 1 && (strTemp = strTemp.substring(iPos + 2)).trim().length() > 0 && (iPos = strTemp.indexOf("+")) > 0) {
                    data[1] = strSecond = strTemp.substring(0, iPos);
                    formual.append(" || #1");
                    if (strTemp.length() > iPos + 1) {
                        strRight = strTemp.substring(iPos + 2);
                        if (!StringUtils.isEmpty((String)(strRight = strRight.replaceAll("\"", "")))) {
                            formual.append(" || '" + strRight + "'");
                        }
                    }
                }
            }
            data[2] = this.replaceFormula(formual.toString(), "||", "&");
        } else {
            data[0] = strFirst = sDisField.trim();
            data[2] = "#0";
        }
        return data;
    }

    private String replaceFormula(String formula, String oldKey, String newKey) {
        Lexer lexer = new Lexer(formula);
        StringBuffer buff = new StringBuffer();
        boolean flag = false;
        try {
            while (true) {
                Token token = lexer.next();
                if (token.type != 12) {
                    if (flag) {
                        buff.append(' ');
                    }
                    if (token.type == 4 && token.value.equals(oldKey)) {
                        buff.append(newKey);
                    } else {
                        token.output(buff);
                    }
                    flag = true;
                    continue;
                }
                break;
            }
        }
        catch (ParserException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        return buff.toString();
    }

    public static ConstDataType getQueryType(BizDataTypeEnum bizType) {
        ConstDataType queryType = null;
        queryType = bizType.equals((Object)BizDataTypeEnum.STRING) ? ConstDataType.STRING : (bizType.equals((Object)BizDataTypeEnum.DATE) ? ConstDataType.DATE : (bizType.equals((Object)BizDataTypeEnum.DECIMAL) ? ConstDataType.NUMBER : (bizType.equals((Object)BizDataTypeEnum.INTEGER) ? ConstDataType.INT : (bizType.equals((Object)BizDataTypeEnum.QUANTITY) ? ConstDataType.NUMBER : (bizType.equals((Object)BizDataTypeEnum.AMOUNT) ? ConstDataType.NUMBER : (bizType.equals((Object)BizDataTypeEnum.PRICE) ? ConstDataType.NUMBER : (bizType.equals((Object)BizDataTypeEnum.NOTE) ? ConstDataType.STRING : (bizType.equals((Object)BizDataTypeEnum.BOOLEAN) ? ConstDataType.BOOLEAN : (bizType.equals((Object)BizDataTypeEnum.OBJECT) ? ConstDataType.OBJECT : (bizType.equals((Object)BizDataTypeEnum.TIME) ? ConstDataType.DATE : ConstDataType.UNKNOWN))))))))));
        return queryType;
    }

    public static ConstDataType getQueryType(BizEnumValueType enumValueType) {
        if (enumValueType == BizEnumValueType.DOUBLE || enumValueType == BizEnumValueType.LONG || enumValueType == BizEnumValueType.FLOAT) {
            return ConstDataType.NUMBER;
        }
        if (enumValueType == BizEnumValueType.INTEGER) {
            return ConstDataType.INT;
        }
        if (enumValueType == BizEnumValueType.STRING) {
            return ConstDataType.STRING;
        }
        return ConstDataType.UNKNOWN;
    }
}

