/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.client.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.engine.difftool.PathsHelper;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.ExtendedTableCollection;
import com.kingdee.bos.metadata.data.ExtendedTableInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.uict.BizDataTypeEnum;
import com.kingdee.eas.base.uict.client.util.UictColumnInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;

public class UictUtils {
    private static Logger logger = Logger.getLogger((String)UictUtils.class.getName());
    public static final String strNull = "null";
    public static final String empty = "";

    public static IBriefViewTreeNode getBaseDataNode(IBriefViewTreeNode root) {
        UictUtils.removeNotBaseDataNode(root);
        return root;
    }

    private static void removeNotBaseDataNode(IBriefViewTreeNode node) {
        if (node != null) {
            IBriefViewTreeNode child = null;
            if (node.getChildCount() > 0) {
                for (int i = node.getChildCount() - 1; i >= 0; --i) {
                    child = (IBriefViewTreeNode)node.getChildAt(i);
                    UictUtils.removeNotBaseDataNode(child);
                    if (child.getChildCount() != 0) continue;
                    if (child.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) {
                        node.remove((MutableTreeNode)child);
                        continue;
                    }
                    MetaDataBriefInfo mdInfo = child.getMetaDataObjectBriefInfo();
                    if (mdInfo != null && mdInfo.getMetaDataPK() != null) continue;
                    node.remove((MutableTreeNode)child);
                }
            }
        }
    }

    public static BizUnitInfo loadBizUnit(IMetaDataPK pk) {
        BizUnitInfo bizUnit = null;
        if (pk != null) {
            try {
                Context ctx = ContextManager.getContext();
                String path = (String)ctx.get((Object)"METADATAPATH");
                ctx.put((Object)"METADATAPATH", (Object)PathsHelper.expandPathstoString((String)path));
                BizUnitCtrl bizUnitCtrl = new BizUnitCtrl(ctx);
                bizUnit = bizUnitCtrl.getValue(pk);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return bizUnit;
    }

    public static EntityObjectInfo loadEntity(IMetaDataPK pk) {
        EntityObjectInfo entity = null;
        if (pk != null) {
            try {
                IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                entity = loader.getEntity(pk);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return entity;
    }

    public static BizEnumInfo loadBizEnum(IMetaDataPK pk) {
        BizEnumInfo bizEnum = (BizEnumInfo)UictUtils.loadMD(MetaDataTypeList.BIZENUM, pk);
        return bizEnum;
    }

    public static FunctionObjectInfo loadFunction(IMetaDataPK pk) {
        FunctionObjectInfo fun = (FunctionObjectInfo)UictUtils.loadMD(MetaDataTypeList.FUNCTION, pk);
        return fun;
    }

    public static QueryInfo loadQuery(IMetaDataPK pk) {
        QueryInfo query = (QueryInfo)UictUtils.loadMD(MetaDataTypeList.BASEQUERY, pk);
        return query;
    }

    public static UIObjectInfo loadUI(IMetaDataPK pk) {
        UIObjectInfo ui = (UIObjectInfo)UictUtils.loadMD(MetaDataTypeList.UIOBJECT, pk);
        return ui;
    }

    public static FacadeInfo loadFacade(IMetaDataPK pk) {
        FacadeInfo fi = (FacadeInfo)UictUtils.loadMD(MetaDataTypeList.FACADE, pk);
        return fi;
    }

    public static PermissionInfo loadPermission(IMetaDataPK pk) {
        PermissionInfo pi = (PermissionInfo)UictUtils.loadMD(MetaDataTypeList.PERMISSION, pk);
        return pi;
    }

    public static IObjectValue loadMD(BOSObjectType type, IMetaDataPK pk) {
        if (pk != null && type != null) {
            try {
                IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                return loader.get(type, pk);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return null;
    }

    public static List getConfigureColumnCollection(DataTableInfo table) {
        ColumnInfo column;
        if (table == null) {
            logger.warn((Object)"DataTableInfo is null,can not get the ColumnCollection");
            return null;
        }
        ArrayList<UictColumnInfo> configure = new ArrayList<UictColumnInfo>();
        ColumnCollection col = table.getColumns();
        int num = 0;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            column = col.get(i);
            if (!column.isConfigured()) continue;
            configure.add(new UictColumnInfo(column, false));
            ++num;
        }
        logger.info((Object)("\u672c\u8868\u6709" + num + "\u4e2a\u9884\u7559\u5b57\u6bb5"));
        ExtendedTableInfo extTable = UictUtils.getConfigureExtendedTable(table);
        if (extTable != null) {
            col = extTable.getColumns();
            num = 0;
            int size2 = col.size();
            for (int j = 0; j < size2; ++j) {
                column = col.get(j);
                if (!column.isConfigured()) continue;
                configure.add(new UictColumnInfo(column, true));
                ++num;
            }
            logger.info((Object)("\u6269\u5c55\u8868\u6709" + num + "\u4e2a\u9884\u7559\u5b57\u6bb5"));
        }
        return configure;
    }

    public static ExtendedTableInfo getConfigureExtendedTable(DataTableInfo table) {
        if (table == null) {
            logger.warn((Object)"DataTableInfo is null");
            return null;
        }
        ExtendedTableCollection tableCol = table.getExtendedTables();
        ExtendedTableInfo extTable = null;
        int size = tableCol.size();
        for (int i = 0; i < size; ++i) {
            extTable = tableCol.get(i);
            String isConfigure = extTable.getExtendedProperty("isConfigureExtendedTable");
            if (!"true".equals(isConfigure)) continue;
            return extTable;
        }
        logger.info((Object)"\u6ca1\u627e\u5230\u9884\u7559\u5b57\u6bb5\u7684\u6269\u5c55\u8868");
        return null;
    }

    public static List getCanUseColumnCollection(EntityObjectInfo entity, BizDataTypeEnum type) {
        if (entity == null) {
            logger.warn((Object)"EntityObjectInfo is null,can not get the ColumnCollection");
            return null;
        }
        List col = UictUtils.getConfigureColumnCollection(entity.getTable());
        if (col == null) {
            return null;
        }
        return UictUtils.getCanUseColumnCollection(entity, col, type);
    }

    public static List getCanUseColumnCollection(EntityObjectInfo entity, List col, BizDataTypeEnum type) {
        if (entity == null || col == null) {
            logger.warn((Object)"EntityObjectInfo or ColumnCollection is null,can not get the ColumnCollection");
            return null;
        }
        ArrayList<UictColumnInfo> canUse = new ArrayList<UictColumnInfo>();
        PropertyCollection pCol = entity.getProperties();
        boolean isUse = false;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            UictColumnInfo uci = (UictColumnInfo)col.get(i);
            isUse = false;
            int size2 = pCol.size();
            for (int j = 0; j < size2; ++j) {
                PropertyInfo pInfo = pCol.get(j);
                if (("F" + StringUtils.headCharUpperCase((String)pInfo.getName())).equalsIgnoreCase(uci.getColumn().getName())) {
                    isUse = true;
                    break;
                }
                if (!("CF" + StringUtils.headCharUpperCase((String)pInfo.getName())).equalsIgnoreCase(uci.getColumn().getName())) continue;
                isUse = true;
                break;
            }
            if (isUse || !UictUtils.isCorrectType(uci.getColumn(), type)) continue;
            canUse.add(uci);
        }
        return canUse;
    }

    private static boolean isCorrectType(ColumnInfo column, BizDataTypeEnum type) {
        if (column == null) {
            return false;
        }
        if (type == null) {
            return true;
        }
        if (BizDataTypeEnum.STRING.equals((Object)type) || BizDataTypeEnum.NOTE.equals((Object)type)) {
            return column.getTypeName().equals((Object)SQLType.NVARCHAR);
        }
        if (BizDataTypeEnum.INTEGER.equals((Object)type) || BizDataTypeEnum.BOOLEAN.equals((Object)type)) {
            return column.getTypeName().equals((Object)SQLType.INT);
        }
        if (BizDataTypeEnum.DECIMAL.equals((Object)type) || BizDataTypeEnum.AMOUNT.equals((Object)type) || BizDataTypeEnum.PRICE.equals((Object)type) || BizDataTypeEnum.QUANTITY.equals((Object)type)) {
            return column.getTypeName().equals((Object)SQLType.NUMERIC);
        }
        if (BizDataTypeEnum.DATE.equals((Object)type)) {
            return column.getTypeName().equals((Object)SQLType.DATETIME);
        }
        if (BizDataTypeEnum.OBJECT.equals((Object)type) || BizDataTypeEnum.ENUM.equals((Object)type)) {
            return column.getTypeName().equals((Object)SQLType.VARCHAR);
        }
        return false;
    }

    public static String delFirstF(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        if (str.indexOf("F") == 0 && str.length() > 1) {
            return str.substring(1, str.length());
        }
        if (str.indexOf("CF") == 0 && str.length() > 2) {
            return str.substring(2, str.length());
        }
        return null;
    }

    public static final String getObjectString(Object obj) {
        if (obj == null) {
            return empty;
        }
        String str = String.valueOf(obj).trim();
        if (str.equals(strNull) || str.length() == 0) {
            str = empty;
        }
        return str;
    }

    public static final HashMap getEaslocaleFromKDMultiLangBox(KDMultiLangBox mlb) {
        HashMap<String, String> ps = new HashMap<String, String>();
        int z = mlb.getItemCount();
        for (int i = 0; i < z; ++i) {
            MultiLangItem mli = (MultiLangItem)mlb.getItemAt(i);
            String key = LangUtil.makeLang((Locale)mli.getLang().getLocale());
            String val = (String)mli.getData();
            ps.put(key, val);
        }
        return ps;
    }
}

