/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe;

import com.kingdee.eas.base.uiframe.ZipFilenameFilter;
import com.kingdee.eas.cp.autoupdater.util.ResourceListGenerator;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class PersonalityUtils {
    private static Logger logger;
    private static final String CLIENTROOT = "user.dir";
    private static final String TEXTFILEName = "userSettingInfo.properties";
    public static String serverDir;
    private static String allRightWord;
    private static Icon imageRights;
    private static boolean bimageRights;
    private static String gUIWelcomeTip;
    private static String portalIndexWelcomeTip;
    private static String portalMainWelcomeTip;
    private static Icon gUILoginLogo;
    private static boolean bGUILoginLogo;
    private static Icon gUIMainLogo;
    private static boolean bGUIMainLogo;

    public static void load(Properties props, InputStream is) throws IOException {
        PersonalityUtils.load(props, new InputStreamReader(is, "UTF-8"));
    }

    public static void load(Properties props, Reader reader) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        String line;
        while ((line = in.readLine()) != null) {
            char firstChar;
            if ((line = StringUtils.trim((String)line)).length() <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
            while (PersonalityUtils.endsWithContinuationMarker(line)) {
                String nextLine = in.readLine();
                line = line.substring(0, line.length() - 1);
                if (nextLine == null) continue;
                line = line + StringUtils.trim((String)nextLine);
            }
            int separatorIndex = line.indexOf("=");
            if (separatorIndex == -1) {
                separatorIndex = line.indexOf(":");
            }
            String key = separatorIndex != -1 ? line.substring(0, separatorIndex) : line;
            String value = separatorIndex != -1 ? line.substring(separatorIndex + 1) : "";
            key = StringUtils.trim((String)key);
            value = StringUtils.trim((String)value);
            props.put(PersonalityUtils.unescape(key), PersonalityUtils.unescape(value));
        }
        return;
    }

    protected static boolean endsWithContinuationMarker(String line) {
        boolean evenSlashCount = true;
        for (int index = line.length() - 1; index >= 0 && line.charAt(index) == '\\'; --index) {
            evenSlashCount = !evenSlashCount;
        }
        return !evenSlashCount;
    }

    protected static String unescape(String str) {
        StringBuffer outBuffer = new StringBuffer(str.length());
        int index = 0;
        while (index < str.length()) {
            char c;
            if ((c = str.charAt(index++)) == '\\') {
                outBuffer.append("\\\\");
                continue;
            }
            outBuffer.append(c);
        }
        return outBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAllRightWord() {
        if (allRightWord == null) {
            String textFileName = System.getProperty(CLIENTROOT).trim() + "/deploy/images/authorizationTip/" + TEXTFILEName;
            Properties p = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(textFileName);
                PersonalityUtils.load(p, in);
                in.close();
                allRightWord = p.getProperty("authorizationInfo");
            }
            catch (Exception e) {
                allRightWord = null;
                logger.error((Object)"error:", (Throwable)e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return allRightWord;
    }

    public static Icon getImageRights() {
        if (!bimageRights) {
            bimageRights = true;
            String imageFileName = System.getProperty(CLIENTROOT).trim() + "/deploy/images/authorizationTip/";
            imageRights = PersonalityUtils.getImage(imageFileName);
        }
        return imageRights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGUIWelcomeTip() {
        if (gUIWelcomeTip == null) {
            String textFileName = System.getProperty(CLIENTROOT).trim() + "/deploy/images/welcomTip/" + TEXTFILEName;
            Properties p = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(textFileName);
                PersonalityUtils.load(p, in);
                in.close();
                gUIWelcomeTip = p.getProperty("guiWelcom");
                if (gUIWelcomeTip == null && (gUIWelcomeTip = p.getProperty("welcom")) == null) {
                    gUIWelcomeTip = "";
                }
            }
            catch (Exception e) {
                gUIWelcomeTip = "";
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return gUIWelcomeTip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPortalIndexWelcomeTip() {
        if (portalIndexWelcomeTip == null) {
            String textFileName = serverDir + "deploy/images/welcomTip/" + TEXTFILEName;
            Properties p = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(textFileName);
                PersonalityUtils.load(p, in);
                in.close();
                portalIndexWelcomeTip = p.getProperty("portalLoginWelcom");
                if (StringUtils.isEmpty((String)portalIndexWelcomeTip) && (portalIndexWelcomeTip = p.getProperty("welcom")) == null) {
                    portalIndexWelcomeTip = "";
                }
            }
            catch (Exception e) {
                portalIndexWelcomeTip = "";
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return portalIndexWelcomeTip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPortalMainWelcomeTip() {
        if (portalMainWelcomeTip == null) {
            String textFileName = serverDir + "deploy/images/welcomTip/" + TEXTFILEName;
            Properties p = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(textFileName);
                PersonalityUtils.load(p, in);
                in.close();
                portalMainWelcomeTip = p.getProperty("portalLoginMainWelcom");
                if (StringUtils.isEmpty((String)portalMainWelcomeTip) && (portalMainWelcomeTip = p.getProperty("welcom")) == null) {
                    portalMainWelcomeTip = "";
                }
            }
            catch (Exception e) {
                portalMainWelcomeTip = "";
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return portalMainWelcomeTip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Icon getImage(String imageFileName) {
        File file = new File(imageFileName);
        if (file.exists() && file.isDirectory()) {
            byte[] bytes;
            block19: {
                ZipFilenameFilter filter = new ZipFilenameFilter();
                File[] zipFile = file.listFiles(filter);
                if (zipFile == null || zipFile.length != 1) {
                    return null;
                }
                imageFileName = zipFile[0].getAbsolutePath();
                ZipFile zFile = null;
                bytes = null;
                int size = 0;
                int read = 0;
                try {
                    zFile = new ZipFile(imageFileName);
                    Enumeration<? extends ZipEntry> e = zFile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry zEntry = e.nextElement();
                        if (zEntry.isDirectory() || zEntry.getName().startsWith("META-INF")) continue;
                        InputStream input = zFile.getInputStream(zEntry);
                        while ((size = input.available()) == 0) {
                        }
                        bytes = new byte[size];
                        int sum = 0;
                        while (true) {
                            byte[] byteTemp;
                            if ((read = input.read(byteTemp = new byte[size], 0, byteTemp.length)) < 0) {
                                break block19;
                            }
                            if (read > size) continue;
                            System.arraycopy(byteTemp, 0, bytes, sum, read);
                            sum += read;
                        }
                    }
                }
                catch (IOException e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
                finally {
                    if (file != null) {
                        file = null;
                    }
                    if (zFile != null) {
                        try {
                            zFile.close();
                        }
                        catch (IOException e) {
                            logger.error((Object)"close zip file error", (Throwable)e);
                        }
                    }
                }
            }
            return new ImageIcon(bytes);
        }
        return null;
    }

    public static Icon getGUILoginLogo() {
        if (!bGUILoginLogo) {
            bGUILoginLogo = true;
            String imageFileName = System.getProperty(CLIENTROOT).trim() + "/deploy/images/guiLogin/";
            gUILoginLogo = PersonalityUtils.getImage(imageFileName);
        }
        return gUILoginLogo;
    }

    public static Icon getGUIMainLogo() {
        if (!bGUIMainLogo) {
            bGUIMainLogo = true;
            String imageFileName = System.getProperty(CLIENTROOT).trim() + "/deploy/images/guiMain/";
            gUIMainLogo = PersonalityUtils.getImage(imageFileName);
        }
        return gUIMainLogo;
    }

    public static boolean hasportalMainLogo() {
        ZipFilenameFilter filter;
        File[] zipFile;
        boolean flag = false;
        String imageFileName = serverDir + "deploy/images/portalMainLogo/";
        File file = new File(imageFileName);
        if (file.exists() && file.isDirectory() && (zipFile = file.listFiles(filter = new ZipFilenameFilter())) != null && zipFile.length >= 1) {
            flag = true;
        }
        return flag;
    }

    public static boolean hasportalMainImage() {
        ZipFilenameFilter filter;
        File[] zipFile;
        boolean flag = false;
        String imageFileName = serverDir + "deploy/images/portalMainImage/";
        File file = new File(imageFileName);
        if (file.exists() && file.isDirectory() && (zipFile = file.listFiles(filter = new ZipFilenameFilter())) != null && zipFile.length >= 1) {
            flag = true;
        }
        return flag;
    }

    public static boolean hasportalLogin() {
        ZipFilenameFilter filter;
        File[] zipFile;
        boolean flag = false;
        String imageFileName = serverDir + "deploy/images/portalLogin/";
        File file = new File(imageFileName);
        if (file.exists() && file.isDirectory() && (zipFile = file.listFiles(filter = new ZipFilenameFilter())) != null && zipFile.length >= 1) {
            flag = true;
        }
        return flag;
    }

    public static boolean hasBizCenter() {
        ZipFilenameFilter filter;
        File[] zipFile;
        boolean flag = false;
        String imageFileName = serverDir + "deploy/images/operationCenter/";
        File file = new File(imageFileName);
        if (file.exists() && file.isDirectory() && (zipFile = file.listFiles(filter = new ZipFilenameFilter())) != null && zipFile.length >= 1) {
            flag = true;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getPortalBizCenter() {
        String textFileName = serverDir + "deploy/images/operationCenter/" + TEXTFILEName;
        String[] tip = new String[3];
        FileInputStream in = null;
        try {
            in = new FileInputStream(textFileName);
            BufferedReader buffer = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
            String line = buffer.readLine();
            boolean isFirstLine = true;
            String bizcenterwellcome = line;
            if (line != null) {
                tip[0] = bizcenterwellcome;
                StringBuffer sb = new StringBuffer();
                String textLine = null;
                while ((textLine = buffer.readLine()) != null) {
                    if (!isFirstLine) {
                        textLine = PersonalityUtils.replaceSpace(textLine);
                    }
                    sb.append(textLine);
                    sb.append("<br>");
                    isFirstLine = false;
                }
                tip[1] = sb.toString();
            } else {
                tip[0] = "false";
            }
        }
        catch (Exception e) {
            tip[0] = "false";
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return tip;
    }

    private static String replaceSpace(String textLine) {
        StringBuffer buff = new StringBuffer();
        while (textLine.startsWith(" ")) {
            textLine = textLine.substring(1);
            buff.append("&nbsp;");
        }
        buff.append(textLine);
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File resourceFileHandler;
        File configFile;
        logger = Logger.getLogger(PersonalityUtils.class);
        serverDir = null;
        String configDir = System.getProperty("portal.config");
        if (configDir != null && (configFile = new File(configDir)).exists() && (resourceFileHandler = new File(configDir = configFile.getParentFile().getAbsolutePath() + "/", ResourceListGenerator.RESOURCESET_FILENAME)).exists()) {
            FileInputStream is = null;
            try {
                Pattern expandPattern;
                Matcher m;
                is = new FileInputStream(resourceFileHandler);
                Properties prop = new Properties();
                prop.load(is);
                serverDir = prop.getProperty("fileserverDir");
                if (serverDir != null && serverDir.indexOf("${EAS_HOME}") >= 0 && System.getProperty("EAS_HOME") != null && (m = (expandPattern = Pattern.compile("\\$\\{([^\\$\\{\\}]*)\\}")).matcher(serverDir)).find()) {
                    serverDir = m.replaceAll(System.getProperty("EAS_HOME"));
                }
            }
            catch (Exception e) {
                logger.error((Object)("load " + ResourceListGenerator.RESOURCESET_FILENAME + " error."), (Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException ex1) {
                    logger.error((Object)"IOException when closing!", (Throwable)ex1);
                }
            }
        }
        allRightWord = null;
        imageRights = null;
        bimageRights = false;
        gUIWelcomeTip = null;
        portalIndexWelcomeTip = null;
        portalMainWelcomeTip = null;
        gUILoginLogo = null;
        bGUILoginLogo = false;
        gUIMainLogo = null;
        bGUIMainLogo = false;
    }
}

