/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.uiframe.ConfigItem;
import com.kingdee.util.SAXBuilderFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPath;

public class XMLConfigUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.util.XMLConfiguration");
    private Document doc;
    private Element root;
    private File file;
    private URL url;

    private XMLConfigUtil(File file) {
        this.file = file;
    }

    private XMLConfigUtil(URL url) {
        this.url = url;
    }

    public static XMLConfigUtil getInstance(File file) throws BOSException {
        if (file == null) {
            throw new BOSException("file is null");
        }
        if (!file.exists()) {
            throw new BOSException("config file " + file.getAbsolutePath() + " not exists.");
        }
        XMLConfigUtil myself = new XMLConfigUtil(file);
        myself.load();
        return myself;
    }

    public static XMLConfigUtil getInstance(URL url) throws BOSException {
        if (url == null) {
            throw new BOSException("url is null");
        }
        XMLConfigUtil myself = new XMLConfigUtil(url);
        myself.load();
        return myself;
    }

    private void load() throws BOSException {
        try {
            if (this.file != null && this.file.exists()) {
                logger.debug((Object)("read config file: " + this.file.getAbsolutePath()));
                SAXBuilder builder = SAXBuilderFactory.create();
                this.doc = builder.build(this.file);
            } else if (this.url != null) {
                logger.debug((Object)("read config from url: " + this.url.getFile()));
                SAXBuilder builder = SAXBuilderFactory.create();
                this.doc = builder.build(this.url);
            } else {
                throw new BOSException("config file not exists");
            }
            this.root = this.doc.getRootElement();
            if (!this.root.getName().equals("config")) {
                throw new BOSException("not a config file,root tag must be 'config'");
            }
        }
        catch (IOException ie) {
            logger.error((Object)ie);
            throw new BOSException("read config error ", (Throwable)ie);
        }
        catch (JDOMException de) {
            throw new BOSException("parse file error ", (Throwable)de);
        }
    }

    public List getConfigItemList() {
        List _els = this.root.getChildren("configitem");
        ArrayList<ConfigItem> children = new ArrayList<ConfigItem>();
        for (int i = 0; _els != null && i < _els.size(); ++i) {
            Element _el = (Element)_els.get(i);
            children.add(new ConfigItem(_el));
        }
        return children;
    }

    public List getAllNodes() {
        ArrayList allNodes = new ArrayList();
        List configItemList = this.getConfigItemList();
        for (int i = 0; i < configItemList.size(); ++i) {
            allNodes.addAll(this.getConfigItemInfo(new ArrayList(), (ConfigItem)configItemList.get(i)));
        }
        return allNodes;
    }

    public List getConfigItemInfo(List entitys, ConfigItem configItem) {
        entitys.add(configItem.item2entity());
        List children = configItem.getChildrenConfigItem();
        if (children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                this.getConfigItemInfo(entitys, (ConfigItem)children.get(i));
            }
        }
        entitys.addAll(configItem.getProperties());
        return entitys;
    }

    public ConfigItem getConfigItem(String name) {
        Element _el = this.getConfigItemElement(this.root, name);
        if (_el != null) {
            return new ConfigItem(_el);
        }
        return null;
    }

    public Element getConfigItemElement(Element el, String name) {
        Element _el = null;
        try {
            _el = (Element)XPath.selectSingleNode((Object)el, (String)("configitem[lower-case(attribute::name)='" + name.toLowerCase() + "']"));
        }
        catch (JDOMException _e) {
            logger.error((Object)"XPath error", (Throwable)_e);
        }
        return _el;
    }
}

