/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe;

import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class XmlConfigParser {
    private static final Logger logger = Logger.getLogger(XmlConfigParser.class);
    private File baseDir;
    private String moduleItemName = "modules";
    private String itemName = "services";
    private Map configItemMap = new HashMap();
    private Set travelFileLog = new HashSet();

    public Map parse(File baseDir, String modulePath, String xmlConfig) {
        this.clear();
        this.baseDir = baseDir;
        this.parse(modulePath, xmlConfig);
        return this.configItemMap;
    }

    protected void parse(String modulePath, String xmlConfig) {
        ConfigurationItem services;
        File xmlFile = new File(this.baseDir, xmlConfig);
        if (!xmlFile.exists()) {
            logger.error((Object)("File [" + xmlFile.toString() + "] is not exists."));
            return;
        }
        if (this.travelFileLog.contains(xmlFile.toString())) {
            return;
        }
        this.travelFileLog.add(xmlFile.toString());
        XMLConfiguration serviceConfig = XMLConfiguration.getInstance((File)xmlFile);
        ConfigurationItem subModules = serviceConfig.getConfigItem(this.moduleItemName);
        if (subModules != null) {
            Map moduleFiles = subModules.getProperties();
            this.travel(modulePath, moduleFiles);
        }
        if ((services = serviceConfig.getConfigItem(this.itemName)) != null) {
            List serviceList = services.getAllChildren();
            this.parseItems(modulePath, serviceList);
        }
    }

    protected void travel(String modulePath, Map moduleFiles) {
        for (Map.Entry entry : moduleFiles.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            String allPath = this.assemblePath(modulePath, key);
            this.parse(allPath, val);
        }
    }

    protected void parseItems(String modulePath, List items) {
        for (int i = 0; items != null && i < items.size(); ++i) {
            ConfigurationItem configItem = (ConfigurationItem)items.get(i);
            String serviceName = configItem.getName();
            Map serviceMap = configItem.getProperties();
            String key = this.assemblePath(modulePath, serviceName);
            this.register(key, serviceMap);
        }
    }

    protected String assemblePath(String path, String nodeName) {
        String result = null;
        result = path == null || "".equals(path) ? nodeName : path + "/" + nodeName;
        return result;
    }

    protected void register(String key, Map val) {
        this.configItemMap.put(key, val);
    }

    protected void clear() {
        this.configItemMap.clear();
        this.travelFileLog.clear();
    }

    public String getModuleItemName() {
        return this.moduleItemName;
    }

    public void setModuleItemName(String moduleItemName) {
        this.moduleItemName = moduleItemName;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }
}

