/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.common.VersionManager;
import com.kingdee.eas.common.client.ClientVersionUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.Base64Encoder;
import org.apache.log4j.Logger;

public class AboutInfoUtil {
    private static final Logger logger = Logger.getLogger(AboutInfoUtil.class);
    public static final String UNKNOWN = "Unknown";

    public static String getBosVersion() {
        String bosversion = UIFrameUtils.getEASOrBOSVersionFromServerAtProperties("BOS", SysContext.getSysContext().getLocale());
        if (bosversion == null) {
            try {
                bosversion = ClientVersionUtil.getCommonLibVersion();
            }
            catch (Exception e) {
                bosversion = UNKNOWN;
            }
        }
        return bosversion;
    }

    public static String getEASversion() {
        String version = UIFrameUtils.getEASOrBOSVersionFromServerAtProperties("EAS", SysContext.getSysContext().getLocale());
        if (null == version) {
            VersionManager vmeas = new VersionManager();
            try {
                version = vmeas.getMetadataVersion();
            }
            catch (Exception e1) {
                version = UNKNOWN;
            }
        }
        System.setProperty("productVersion", version);
        return version;
    }

    public static boolean isOnlyBOS() {
        boolean flag = true;
        String isonlybos = System.getProperty("isOnlyBOS");
        if (null != isonlybos && !"".equals(isonlybos) && "no".equalsIgnoreCase(isonlybos)) {
            flag = false;
        }
        return flag;
    }

    public static String getSerialNum() {
        try {
            return LicenseSrvAgentFactory.getRemoteInstance().getLicenseBaseInfo().getSerialNum();
        }
        catch (LicenseException licenseException) {
            return UNKNOWN;
        }
    }

    public static String getLicenseTo() {
        try {
            return new String(Base64Encoder.base64ToByteArray((String)LicenseSrvAgentFactory.getRemoteInstance().getLicenseBaseInfo().getLicenseTo()), "GBK");
        }
        catch (Exception exception) {
            return UNKNOWN;
        }
    }
}

