/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.uiframe.MyComFunctionFacadeFactory;
import com.kingdee.eas.base.uiframe.SSOToYZJFacadeFactory;
import com.kingdee.eas.base.uiframe.client.AbstractAboutUserUI;
import com.kingdee.eas.base.uiframe.client.BodyUI;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class AboutUserUI
extends AbstractAboutUserUI {
    private static final Logger logger = Logger.getLogger(AboutUserUI.class);
    private boolean isWeiboEnable = false;
    private static final String MAC_OS = "Mac OS";
    private static final String WINDOWS_OS = "Windows";
    private static final String resClassname = "com.kingdee.eas.base.uiframe.CloudHubResource";
    private static final String res = "com.kingdee.eas.base.uiframe.UIFrameResource";

    public AboutUserUI() {
        this.lblShowCloudHub.setEnabled(true);
        this.lblShowCloudHub.setToolTipText(EASResource.getString((String)resClassname, (String)"my") + EASResource.getString((String)resClassname, (String)"cloudHome"));
        this.lblShowCloudHub.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                AboutUserUI.this.ssoToYZJ();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                KDLabel label = (KDLabel)e.getSource();
                label.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                KDLabel label = (KDLabel)e.getSource();
                label.setCursor(new Cursor(0));
            }
        });
        this.lblCloudHubText.setToolTipText(EASResource.getString((String)resClassname, (String)"my") + EASResource.getString((String)resClassname, (String)"cloudHome"));
        this.lblCloudHubText.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                AboutUserUI.this.ssoToYZJ();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                KDLabel label = (KDLabel)e.getSource();
                label.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                KDLabel label = (KDLabel)e.getSource();
                label.setCursor(new Cursor(0));
            }
        });
        boolean isShowCloudHb = AboutUserUI.getIsShowCloudHbParamValue();
        if (!isShowCloudHb) {
            this.cloudHubSeparator.setVisible(false);
            this.lblShowCloudHub.setVisible(false);
            this.lblCloudHubText.setVisible(false);
        }
    }

    private static boolean getIsShowCloudHbParamValue() {
        boolean isShowCloudHb = true;
        try {
            String paramItemValue = ParamManager.getParamValue(null, null, (String)"isShowCloudHub");
            if (!StringUtils.isEmpty((String)paramItemValue)) {
                isShowCloudHb = Boolean.valueOf(paramItemValue);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return isShowCloudHb;
    }

    private String decode(String str) {
        String codeName = System.getProperty("sun.jnu.encoding");
        if (StringUtils.isEmpty((String)codeName)) {
            codeName = "GBK";
        }
        String result = null;
        char[] charbuf = str.toCharArray();
        byte[] bytebuf = new byte[charbuf.length];
        for (int i = 0; i < charbuf.length; ++i) {
            bytebuf[i] = (byte)charbuf[i];
        }
        try {
            result = new String(bytebuf, codeName);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)resClassname, (String)"openCloudHubFail"), (String)ThrowableHelper.toString((Exception)e), (int)0);
            SysUtil.abort();
        }
        return result;
    }

    private boolean isMacOSPlatform() {
        String osname = System.getProperty("os.name");
        return !StringUtils.isEmpty((String)osname) && osname.startsWith(MAC_OS);
    }

    private boolean isWindowsOSPlatform() {
        String osname = System.getProperty("os.name");
        return !StringUtils.isEmpty((String)osname) && osname.startsWith(WINDOWS_OS);
    }

    public void load() {
        this.isWeiboEnable = this.isWeiboEnable();
        this.setWeiboVisible(this.isWeiboEnable);
        this.initDatas();
        UserInfo userInfo = this.getUserInfo();
        this.setUserInfo(userInfo);
        this.refresh();
    }

    private boolean isWeiboEnable() {
        try {
            Class<?> processCenterUtil = Class.forName("com.kingdee.eas.base.weibo.util.WeiboBizUtil");
            Method method = processCenterUtil.getMethod("isWeiboEnable", new Class[0]);
            boolean weiboEnable = (Boolean)method.invoke(null, new Object[0]);
            String weiboId = null;
            if (weiboEnable) {
                weiboId = this.getWeiboId(this.getPersonId(this.getUserInfo()));
            }
            return weiboEnable && weiboId != null;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
    }

    private String getPersonId(UserInfo userInfo) {
        return userInfo.getPerson().getId().toString();
    }

    private String getWeiboId(String personId) {
        if (personId == null) {
            return null;
        }
        String weiboId = null;
        try {
            Class<?> processCenterUtil = Class.forName("com.kingdee.eas.base.weibo.util.WeiboBizUtil");
            Method method = processCenterUtil.getMethod("getLocalWeiboIdByPersonId", String.class);
            weiboId = (String)method.invoke(null, personId);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return weiboId;
    }

    private void setWeiboVisible(boolean isVisible) {
        this.weiboTitle.setVisible(isVisible);
        this.lblWeiboLine.setVisible(isVisible);
        this.lblMyJoin.setVisible(isVisible);
        this.lblMySay.setVisible(isVisible);
        this.lblMyJoinNum.setVisible(isVisible);
        this.mySay.setVisible(isVisible);
    }

    private void initDatas() {
        this.undisposeTask.setText("0");
        this.unReadNotice.setText("0");
        this.onlineNotice.setText("0");
        this.lblMyJoinNum.setText("0");
        this.mySay.setText("0");
    }

    private UserInfo getUserInfo() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    protected int[] getMessageCounts() {
        int[] counts = new int[]{0, 0, 0, 0, 0, 0, 0};
        try {
            Class<?> messageCenterFactory = Class.forName("com.kingdee.eas.base.message.MessageCenterFactory");
            Method method = messageCenterFactory.getMethod("getRemoteInstance", new Class[0]);
            Object o = method.invoke(null, new Object[0]);
            Class<?> iMessageCenter = Class.forName("com.kingdee.eas.base.message.IMessageCenter");
            Method method2 = iMessageCenter.getMethod("getMessageCenterCounts", Boolean.TYPE);
            Method method3 = iMessageCenter.getMethod("isOrg", new Class[0]);
            boolean isOrg = (Boolean)method3.invoke(o, new Object[0]);
            counts = (int[])method2.invoke(o, isOrg);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return counts;
    }

    protected Map getWeiBoCounts() {
        Map unread = null;
        try {
            Class<?> processCenterUtil = Class.forName("com.kingdee.eas.base.weibo.util.WeiboBizUtil");
            Method method1 = processCenterUtil.getMethod("getUserAllUnread", String.class);
            unread = (Map)method1.invoke(null, "4");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return unread;
    }

    private void setUserInfo(UserInfo userInfo) {
        this.setUserPhotoData(this.getUserPhoto(userInfo.getId().toString()));
    }

    private void setUserPhotoData(Icon icon) {
        if (icon == null) {
            this.userImage.setIcon(EASResource.getIcon((String)"personPhoto"));
        } else {
            this.userImage.setIcon(icon);
        }
    }

    private Icon getUserPhoto(String userId) {
        try {
            byte[] photo = MyComFunctionFacadeFactory.getRemoteInstance().getPersonPhoto(userId);
            if (photo != null && photo.length > 0) {
                ByteArrayInputStream input = new ByteArrayInputStream(photo);
                BufferedImage srcImage = ImageIO.read(input);
                boolean isStartSHR = NewOrgUnitFacadeFactory.getRemoteInstance().isStartSHR();
                Image destImage = isStartSHR ? srcImage.getScaledInstance(62, 84, 4) : srcImage.getScaledInstance(62, 62, 4);
                return new ImageIcon(destImage);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    private void setMessageCenterData(int[] counts) {
        int undisposeTaskCount = 0;
        int unReadNoticeCount = 0;
        int onlineNoticeCount = 0;
        if (counts != null && counts.length >= 5) {
            undisposeTaskCount = counts[0];
            unReadNoticeCount = counts[2];
            onlineNoticeCount = counts[4];
        }
        this.undisposeTask.setText("" + undisposeTaskCount);
        this.unReadNotice.setText("" + unReadNoticeCount);
        this.onlineNotice.setText("" + onlineNoticeCount);
        this.undisposeTask.repaint();
        this.unReadNotice.repaint();
        this.onlineNotice.repaint();
    }

    private void setWeiboData(Map unread) {
        if (unread == null) {
            this.lblMyJoinNum.setText("0");
            this.mySay.setText("0");
        } else {
            this.lblMyJoinNum.setText("" + unread.get("unreadParticipateCount"));
            this.mySay.setText("" + unread.get("unreadSubscribeCount"));
        }
        this.lblMyJoinNum.repaint();
        this.mySay.repaint();
    }

    @Override
    protected void newMouseClicked(MouseEvent e) {
        Object o = e.getSource();
        if (ToolUtils.equalObject((Object)o, (Object)((Object)this.undisposeTask)) || ToolUtils.equalObject((Object)o, (Object)((Object)this.lblUndisposeTask))) {
            this.openMessageCenterUI(0);
        } else if (ToolUtils.equalObject((Object)o, (Object)((Object)this.unReadNotice)) || ToolUtils.equalObject((Object)o, (Object)((Object)this.lblUnReadNotice))) {
            this.openMessageCenterUI(1);
        } else if (ToolUtils.equalObject((Object)o, (Object)((Object)this.onlineNotice)) || ToolUtils.equalObject((Object)o, (Object)((Object)this.lblOnlineNotice))) {
            this.openMessageCenterUI(2);
        } else if (ToolUtils.equalObject((Object)o, (Object)((Object)this.lblMyJoinNum)) || ToolUtils.equalObject((Object)o, (Object)((Object)this.lblMyJoin))) {
            this.gotoSite(this.getWeiboMyJoinUrl());
        } else if (ToolUtils.equalObject((Object)o, (Object)((Object)this.mySay)) || ToolUtils.equalObject((Object)o, (Object)((Object)this.lblMySay))) {
            this.gotoSite(this.getWeiboMySendUrl());
        }
    }

    private void openMessageCenterUI(int target) {
        BodyUI bodyUI = this.getBodyUI();
        if (bodyUI == null) {
            return;
        }
        bodyUI.openMessgeCenterUI(1);
        Component component = bodyUI.getMessageComponent(1);
        if (StringUtils.equals((String)"com.kingdee.eas.base.message.client.MessageCenterUI", (String)component.getClass().getName())) {
            try {
                Class<?> messageCenterUI = Class.forName("com.kingdee.eas.base.message.client.MessageCenterUI");
                Method method = messageCenterUI.getMethod("locateDefaultNode", Integer.TYPE, Integer.TYPE);
                method.invoke((Object)component, target, -1);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        bodyUI.setCurTabIndex(1);
    }

    private BodyUI getBodyUI() {
        Container parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof BodyUI); parent = parent.getParent()) {
        }
        return (BodyUI)((Object)parent);
    }

    private String getWeiboMyJoinUrl() {
        try {
            Class<?> processCenterUtil = Class.forName("com.kingdee.eas.base.weibo.util.WeiboBizUtil");
            Method method = processCenterUtil.getMethod("getWeiboMySendUrl", String.class);
            String url = (String)method.invoke(null, "4");
            return url;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    private String getWeiboMySendUrl() {
        try {
            Class<?> processCenterUtil = Class.forName("com.kingdee.eas.base.weibo.util.WeiboBizUtil");
            Method method = processCenterUtil.getMethod("getWeiboFocusUrl", String.class);
            String url = (String)method.invoke(null, "4");
            return url;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    private void gotoSite(String url) {
        if (url == null) {
            return;
        }
        FrameWorkUtils.openByDefaultBrowser((String)url);
    }

    public void refresh() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AboutUserUI.this.setMessageCenterData(AboutUserUI.this.getMessageCounts());
                if (AboutUserUI.this.isWeiboEnable) {
                    AboutUserUI.this.setWeiboData(AboutUserUI.this.getWeiBoCounts());
                }
            }
        };
        new Thread(runnable).start();
    }

    private void ssoToYZJ() {
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        try {
            Map ssoUrlMap = SSOToYZJFacadeFactory.getRemoteInstance().getSSOUrl(user.getId().toString());
            if (Boolean.valueOf(ssoUrlMap.get("success").toString()).booleanValue()) {
                try {
                    URI browseUri = null;
                    Desktop dp = Desktop.getDesktop();
                    String ssoLoginUrl = ssoUrlMap.get("ssoLoginUrl").toString();
                    browseUri = URI.create(ssoLoginUrl);
                    dp.browse(browseUri);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    MsgBox.showError((String)ssoUrlMap.get("errorMsg").toString());
                }
            } else {
                MsgBox.showError((String)ssoUrlMap.get("errorMsg").toString());
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
            MsgBox.showError((String)EASResource.getString((String)res, (String)"GET_LOGIN_ERROR"));
        }
        catch (BOSException e1) {
            e1.printStackTrace();
            MsgBox.showError((String)EASResource.getString((String)res, (String)"GET_LOGIN_ERROR"));
        }
    }
}

