/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.base.uiframe.client.BillDoublePanel;
import com.kingdee.eas.base.uiframe.client.ImagePanel;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

abstract class AbstractMyConcernBillPanel
extends ImagePanel {
    private static final String RESOURCE = "com.kingdee.eas.base.uiframe.client.WorkBenchResource";
    protected static final int BILL_HGAP = 30;
    protected static final int BILL_VGAP = 15;
    protected KDPanel billPanel;
    protected KDPanel billPagePanel;
    protected KDLabel billTitleLabel;

    public AbstractMyConcernBillPanel() {
        this.jbInit();
        this.initUIContentLayout();
    }

    private void jbInit() {
        this.billPanel = new KDPanel();
        this.billPagePanel = new KDPanel();
        this.billTitleLabel = new KDLabel();
        this.billPanel.setName("billPanel");
        this.billPagePanel.setName("billPagePanel");
        this.billTitleLabel.setName("billTitleLabel");
        this.billTitleLabel.setText(EASResource.getString((String)RESOURCE, (String)"concernBill"));
        this.billTitleLabel.setHorizontalAlignment(2);
        this.billTitleLabel.setVerticalAlignment(0);
        this.billTitleLabel.setHorizontalTextPosition(4);
        this.billTitleLabel.setFont(new Font(null, 1, 13));
        this.billTitleLabel.setForeground(new Color(77, 80, 82));
        this.billPagePanel.setBackground(new Color(240, 242, 244));
        this.billPanel.setBackground(new Color(240, 242, 244));
    }

    private void initUIContentLayout() {
        this.setBgImage(EASResource.getImage((String)"the_concernbill"));
        this.setCustomInsets(new Insets(6, 6, 30, 6));
        this.setLayout(new BorderLayout());
        this.add((Component)this.billTitleLabel, "North");
        this.add((Component)this.billPanel, "Center");
        this.add((Component)this.billPagePanel, "South");
        this.billTitleLabel.setPreferredSize(new Dimension(150, 30));
        this.billPagePanel.setPreferredSize(new Dimension(100, 20));
        this.billPagePanel.setLayout((LayoutManager)new FlowLayout(1, 5, 2));
        this.billPanel.setCustomInsets(new Insets(0, 0, 0, 0));
        this.billPanel.setLayout((LayoutManager)new FlowLayout(0, 30, 15));
    }

    protected abstract void removeBill(BillDoublePanel var1);

    class BillDoublePanelMouseMotionListener
    extends MouseMotionAdapter {
        BillDoublePanelMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.newMouseMoved(e);
        }

        private void newMouseMoved(MouseEvent e) {
            Component c = (Component)e.getSource();
            BillDoublePanel pane = (BillDoublePanel)((Object)c.getParent());
            JButton button = pane.getButton();
            Point p2Source = e.getPoint();
            Point p2Button = SwingUtilities.convertPoint(c, p2Source, pane.getButton());
            if (p2Button.x > 0 && p2Button.y > 0 && p2Button.x < button.getWidth() && p2Button.y < button.getHeight()) {
                pane.getSurfaceLabel().setToolTipText(EASResource.getString((String)AbstractMyConcernBillPanel.RESOURCE, (String)"remove"));
                pane.getBillLabelContainer().setEnteredButton(true);
                pane.setCursor(new Cursor(12));
            } else {
                pane.getSurfaceLabel().setToolTipText(pane.getText());
                pane.getBillLabelContainer().setEnteredButton(false);
                pane.setCursor(new Cursor(0));
            }
            pane.repaint();
        }
    }

    class BillDoublePanelMouseListener
    extends MouseAdapter {
        BillDoublePanelMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.newMouseClicked(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.newMouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.newMouseExited(e);
        }

        private void newMouseClicked(MouseEvent e) {
            Component c = (Component)e.getSource();
            BillDoublePanel pane = (BillDoublePanel)((Object)c.getParent());
            JButton button = pane.getButton();
            Point p2Source = e.getPoint();
            Point p2Button = SwingUtilities.convertPoint(c, p2Source, pane.getButton());
            if (p2Button.x > 0 && p2Button.y > 0 && p2Button.x < button.getWidth() && p2Button.y < button.getHeight()) {
                AbstractMyConcernBillPanel.this.removeBill(pane);
            }
        }

        private void newMouseEntered(MouseEvent e) {
            Component c = (Component)e.getSource();
            BillDoublePanel pane = (BillDoublePanel)((Object)c.getParent());
            pane.getBillLabelContainer().setButtonVisible(true);
            pane.getButton().setVisible(true);
            pane.getBillLabelContainer().setMouseEntered(true);
            pane.getBillLabelContainer().revalidate();
            pane.getBillLabelContainer().repaint();
        }

        private void newMouseExited(MouseEvent e) {
            Component c = (Component)e.getSource();
            BillDoublePanel pane = (BillDoublePanel)((Object)c.getParent());
            pane.getButton().setVisible(false);
            pane.getBillLabelContainer().setButtonVisible(false);
            pane.getBillLabelContainer().setMouseEntered(false);
            pane.getBillLabelContainer().revalidate();
            pane.getBillLabelContainer().repaint();
        }
    }
}

