/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.uiframe.client.ListUIObjectProxy;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.TabbedChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.InputMap;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AppletBodyUI
extends KDPanel {
    KDTabbedPane tabbedPane = new KDTabbedPane();
    IUIObject curUIObject = null;
    ListUIObjectProxy mgr = null;

    public AppletBodyUI(ListUIObjectProxy mgr) {
        this.mgr = mgr;
        this.jbInit();
    }

    public int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public int getCurTabIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    public void changeTab() {
        this.tabbedPane_stateChanged(null);
    }

    public void setCurTabIndex(int index) {
        this.tabbedPane.setSelectedIndex(index);
        this.tabbedPane.validate();
    }

    public void addTab(IUIObject uiObject, int index) {
        this.tabbedPane.add((Component)uiObject.getUIContentPane(), index);
        this.tabbedPane.setTitleAt(index, uiObject.getUITitle());
    }

    public void addTab(IUIObject uiObject) {
        this.tabbedPane.add((Component)uiObject.getUIContentPane());
        this.tabbedPane.setTitleAt(this.tabbedPane.getTabCount() - 1, uiObject.getUITitle());
    }

    public void removeTab(IUIObject uiObject) {
        this.tabbedPane.remove((Component)uiObject.getUIContentPane());
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.tabbedPane.setViewStyle(2);
        this.tabbedPane.addCloseActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IUIObject uiObject = (IUIObject)AppletBodyUI.this.tabbedPane.getSelectedComponent();
                uiObject.getUIWindow().close();
            }
        });
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AppletBodyUI.this.tabbedPane_stateChanged(e);
            }
        });
        this.add((Component)this.tabbedPane, "Center");
        this.resetNavigateKey();
    }

    private void resetNavigateKey() {
        InputMap inputMap = this.tabbedPane.getInputMap(2);
        if (inputMap == null) {
            return;
        }
        KeyStroke ksUp = KeyStroke.getKeyStroke(33, 2, false);
        KeyStroke ksDown = KeyStroke.getKeyStroke(34, 2, false);
        if (inputMap.get(ksUp) != null) {
            inputMap.remove(ksUp);
        }
        if (inputMap.get(ksDown) != null) {
            inputMap.remove(ksDown);
        }
        inputMap.put(ksUp, "navigatePageUp");
        inputMap.put(ksDown, "navigatePageDown");
    }

    private void tabbedPane_stateChanged(ChangeEvent e) {
        IUIObject oldUIObject = this.curUIObject;
        if (this.tabbedPane.getTabCount() <= this.tabbedPane.getSelectedIndex() || this.tabbedPane.getSelectedIndex() < 0) {
            return;
        }
        this.curUIObject = (IUIObject)this.tabbedPane.getComponentAt(this.tabbedPane.getSelectedIndex());
        if (this.curUIObject == null) {
            return;
        }
        if (oldUIObject instanceof CoreUI) {
            Set oldListenerList = ((CoreUI)oldUIObject).getTabbedChangeListenerList();
            for (TabbedChangeListener oldListener : oldListenerList) {
                oldListener.exitTab();
            }
        }
        if (this.curUIObject instanceof CoreUI) {
            Set curListenerList = ((CoreUI)this.curUIObject).getTabbedChangeListenerList();
            for (TabbedChangeListener curListener : curListenerList) {
                curListener.enterTab();
            }
        }
        this.mgr.getApplet().getRootPane().setMenuBar((JMenuBar)this.curUIObject.getUIMenuBar());
        this.mgr.getToolBar().removeAll();
        if (this.curUIObject.getUIToolBar() != null) {
            this.mgr.getToolBar().add((Component)this.curUIObject.getUIToolBar(), (Object)"Center");
        }
        this.mgr.getStatusBar().removeAll();
        if (this.curUIObject.getStatusBar() != null) {
            this.mgr.getStatusBar().add((Component)this.curUIObject.getStatusBar(), (Object)"Center");
        }
        this.mgr.getStatusBar().repaint();
    }

    public void resetUI() {
        this.mgr.resetUI();
    }
}

