/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.event.TabbedPaneCloseAllTabListener;
import com.kingdee.bos.framework.cache.UIActionMonitor;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.license.ControlPolicy;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.uiframe.client.LoginHelper;
import com.kingdee.eas.base.uiframe.client.MainMenuEditUI;
import com.kingdee.eas.base.uiframe.client.MainStatusBar;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.base.uiframe.client.UISysTabFactory;
import com.kingdee.eas.base.uiframe.client.ui.IMainUIObject;
import com.kingdee.eas.base.uiframe.client.ui.gpt.ChatgptUI;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.basedata.org.MultiOrgSwitchUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.TabbedChangeListener;
import com.kingdee.eas.framework.client.uisidebar.NewTabbedChangeListener;
import com.kingdee.eas.framework.client.uisidebar.TabChangeEvent;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BodyUI
extends KDPanel {
    static String[] SYS_TAB_CLASSNAME_LIST;
    static int DEFAULT_TAB_INDEX;
    static int MENU_TAB_INDEX;
    static Logger logger;
    IMainUIObject mainUIObject;
    KDTabbedPane tabbedPane = new KDTabbedPane();
    List uiObjects = new ArrayList();
    IUIObject oldUIObject = null;
    IUIObject curUIObject = null;
    private SysTabThread openSysTabThread = null;
    private KDLabel gptLabel = new KDLabel("");
    ChatgptUI chatGpt = null;
    private CellRendererPane cellRendererPane = new CellRendererPane();
    private static final String UICONTEXT_OUID_KEY = "UIContext.OU.ID#KEY";

    public BodyUI(IMainUIObject mainUIObject) {
        this.mainUIObject = mainUIObject;
        this.jbInit();
    }

    public IMainUIObject getMainUIObject() {
        return this.mainUIObject;
    }

    public int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public int getCurTabIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    IUIObject getTabByIndex() {
        return (IUIObject)this.tabbedPane.getSelectedComponent();
    }

    public void changeTab() {
        this.tabbedPane_stateChanged(null);
    }

    public void setCurTabIndex(int index) {
        this.tabbedPane.setSelectedIndex(index);
        this.tabbedPane.validate();
    }

    public void addTab(IUIObject uiObject, int index) {
        this.uiObjects.add(index, uiObject);
        this.tabbedPane.add((Component)uiObject.getUIContentPane(), index);
        this.tabbedPane.setTitleAt(index, uiObject.getUITitle());
    }

    public void addTab(IUIObject uiObject) {
        this.uiObjects.add(uiObject);
        this.tabbedPane.add((Component)uiObject.getUIContentPane());
        this.tabbedPane.setTitleAt(this.tabbedPane.getTabCount() - 1, uiObject.getUITitle());
    }

    public void removeTab(IUIObject uiObject) {
        this.uiObjects.remove(uiObject);
        this.tabbedPane.remove((Component)uiObject.getUIContentPane());
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.tabbedPane.setViewStyle(2);
        this.tabbedPane.addCloseAllTabListener(new TabbedPaneCloseAllTabListener(){

            public void closeAllTab(ActionEvent e) {
                BodyUI.this.mainUIObject.getUiManager().closeAllTab();
            }
        });
        this.tabbedPane.addCloseActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = BodyUI.this.tabbedPane.getSelectedIndex();
                IUIObject uiObject = (IUIObject)BodyUI.this.uiObjects.get(index);
                uiObject.getUIWindow().close();
            }
        });
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BodyUI.this.tabbedPane_stateChanged(e);
            }
        });
        this.add((Component)this.tabbedPane, "Center");
        this.resetNavigateKey();
        this.gptLabel.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("ui/gpt/gpt.png")));
        this.gptLabel.setBounds(this.getSize().width - 120, 10, 16, 16);
        try {
            boolean hasGptLicense = false;
            String controlPolicy = LicenseSrvAgentFactory.getRemoteInstance().getLicenseBaseInfo().getControlPolicy();
            if (ControlPolicy.isByRegistUsers((String)controlPolicy)) {
                LicenseUserInfo user = (LicenseUserInfo)SysContext.getSysContext().getProperty((Object)"License.UserInfo");
                int PRO_GPT_G = LicenseSrvAgentFactory.getRemoteInstance().requestLicenseByUserAndSubSystem(user, "PRO_GPT_G");
                int PRO_GPT_P_G = LicenseSrvAgentFactory.getRemoteInstance().requestLicenseByUserAndSubSystem(user, "PRO_GPT_P_G");
                hasGptLicense = PRO_GPT_G == 1 || PRO_GPT_P_G == 1;
            } else {
                String GPT = LicenseSrvAgentFactory.getRemoteInstance().getSubSystemByModule("GPT");
                String GPT_P = LicenseSrvAgentFactory.getRemoteInstance().getSubSystemByModule("GPT_P");
                hasGptLicense = !StringUtils.isEmpty((String)GPT) || !StringUtils.isEmpty((String)GPT_P);
            }
            this.gptLabel.setVisible(hasGptLicense);
            if (this.gptLabel.isVisible()) {
                this.tabbedPane.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        Point point = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), (Component)((Object)BodyUI.this));
                        if (point.x > BodyUI.this.getSize().width - 120 && point.x < BodyUI.this.getSize().width - 120 + 16 && point.y > 8 && point.y < 24) {
                            if (BodyUI.this.chatGpt != null && BodyUI.this.chatGpt.isVisible()) {
                                BodyUI.this.showChatgpt(false);
                            } else {
                                BodyUI.this.showChatgpt(true);
                            }
                        }
                    }
                });
            }
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
    }

    private void showChatgpt(boolean isShowChatgpt) {
        if (this.chatGpt == null) {
            this.chatGpt = new ChatgptUI(this.mainUIObject);
            this.chatGpt.setBounds(this.getWidth() - 420, 85, 420, this.getHeight() - 35);
            if (this.mainUIObject != null && this.mainUIObject.getUIContainer() instanceof NewMainFrame) {
                NewMainFrame mainFrame = (NewMainFrame)this.mainUIObject.getUIContainer();
                mainFrame.getLayeredPane().add((Component)((Object)this.chatGpt));
                mainFrame.getLayeredPane().setComponentZOrder((Component)((Object)this.chatGpt), 0);
            }
        }
        this.chatGpt.setVisible(isShowChatgpt);
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.gptLabel.isVisible()) {
            this.gptLabel.setBounds(this.getSize().width - 120, 8, 16, 16);
            this.cellRendererPane.paintComponent(g2d, (Component)this.gptLabel, (Container)((Object)this), this.getSize().width - 120, 10, 16, 16);
            if (this.chatGpt != null) {
                this.chatGpt.setBounds(this.getWidth() - this.chatGpt.getWidth(), 85, this.chatGpt.getWidth(), this.getHeight() - 35);
            }
        }
    }

    private void resetNavigateKey() {
        InputMap inputMap = this.tabbedPane.getInputMap(2);
        if (inputMap == null) {
            return;
        }
        KeyStroke ksUp = KeyStroke.getKeyStroke(33, 2, false);
        KeyStroke ksDown = KeyStroke.getKeyStroke(34, 2, false);
        if (inputMap.get(ksUp) != null) {
            inputMap.remove(ksUp);
        }
        if (inputMap.get(ksDown) != null) {
            inputMap.remove(ksDown);
        }
        inputMap.put(ksUp, "navigatePageUp");
        inputMap.put(ksDown, "navigatePageDown");
    }

    public void initSysTab(Frame owner) throws UIException {
        if (SYS_TAB_CLASSNAME_LIST.length == 0) {
            return;
        }
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
        UIContext map = new UIContext((Object)owner);
        map.put("IMainUIObject", this.mainUIObject);
        IUIWindow[] uiWindows = new IUIWindow[SYS_TAB_CLASSNAME_LIST.length];
        for (int i = 0; i < SYS_TAB_CLASSNAME_LIST.length; ++i) {
            long start3 = System.currentTimeMillis();
            this.assignSysTabPosition(uiFactory, (Map)map, uiWindows, SYS_TAB_CLASSNAME_LIST[i], i);
            long end3 = System.currentTimeMillis() - start3;
            if (!UIFrameUtils.isLogged()) continue;
            logger.info((Object)UIFrameUtils.getLogText(SYS_TAB_CLASSNAME_LIST[i] + " in  initSysTab  in new NewMainFrame(uiObject) cost : " + end3 + " ms."));
        }
        owner.setEnabled(false);
        this.tabbedPane.setEnabled(false);
        if (SYS_TAB_CLASSNAME_LIST.length > 0) {
            this.openSysTabThread = new SysTabThread(uiFactory, (Map)map, uiWindows, SYS_TAB_CLASSNAME_LIST);
        }
    }

    public SysTabThread getOpenSysTabThread() {
        return this.openSysTabThread;
    }

    public void join() {
        try {
            if (this.openSysTabThread != null && this.openSysTabThread.isAlive()) {
                this.openSysTabThread.join();
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    void closeSysTabThread() {
        if (this.openSysTabThread != null && this.openSysTabThread.isAlive()) {
            this.openSysTabThread.stop();
        }
    }

    public Component getMessageComponent(int i) {
        return this.tabbedPane.getComponentAt(i);
    }

    void assignSysTabPosition(IUIFactory uiFactory, Map map, IUIWindow[] uiWindows, String uiClassName, int i) throws UIException {
        uiWindows[i] = uiFactory.create("com.kingdee.eas.base.uiframe.client.DefaultSysTabUI", map);
        String[] ui = uiClassName.split("#");
        Locale local = LocaleUtils.getDefaultLocale();
        int uiTitleIdx = 3;
        uiTitleIdx = local.toString().equalsIgnoreCase("L1") ? 2 : (local.toString().equalsIgnoreCase("L2") ? 3 : 4);
        String uiTitle = "";
        if (ui.length > uiTitleIdx) {
            uiTitle = ui[uiTitleIdx];
        }
        this.tabbedPane.setTitleAt(i, uiTitle);
        this.tabbedPane.setEnabledAt(i, false);
        if (ui.length > 1) {
            this.tabbedPane.setDisabledIconAt(i, EASResource.getIcon((String)"imgPic_wait_sandglass"));
        }
    }

    void showRealSysUI(IUIFactory uiFactory, Map map, IUIWindow[] uiWindows, String uiClassName, int i) throws UIException {
        UISysTabFactory uiSysTabFactory = (UISysTabFactory)UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UISysTabFactory");
        String[] ui = uiClassName.split("#");
        if (MainMenuEditUI.class.getName().equals(ui[0])) {
            return;
        }
        uiWindows[i] = uiSysTabFactory.create(ui[0], map, null, null, i);
        this.tabbedPane.setToggled(i, true);
        if (ui.length > 1) {
            this.tabbedPane.setIconAt(i, EASResource.getIcon((String)ui[1]));
        }
    }

    void showSysUI(IUIFactory uiFactory, Map map, IUIWindow[] uiWindows, String uiClassName, int i) throws UIException {
        String[] ui = uiClassName.split("#");
        if (MainMenuEditUI.class.getName().equals(ui[0])) {
            return;
        }
        uiWindows[i] = uiFactory.create(ui[0], map);
        this.tabbedPane.setToggled(i, true);
        if (ui.length > 1) {
            this.tabbedPane.setIconAt(i, EASResource.getIcon((String)ui[1]));
        }
    }

    private void tabbedPane_stateChanged(ChangeEvent e) {
        this.oldUIObject = this.curUIObject;
        if (this.tabbedPane.getTabCount() <= this.tabbedPane.getSelectedIndex() || this.tabbedPane.getSelectedIndex() < 0) {
            return;
        }
        Component component = this.tabbedPane.getSelectedComponent();
        String className = component.getClass().getName();
        if (StringUtils.equalsIgnoreCase((String)"com.kingdee.eas.base.uiframe.client.NewMainFunctionMenuUI", (String)className)) {
            try {
                Class<?> uiClass = Class.forName(className);
                Method method = uiClass.getMethod("refreshMessage", null);
                method.invoke((Object)component, null);
            }
            catch (Exception e1) {
                logger.error((Object)e1);
            }
        }
        int index = this.tabbedPane.getSelectedIndex();
        this.curUIObject = (IUIObject)this.uiObjects.get(this.tabbedPane.getSelectedIndex());
        if (this.oldUIObject instanceof CoreUI) {
            Set oldListenerList = ((CoreUI)this.oldUIObject).getTabbedChangeListenerList();
            for (TabbedChangeListener oldListener : oldListenerList) {
                oldListener.exitTab();
                if (!(oldListener instanceof NewTabbedChangeListener)) continue;
                ((NewTabbedChangeListener)oldListener).exitTab(new TabChangeEvent((Object)this.oldUIObject));
            }
        }
        if (this.curUIObject instanceof CoreUI) {
            Set curListenerList = ((CoreUI)this.curUIObject).getTabbedChangeListenerList();
            for (TabbedChangeListener curListener : curListenerList) {
                curListener.enterTab();
                if (!(curListener instanceof NewTabbedChangeListener)) continue;
                ((NewTabbedChangeListener)curListener).enterTab(new TabChangeEvent((Object)this.curUIObject));
            }
        }
        this.mainUIObject.changeMenuToolBar(this.tabbedPane.getSelectedIndex());
        if (index != DEFAULT_TAB_INDEX && index < SYS_TAB_CLASSNAME_LIST.length) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    int index = BodyUI.this.tabbedPane.getSelectedIndex();
                    if (index == 1) {
                        BodyUI.this.openMessgeCenterUI(index);
                    }
                }
            };
            SwingUtilities.invokeLater(t);
        }
        if (this.chatGpt != null) {
            this.chatGpt.changeToUI(component);
        }
        if (this.gptLabel.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BodyUI.this.repaint();
                }
            });
        }
    }

    public void openMessgeCenterUI(int index) {
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
            UIContext map = new UIContext((Object)this.tabbedPane.getParent());
            map.put("IMainUIObject", this.mainUIObject);
            IUIWindow[] uiWindows = new IUIWindow[SYS_TAB_CLASSNAME_LIST.length];
            this.tabbedPane.setIconAt(index, EASResource.getIcon((String)"imgPic_wait_sandglass"));
            this.tabbedPane.setDisabledIconAt(index, EASResource.getIcon((String)"imgPic_wait_sandglass"));
            this.showRealSysUI(uiFactory, (Map)map, uiWindows, SYS_TAB_CLASSNAME_LIST[index], index);
            this.tabbedPane.setEnabledAt(index, true);
            this.mainUIObject.changeMenuToolBar(this.tabbedPane.getSelectedIndex());
        }
        catch (UIException e1) {
            logger.error((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)e1));
            this.tabbedPane.setEnabled(true);
            ExceptionHandler.handle((Throwable)e1);
            this.tabbedPane.setSelectedIndex(DEFAULT_TAB_INDEX);
            String[] ui = SYS_TAB_CLASSNAME_LIST[index].split("#");
            this.tabbedPane.setIconAt(index, EASResource.getIcon((String)ui[1]));
            this.tabbedPane.setEnabledAt(index, true);
            this.tabbedPane.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void switchOrg() {
        this.ensureInitSysTabOuId();
        IUIObject ui = (IUIObject)this.uiObjects.get(this.tabbedPane.getSelectedIndex());
        Map uiCtx = ui.getUIContext();
        String ouId = (String)uiCtx.get(UICONTEXT_OUID_KEY);
        if (ouId != null) {
            if (!ouId.equals(SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
                try {
                    MultiOrgSwitchUtils.switchOrg((String)ouId);
                }
                catch (Exception e) {
                    ui.handUIException((Throwable)e);
                }
            }
        } else {
            ouId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            uiCtx.put(UICONTEXT_OUID_KEY, ouId);
        }
        this.setOrgInfo(ui.getStatusBar());
    }

    private void ensureInitSysTabOuId() {
        IUIObject ui = (IUIObject)this.uiObjects.get(0);
        String ouId = (String)ui.getUIContext().get(UICONTEXT_OUID_KEY);
        if (ouId == null || this.getSysTabCount() > this.tabbedPane.getTabCount()) {
            ouId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            int count = Math.min(this.getSysTabCount(), this.tabbedPane.getTabCount());
            for (int i = 0; i < count; ++i) {
                ui = (IUIObject)this.uiObjects.get(i);
                ui.getUIContext().put(UICONTEXT_OUID_KEY, ouId);
            }
        }
    }

    private void setOrgInfo(KDStatusBar bar) {
        if (bar == null || bar.getPart(1) == null) {
            return;
        }
        JLabel lblOrg = (JLabel)bar.getPart(1).getRenderer((Object)"OrgText").getComponent(bar);
        String org = MainStatusBar.getOrgText();
        lblOrg.setText(org);
    }

    public int getSysTabCount() {
        if (SYS_TAB_CLASSNAME_LIST == null) {
            return 0;
        }
        return SYS_TAB_CLASSNAME_LIST.length;
    }

    public void resetOrg() {
        IUIObject ui = (IUIObject)this.uiObjects.get(0);
        String ouId = (String)ui.getUIContext().get(UICONTEXT_OUID_KEY);
        if (ouId != null) {
            if (!ouId.equals(SysContext.getSysContext().getCurrentOrgUnit().getId().toString())) {
                try {
                    MultiOrgSwitchUtils.switchOrg((String)ouId);
                }
                catch (Exception e) {
                    ui.handUIException((Throwable)e);
                }
            }
            int count = Math.min(this.getSysTabCount(), this.tabbedPane.getTabCount());
            for (int i = 0; i < count; ++i) {
                ui = (IUIObject)this.uiObjects.get(i);
                BodyUI.resetUIContext(ui);
            }
        }
    }

    public static void resetUIContext(IUIObject ui) {
        ui.getUIContext().remove(UICONTEXT_OUID_KEY);
    }

    public int getLastSysTabIndex(ArrayList uiLists) {
        int index = -1;
        IUIObject iUIObject = null;
        for (int i = uiLists.size() - 1; i >= 0; --i) {
            iUIObject = (IUIObject)uiLists.get(i);
            if (!this.isSysTab(iUIObject)) continue;
            index = i;
            break;
        }
        return index;
    }

    public boolean isTempSysTabUI(IUIObject uiObject) {
        boolean result = false;
        String uiClassName = uiObject.getClass().getName();
        return uiClassName != null && uiClassName.equals("com.kingdee.eas.base.uiframe.client.DefaultSysTabUI");
    }

    public boolean isSysTab(IUIObject uiObject) {
        boolean result = false;
        if (SYS_TAB_CLASSNAME_LIST == null) {
            return false;
        }
        String uiClassName = uiObject.getClass().getName();
        if (uiClassName != null) {
            if (this.isTempSysTabUI(uiObject)) {
                result = true;
            } else {
                for (int i = SYS_TAB_CLASSNAME_LIST.length - 1; i >= 0; --i) {
                    if (!SYS_TAB_CLASSNAME_LIST[i].startsWith(uiClassName)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public void closeApplication() {
        if (this.chatGpt != null) {
            this.chatGpt.closeApplication();
        }
    }

    static {
        logger = Logger.getLogger(BodyUI.class);
        Map sortedSysTabList = UIConfig.getSysTabs();
        SYS_TAB_CLASSNAME_LIST = new String[sortedSysTabList.size()];
        DEFAULT_TAB_INDEX = UIConfig.getDefaultTabIndex();
        if (DEFAULT_TAB_INDEX >= SYS_TAB_CLASSNAME_LIST.length) {
            DEFAULT_TAB_INDEX = 0;
        }
        MENU_TAB_INDEX = UIConfig.getMenuTabIndex();
        Iterator iterator = sortedSysTabList.entrySet().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            BodyUI.SYS_TAB_CLASSNAME_LIST[index] = (String)entry.getValue();
            ++index;
        }
    }

    class SysTabThread
    extends Thread {
        IUIFactory uiFactory = null;
        Map map = null;
        IUIWindow[] uiWindows = null;
        String[] uiClassNames = null;

        public SysTabThread(IUIFactory uiFactory, Map map, IUIWindow[] uiWindows, String[] uiClassNames) {
            this.uiFactory = uiFactory;
            this.map = map;
            this.uiWindows = uiWindows;
            this.uiClassNames = uiClassNames;
        }

        @Override
        public void run() {
            Graphics graphics;
            long start = System.currentTimeMillis();
            UIActionMonitor.startAction((String)"BodyUI$SysTabThread", (String)"run()");
            final Frame mainFrame = (Frame)this.map.get("Owner");
            try {
                BodyUI.this.showRealSysUI(this.uiFactory, this.map, this.uiWindows, SYS_TAB_CLASSNAME_LIST[DEFAULT_TAB_INDEX], DEFAULT_TAB_INDEX);
                mainFrame.setEnabled(true);
                BodyUI.this.tabbedPane.setEnabled(true);
                BodyUI.this.tabbedPane.setDisabledIconAt(DEFAULT_TAB_INDEX, null);
                BodyUI.this.tabbedPane.setEnabledAt(DEFAULT_TAB_INDEX, true);
                for (int i = 0; i < this.uiClassNames.length; ++i) {
                    if (i == DEFAULT_TAB_INDEX) continue;
                    BodyUI.this.tabbedPane.setDisabledIconAt(i, null);
                    BodyUI.this.tabbedPane.setEnabledAt(i, true);
                }
                LoginHelper.initAfterLoginExt();
            }
            catch (UIException e) {
                logger.error((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)e));
                if (mainFrame != null) {
                    mainFrame.setEnabled(true);
                }
                BodyUI.this.tabbedPane.setEnabled(true);
                ExceptionHandler.handle((Component)mainFrame, (Throwable)e);
            }
            catch (ArrayIndexOutOfBoundsException e1) {
                logger.error((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)e1));
                if (mainFrame != null) {
                    mainFrame.setEnabled(true);
                }
                BodyUI.this.tabbedPane.setEnabled(true);
            }
            UIActionMonitor.endAction((String)"BodyUI$SysTabThread", (String)"run()", (long)(System.currentTimeMillis() - start));
            Graphics graphics2 = graphics = mainFrame == null ? null : mainFrame.getGraphics();
            if (mainFrame != null && graphics == null) {
                mainFrame.repaint();
            } else if (mainFrame != null && graphics != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        mainFrame.paint(graphics);
                    }
                });
            }
        }
    }
}

