/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.IClientLoginContextFilter;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.uiframe.client.ILoginRPCFilter;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClientLoginContextInterceptor {
    private static IClientLoginContextFilter[] filters;
    private static String[] filterNames;
    protected static final Logger logger;

    private static synchronized void initFilters() throws BOSLoginException {
        if (filters != null) {
            return;
        }
        ArrayList<IClientLoginContextFilter> tempFilters = new ArrayList<IClientLoginContextFilter>();
        ArrayList<String> tempFilterNames = new ArrayList<String>();
        Map filtersName = UIConfig.getSysLoginListeners();
        Iterator iterator = filtersName.entrySet().iterator();
        while (iterator.hasNext()) {
            String filterName = (String)iterator.next().getValue();
            Class<?> clazz = null;
            try {
                clazz = Class.forName(filterName);
                IClientLoginContextFilter iClientLoginContextFilter = (IClientLoginContextFilter)clazz.newInstance();
            }
            catch (Exception e) {
                logger.error((Object)("Invoke SysLoginListener " + filterName + " fail!"), (Throwable)e);
            }
            try {
                if (clazz == null) continue;
                IClientLoginContextFilter filter = (IClientLoginContextFilter)clazz.newInstance();
                tempFilters.add(filter);
                tempFilterNames.add(filterName);
            }
            catch (Exception e) {
                logger.error((Object)("Filter class[" + filterName + "] new instance error"));
            }
        }
        filters = tempFilters.toArray(new IClientLoginContextFilter[tempFilters.size()]);
        filterNames = tempFilterNames.toArray(new String[tempFilterNames.size()]);
    }

    public static void prepareInitHandler() {
        IUIActionPostman handler = UIActionPostman.getInstance(null);
        if (handler != null) {
            RequestContext request = new RequestContext();
            request.setClassName("com.kingdee.eas.base.uiframe.app.LoginFrameHandler");
            request.setMethodName("handleInit");
            if (filters != null) {
                int filterSize = filters.length;
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < filterSize; ++i) {
                    if (!(filters[i] instanceof ILoginRPCFilter)) continue;
                    IUIActionPostman postMan = ((ILoginRPCFilter)filters[i]).prepareInit();
                    list.add(postMan.getRequestContext());
                }
                request.put("InitHandler", list);
            }
            handler.setRequestContext((Serializable)request);
        }
        try {
            handler.callHandler();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void afterAuthenticated(Context ctx) throws BOSLoginException {
        if (filters == null) {
            ClientLoginContextInterceptor.initFilters();
        }
        ClientLoginContextInterceptor.prepareInitHandler();
        if (filters != null) {
            long start = 0L;
            for (int i = 0; i < filters.length; ++i) {
                start = System.currentTimeMillis();
                try {
                    filters[i].afterAuthenticated(ctx);
                }
                catch (Exception e) {
                    logger.error((Object)("Invoke SysLoginListener " + filterNames[i] + " fail!"), (Throwable)e);
                    if (e instanceof BOSLoginException) {
                        throw (BOSLoginException)e;
                    }
                    throw new BOSLoginException((Throwable)e);
                }
                logger.info((Object)(" invoke filter " + filterNames[i] + " after authenticated spent: " + (System.currentTimeMillis() - start) + " ms."));
            }
        }
    }

    public static void beforeAuthenticating(LoginContext ctx) throws BOSLoginException {
        if (filters == null) {
            ClientLoginContextInterceptor.initFilters();
        }
        if (filters != null) {
            long start = 0L;
            for (int i = 0; i < filters.length; ++i) {
                start = System.currentTimeMillis();
                try {
                    filters[i].beforeAuthenticating(ctx);
                }
                catch (Exception e) {
                    logger.error((Object)("Invoke SysLoginListener " + filterNames[i] + " fail!"), (Throwable)e);
                    throw new BOSLoginException((Throwable)e);
                }
                logger.info((Object)(" invoke  filter " + filterNames[i] + "  before Authenticating spent: " + (System.currentTimeMillis() - start) + " ms."));
            }
        }
    }

    static {
        logger = Logger.getLogger(ClientLoginContextInterceptor.class);
    }
}

