/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.base.uiframe.client.AbstractCloudHyperLinkPanel;
import com.kingdee.eas.base.uiframe.client.HyperLinkPanel;
import com.kingdee.eas.base.uiframe.client.HyperLinkUtil;
import com.kingdee.eas.base.uiframe.client.NewWorkBenchPanel;
import com.kingdee.eas.base.uiframe.client.OperatorHyperLinkPanel;
import com.kingdee.eas.base.uiframe.client.ui.web20.statistics.StatisticsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class CloudHyperLinkPanel
extends AbstractCloudHyperLinkPanel {
    private NewWorkBenchPanel newWorkBenchPanel = null;
    private static final Logger logger = Logger.getLogger(CloudHyperLinkPanel.class);

    public void load(NewWorkBenchPanel superPanel) {
        this.newWorkBenchPanel = superPanel;
        HyperLinkLoader thread = new HyperLinkLoader();
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllHyperLinks() throws IOException {
        InputStream l_urlStream = this.getHyperLinkInputStream();
        if (l_urlStream == null) {
            return;
        }
        try {
            String urlStreamString = CloudHyperLinkPanel.convertStream2String(l_urlStream);
            JSONObject jsonObject = new JSONObject(urlStreamString);
            String returnCode = jsonObject.getString("code");
            if (!"200".equals(returnCode)) {
                return;
            }
            this.subjectList = jsonObject.getJSONArray(this.HYPER_LINK_DATA);
            this.dealWithAllHyperLinks();
        }
        catch (JSONException e) {
            logger.error((Object)"\u6ca1\u6709\u70ed\u70b9\u63a8\u8350\u6570\u636e\uff01");
            logger.error((Object)"\u89e3\u6790\u70ed\u70b9\u63a8\u8350json\u51fa\u73b0\u5f02\u5e38!");
        }
        finally {
            if (l_urlStream != null) {
                l_urlStream.close();
            }
        }
    }

    private void dealWithAllHyperLinks() throws IOException, JSONException {
        this.addHyperLinkPanel(this.hyperLinkPanel);
    }

    private void addHyperLinkPanel(HyperLinkPanel parentPanel) throws IOException, JSONException {
        if (this.subjectList == null || this.subjectList.length() == 0) {
            return;
        }
        this.addHyperLinkPanel();
        this.add((Component)((Object)this.hyperLinkPanel), "Center");
        int j = 0;
        for (int k = 0; j < this.subjectList.length() && k < LIMIT_HYPER_lINK_COUNTS; ++j, ++k) {
            JSONObject jsonObject = (JSONObject)this.subjectList.get(j);
            KDLabel image = new KDLabel();
            String imageUrl = this.getSubjectImageUrl(jsonObject);
            if (imageUrl != null && !"".equals(imageUrl)) {
                ImageIcon icon = new ImageIcon(new URL(imageUrl));
                icon.setImage(icon.getImage().getScaledInstance(19, 18, 20));
                image.setIcon((Icon)icon);
            }
            String title = jsonObject.getString(this.HYPER_LINK_TITLE);
            String titleUrl = jsonObject.getString(this.HYPER_LINK_TITLE_URL);
            if (title == null || "".equals(title) || titleUrl == null || "".equals(titleUrl)) continue;
            KDLabel kdTitle = new KDLabel();
            kdTitle.setText(title);
            OperatorHyperLinkPanel panel = new OperatorHyperLinkPanel(image, kdTitle, titleUrl);
            panel.setPreferredSize(new Dimension(200, 20));
            parentPanel.add((Component)((Object)panel));
        }
        parentPanel.revalidate();
        parentPanel.repaint();
    }

    private String getSubjectImageUrl(JSONObject jsonObject) {
        try {
            return jsonObject.getString(this.HYPER_LINK_IMAGE_URL);
        }
        catch (JSONException e) {
            return null;
        }
    }

    private void addHyperLinkPanel() {
        KDPanel southPanel = new KDPanel();
        this.newWorkBenchPanel.setPreferredSize(new Dimension(100, 10));
        this.newWorkBenchPanel.add((Component)southPanel, "South");
        southPanel.setPreferredSize(new Dimension(10, 150));
        KDPanel southTmp = new KDPanel();
        southPanel.setLayout((LayoutManager)new BorderLayout());
        southPanel.add((Component)southTmp, (Object)"North");
        southPanel.add((Component)((Object)this), (Object)"Center");
        southTmp.setPreferredSize(new Dimension(100, 10));
    }

    private InputStream getHyperLinkInputStream() {
        InputStream l_urlStream = null;
        try {
            String hyperLinkUrl = HyperLinkUtil.getHyperLinkUrl();
            if (hyperLinkUrl != null) {
                URL l_url = new URL(hyperLinkUrl);
                HttpURLConnection l_connection = (HttpURLConnection)l_url.openConnection();
                l_connection.setConnectTimeout(5000);
                l_connection.connect();
                l_urlStream = l_connection.getInputStream();
            }
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)"URL\u94fe\u63a5\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u8bbf\u95ee\u5916\u7f51\u7684\u6743\u9650\uff01");
            return null;
        }
        catch (IOException e) {
            logger.error((Object)"URL\u94fe\u63a5\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u8bbf\u95ee\u5916\u7f51\u7684\u6743\u9650\uff01");
            return null;
        }
        return l_urlStream;
    }

    private String xml2JSON(String xml) {
        JSONObject obj = new JSONObject();
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("utf-8"));
            SAXBuilder sb = new SAXBuilder();
            Document doc = sb.build((InputStream)is);
            Element root = doc.getRootElement();
            obj.put(root.getName(), CloudHyperLinkPanel.iterateElement(root));
            return obj.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Map iterateElement(Element element) {
        List jiedian = element.getChildren();
        Element et = null;
        HashMap obj = new HashMap();
        List<Object> list = null;
        for (int i = 0; i < jiedian.size(); ++i) {
            list = new LinkedList<Object>();
            et = (Element)jiedian.get(i);
            if ("".equals(et.getTextTrim())) {
                if (et.getChildren().size() == 0) continue;
                if (obj.containsKey(et.getName())) {
                    list = (List)obj.get(et.getName());
                }
                list.add(CloudHyperLinkPanel.iterateElement(et));
                obj.put(et.getName(), list);
                continue;
            }
            if (obj.containsKey(et.getName())) {
                list = (List)obj.get(et.getName());
            }
            list.add(et.getTextTrim());
            obj.put(et.getName(), list);
        }
        return obj;
    }

    private static String convertStream2String(InputStream inputStream) {
        String str = "";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        try {
            while ((len = inputStream.read(buffer, 0, buffer.length)) != -1) {
                out.write(buffer, 0, len);
            }
            str = new String(out.toByteArray(), "utf-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)"\u70ed\u70b9\u63a8\u8350\u5b57\u8282\u6d41\u8f6c\u6362\u6210string\u51fa\u73b0\u5f02\u5e38\uff01");
        }
        return str;
    }

    public boolean hasHyperLinks() {
        return this.subjectList != null && this.subjectList.length() > 0;
    }

    private InputStream getUserRoleInputStream() {
        InputStream l_urlStream = null;
        try {
            URL l_url = new URL(MessageFormat.format("http://web20.kingdee.com/easlog/role/{0}/{1}/{2}", StatisticsUtil.getEncodedSerialNum(), StatisticsUtil.getEncodedEASVersion(), StatisticsUtil.getEncodedUserId()));
            HttpURLConnection l_connection = (HttpURLConnection)l_url.openConnection();
            l_connection.setConnectTimeout(5000);
            l_connection.connect();
            l_urlStream = l_connection.getInputStream();
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)"URL\u94fe\u63a5\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u8bbf\u95ee\u5916\u7f51\u7684\u6743\u9650\uff01");
            return null;
        }
        catch (IOException e) {
            logger.error((Object)"URL\u94fe\u63a5\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u8bbf\u95ee\u5916\u7f51\u7684\u6743\u9650\uff01");
            return null;
        }
        return l_urlStream;
    }

    private class HyperLinkLoader
    extends Thread {
        private HyperLinkLoader() {
        }

        @Override
        public void run() {
            try {
                CloudHyperLinkPanel.this.loadAllHyperLinks();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

