/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.base.uiframe.client.AbstractCloudValidityUI;
import com.kingdee.eas.common.ContextManagerFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CloudValidityUI
extends AbstractCloudValidityUI {
    private static final Logger logger = CoreUIObject.getLogger(CloudValidityUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.uiframe.UIFrameResource";
    private boolean completed;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnVerify_actionPerformed(ActionEvent e) throws Exception {
        super.btnVerify_actionPerformed(e);
        if (this.checkCloud()) {
            String userName = new String(this.textCloudName.getText()).trim();
            String password = new String(this.txtPwd.getPassword()).trim();
            HashMap<String, String> ctxMap = new HashMap<String, String>();
            ctxMap.put("cloudU", userName);
            ctxMap.put("cloudP", password);
            try {
                ContextManagerFactory.getRemoteInstance().setContext(ctxMap);
                this.completed = true;
            }
            catch (Exception e2) {
                logger.error((Object)e2);
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"userKickedOut"));
            }
            this.uiWindow.close();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"online_verify_error"));
        }
    }

    public boolean isCompleted() {
        return this.completed;
    }

    private boolean checkCloud() {
        String userName = new String(this.textCloudName.getText()).trim();
        UserInfo currentUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        String erpNumber = currentUserInfo.getNumber();
        if (StringUtils.isEmpty((String)erpNumber) || StringUtils.isEmpty((String)userName)) {
            return false;
        }
        if (!erpNumber.equalsIgnoreCase(userName)) {
            return false;
        }
        String password = new String(this.txtPwd.getPassword()).trim();
        String access_token = "";
        String cloudId = "";
        try {
            JSONObject o = EasCloud.getUserAccessToken(userName, password);
            logger.error((Object)("==================\u4e91\u9a8c\u8bc1\u8fd4\u56de\u4fe1\u606f====================== \uff1a" + o));
            if (o.getInteger("errcode") == 0) {
                String verifyCloudId;
                JSONObject data = JSONObject.parseObject((String)o.getString("data"));
                access_token = data.getString("access_token");
                cloudId = data.getString("uid");
                if (cloudId.equals(verifyCloudId = StringUtils.cnulls((String)this.getCloudIdOnLicenseVerify(access_token))) && CloudRegistSrvAgentFactory.getRemoteInstance().checkCloudIdIsRegisted(cloudId)) {
                    HashMap<String, String> ctxMap = new HashMap<String, String>();
                    ctxMap.put("cloudUserId", cloudId);
                    ContextManagerFactory.getRemoteInstance().setContext(ctxMap);
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return false;
    }

    private String getCloudIdOnLicenseVerify(String userToken) throws Exception {
        String cloudId = "";
        ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
        LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
        String prod_inst_code = baseInfo.getProductInstanceID();
        if (StringUtils.isEmpty((String)userToken) || StringUtils.isEmpty((String)prod_inst_code)) {
            return cloudId;
        }
        JSONObject o = EasCloud.getLicenseProVerify(userToken, prod_inst_code);
        if (o.getInteger("errcode") == 0) {
            JSONObject data = JSONObject.parseObject((String)o.getString("data"));
            cloudId = data.getString("uid");
        }
        return cloudId;
    }
}

