/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.DynamicPasswordFacadeFactory;
import com.kingdee.eas.base.permission.SMSValidataException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.AbstractDynPasswordUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DynPasswordUI
extends AbstractDynPasswordUI {
    private static final Logger logger = CoreUIObject.getLogger(DynPasswordUI.class);
    public boolean isCancel = true;
    private UserInfo user = null;
    private static final String RESOURCE = "com.kingdee.eas.base.uiframe.client.LoginFrameResx";
    private static int reSendTime = 30;

    public void onLoad() throws Exception {
        super.onLoad();
        this.cancel.setEnabled(true);
        this.confirm.setEnabled(true);
        this.user = (UserInfo)this.getUIContext().get("user");
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        String code = this.txtCode.getStringValue();
        try {
            boolean checkCode = DynamicPasswordFacadeFactory.getRemoteInstance().checkCode(this.user.getNumber(), code);
            if (!checkCode) {
                throw new SMSValidataException(SMSValidataException.CHECK_ERROR);
            }
            this.isCancel = false;
            this.getUIWindow().close();
        }
        catch (SMSValidataException e1) {
            this.showError(e1.getMessage());
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.getUIWindow().close();
    }

    private void regenerateDynPassword() {
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("userNumber", this.user.getNumber());
            paramMap.put("userId", this.user.getId().toString());
            DynamicPasswordFacadeFactory.getRemoteInstance().getCode(paramMap);
        }
        catch (BOSException | EASBizException e) {
            e.printStackTrace();
        }
    }

    private void startTimer(int reGetTime) {
        SendTimerTask task = new SendTimerTask(reGetTime);
        Thread thread = new Thread(task);
        thread.start();
    }

    private String getResx(String resxItemName) {
        return EASResource.getString((String)RESOURCE, (String)resxItemName);
    }

    private void showSuccess(String message) {
        this.errMsg.setText(message);
        this.errMsg.setForeground(Color.BLUE);
    }

    private void showError(String message) {
        this.errMsg.setText(message);
        this.errMsg.setForeground(Color.RED);
        Font topFont = this.errMsg.getFont().deriveFont(0, 13.0f);
        this.errMsg.setFont(topFont);
    }

    private class SendTimerTask
    implements Runnable {
        private int reGetTime;
        private int count = 0;

        public SendTimerTask(int reGetTime) {
            this.reGetTime = reGetTime;
        }

        @Override
        public void run() {
            try {
                while (this.count++ < 10) {
                    DynPasswordUI.this.regenerateDynPassword();
                    Thread.sleep(1000 * this.reGetTime);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

