/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.eas.base.uiframe.client.HelpUtils;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import org.apache.log4j.Logger;

public class HelpBasicData
implements Serializable {
    static Logger logger = Logger.getLogger(HelpBasicData.class);
    private static final long serialVersionUID = 254840587612877647L;
    private static HelpBasicData _singleInstance = null;
    private HelpSet hs;
    private HelpBroker hb;
    private Locale locale;
    private boolean isDisplayByIE = true;

    private HelpBasicData() {
    }

    public static synchronized HelpBasicData getInstance() {
        if (_singleInstance == null) {
            _singleInstance = new HelpBasicData();
        }
        return _singleInstance;
    }

    public void setLocale(Locale lc) {
        Locale newLocale = null;
        newLocale = lc.getLanguage().equalsIgnoreCase("l1") ? new Locale("en", "US") : (lc.getLanguage().equalsIgnoreCase("l3") ? new Locale("zh", "TW") : new Locale("zh", "CN"));
        if (this.locale == null || !this.locale.equals(newLocale)) {
            this.locale = newLocale;
            this.hs = null;
            this.initHelpSet();
        }
    }

    public String getStrLocale() {
        String strLocale = "";
        strLocale = this.locale == null ? "zh_cn" : this.locale.toString().toLowerCase();
        return strLocale;
    }

    private void initHelpSet() {
        String postfix = "";
        try {
            postfix = "eashelp/eashelp.hs";
            this.hs = new HelpSet(this.getClass().getClassLoader(), this.findHelpSet(postfix, true));
            this.isDisplayByIE = false;
            if (this.hs == null) {
                this.hs = new HelpSet(this.getClass().getClassLoader(), this.findHelpSet(postfix, false));
            }
        }
        catch (HelpSetException e) {
            try {
                this.hs = new HelpSet(this.getClass().getClassLoader(), this.findHelpSet(postfix, false));
            }
            catch (MalformedURLException e1) {
                logger.error((Object)("......" + UIFrameUtils.getRes("res_37") + "hs" + UIFrameUtils.getRes("res_38")));
            }
            catch (HelpSetException e1) {
                logger.error((Object)("......" + UIFrameUtils.getRes("res_37") + "hs" + UIFrameUtils.getRes("res_38")));
            }
        }
        catch (MalformedURLException e) {
            logger.info((Object)("......" + UIFrameUtils.getRes("res_39") + "hs" + UIFrameUtils.getRes("res_38")));
        }
        this.hb = this.hs.createHelpBroker("Main_Window");
    }

    public HelpSet getHelpSet() {
        if (this.hs == null) {
            this.initHelpSet();
        }
        return this.hs;
    }

    private URL findHelpSet(String postfix, boolean isLocalHelp) throws MalformedURLException {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (postfix.endsWith(".hs")) {
            postfix = postfix.substring(0, postfix.length() - 3);
        }
        if (isLocalHelp) {
            URL url = HelpUtils.ActionHelp.getLocalSrcUrl();
            return url;
        }
        URL url = HelpUtils.ActionHelp.getRemoteSrcUrl();
        return new URL(url, postfix + "_" + this.locale.getLanguage() + "_" + this.locale.getCountry() + ".hs");
    }

    public HelpBroker getHelpBroker() {
        if (this.hb == null && this.getHelpSet() != null) {
            this.hb = this.getHelpSet().createHelpBroker("Main_Window");
        }
        return this.hb;
    }

    public String getHelpID(Locale locale, String className) {
        String helpID = className;
        if (helpID.startsWith("com.kingdee.")) {
            helpID = helpID.replaceFirst("com.kingdee.", "");
        }
        helpID = helpID.replace('.', '_');
        helpID = (helpID + "_htm").toLowerCase();
        if (locale != null) {
            this.setLocale(locale);
        }
        if (!this.getHelpSet().getLocalMap().isValidID(helpID, this.getHelpSet())) {
            helpID = null;
        }
        return helpID;
    }

    public boolean isDisplayByIE() {
        return this.isDisplayByIE;
    }

    public void setDisplayByIE(boolean isDisplayByIE) {
        this.isDisplayByIE = isDisplayByIE;
    }
}

