/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.EASClientDownLoadHelperFile;
import com.kingdee.eas.base.uiframe.client.HelpBasicData;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.base.uiframe.client.VersionUtil;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.help.CSH;
import javax.help.HelpSet;
import javax.help.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class HelpUtils {
    static Logger logger = Logger.getLogger(HelpUtils.class);
    private static String ROOTID;
    static final int SRC_FULLNAME = 10;
    static final int SRC_HELPID = 20;
    static final int SRC_COMPONENT = 30;
    private static HelpBasicData helpBasicData;

    public HelpUtils() {
        helpBasicData = HelpBasicData.getInstance();
    }

    private static String getHelpIDFromComp(Component comp) {
        if (comp == null) {
            return ROOTID;
        }
        String helpID = null;
        helpID = helpBasicData.getHelpID(comp.getLocale(), comp.getClass().getName());
        if (StringUtils.isEmpty((String)helpID) && comp.getClass().getName().indexOf("Edit") != -1) {
            String strListUI = comp.getClass().getName().replaceFirst("Edit", "List");
            helpID = helpBasicData.getHelpID(comp.getLocale(), strListUI);
        }
        for (Component parent = comp; parent != null && StringUtils.isEmpty((String)helpID); parent = parent.getParent()) {
            helpID = helpBasicData.getHelpID(parent.getLocale(), parent.getClass().getName());
        }
        if (!StringUtils.isEmpty((String)helpID)) {
            return helpID;
        }
        return ROOTID;
    }

    private static String getHelpIDFromFullName(String fullName) {
        if (fullName == null) {
            return ROOTID;
        }
        String helpID = null;
        helpID = helpBasicData.getHelpID(null, fullName);
        if (!StringUtils.isEmpty((String)helpID)) {
            return helpID;
        }
        return ROOTID;
    }

    public static void addCSHelp(JComponent comp) {
        if (comp == null) {
            return;
        }
        InputMap inputMap = comp.getInputMap(2);
        ActionMap actionMap = comp.getActionMap();
        if (inputMap == null || actionMap == null) {
            return;
        }
        KeyStroke ks = KeyStroke.getKeyStroke(112, 0, false);
        inputMap.put(ks, "EASHelp");
        actionMap.remove(inputMap.get(ks));
        actionMap.put(inputMap.get(ks), new ActionHelp("", comp, comp));
    }

    public static void addCSHelp(JMenuItem menuItem, JComponent comp) {
        menuItem.setAction(new ActionHelp(UIFrameResource.getString("MainMenuBar.help"), menuItem, comp));
    }

    public static void addCSHelpforBtn(JButton btn) {
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getModifiers() == 16) {
                    JButton btn = (JButton)e.getSource();
                    IUIObject uiObject = UIFrameUtil.getCurrUIObject(btn);
                    ActionHelp actHelp = new ActionHelp("", uiObject.getUIContentPane(), btn);
                    actHelp.actionPerformed(e);
                }
            }
        });
    }

    public static void openCSHelpforPortal(Frame frame) {
        JButton btn = new JButton();
        logger.info((Object)(UIFrameUtils.getRes("res_40") + "frame" + UIFrameUtils.getRes("res_41") + frame.getClass().getName()));
        ActionHelp actHelp = new ActionHelp("", frame, frame);
        ActionEvent event = new ActionEvent(btn, 1001, btn.getActionCommand());
        actHelp.actionPerformed(event);
    }

    private static boolean testConnection(String urlString) {
        try {
            URL url = new URL(urlString);
            if (urlString.startsWith("https://")) {
                HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
                conn.setConnectTimeout(2000);
                int code = conn.getResponseCode();
                if (code == 200) {
                    return true;
                }
            } else {
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(2000);
                int code = conn.getResponseCode();
                if (code == 200) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static {
        helpBasicData = null;
        String tmpRootId = "";
        tmpRootId = "eas_kingdeeeas_htm";
        if (tmpRootId == null) {
            tmpRootId = "eas_kingdeeeas_htm";
        }
        ROOTID = tmpRootId;
    }

    public static class ActionHelp
    extends AbstractAction {
        private Component source;
        private Component target;
        private String fullName;
        private String helpID;
        private int category = 30;
        private EASClientDownLoadHelperFile instance;
        private static final String LOCATION_RESOURCE_ON_SERVER = "/lib/client/eas/eas_help.jar";
        private static boolean isDownload = false;
        private static final String helpHS = "eashelp/eashelp_zh_CN.hs";
        private static URL localSrcUrl;
        private static URL remoteSrcUrl;
        private static final String onlinePublicUrl = "https://vip.kingdee.com/knowledge?productLineId=8&module=basedata&labels=CZSC#tabMain";
        private static Process processOfIE;

        public ActionHelp(String name, Component comp) {
            super(name);
            this.source = comp;
            this.target = comp;
        }

        public ActionHelp(String name, Component source, Component target) {
            super(name);
            this.source = source;
            this.target = target;
        }

        public ActionHelp(String name, Component target, String strSource, int category) {
            super(name);
            this.target = target;
            this.category = category;
            switch (category) {
                case 10: {
                    this.fullName = strSource;
                    break;
                }
                case 20: {
                    this.helpID = strSource;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Locale locale = SysContext.getSysContext().getOriginLocale();
                if (locale == null || LocaleUtils.locale_l2.equals(locale) || LocaleUtils.locale_L2.equals(locale) || LocaleUtils.locale_zh_CN.equals(locale)) {
                    if (HelpUtils.testConnection(onlinePublicUrl)) {
                        VersionUtil.gotoSite(onlinePublicUrl);
                    } else {
                        String offlinePublicUrl = "";
                        offlinePublicUrl = remoteSrcUrl == null || remoteSrcUrl.toString().equals("null") ? "http://localhost:6888/eashelp/index.html" : (remoteSrcUrl.toString().endsWith("/") ? remoteSrcUrl + "eashelp/index.html" : remoteSrcUrl + "/eashelp/index.html");
                        VersionUtil.gotoSite(offlinePublicUrl);
                    }
                    return;
                }
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"manualsNotAvailable"));
                SysUtil.abort();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }

        private void initData(ActionEvent e) throws UIException {
            if (helpBasicData == null) {
                helpBasicData = HelpBasicData.getInstance();
            }
            helpBasicData.setLocale(SysContext.getSysContext().getLocale());
            if (helpBasicData.isDisplayByIE() && this.displayByIE()) {
                return;
            }
            CSH.setHelpIDString((Component)this.target, (String)this.getHelpID());
            CSH.DisplayHelpFromSource help = new CSH.DisplayHelpFromSource(helpBasicData.getHelpBroker());
            help.actionPerformed(e);
        }

        private boolean displayByIE() {
            String helpFile = this.getHelpID();
            String cIE = "cmd /c start iexplore ";
            try {
                HelpSet hs = helpBasicData.getHelpSet();
                helpFile = hs.getLocalMap().getURLFromID(Map.ID.create((String)helpFile, (HelpSet)hs)).toString();
                String helpSet = "";
                String webHelp = "";
                helpBasicData.setLocale(SysContext.getSysContext().getLocale());
                String strLocale = helpBasicData.getStrLocale();
                helpSet = "eashelp/eashelp.hs";
                webHelp = "eashelp/" + strLocale + "/eashelp.htm";
                String hsUrl = new URL(remoteSrcUrl, helpSet).toString();
                hsUrl = hsUrl.substring(0, hsUrl.lastIndexOf(47) + 1);
                hsUrl = hsUrl + strLocale + "/";
                if (helpFile.startsWith(hsUrl)) {
                    helpFile = helpFile.replaceFirst(hsUrl, "").trim();
                }
                helpFile = remoteSrcUrl.toString() + webHelp + "#" + helpFile;
                helpFile = helpFile.toLowerCase();
                if (processOfIE != null) {
                    processOfIE.destroy();
                }
                processOfIE = Runtime.getRuntime().exec("cmd /c start iexplore  " + helpFile);
                return true;
            }
            catch (IOException e1) {
                logger.error((Object)(UIFrameUtils.getRes("res_44") + "IEXPLORE" + UIFrameUtils.getRes("res_45") + "IEXPLORE" + UIFrameUtils.getRes("res_46")));
                return false;
            }
        }

        public static URL findSrcOnServer() throws MalformedURLException {
            String srvUrlPath = System.getProperty("UPDATE_SERVER");
            if (srvUrlPath == null || srvUrlPath.equals("")) {
                throw new NullPointerException("System Property UPDATE_SERVER is not available");
            }
            isDownload = true;
            return new URL(srvUrlPath + LOCATION_RESOURCE_ON_SERVER);
        }

        public Frame getCurFrame(Component component) {
            Component child = component;
            for (Container parent = child.getParent(); parent != null; parent = parent.getParent()) {
                child = parent;
            }
            if (child instanceof Frame) {
                return (Frame)child;
            }
            return null;
        }

        public static URL getLocalSrcUrl() {
            return localSrcUrl;
        }

        public static void setLocalSrcUrl(URL url) {
            localSrcUrl = url;
        }

        public static URL getRemoteSrcUrl() {
            return remoteSrcUrl;
        }

        public static void setRemoteSrcUrl(URL remoteSrcUrl) {
            ActionHelp.remoteSrcUrl = remoteSrcUrl;
        }

        private String getHelpID() {
            switch (this.category) {
                case 30: {
                    return HelpUtils.getHelpIDFromComp(this.source);
                }
                case 10: {
                    return HelpUtils.getHelpIDFromFullName(this.fullName);
                }
                case 20: {
                    return this.helpID;
                }
            }
            return ROOTID;
        }

        static {
            String strUpdateServer = null;
            URL localUrl = null;
            strUpdateServer = System.getProperty("UPDATE_SERVER");
            localUrl = HelpUtils.class.getClassLoader().getResource(helpHS);
            localSrcUrl = localUrl;
            if (localSrcUrl != null) {
                ROOTID = "kingdeeeas";
            }
            try {
                if (StringUtils.isEmpty((String)strUpdateServer)) {
                    strUpdateServer = "localhost:6888";
                }
                remoteSrcUrl = new URL(new URL(strUpdateServer), "/");
            }
            catch (MalformedURLException e) {
                logger.error((Object)(UIFrameUtils.getRes("res_42") + "url" + UIFrameUtils.getRes("res_43") + "url:" + strUpdateServer));
            }
            processOfIE = null;
        }
    }
}

