/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.base.uiframe.IndustryEnum;
import com.kingdee.eas.base.uiframe.client.AbstractIndustrySelectUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import org.apache.log4j.Logger;

public class IndustrySelectUI
extends AbstractIndustrySelectUI {
    private static final Logger logger = Logger.getLogger(IndustrySelectUI.class);
    private KDCheckBox[] industryCheckBox;
    String returnValues = null;

    public IndustrySelectUI() throws Exception {
        this.jbinit();
    }

    private void jbinit() {
        this.setBounds(new Rectangle(10, 10, 350, 250));
        this.industryPanel.setBounds(16, 39, 316, 122);
        this.initIndustryMenu();
        this.initCurrentIndustry();
        this.selectAllBtn.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.unSelectBtn.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.selectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                IndustrySelectUI.this.selectAll(true);
            }
        });
        this.unSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                IndustrySelectUI.this.selectAll(false);
            }
        });
    }

    private void initCurrentIndustry() {
        String sql = "select * from T_BAS_MenuUpdate where Fid = 'menuUpdate' ";
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sql);
        try {
            IRowSet rs = sqlExe.executeSQL();
            if (rs.next()) {
                String industry = rs.getString("FIndustryStatus");
                int FIsUpdate = rs.getInt("FIsUpdate");
                if (FIsUpdate == 1) {
                    int size = this.industryCheckBox.length;
                    String[] typesIndustry = industry.split(";");
                    int length = typesIndustry.length;
                    block2: for (int i = 0; i < size; ++i) {
                        String name = this.industryCheckBox[i].getName();
                        for (int j = 0; j < length; ++j) {
                            if (!name.equals(typesIndustry[j]) && !industry.equals("all")) continue;
                            this.industryCheckBox[i].setSelected(true);
                            continue block2;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void selectAll(boolean flag) {
        int size = this.industryCheckBox.length;
        for (int i = 0; i < size; ++i) {
            if (flag) {
                this.industryCheckBox[i].setSelected(true);
                continue;
            }
            this.industryCheckBox[i].setSelected(false);
        }
    }

    private void initIndustryMenu() {
        List industryEnums = IndustryEnum.getEnumList();
        int size = industryEnums.size();
        this.industryCheckBox = new KDCheckBox[size];
        for (int i = 0; i < size; ++i) {
            IndustryEnum enumTemp = (IndustryEnum)((Object)industryEnums.get(i));
            this.industryCheckBox[i] = new KDCheckBox();
            this.industryCheckBox[i].setName(enumTemp.getValue() + "");
            this.industryCheckBox[i].setBounds(new Rectangle(13, 10 + i * 22, 200, 29));
            this.industryCheckBox[i].setText(enumTemp.getAlias());
            this.industryPanel.add((Component)this.industryCheckBox[i], null);
        }
    }

    public void setReturnValues(String returnValues) {
        this.returnValues = returnValues;
    }

    public String getReturnValues() {
        return this.returnValues;
    }

    @Override
    protected void cancelBtn_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    @Override
    protected void confirmBtn_actionPerformed(ActionEvent e) throws Exception {
        StringBuffer bf = new StringBuffer();
        int size = this.industryCheckBox.length;
        for (int i = 0; i < size; ++i) {
            if (!this.industryCheckBox[i].isSelected()) continue;
            bf.append(this.industryCheckBox[i].getName());
            bf.append(";");
        }
        this.setReturnValues(bf.toString());
        this.disposeUIWindow();
    }
}

