/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.license.ControlPolicy;
import com.kingdee.eas.base.license.EditionTypeEnum;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.client.LicenseController;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.file.Account;
import com.kingdee.eas.base.license.file.LicenseCloudRequestInfo;
import com.kingdee.eas.base.license.file.LicenseValidateInfo;
import com.kingdee.eas.base.log.StatisticConstant;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.ActiveCodeUI;
import com.kingdee.eas.base.uiframe.client.ProductExpireNoticeUI;
import com.kingdee.eas.base.uiframe.client.ProductValidityNoticeUI;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.base.uiframe.client.util.CloudUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;

public class LicenseHelper {
    private static final Logger logger = Logger.getLogger(LicenseHelper.class);
    private static final String LICENSE_CLIENT_IP = "License.ClientIP";
    private static final String LICENSE_LOGIN_TIME = "License.LoginTime";
    private static final String LICENSE_USER_INFO = "License.UserInfo";

    public static LicenseUserInfo createLicenseUserInfo() {
        LicenseUserInfo user = null;
        try {
            CompanyOrgUnitInfo orgUnit;
            String clientIP = InetAddress.getLocalHost().getHostAddress();
            Date loginTime = new Date(System.currentTimeMillis());
            SysContext.getSysContext().setProperty((Object)LICENSE_CLIENT_IP, (Object)clientIP);
            SysContext.getSysContext().setProperty((Object)LICENSE_LOGIN_TIME, (Object)loginTime);
            user = new LicenseUserInfo();
            if (SysContext.getSysContext().getCurrentUser() != null) {
                user.setUserID(((UserInfo)SysContext.getSysContext().getCurrentUser()).getId().toString());
            }
            if (SysContext.getSysContext().getUserName() != null) {
                user.setUserName(SysContext.getSysContext().getUserName());
            }
            if ((orgUnit = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany()) == null) {
                user.setUserCompany("");
            } else {
                String compName = orgUnit.getName(SysContext.getSysContext().getLocale());
                user.setUserCompany(compName);
            }
            if (SysContext.getSysContext().getDcName() != null) {
                user.setUserLoginAis(SysContext.getSysContext().getDcName());
            }
            if (SysContext.getSysContext().getProperty((Object)"SessionId") != null) {
                user.setSessionID((String)SysContext.getSysContext().getProperty((Object)"SessionId"));
            }
            user.setUserIP(clientIP);
            user.setUserLoginTime(loginTime);
            SysContext.getSysContext().setProperty((Object)LICENSE_USER_INFO, (Object)user);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            user = null;
        }
        return user;
    }

    public static boolean checkLicence(Component owner, String packageName) throws LicenseException {
        boolean hasLicence = false;
        LicenseUserInfo user = LicenseHelper.createLicenseUserInfo();
        LicenseController lc = LicenseController.getInstance();
        if (user == null) {
            return true;
        }
        int licenselcFlag = lc.requestLicense(user, packageName);
        switch (licenselcFlag) {
            case 1: {
                hasLicence = true;
                break;
            }
            case 4: {
                MsgBox.showError((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid"));
                break;
            }
            case 2: {
                MsgBox.showError((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_NO_SURPLUS"));
            }
        }
        return hasLicence;
    }

    public static void abort() {
        throw new AbortException();
    }

    public static boolean releaseLicense(boolean hasLicence, String packageName) {
        if (hasLicence) {
            String sessionId = SysContext.getSysContext().getSessionID();
            LicenseController lc = LicenseController.getInstance();
            try {
                lc.releaseLicense(sessionId, packageName);
            }
            catch (LicenseException licenseException) {
                // empty catch block
            }
            hasLicence = false;
        }
        return hasLicence;
    }

    public static boolean isTrail() {
        try {
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
            return agent.isDemoVersion();
        }
        catch (LicenseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean keyPointLicenseCheck() {
        String[] aixs;
        LicenseCloudRequestInfo requestInfo;
        boolean result;
        logger.info((Object)"keyPointLicenseCheck enter");
        ILicenseSrvAgent agent = null;
        try {
            agent = LicenseSrvAgentFactory.getRemoteInstance();
            if (2 == agent.getLicenseBaseInfo().getLicenseType()) {
                return true;
            }
            EditionTypeEnum editionType = agent.getEditionType();
            if (editionType != EditionTypeEnum.ENTERPRISE) {
                logger.info((Object)EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"24_LicenseHelper"));
                return true;
            }
        }
        catch (LicenseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return true;
        }
        LicenseValidateInfo info = agent.getLicenseValidateInfo();
        String latestCheckDate = info.getLatestCheckDate();
        String createDate = info.getCreateDate();
        if (StringUtils.isEmpty((String)latestCheckDate) && !StringUtils.isEmpty((String)createDate)) {
            latestCheckDate = createDate;
        }
        if (LicenseHelper.calculateDaysBetween(latestCheckDate, info.getCurrentDate()) > 10L) {
            latestCheckDate = null;
        }
        if ((StringUtils.isEmpty((String)latestCheckDate) || LicenseHelper.calculateDaysBetween(info.getCurrentDate(), latestCheckDate) > 180L) && !(result = LicenseHelper.validateLicense(requestInfo = agent.generateRequestInfo(aixs = new String[]{SysContext.getSysContext().getDcName()})))) {
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"30_LicenseHelper"));
            return LicenseHelper.showActiveUI(StringUtils.equals((String)latestCheckDate, (String)createDate));
        }
        logger.info((Object)"keyPointLicenseCheck end");
        return true;
    }

    private static boolean showActiveUI(boolean needProvideAssistFile) {
        IUIFactory uiFactory = null;
        try {
            UIContext ctx = new UIContext();
            logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"31_LicenseHelper") + (needProvideAssistFile ? EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"32_LicenseHelper") : EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"33_LicenseHelper"))));
            ctx.put("needProvideAssistFile", needProvideAssistFile);
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow uiWindow = uiFactory.create(ActiveCodeUI.class.getName(), (Map)ctx);
            ActiveCodeUI uiObject = (ActiveCodeUI)uiWindow.getUIObject();
            uiWindow.show();
            return uiObject.getReturnValue();
        }
        catch (UIException ex) {
            ExceptionHandler.handle((Throwable)ex);
            return false;
        }
    }

    public static boolean showValidityNoticeUI(long days) {
        IUIFactory uiFactory = null;
        try {
            UIContext ctx = new UIContext();
            ctx.put("days", days);
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow uiWindow = uiFactory.create(ProductValidityNoticeUI.class.getName(), (Map)ctx);
            ProductValidityNoticeUI uiObject = (ProductValidityNoticeUI)uiWindow.getUIObject();
            uiWindow.show();
            return true;
        }
        catch (UIException ex) {
            ExceptionHandler.handle((Throwable)ex);
            return false;
        }
    }

    public static boolean showExpireNoticeUI() {
        IUIFactory uiFactory = null;
        try {
            UIContext ctx = new UIContext();
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow uiWindow = uiFactory.create(ProductExpireNoticeUI.class.getName(), (Map)ctx);
            ProductExpireNoticeUI uiObject = (ProductExpireNoticeUI)uiWindow.getUIObject();
            uiWindow.show();
            return true;
        }
        catch (UIException ex) {
            ExceptionHandler.handle((Throwable)ex);
            return false;
        }
    }

    public static String sendData(JSONObject json) throws Exception {
        HttpClient http = new HttpClient();
        String url = "https://api.cmcloud.cn/api/genuineCheck.do";
        UTF8PostMethod post = new UTF8PostMethod(url);
        NameValuePair reqPart = new NameValuePair("req", json.toString());
        NameValuePair[] parts = new NameValuePair[]{reqPart};
        post.setRequestBody(parts);
        int status = http.executeMethod((HttpMethod)post);
        logger.info((Object)("http.executeMethod(get) status: " + status));
        String response = new String(post.getResponseBodyAsString().getBytes("utf-8"), "utf-8");
        logger.info((Object)("response: " + response));
        post.releaseConnection();
        return response;
    }

    public static JSONObject generateJSONObject(LicenseCloudRequestInfo requestInfo) throws JSONException {
        Account[] accounts;
        JSONObject json = new JSONObject();
        if (requestInfo == null) {
            return json;
        }
        json.put("FProductRegNO", (Object)requestInfo.getProductRegNO());
        json.put("FProductID", (Object)requestInfo.getProductID());
        json.put("FLicExpireDate", (Object)requestInfo.getExpireDate());
        json.put("FLicMD5", (Object)requestInfo.getLicenseMD5());
        json.put("FCellsMD5", (Object)requestInfo.getCellsMD5());
        json.put("FAdditionalInfo", (Object)requestInfo.getAdditionalInfo());
        json.put("FMode", (Object)requestInfo.getEncryMode());
        json.put("FType", (Object)requestInfo.getType());
        json.put("FPeriod", (Object)requestInfo.getPeriod());
        json.put("FLicName", (Object)requestInfo.getLicenseName());
        if (!StringUtils.isEmpty((String)requestInfo.getRegisterUsers())) {
            json.put("FRegisterUsers", (Object)new JSONArray(requestInfo.getRegisterUsers()));
        }
        if ((accounts = requestInfo.getAccounts()) != null && accounts.length > 0) {
            JSONArray jsonArray = new JSONArray();
            for (int i = 0; i < accounts.length; ++i) {
                JSONObject subJson = new JSONObject();
                subJson.put("FAccountName", (Object)accounts[i].getAccountName());
                subJson.put("FProductVer", (Object)accounts[i].getProductVersion());
                subJson.put("FCustomName", (Object)accounts[i].getCustomerName());
                jsonArray.put((Object)subJson);
            }
            json.put("FAccounts", (Object)jsonArray);
        }
        return json;
    }

    public static String decodeBASE64(String source) {
        return new String(Base64Encoder.base64ToByteArray((String)source));
    }

    public static String generateActiveCode() throws LicenseException {
        ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
        LicenseValidateInfo info = agent.getLicenseValidateInfo();
        String productCode = info.getProductCode();
        String softwareCode = info.getSoftwareCode();
        softwareCode = softwareCode.substring(0, 16);
        SecureRandom randomrand = new SecureRandom();
        String rand = String.valueOf(randomrand.nextInt(9999));
        switch (rand.length()) {
            case 1: {
                rand = "000" + rand;
                break;
            }
            case 2: {
                rand = "00" + rand;
                break;
            }
            case 3: {
                rand = "0" + rand;
                break;
            }
            default: {
                rand = rand.substring(0, 4);
            }
        }
        String activeCode = productCode + softwareCode + rand;
        assert (activeCode.length() == 30);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < activeCode.length(); i += 5) {
            result.append(activeCode.substring(i, i + 5)).append("-");
        }
        return result.substring(0, result.length() - 1);
    }

    public static boolean validateLicense(LicenseCloudRequestInfo requestInfo) {
        try {
            if (requestInfo == null) {
                logger.error((Object)"requestInfo is null.");
                return false;
            }
            JSONObject obj = LicenseHelper.generateJSONObject(requestInfo);
            String response = LicenseHelper.sendData(obj);
            JSONObject json = new JSONObject(response);
            String validateResult = LicenseHelper.decodeBASE64(json.get("result").toString());
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance((String)LicenseHelper.getRpcUrl());
            agent.updateLicenseValidate(validateResult);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public static LicenseValidateInfo getLicenseValidateInfo() {
        try {
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance((String)LicenseHelper.getRpcUrl());
            LicenseValidateInfo info = agent.getLicenseValidateInfo();
            return info;
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            return null;
        }
    }

    public static long calculateDaysBetween(String source, String destin) {
        if (StringUtils.isEmpty((String)source) || StringUtils.isEmpty((String)destin)) {
            return 100L;
        }
        DateFormat formatter = BOSLocaleUtil.getDateFormat();
        try {
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            if (!StringUtils.isEmpty((String)source)) {
                Date sourceDate = formatter.parse(source);
                logger.error((Object)("source date:" + sourceDate.toString()));
                c1.setTime(sourceDate);
            }
            if (!StringUtils.isEmpty((String)destin)) {
                Date destDate = formatter.parse(destin);
                logger.error((Object)("dest date:" + destDate.toString()));
                c2.setTime(destDate);
            }
            return (c1.getTimeInMillis() - c2.getTimeInMillis()) / 86400000L;
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            return 100L;
        }
    }

    public static long calculateDaysBetweenByDay(String source, String destin) {
        SimpleDateFormat formatDays = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date sourceDate = formatDays.parse(source);
            Date destinDate = formatDays.parse(destin);
            if (sourceDate.compareTo(destinDate) == 0) {
                return 1L;
            }
            return (sourceDate.getTime() - destinDate.getTime()) / 86400000L;
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return 100L;
        }
    }

    public static boolean isNeedRevalidate() {
        ILicenseSrvAgent agent = null;
        try {
            agent = LicenseSrvAgentFactory.getRemoteInstance((String)LicenseHelper.getRpcUrl());
        }
        catch (LicenseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        String period = CloudUtil.getLicenseCheckPeriod();
        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"41_LicenseHelper") + period));
        if (StatisticConstant.ERROR.equals(period)) {
            return false;
        }
        boolean isNeedRevalidate = agent.isNeedRevalidate(period);
        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"42_LicenseHelper") + isNeedRevalidate));
        return isNeedRevalidate;
    }

    public static String getRpcUrl() {
        String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
        if (rpcUrl == null || rpcUrl.trim().equals("")) {
            rpcUrl = UIConfig.getUrl();
        }
        return rpcUrl;
    }

    public static boolean isBySubscriptionRegOnline() throws LicenseException {
        return ControlPolicy.isBySubscriptionRegOnline(null);
    }

    public static class UTF8PostMethod
    extends PostMethod {
        public UTF8PostMethod(String url) {
            super(url);
        }

        public String getRequestCharSet() {
            return "UTF-8";
        }
    }
}

