/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.file.LicenseCloudRequestInfo;
import com.kingdee.eas.base.license.file.LicenseValidateInfo;
import com.kingdee.eas.base.uiframe.client.AbstractLicenseValidateUI;
import com.kingdee.eas.base.uiframe.client.LicenseHelper;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.apache.log4j.Logger;

public class LicenseValidateUI
extends AbstractLicenseValidateUI {
    private static final Logger logger = CoreUIObject.getLogger(LicenseValidateUI.class);
    private String aix;

    public LicenseValidateUI(String aix) throws Exception {
        this.aix = aix;
        this.initUIContentLayout();
        this.setBackground(new Color(255, 241, 212));
        this.validateMethodTips.setVisible(false);
        this.btnValidate.setVisible(false);
        this.limitTips.setFont(new Font(null, 0, 18));
        this.dayLabel.setFont(new Font(null, 0, 18));
        this.limitDays.setFont(new Font(null, 0, 32));
        this.addListener();
    }

    private void addListener() {
        this.onLineBugTips.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                LicenseValidateUI.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LicenseValidateUI.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                FrameWorkUtils.openByDefaultBrowser((String)"http://www.kingdee.com");
            }
        });
        this.validateMethodTips.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                LicenseValidateUI.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LicenseValidateUI.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                String url = "http://www.kingdee.com/genuine/reqquery.jsp?requestid=";
                ILicenseSrvAgent agent = null;
                try {
                    agent = LicenseSrvAgentFactory.getRemoteInstance();
                }
                catch (LicenseException e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                    return;
                }
                LicenseValidateInfo validateInfo = agent.getLicenseValidateInfo();
                String requestId = validateInfo.getRequestId();
                if (StringUtils.isEmpty((String)requestId)) {
                    requestId = "unknown";
                }
                url = url + requestId;
                String productCode = validateInfo.getProductCode();
                if (StringUtils.isEmpty((String)productCode)) {
                    productCode = "unknown";
                }
                url = url + "&productcode=" + productCode;
                String softwarecode = validateInfo.getSoftwareCode();
                if (StringUtils.isEmpty((String)softwarecode)) {
                    softwarecode = "unknown";
                }
                url = url + "&softwarecode=" + softwarecode;
                FrameWorkUtils.openByDefaultBrowser((String)url);
            }
        });
    }

    @Override
    protected void btnValidate_actionPerformed(ActionEvent e) throws Exception {
        LicenseCloudRequestInfo requestInfo;
        ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
        String[] aixs = null;
        if (!StringUtils.isEmpty((String)this.aix)) {
            aixs = new String[]{this.aix};
        }
        if ((requestInfo = agent.generateRequestInfo(aixs)) == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"14_LicenseValidateUI"));
            return;
        }
        boolean result = LicenseHelper.validateLicense(requestInfo);
        if (!result) {
            logger.error((Object)("result: " + result));
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"15_LicenseValidateUI"));
            return;
        }
        LicenseValidateInfo validityInfo = agent.getLicenseValidateInfo();
        if (validityInfo == null || validityInfo.getStatus() != 0 || "2".equals(validityInfo.getValidityStatus())) {
            logger.error((Object)"validityInfo is null or validityInfo != normal or validityInfo is illegal");
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"15_LicenseValidateUI"));
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"16_LicenseValidateUI"));
        }
    }
}

