/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.eas.base.uiframe.client.BusinessWorker;
import com.kingdee.eas.base.uiframe.client.ILongTaskPost;

public abstract class LongTask {
    private int current = 0;
    private boolean done = false;
    private boolean canceled = false;
    private String stateMessage;
    private boolean indeterminate = false;
    private ILongTaskPost post = null;
    private String progressMsg = null;
    private BusinessWorker worker = null;
    private Object value;
    public static final int ONE_SECOND = 1000;
    public static final int NORMAL = 10;
    public static final int NORMALCANCEL = 11;
    public static final int MODAL = 20;
    public static final int MODALCANCEL = 21;
    public static final int NONDISP = 30;
    public static final int NONE = 0;
    private int taskType = 10;

    public LongTask() {
    }

    public LongTask(ILongTaskPost pPost) {
        this.post = pPost;
    }

    public LongTask(int taskType) {
        this.taskType = taskType;
    }

    public LongTask(int taskType, ILongTaskPost pPost) {
        this.taskType = taskType;
        this.post = pPost;
    }

    public synchronized Object getValue() {
        return this.value;
    }

    public synchronized void setValue(Object x) {
        this.value = x;
    }

    public void go() {
        BusinessWorker worker = new BusinessWorker(){

            @Override
            public Object construct() {
                LongTask.this.current = LongTask.this.getMinimum();
                LongTask.this.done = false;
                LongTask.this.canceled = false;
                LongTask.this.progressMsg = null;
                return LongTask.this.exec();
            }

            @Override
            public void finished() {
                LongTask.this.finish(this.getValue());
            }
        };
        worker.start();
    }

    public abstract Object exec();

    int getLengthOfTask() {
        return 100;
    }

    int getCurrent() {
        return this.current;
    }

    void cancel() {
        this.canceled = true;
        if (this.indeterminate) {
            this.indeterminate = false;
        }
        if (this.post != null) {
            this.post.canceled(null);
        }
    }

    protected void finish(Object value) {
        this.done = true;
        if (this.indeterminate) {
            this.indeterminate = false;
        }
        if (this.post != null) {
            this.post.finished(value);
        }
    }

    boolean isDone() {
        return this.done;
    }

    String getMessage() {
        return this.stateMessage;
    }

    boolean isIndeterminate() {
        return this.indeterminate;
    }

    String getProgressMsg() {
        return this.progressMsg;
    }

    boolean isCanceled() {
        return this.canceled;
    }

    int getTaskType() {
        return this.taskType;
    }

    int getDelay() {
        return 1000;
    }

    int getMinimum() {
        return 0;
    }

    public void setCurrent(int i) {
        this.current = i;
    }

    public void setIndeterminate(boolean b) {
        this.indeterminate = b;
    }

    public void setProgressMsg(String string) {
        this.progressMsg = string;
    }

    public void setMessage(String string) {
        this.stateMessage = string;
    }
}

