/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfo;
import com.kingdee.eas.base.permission.MainMenuItemCollection;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.uiframe.BizTypeEnum;
import com.kingdee.eas.base.uiframe.IMainFunctionMenu;
import com.kingdee.eas.base.uiframe.IndustryEnum;
import com.kingdee.eas.base.uiframe.MainFunctionMenuFactory;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.eas.base.uiframe.SysMenuItemInfo;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.IMenuBuilder;
import com.kingdee.eas.base.uiframe.client.IMenuComponent;
import com.kingdee.eas.base.uiframe.client.MainFunctionMenuUI;
import com.kingdee.eas.base.uiframe.client.MainMenuComposite;
import com.kingdee.eas.base.uiframe.client.MainMenuLeaf;
import com.kingdee.eas.base.uiframe.client.MainMenuModel;
import com.kingdee.eas.base.uiframe.client.MainMenuTree;
import com.kingdee.eas.base.uiframe.client.MenuComposite;
import com.kingdee.eas.base.uiframe.client.MenuLeaf;
import com.kingdee.eas.base.uiframe.client.MenuVisitorHelper;
import com.kingdee.eas.base.uiframe.client.util.MainMenuComparator;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JViewport;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

class MainMenuBuilder
implements IMenuBuilder {
    private Object[] menuModels = null;
    private JViewport[] viewPorts = null;
    private KDScrollPane[] scrollPanes = null;
    MainFunctionMenuUI owner = null;
    protected static Logger logger = Logger.getLogger(MainMenuBuilder.class);
    private static final Icon ICON_FOLDER_OPEN = EASResource.getIcon((String)"imgTree_folder_openpick");
    private static final Icon ICON_FOLDER_CLOSE = EASResource.getIcon((String)"imgTree_folder_closepick");
    private static final Icon ICON_LEAF = EASResource.getIcon((String)"imgTree_folder_leafpick");
    public static final String sample = "com.kingdee.eas.base.uiframe.client.MyUI";
    public static final Color disableColor = new Color(102, 102, 102);

    public MainMenuBuilder(MainMenuItemCollection topMenus) throws EASBizException, BOSException {
        this.menuModels = MainMenuBuilder.buildSubSysMenuModels(topMenus).toArray();
        this.viewPorts = new JViewport[this.menuModels.length];
        this.scrollPanes = new KDScrollPane[this.menuModels.length];
    }

    public void setMenuModels(Object[] menuModels) {
        this.menuModels = menuModels;
    }

    @Override
    public JViewport getViewPort(int index) throws EASBizException, BOSException {
        if (this.viewPorts[index] == null) {
            this.initViewPort(index);
        }
        return this.viewPorts[index];
    }

    public KDScrollPane getScrollPane(int index) throws EASBizException, BOSException {
        if (this.scrollPanes[index] == null) {
            this.initScrollPane(index);
        }
        return this.scrollPanes[index];
    }

    private void initScrollPane(int index) throws EASBizException, BOSException {
        logger.info((Object)"Begin init menu tree!");
        long start = System.currentTimeMillis();
        MainMenuTree menuTree = new MainMenuTree(MainMenuBuilder.buildSubSysTree2(((MainMenuModel)this.menuModels[index]).getLongNumber()));
        MainMenuBuilder.filterUnVisibleNode(menuTree);
        menuTree.setRootVisible(false);
        long cost = System.currentTimeMillis() - start;
        logger.info((Object)"End init menu tree!");
        logger.info((Object)("Init menu tree : " + cost + " ms!"));
        menuTree.owner = this.owner;
        menuTree.setShowsRootHandles(true);
        menuTree.setRowHeight(20);
        menuTree.setBackground(Color.decode("#EFEFED"));
        this.viewPorts[index] = new JViewport();
        this.viewPorts[index].setView((Component)((Object)menuTree));
        this.viewPorts[index].setBackground(Color.decode("#EFEFED"));
        this.scrollPanes[index] = new KDScrollPane((Component)((Object)menuTree));
        this.scrollPanes[index].setBorder(null);
        this.scrollPanes[index].setBackground(Color.decode("#EFEFED"));
        this.scrollPanes[index].getViewport().setBackground(Color.decode("#EFEFED"));
    }

    private void initViewPort(int index) throws EASBizException, BOSException {
        logger.info((Object)"Begin init menu tree!");
        long start = System.currentTimeMillis();
        MainMenuTree menuTree = new MainMenuTree(MainMenuBuilder.buildSubSysTree2(((MainMenuModel)this.menuModels[index]).getLongNumber()));
        long cost = System.currentTimeMillis() - start;
        logger.info((Object)"End init menu tree!");
        logger.info((Object)("Init menu tree : " + cost + " ms!"));
        menuTree.owner = this.owner;
        menuTree.setShowsRootHandles(true);
        menuTree.setRowHeight(20);
        menuTree.setBackground(Color.decode("#EFEFED"));
        this.viewPorts[index] = new JViewport();
        this.viewPorts[index].setView((Component)((Object)menuTree));
        this.viewPorts[index].setBackground(Color.decode("#EFEFED"));
    }

    @Override
    public Object[] getSubSysMenuModels() {
        return this.menuModels;
    }

    private static ArrayList buildSubSysMenuModels(MainMenuItemCollection menuItes) throws EASBizException, BOSException {
        ArrayList<MainMenuModel> result = new ArrayList<MainMenuModel>();
        Timestamp startTime = new Timestamp(System.currentTimeMillis());
        String longNumber = null;
        String name = null;
        String iconKey = null;
        MainMenuItemInfo info = null;
        MainMenuModel menuModel = null;
        String EAS_FIRST_LOAD_RESOURCE_NAME = "com.kingdee.eas.basedata.common.EASFirstLoadImageResource";
        Locale local = MainMenuBuilder.getLocale();
        for (int i = 0; i < menuItes.size(); ++i) {
            info = menuItes.get(i);
            longNumber = info.getLongNumber();
            name = info.getName();
            iconKey = info.getImagePath();
            Icon icon = null;
            if (!StringUtils.isEmpty((String)iconKey)) {
                if (iconKey.startsWith("imgMenumodule_eas_")) {
                    icon = EASResource.getIcon((String)(EAS_FIRST_LOAD_RESOURCE_NAME + "." + iconKey));
                } else if (iconKey.startsWith("img") && !iconKey.startsWith("imgMenumodule_eas_")) {
                    icon = UIFrameResource.getCommonIcon(iconKey);
                } else {
                    try {
                        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
                        String[] attParams = iconKey.split(";");
                        ComplexAttachmentInfo attinfo = acm.getComplexAttachmentInfo(attParams[0]);
                        if (attinfo != null) {
                            byte[] data = attinfo.getContent();
                            icon = new ImageIcon(data);
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)("get attchment icon error" + ex.getMessage()));
                    }
                }
            }
            menuModel = new MainMenuModel(longNumber, name, icon);
            if (!info.isVisible()) continue;
            result.add(menuModel);
        }
        logger.info((Object)(UIFrameUtils.getRes("res_4") + (double)(System.currentTimeMillis() - startTime.getTime()) / 1000.0));
        return result;
    }

    static TreeNode buildSubSysTree(String longNumber) throws EASBizException, BOSException {
        DefaultKingdeeTreeNode root = null;
        Timestamp startTime = new Timestamp(System.currentTimeMillis());
        try {
            IMainFunctionMenu iMainFunctionMenu = MainFunctionMenuFactory.getRemoteInstance();
            IRowSet rowset = iMainFunctionMenu.getMenuByParent(longNumber);
            MainMenuItemInfo parentItemInfo = null;
            MainMenuItemInfo menuItemInfo = null;
            SysMenuItemInfo sysMenu = null;
            DefaultKingdeeTreeNode menuComponent = null;
            IMenuComponent parent = null;
            Hashtable<String, MenuLeaf> menuht = new Hashtable<String, MenuLeaf>();
            PermItemInfo pemission = null;
            while (rowset.next()) {
                menuItemInfo = new MainMenuItemInfo();
                menuItemInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
                MainMenuBuilder.setMultiLangValue(menuItemInfo, rowset);
                menuItemInfo.setNumber(rowset.getString("FNumber"));
                menuItemInfo.setLongNumber(rowset.getString("FLongNumber"));
                if (rowset.getString("FParent") != null) {
                    parentItemInfo = new MainMenuItemInfo();
                    parentItemInfo.setId(BOSUuid.read((String)rowset.getString("FParent")));
                    menuItemInfo.setParent(parentItemInfo);
                } else {
                    menuItemInfo.setParent(null);
                }
                menuItemInfo.setLevel(rowset.getInt("FLevel"));
                menuItemInfo.setIsLeaf(rowset.getInt("FIsLeaf") != 0);
                menuItemInfo.setOrder(rowset.getString("FOrder"));
                menuItemInfo.setImagePath(rowset.getString("FImagePath"));
                menuItemInfo.setEnabled(rowset.getInt("FEnabled") != 0);
                menuItemInfo.setVisible(rowset.getInt("FVisible") != 0);
                menuItemInfo.setIsReport(rowset.getInt("FIsReport") != 0);
                menuItemInfo.setUiClassName(rowset.getString("FUiClassName"));
                menuItemInfo.setUiClassParam(rowset.getString("FUiClassParam"));
                menuItemInfo.setUiOprt(rowset.getString("FUiOprt"));
                menuItemInfo.setOpenMethod(OpenMethod.getEnum(rowset.getInt("FOpenMethod")));
                menuItemInfo.setShortcutCode(rowset.getString("FShortcutCode"));
                if (rowset.getString("FFunction") != null && rowset.getString("FFunction").trim().length() > 0) {
                    pemission = new PermItemInfo();
                    pemission.setId(BOSUuid.read((String)rowset.getString("FFunction")));
                    menuItemInfo.setFunction(pemission);
                }
                if (rowset.getString("FSysMenuID") != null && rowset.getString("FSysMenuID").trim().length() > 0) {
                    sysMenu = new SysMenuItemInfo();
                    sysMenu.setId(BOSUuid.read((String)rowset.getString("FSysMenuID")));
                    menuItemInfo.setSysMenu(sysMenu);
                }
                if (rowset.getInt("FIsLeaf") == 1) {
                    menuComponent = new MenuLeaf(menuItemInfo);
                    if (StringUtils.isEmpty((String)rowset.getString("FUiClassName")) || sample.equals(rowset.getString("FUiClassName")) || rowset.getInt("FEnabled") == 0) {
                        ((DefaultKingdeeTreeNode)menuComponent).setTextColor(disableColor);
                    }
                    if (null != menuItemInfo.getSysMenu() && menuItemInfo.getSysMenu().getId().toString().trim().length() > 0) {
                        ((DefaultKingdeeTreeNode)menuComponent).setCustomIcon(ICON_LEAF);
                    }
                } else {
                    menuComponent = new MenuComposite(menuItemInfo);
                    if (null != menuItemInfo.getSysMenu() && menuItemInfo.getSysMenu().getId().toString().trim().length() > 0) {
                        ((DefaultKingdeeTreeNode)menuComponent).setCustomOpenIcon(ICON_FOLDER_OPEN);
                        ((DefaultKingdeeTreeNode)menuComponent).setCustomClosedIcon(ICON_FOLDER_CLOSE);
                    }
                    menuht.put(menuItemInfo.getId().toString(), (MenuLeaf)menuComponent);
                }
                if (rowset.getString("FParent") == null) {
                    root = menuComponent;
                    continue;
                }
                parent = (IMenuComponent)menuht.get(rowset.getString("FParent"));
                if (parent == null) continue;
                parent.addComponent((IMenuComponent)menuComponent);
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        logger.info((Object)(UIFrameUtils.getRes("res_54") + (double)(System.currentTimeMillis() - startTime.getTime()) / 1000.0));
        return root;
    }

    static TreeNode[] buildSubSysTree2(String[] longNumber) throws EASBizException, BOSException {
        TreeNode[] root = null;
        Timestamp startTime = new Timestamp(System.currentTimeMillis());
        try {
            IMainFunctionMenu iMainFunctionMenu = MainFunctionMenuFactory.getRemoteInstance();
            IRowSet[] rowset = iMainFunctionMenu.getMenuByParent(longNumber);
            if (rowset != null && rowset.length >= 1) {
                int length = rowset.length;
                root = new TreeNode[length];
                for (int i = 0; i < length; ++i) {
                    root[i] = MainMenuBuilder.buildRsResult(rowset[i]);
                }
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        logger.info((Object)(UIFrameUtils.getRes("res_54") + (double)(System.currentTimeMillis() - startTime.getTime()) / 1000.0));
        return root;
    }

    static TreeNode[] buildSubSysTreeForMenuType(String[] longNumber, String menutype) throws EASBizException, BOSException {
        TreeNode[] root = null;
        Timestamp startTime = new Timestamp(System.currentTimeMillis());
        try {
            IMainFunctionMenu iMainFunctionMenu = MainFunctionMenuFactory.getRemoteInstance();
            IRowSet[] rowset = iMainFunctionMenu.getMenuByParentForMenuType(longNumber, menutype);
            if (rowset != null && rowset.length >= 1) {
                int length = rowset.length;
                root = new TreeNode[length];
                for (int i = 0; i < length; ++i) {
                    root[i] = MainMenuBuilder.buildRsResult(rowset[i]);
                }
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        logger.info((Object)(UIFrameUtils.getRes("res_54") + (double)(System.currentTimeMillis() - startTime.getTime()) / 1000.0));
        return root;
    }

    static TreeNode[] buildSimpleSubSysTree2(String[] longNumber) throws EASBizException, BOSException {
        TreeNode[] root = null;
        Timestamp startTime = new Timestamp(System.currentTimeMillis());
        try {
            IMainFunctionMenu iMainFunctionMenu = MainFunctionMenuFactory.getRemoteInstance();
            IRowSet[] rowset = iMainFunctionMenu.getSimpleMenuByParent(longNumber);
            if (rowset != null && rowset.length >= 1) {
                int length = rowset.length;
                root = new TreeNode[length];
                for (int i = 0; i < length; ++i) {
                    root[i] = MainMenuBuilder.buildSimpleRsResult(rowset[i]);
                }
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        logger.info((Object)(UIFrameUtils.getRes("res_54") + (double)(System.currentTimeMillis() - startTime.getTime()) / 1000.0));
        return root;
    }

    private static TreeNode buildSimpleRsResult(IRowSet rowset) throws SQLException {
        DefaultKingdeeTreeNode root = null;
        MainMenuItemInfo parentItemInfo = null;
        MainMenuItemInfo menuItemInfo = null;
        SysMenuItemInfo sysMenu = null;
        DefaultKingdeeTreeNode menuComponent = null;
        IMenuComponent parent = null;
        Hashtable<String, MenuLeaf> menuht = new Hashtable<String, MenuLeaf>();
        while (rowset.next()) {
            menuItemInfo = new MainMenuItemInfo();
            menuItemInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
            MainMenuBuilder.setMultiLangValue(menuItemInfo, rowset);
            menuItemInfo.setNumber(rowset.getString("FNumber"));
            menuItemInfo.setLongNumber(rowset.getString("FLongNumber"));
            if (rowset.getString("FParent") != null) {
                parentItemInfo = new MainMenuItemInfo();
                parentItemInfo.setId(BOSUuid.read((String)rowset.getString("FParent")));
                menuItemInfo.setParent(parentItemInfo);
            } else {
                menuItemInfo.setParent(null);
            }
            menuItemInfo.setLevel(rowset.getInt("FLevel"));
            menuItemInfo.setIsLeaf(rowset.getInt("FIsLeaf") != 0);
            if (rowset.getInt("FIsLeaf") == 1) {
                menuComponent = new MenuLeaf(menuItemInfo);
            } else {
                menuComponent = new MenuComposite(menuItemInfo);
                menuht.put(menuItemInfo.getId().toString(), (MenuLeaf)menuComponent);
            }
            if (rowset.getString("FSysMenuID") != null && rowset.getString("FSysMenuID").trim().length() > 0) {
                sysMenu = new SysMenuItemInfo();
                sysMenu.setId(BOSUuid.read((String)rowset.getString("FSysMenuID")));
                menuItemInfo.setSysMenu(sysMenu);
            }
            if (rowset.getString("FParent") == null) {
                root = menuComponent;
                continue;
            }
            parent = (IMenuComponent)menuht.get(rowset.getString("FParent"));
            if (parent == null) continue;
            parent.addComponent((IMenuComponent)menuComponent);
        }
        return root;
    }

    private static TreeNode buildRsResult(IRowSet rowset) throws SQLException {
        DefaultKingdeeTreeNode root = null;
        MainMenuItemInfo parentItemInfo = null;
        MainMenuItemInfo menuItemInfo = null;
        SysMenuItemInfo sysMenu = null;
        DefaultKingdeeTreeNode menuComponent = null;
        IMenuComponent parent = null;
        Hashtable<String, MenuLeaf> menuht = new Hashtable<String, MenuLeaf>();
        PermItemInfo pemission = null;
        while (rowset.next()) {
            menuItemInfo = new MainMenuItemInfo();
            menuItemInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
            MainMenuBuilder.setMultiLangValue(menuItemInfo, rowset);
            if (null == rowset.getString("FMenutype") || "".equals(rowset.getString("FMenutype"))) {
                menuItemInfo.setMenutype(BizTypeEnum.guimenu);
            } else {
                menuItemInfo.setMenutype(BizTypeEnum.getEnum(rowset.getString("FMenutype")));
            }
            menuItemInfo.setNumber(rowset.getString("FNumber"));
            menuItemInfo.setLongNumber(rowset.getString("FLongNumber"));
            if (rowset.getString("FIndustry") != null) {
                int industry = Integer.parseInt(rowset.getString("FIndustry"));
                menuItemInfo.setIndustry(IndustryEnum.getEnum(industry));
            }
            menuItemInfo.setNoSuit(rowset.getString("FNoSuit"));
            if (rowset.getString("FParent") != null) {
                parentItemInfo = new MainMenuItemInfo();
                parentItemInfo.setId(BOSUuid.read((String)rowset.getString("FParent")));
                menuItemInfo.setParent(parentItemInfo);
            } else {
                menuItemInfo.setParent(null);
            }
            menuItemInfo.setLevel(rowset.getInt("FLevel"));
            menuItemInfo.setIsLeaf(rowset.getInt("FIsLeaf") != 0);
            menuItemInfo.setOrder(rowset.getString("FOrder"));
            menuItemInfo.setImagePath(rowset.getString("FImagePath"));
            menuItemInfo.setEnabled(rowset.getInt("FEnabled") != 0);
            menuItemInfo.setVisible(rowset.getInt("FVisible") != 0);
            menuItemInfo.setIsReport(rowset.getInt("FIsReport") != 0);
            menuItemInfo.setUiClassName(rowset.getString("FUiClassName"));
            menuItemInfo.setUiClassParam(rowset.getString("FUiClassParam"));
            menuItemInfo.setUiOprt(rowset.getString("FUiOprt"));
            menuItemInfo.setOpenMethod(OpenMethod.getEnum(rowset.getInt("FOpenMethod")));
            menuItemInfo.setShortcutCode(rowset.getString("FShortcutCode"));
            if (rowset.getString("FFunction") != null && rowset.getString("FFunction").trim().length() > 0) {
                pemission = new PermItemInfo();
                pemission.setId(BOSUuid.read((String)rowset.getString("FFunction")));
                menuItemInfo.setFunction(pemission);
            }
            if (rowset.getString("FSysMenuID") != null && rowset.getString("FSysMenuID").trim().length() > 0) {
                sysMenu = new SysMenuItemInfo();
                sysMenu.setId(BOSUuid.read((String)rowset.getString("FSysMenuID")));
                menuItemInfo.setSysMenu(sysMenu);
            }
            if (rowset.getInt("FIsLeaf") == 1) {
                menuComponent = new MenuLeaf(menuItemInfo);
                if (StringUtils.isEmpty((String)rowset.getString("FUiClassName")) || sample.equals(rowset.getString("FUiClassName")) || rowset.getInt("FEnabled") == 0) {
                    ((DefaultKingdeeTreeNode)menuComponent).setTextColor(disableColor);
                }
                if (null != menuItemInfo.getSysMenu() && menuItemInfo.getSysMenu().getId().toString().trim().length() > 0) {
                    ((DefaultKingdeeTreeNode)menuComponent).setCustomIcon(ICON_LEAF);
                }
            } else {
                menuComponent = new MenuComposite(menuItemInfo);
                if (null != menuItemInfo.getSysMenu() && menuItemInfo.getSysMenu().getId().toString().trim().length() > 0) {
                    ((DefaultKingdeeTreeNode)menuComponent).setCustomOpenIcon(ICON_FOLDER_OPEN);
                    ((DefaultKingdeeTreeNode)menuComponent).setCustomClosedIcon(ICON_FOLDER_CLOSE);
                }
                menuht.put(menuItemInfo.getId().toString(), (MenuLeaf)menuComponent);
            }
            if (rowset.getString("FParent") == null) {
                root = menuComponent;
                continue;
            }
            parent = (IMenuComponent)menuht.get(rowset.getString("FParent"));
            if (parent == null) continue;
            parent.addComponent((IMenuComponent)menuComponent);
        }
        return root;
    }

    static TreeNode buildSubSysTree2(String longNumber) throws EASBizException, BOSException {
        DefaultKingdeeTreeNode root = null;
        Timestamp startTime = new Timestamp(System.currentTimeMillis());
        try {
            ArrayList<String> list;
            ArrayList menuList = (ArrayList)MenuVisitorHelper.getSubItemMap().get(longNumber);
            Hashtable<String, MainMenuLeaf> menuht = new Hashtable<String, MainMenuLeaf>();
            Hashtable<String, Integer> menuhtCount = new Hashtable<String, Integer>();
            MainMenuItemInfo menuItemInfo = null;
            for (int k = 0; k < menuList.size(); ++k) {
                DefaultKingdeeTreeNode menuComponent;
                menuItemInfo = (MainMenuItemInfo)menuList.get(k);
                if (menuItemInfo.isIsLeaf()) {
                    menuComponent = new MainMenuLeaf(menuItemInfo);
                    if (StringUtils.isEmpty((String)menuItemInfo.getUiClassName()) || sample.equals(menuItemInfo.getUiClassName()) || !menuItemInfo.isEnabled()) {
                        ((DefaultKingdeeTreeNode)menuComponent).setTextColor(disableColor);
                    }
                } else {
                    menuComponent = new MainMenuComposite(menuItemInfo);
                    menuht.put(menuItemInfo.getId().toString(), (MainMenuLeaf)menuComponent);
                    menuhtCount.put(menuItemInfo.getId().toString(), new Integer(0));
                }
                if (menuItemInfo.getParent() == null) {
                    root = menuComponent;
                    continue;
                }
                IMenuComponent parent = (IMenuComponent)menuht.get(menuItemInfo.getParent().getId().toString());
                if (parent == null) continue;
                parent.addComponent((IMenuComponent)menuComponent);
                Integer i = (Integer)menuhtCount.get(menuItemInfo.getParent().getId().toString());
                menuhtCount.put(menuItemInfo.getParent().getId().toString(), new Integer(i + 1));
            }
            long start1 = System.currentTimeMillis();
            do {
                list = new ArrayList<String>();
                for (Object obj : menuhtCount.keySet()) {
                    IMenuComponent menuComp;
                    MainMenuItemInfo info;
                    if ((Integer)menuhtCount.get(obj.toString()) != 0 || (info = ((MainMenuItemInfo)((MainMenuComposite)(menuComp = (IMenuComponent)menuht.get(obj.toString()))).getUserObject()).getParent()) == null) continue;
                    String parentId = info.getId().toString();
                    IMenuComponent parent = (IMenuComponent)menuht.get(parentId);
                    if (parent != null) {
                        parent.removeComponent(menuComp);
                    }
                    menuht.remove(obj.toString());
                    Integer count = (Integer)menuhtCount.get(parentId);
                    if (count != null) {
                        menuhtCount.put(parentId, new Integer(count - 1));
                    }
                    list.add(obj.toString());
                }
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    menuhtCount.remove(list.get(i).toString());
                }
            } while (list.size() > 0);
            long start2 = System.currentTimeMillis();
            logger.info((Object)(UIFrameUtils.getRes("res_55") + (start2 - start1) + "ms!"));
        }
        catch (Exception exc) {
            throw new BOSException((Throwable)exc);
        }
        logger.info((Object)(UIFrameUtils.getRes("res_54") + (double)(System.currentTimeMillis() - startTime.getTime()) / 1000.0));
        return root;
    }

    private static void setMultiLangValue(MainMenuItemInfo menuItem, IRowSet rowset) throws SQLException {
        List langList = KDBizMultiLangBox.getLanguageList();
        for (LanguageInfo currentLang : langList) {
            Locale locale = currentLang.getLocale();
            String name = rowset.getString("FName_" + locale.toString());
            menuItem.setName(name, locale);
            String description = rowset.getString("FDescription_" + locale.toString());
            menuItem.setDescription(description, locale);
            if (!locale.equals(SysContext.getSysContext().getLocale())) continue;
            menuItem.setName(name);
            menuItem.setDescription(description);
        }
    }

    static void buildMenuTreeNode(DefaultKingdeeTreeNode parentNode) throws EASBizException, BOSException {
        if (parentNode == null || !(parentNode instanceof MainMenuComposite)) {
            return;
        }
        MainMenuItemInfo parentData = (MainMenuItemInfo)parentNode.getUserObject();
        if (parentData == null) {
            return;
        }
        String longNumber = parentData.getLongNumber();
        if (longNumber == null || longNumber.length() == 0) {
            return;
        }
        try {
            IMainFunctionMenu iMainFunctionMenu = MainFunctionMenuFactory.getRemoteInstance();
            IRowSet rowset = iMainFunctionMenu.getMenuByParent(longNumber);
            if (rowset == null || !rowset.next()) {
                return;
            }
            if (parentNode.getChildCount() > 0) {
                parentNode.removeAllChildren();
            }
            Hashtable<String, DefaultKingdeeTreeNode> menuht = new Hashtable<String, DefaultKingdeeTreeNode>();
            menuht.put(parentData.getId().toString(), parentNode);
            while (rowset.next()) {
                IMenuComponent parent;
                DefaultKingdeeTreeNode menuComponent;
                MainMenuItemInfo menuItemInfo = new MainMenuItemInfo();
                menuItemInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
                menuItemInfo.setName(rowset.getString("FName_" + SysContext.getSysContext().getLocale().toString()));
                menuItemInfo.setNumber(rowset.getString("FNumber"));
                menuItemInfo.setDescription(rowset.getString("FDescription_" + SysContext.getSysContext().getLocale().toString()));
                menuItemInfo.setLongNumber(rowset.getString("FLongNumber"));
                if (rowset.getString("FParent") != null) {
                    MainMenuItemInfo parentItemInfo = new MainMenuItemInfo();
                    parentItemInfo.setId(BOSUuid.read((String)rowset.getString("FParent")));
                    menuItemInfo.setParent(parentItemInfo);
                } else {
                    menuItemInfo.setParent(null);
                }
                menuItemInfo.setLevel(rowset.getInt("FLevel"));
                menuItemInfo.setIsLeaf(rowset.getInt("FIsLeaf") != 0);
                menuItemInfo.setOrder(rowset.getString("FOrder"));
                menuItemInfo.setImagePath(rowset.getString("FImagePath"));
                menuItemInfo.setEnabled(rowset.getInt("FEnabled") != 0);
                menuItemInfo.setVisible(rowset.getInt("FVisible") != 0);
                menuItemInfo.setUiClassName(rowset.getString("FUiClassName"));
                menuItemInfo.setUiClassParam(rowset.getString("FUiClassParam"));
                menuItemInfo.setUiOprt(rowset.getString("FUiOprt"));
                menuItemInfo.setOpenMethod(OpenMethod.getEnum(rowset.getInt("FOpenMethod")));
                menuItemInfo.setShortcutCode(rowset.getString("FShortcutCode"));
                if (rowset.getInt("FIsLeaf") == 1) {
                    menuComponent = new MainMenuLeaf(menuItemInfo);
                    String string = sample;
                } else {
                    menuComponent = new MainMenuComposite(menuItemInfo);
                    menuht.put(menuItemInfo.getId().toString(), menuComponent);
                }
                if ((parent = (IMenuComponent)menuht.get(rowset.getString("FParent"))) == null) continue;
                parent.addComponent((IMenuComponent)menuComponent);
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
    }

    static void filterUnVisibleNode(KDTree tree) {
        if (tree == null) {
            return;
        }
        KingdeeTreeModel treeModel = (KingdeeTreeModel)tree.getModel();
        Object obj = treeModel.getRoot();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)obj;
        MainMenuBuilder.filterUnVisibleNode(treeModel, root);
    }

    private static void filterUnVisibleNode(KingdeeTreeModel treeModel, DefaultKingdeeTreeNode root) {
        Enumeration children = root.children();
        ArrayList<DefaultKingdeeTreeNode> list = new ArrayList<DefaultKingdeeTreeNode>();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)children.nextElement();
            MainMenuItemInfo info = (MainMenuItemInfo)tempNode.getUserObject();
            if (info.isIsLeaf()) {
                if (info.isVisible()) continue;
                list.add(tempNode);
                continue;
            }
            if (info.isVisible()) {
                MainMenuBuilder.filterUnVisibleNode(treeModel, tempNode);
                continue;
            }
            list.add(tempNode);
        }
        MainMenuBuilder.removeNodeFromRoot(treeModel, list);
        MainMenuBuilder.filterNoLeafNode(treeModel, root);
    }

    private static void filterNoLeafNode(KingdeeTreeModel treeModel, DefaultKingdeeTreeNode root) {
        Enumeration children = root.children();
        ArrayList<DefaultKingdeeTreeNode> list = new ArrayList<DefaultKingdeeTreeNode>();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)children.nextElement();
            MainMenuItemInfo info = (MainMenuItemInfo)tempNode.getUserObject();
            if (!info.isIsLeaf() && tempNode.getChildCount() == 0) {
                list.add(tempNode);
                continue;
            }
            MainMenuBuilder.filterNoLeafNode(treeModel, tempNode);
        }
        MainMenuBuilder.removeNodeFromRoot(treeModel, list);
    }

    private static void removeNodeFromRoot(KingdeeTreeModel treeModel, List delNodesList) {
        int num = delNodesList.size();
        if (num == 0) {
            return;
        }
        for (int i = 0; i < num; ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)delNodesList.get(i);
            treeModel.removeNodeFromParent((MutableTreeNode)node);
        }
    }

    private static Locale getLocale() {
        try {
            return SysContext.getSysContext().getLocale();
        }
        catch (Throwable e) {
            logger.error((Object)("Get Locale fail!" + e.getMessage()));
            return new Locale("L2");
        }
    }

    public static MainMenuItemInfo getMenuInfoByID(String menuID) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)menuID)) {
            return null;
        }
        IMainFunctionMenu iMainFunctionMenu = MainFunctionMenuFactory.getRemoteInstance();
        IRowSet rowset = iMainFunctionMenu.getMainMenuByID(menuID);
        try {
            if (rowset.next()) {
                MainMenuItemInfo menuItemInfo = new MainMenuItemInfo();
                menuItemInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
                MainMenuBuilder.setMultiLangValue(menuItemInfo, rowset);
                menuItemInfo.setNumber(rowset.getString("FNumber"));
                menuItemInfo.setIndustry(IndustryEnum.getEnum(rowset.getInt("FIndustry")));
                menuItemInfo.setNoSuit(rowset.getString("FNoSuit"));
                menuItemInfo.setLongNumber(rowset.getString("FLongNumber"));
                if (!StringUtils.isEmpty((String)rowset.getString("FParent"))) {
                    MainMenuItemInfo parentItemInfo = new MainMenuItemInfo();
                    parentItemInfo.setId(BOSUuid.read((String)rowset.getString("FParent")));
                    menuItemInfo.setParent(parentItemInfo);
                }
                menuItemInfo.setLevel(rowset.getInt("FLevel"));
                menuItemInfo.setIsLeaf(rowset.getBoolean("FIsLeaf"));
                menuItemInfo.setOrder(rowset.getString("FOrder"));
                menuItemInfo.setImagePath(rowset.getString("FImagePath"));
                menuItemInfo.setEnabled(rowset.getBoolean("FEnabled"));
                menuItemInfo.setVisible(rowset.getBoolean("FVisible"));
                menuItemInfo.setIsReport(rowset.getBoolean("FIsReport"));
                menuItemInfo.setUiClassName(rowset.getString("FUiClassName"));
                menuItemInfo.setUiClassParam(rowset.getString("FUiClassParam"));
                menuItemInfo.setUiOprt(rowset.getString("FUiOprt"));
                menuItemInfo.setOpenMethod(OpenMethod.getEnum(rowset.getInt("FOpenMethod")));
                menuItemInfo.setShortcutCode(rowset.getString("FShortcutCode"));
                if (!StringUtils.isEmpty((String)rowset.getString("FFunction"))) {
                    PermItemInfo pemission = new PermItemInfo();
                    pemission.setId(BOSUuid.read((String)rowset.getString("FFunction")));
                    menuItemInfo.setFunction(pemission);
                }
                if (!StringUtils.isEmpty((String)rowset.getString("FSysMenuID"))) {
                    SysMenuItemInfo sysInfo = new SysMenuItemInfo();
                    sysInfo.setId(BOSUuid.read((String)rowset.getString("FSysMenuID")));
                    menuItemInfo.setSysMenu(sysInfo);
                }
                return menuItemInfo;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static void buildAllMainMenuTree(KDTree tree, BizTypeEnum menuType) throws EASBizException, BOSException {
        IMainFunctionMenu iMainFunctionMenu = MainFunctionMenuFactory.getRemoteInstance();
        String locale = SysContext.getSysContext().getLocale().toString();
        HashMap<String, List<MainMenuItemInfo>> parentMapper = new HashMap<String, List<MainMenuItemInfo>>();
        parentMapper.put("topNodes", new ArrayList());
        IRowSet rowset = iMainFunctionMenu.getAllMainMenuTree(menuType);
        try {
            while (rowset.next()) {
                MainMenuItemInfo menuItemInfo = new MainMenuItemInfo();
                menuItemInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
                menuItemInfo.setName(rowset.getString("FName_" + locale));
                menuItemInfo.setNumber(rowset.getString("FNumber"));
                menuItemInfo.setIsLeaf(rowset.getBoolean("FIsLeaf"));
                menuItemInfo.setLongNumber(rowset.getString("FLongNumber"));
                menuItemInfo.setOrder(rowset.getString("FOrder"));
                menuItemInfo.setEnabled(rowset.getBoolean("FEnabled"));
                if (!StringUtils.isEmpty((String)rowset.getString("FParent"))) {
                    MainMenuItemInfo parentInfo = new MainMenuItemInfo();
                    parentInfo.setId(BOSUuid.read((String)rowset.getString("FParent")));
                    menuItemInfo.setParent(parentInfo);
                    ArrayList<MainMenuItemInfo> subNodes = (ArrayList<MainMenuItemInfo>)parentMapper.get(rowset.getString("FParent"));
                    if (subNodes == null) {
                        subNodes = new ArrayList<MainMenuItemInfo>();
                        parentMapper.put(rowset.getString("FParent"), subNodes);
                    }
                    subNodes.add(menuItemInfo);
                } else {
                    ((List)parentMapper.get("topNodes")).add(menuItemInfo);
                }
                if (StringUtils.isEmpty((String)rowset.getString("FSysMenuID"))) continue;
                SysMenuItemInfo sysInfo = new SysMenuItemInfo();
                sysInfo.setId(BOSUuid.read((String)rowset.getString("FSysMenuID")));
                menuItemInfo.setSysMenu(sysInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        DefaultKingdeeTreeNode root = MainMenuBuilder.insertNodesIntoRoot(parentMapper);
        tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        tree.expandPath(new TreePath(root.getPath()));
        tree.setShowsRootHandles(true);
        tree.repaint();
    }

    private static DefaultKingdeeTreeNode insertNodesIntoRoot(Map<String, List<MainMenuItemInfo>> parentMapper) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"EAS");
        List<MainMenuItemInfo> topNodes = parentMapper.get("topNodes");
        Collections.sort(topNodes, new MainMenuComparator("order"));
        for (int i = 0; i < topNodes.size(); ++i) {
            MainMenuItemInfo info = topNodes.get(i);
            DefaultKingdeeTreeNode node = null;
            if (info.isIsLeaf()) {
                node = new MenuLeaf(info);
                if (!info.isEnabled()) {
                    node.setTextColor(disableColor);
                }
                if (info.getSysMenu() != null) {
                    node.setCustomIcon(ICON_LEAF);
                }
            } else {
                node = new MenuComposite(info);
                if (info.getSysMenu() != null) {
                    node.setCustomOpenIcon(ICON_FOLDER_OPEN);
                    node.setCustomClosedIcon(ICON_FOLDER_CLOSE);
                }
            }
            root.add((MutableTreeNode)node);
            MainMenuBuilder.stepAddNodesIntoParent(node, parentMapper);
        }
        return root;
    }

    private static void stepAddNodesIntoParent(DefaultKingdeeTreeNode root, Map<String, List<MainMenuItemInfo>> parentMapper) {
        MainMenuItemInfo info = (MainMenuItemInfo)root.getUserObject();
        String keyID = info.getId().toString();
        List<MainMenuItemInfo> subNodes = parentMapper.get(keyID);
        if (subNodes != null && subNodes.size() > 0) {
            Collections.sort(subNodes, new MainMenuComparator("longNumber"));
            for (int i = 0; i < subNodes.size(); ++i) {
                MainMenuItemInfo subNodeInfo = subNodes.get(i);
                DefaultKingdeeTreeNode node = null;
                if (subNodeInfo.isIsLeaf()) {
                    node = new MenuLeaf(subNodeInfo);
                    if (!subNodeInfo.isEnabled()) {
                        node.setTextColor(disableColor);
                    }
                    if (subNodeInfo.getSysMenu() != null) {
                        node.setCustomIcon(ICON_LEAF);
                    }
                    root.add((MutableTreeNode)node);
                    continue;
                }
                node = new MenuComposite(subNodeInfo);
                if (subNodeInfo.getSysMenu() != null) {
                    node.setCustomOpenIcon(ICON_FOLDER_OPEN);
                    node.setCustomClosedIcon(ICON_FOLDER_CLOSE);
                }
                root.add((MutableTreeNode)node);
                MainMenuBuilder.stepAddNodesIntoParent(node, parentMapper);
            }
        }
    }
}

