/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.swing.DefaultKingdeeListCellRenderer;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.client.MainMenuConstants;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.JList;

public class MainMenuListCellRenderer2
extends DefaultKingdeeListCellRenderer {
    private String itemName = null;
    private boolean isSelected;
    private boolean isLeaf = false;
    private Color selectedForeground = null;
    private int _textX = 0;
    private int _imageX = 0;

    public MainMenuListCellRenderer2() {
    }

    public MainMenuListCellRenderer2(int _textX, int _imageX) {
        this._textX = _textX;
        this._imageX = _imageX;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.isSelected = isSelected;
        this.selectedForeground = list.getSelectionForeground();
        MainMenuItemInfo menuInfo = (MainMenuItemInfo)value;
        this.itemName = menuInfo.getName();
        this.isLeaf = menuInfo.isIsLeaf() && !StringUtils.isEmpty((String)menuInfo.getUiClassName());
        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        this.setText("");
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setBackground(MainMenuConstants.BACKGROUND_COLOR);
        }
        return this;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Font font = new Font(null, 0, 12);
        g2d.setFont(font);
        g2d.setColor(this.isSelected ? this.selectedForeground : Color.BLACK);
        if (this._textX != 0 && this._imageX != 0) {
            g2d.drawString(StringUtils.isEmpty((String)this.itemName) ? "UNKNOWN" : this.itemName, this._textX, 20);
            g2d.drawImage(this.getImage(), this._imageX, 7, this.getLabelIcon().getIconWidth(), this.getLabelIcon().getIconHeight(), null);
        } else {
            int w = this.getWidth();
            g2d.drawString(StringUtils.isEmpty((String)this.itemName) ? "UNKNOWN" : this.itemName, w / 2 - 28, 20);
            g2d.drawImage(this.getImage(), w / 2 - 54, 7, this.getLabelIcon().getIconWidth(), this.getLabelIcon().getIconHeight(), null);
        }
    }

    private Image getImage() {
        if (this.isLeaf) {
            return MainMenuConstants.LEAF_MENU_IMAGE;
        }
        return MainMenuConstants.FOLDER_MENU_IMAGE;
    }

    private Icon getLabelIcon() {
        if (this.isLeaf) {
            return MainMenuConstants.LEAF_MENU_ICON;
        }
        return MainMenuConstants.FOLDER_MENU_ICON;
    }
}

