/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.framework.cache.UIActionMonitor;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.myeas.LastUsedFunctionCollection;
import com.kingdee.eas.base.myeas.LastUsedFunctionInfo;
import com.kingdee.eas.base.myeas.OpenModelInfo;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.ui.IMainUIContainer;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.MainFrameCallBack;
import com.kingdee.eas.base.uiframe.client.MainFunctionMenuUI;
import com.kingdee.eas.base.uiframe.client.MainMenuLeaf;
import com.kingdee.eas.base.uiframe.client.MyUI;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UIFrameContext;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.base.uiframe.client.ui.IMainUIObject;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class MainMenuTree
extends KDTree {
    protected static final Logger logger = Logger.getLogger(MainMenuTree.class);
    private JPopupMenu mnuOpenMethod1;
    private JPopupMenu mnuOpenMethod2;
    MainFunctionMenuUI owner = null;
    MainFunctionMenuUI espicalOwner = null;

    public MainMenuTree(TreeNode root) {
        super((TreeModel)new KingdeeTreeModel(root), false);
        this.initPopMenu();
        this.initKeyBordListener();
        this.initMouseListener();
    }

    public MainMenuTree(TreeNode root, MainFunctionMenuUI theOwner) {
        super((TreeModel)new KingdeeTreeModel(root), false);
        this.initPopMenu();
        this.initMouseListener();
        this.initKeyBordListener();
        this.espicalOwner = theOwner;
    }

    private void initPopMenu() {
        this.mnuOpenMethod1 = new JPopupMenu();
        JMenuItem miFixTab = new JMenuItem();
        JMenuItem miNewTab = new JMenuItem();
        JMenuItem miNewWin = new JMenuItem();
        JSeparator sep1 = new JSeparator();
        JMenuItem miNewSession = new JMenuItem();
        JSeparator sep2 = new JSeparator();
        JMenuItem miAddToFavorite = new JMenuItem();
        miFixTab.setText(MainMenuTree.getString("MainMenuTree.fixTab"));
        miFixTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuTree.this.miFixTab_actionPerformed(e);
            }
        });
        miNewTab.setText(MainMenuTree.getString("MainMenuTree.newTab"));
        miNewTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuTree.this.miNewTab_actionPerformed(e);
            }
        });
        miNewWin.setText(MainMenuTree.getString("MainMenuTree.newWin"));
        miNewWin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuTree.this.miNewWin_actionPerformed(e);
            }
        });
        miNewSession.setText(MainMenuTree.getString("MainMenuTree.newSession"));
        miNewSession.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuTree.this.miNewSession_actionPerformed(e);
            }
        });
        miAddToFavorite.setText(MainMenuTree.getString("MainMenuTree.addToFavorite"));
        miAddToFavorite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuTree.this.addToFavorite_actionPerformed(e);
            }
        });
        this.mnuOpenMethod1.add(miFixTab);
        this.mnuOpenMethod1.add(miNewTab);
        this.mnuOpenMethod1.add(miNewWin);
        this.mnuOpenMethod1.add(sep1);
        this.mnuOpenMethod1.add(miNewSession);
        this.mnuOpenMethod1.add(sep2);
        this.mnuOpenMethod1.add(miAddToFavorite);
        this.mnuOpenMethod2 = new JPopupMenu();
        JMenuItem miModel = new JMenuItem();
        miModel.setText(MainMenuTree.getString("MainMenuTree.model"));
        miModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuTree.this.miModel_actionPerformed(e);
            }
        });
        JSeparator sep3 = new JSeparator();
        JMenuItem miAddToFavorite2 = new JMenuItem();
        miAddToFavorite2.setText(MainMenuTree.getString("MainMenuTree.addToFavorite"));
        miAddToFavorite2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuTree.this.addToFavorite_actionPerformed(e);
            }
        });
        this.mnuOpenMethod2.add(miModel);
        this.mnuOpenMethod2.add(sep3);
        this.mnuOpenMethod2.add(miAddToFavorite2);
    }

    private void addToFavorite_actionPerformed(ActionEvent e) {
        this.espicalOwner.addToFavorite();
    }

    private void miFixTab_actionPerformed(ActionEvent e) {
        KDTree tree = (KDTree)this.mnuOpenMethod1.getInvoker();
        MainMenuTree.showUI((Component)tree, MainMenuTree.getCurrMenuFromTree(tree), OpenMethod.FIXTAB);
    }

    private void miNewTab_actionPerformed(ActionEvent e) {
        KDTree tree = (KDTree)this.mnuOpenMethod1.getInvoker();
        MainMenuTree.showUI((Component)tree, MainMenuTree.getCurrMenuFromTree(tree), OpenMethod.NEWTAB);
    }

    private void miNewWin_actionPerformed(ActionEvent e) {
        KDTree tree = (KDTree)this.mnuOpenMethod1.getInvoker();
        MainMenuTree.showUI((Component)tree, MainMenuTree.getCurrMenuFromTree(tree), OpenMethod.NEWWIN);
    }

    private void miNewSession_actionPerformed(ActionEvent e) {
        KDTree tree = (KDTree)this.mnuOpenMethod1.getInvoker();
        MainMenuTree.showUI((Component)tree, MainMenuTree.getCurrMenuFromTree(tree), OpenMethod.NEWSESSION);
    }

    private void miModel_actionPerformed(ActionEvent e) {
        KDTree tree = (KDTree)this.mnuOpenMethod2.getInvoker();
        MainMenuTree.showUI((Component)tree, MainMenuTree.getCurrMenuFromTree(tree), OpenMethod.MODEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void showUI(Component owner, MainMenuItemInfo menuItem, OpenMethod openMethod) {
        if (StringUtils.isEmpty((String)menuItem.getUiClassName()) || menuItem.getUiClassName().equals(MyUI.class.getName()) || !menuItem.isEnabled()) {
            return;
        }
        IMainUIContainer ui = SystemEntry.instance.getCurrenContainer();
        NewMainFrame mainFrame = null;
        if (ui != null && ui instanceof NewMainFrame && (mainFrame = (NewMainFrame)ui) != null) {
            mainFrame.setCursor(Cursor.getPredefinedCursor(3));
        }
        try {
            IUIWindow uiWindow = MainMenuTree.createUI(owner, menuItem, openMethod);
            if (uiWindow != null) {
                uiWindow.show();
            }
        }
        finally {
            if (mainFrame != null) {
                mainFrame.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    static IUIWindow createUI(Component owner, MainMenuItemInfo menuItem, OpenMethod openMethod) {
        if (owner == null || menuItem == null) {
            logger.debug((Object)"Parent component or Menu is null!");
            return null;
        }
        IUIWindow uiWindow = null;
        if (openMethod == null) {
            openMethod = menuItem.getOpenMethod();
        }
        Frame mainFrame = UIFrameUtil.getCurrMainFrame(owner);
        try {
            uiWindow = MainMenuTree.passCreateUI(mainFrame, menuItem.getUiClassName(), menuItem.getUiClassParam(), openMethod, menuItem.getUiOprt(), menuItem.getName());
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)owner, (Throwable)e);
        }
        return uiWindow;
    }

    static void showUI(Component owner, MainMenuItemInfo menuItem) {
        MainMenuTree.showUI(owner, menuItem, null);
    }

    static IUIWindow createUI(Component owner, MainMenuItemInfo menuItem) {
        return MainMenuTree.createUI(owner, menuItem, null);
    }

    private void initMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MainMenuTree.this.getClosestPath(e.getX(), e.getY()) == null || MainMenuTree.this.getPathForLocation(e.getX(), e.getY()) == null) {
                    return;
                }
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    if (MainMenuTree.this.getLastSelectedPathComponent() instanceof MainMenuLeaf) {
                        MainMenuTree.this.performDblclick();
                    }
                } else if (e.getButton() == 3 && MainMenuTree.this.getLastSelectedPathComponent() instanceof MainMenuLeaf) {
                    MainMenuItemInfo menuItemInfo = (MainMenuItemInfo)((MainMenuLeaf)MainMenuTree.this.getLastSelectedPathComponent()).getUserObject();
                    if (menuItemInfo.getOpenMethod() != OpenMethod.MODEL) {
                        MainMenuTree.this.mnuOpenMethod1.show((Component)e.getSource(), e.getX(), e.getY());
                    } else {
                        MainMenuTree.this.mnuOpenMethod2.show((Component)e.getSource(), e.getX(), e.getY());
                    }
                }
            }
        });
    }

    private void initKeyBordListener() {
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        actionMap.put("ENTER", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuTree.this.performDblclick();
            }
        });
    }

    private void performDblclick() {
        long start = System.currentTimeMillis();
        UIActionMonitor.startAction((String)"", (String)"");
        if ((DefaultKingdeeTreeNode)this.getLastSelectedPathComponent() == null) {
            return;
        }
        MainMenuItemInfo menuItem = (MainMenuItemInfo)((DefaultKingdeeTreeNode)this.getLastSelectedPathComponent()).getUserObject();
        MainMenuTree.showUI((Component)((Object)this), menuItem);
        UIActionMonitor.endAction((String)menuItem.getUiClassName(), (String)"clickMenuItem", (long)(System.currentTimeMillis() - start));
    }

    private static IUIWindow innerCreateUI(Frame mainFrame, String uiClassName, String uiClassParam, String factoryName, String oprt, String uiTitle) throws UIException {
        IUIFactory uiFactory = UIFactory.createUIFactory((String)factoryName);
        UIContext uiContext = new UIContext((Object)mainFrame);
        uiContext.put("checkLicense", "true");
        if (uiClassParam != null && uiClassParam.length() != 0) {
            uiContext.put("UIClassParam", uiClassParam);
        }
        if (uiTitle != null && !"".equals(uiTitle.trim())) {
            uiContext.put("MainMenuName", uiTitle);
        }
        IUIWindow uiWindow = uiFactory.create(uiClassName.trim(), (Map)uiContext, null, oprt);
        return uiWindow;
    }

    static IUIWindow passCreateUI(Frame mainFrame, String uiClassName, String uiClassParam, OpenMethod openMethod, String oprt, String uiTitle) throws UIException {
        OpenMethod finalOpenMethod = MainMenuTree.getFinalOpenMethod(mainFrame, openMethod);
        if (finalOpenMethod == null) {
            return null;
        }
        String uiFactory = MainMenuTree.transOpenMethodToUIFactory(finalOpenMethod);
        return MainMenuTree.innerCreateUI(mainFrame, uiClassName, uiClassParam, uiFactory, oprt, uiTitle);
    }

    static String transOpenMethodToUIFactory(OpenMethod finalOpenMethod) {
        String uiFactory = null;
        switch (finalOpenMethod.getValue()) {
            case 10: {
                uiFactory = "com.kingdee.eas.base.uiframe.client.UIFixTabFactory";
                break;
            }
            case 20: {
                uiFactory = "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
                break;
            }
            case 30: {
                uiFactory = "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
                break;
            }
            case 40: {
                uiFactory = "com.kingdee.eas.base.uiframe.client.UINewSessionFactory";
                break;
            }
            case 50: {
                uiFactory = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
            }
        }
        return uiFactory;
    }

    private static void addLastUsedFunction(MainMenuItemInfo menuItem) {
        Timestamp startTime = new Timestamp(System.currentTimeMillis());
        LastUsedFunctionInfo data = MainMenuTree.createLastUseFunction(menuItem);
        try {
            MainFrameCallBack.firePropertyChange("MyEasLastUsedFunction", "old", data);
        }
        catch (Exception e) {
            MainMenuTree.handException(e);
        }
        logger.info((Object)(UIFrameUtils.getRes("res_61") + (double)(System.currentTimeMillis() - startTime.getTime()) / 1000.0));
    }

    private static LastUsedFunctionInfo createLastUseFunction(MainMenuItemInfo menuItem) {
        LastUsedFunctionInfo data = new LastUsedFunctionInfo();
        UserInfo currUser = (UserInfo)SysContext.getSysContext().getCurrentUser();
        data.setMenuItem(menuItem);
        data.setUser(currUser);
        data.setUsedDate(new Time(System.currentTimeMillis()));
        if (UIFrameContext.getInstance().getProperty("LastUsedFunction") != null) {
            LastUsedFunctionCollection dataCollection = (LastUsedFunctionCollection)UIFrameContext.getInstance().getProperty("LastUsedFunction");
            dataCollection.add(data);
        } else {
            LastUsedFunctionCollection dataCollection = new LastUsedFunctionCollection();
            dataCollection.add(data);
            UIFrameContext.getInstance().setProperty("LastUsedFunction", dataCollection);
        }
        return data;
    }

    protected static void handException(Throwable exc) {
        ExceptionHandler.handle((Throwable)exc);
    }

    private static String getString(String strKey) {
        return UIFrameResource.getString(strKey);
    }

    private static MainMenuItemInfo getCurrMenuFromTree(KDTree tree) {
        return (MainMenuItemInfo)((DefaultKingdeeTreeNode)tree.getLastSelectedPathComponent()).getUserObject();
    }

    private static OpenMethod getDefaultOpenMethod() {
        OpenModelInfo openModelInfo = (OpenModelInfo)UIFrameContext.getInstance().getProperty("OpenModel");
        if (openModelInfo != null) {
            if (openModelInfo.isIsOpenInFour()) {
                return OpenMethod.FIXTAB;
            }
            if (openModelInfo.isIsOpenInNewTab()) {
                return OpenMethod.NEWTAB;
            }
            if (openModelInfo.isIsOpenInWindow()) {
                return OpenMethod.NEWWIN;
            }
        }
        return OpenMethod.FIXTAB;
    }

    private static OpenMethod getFinalOpenMethod(Frame mainFrame, OpenMethod openMethod) {
        if (openMethod == OpenMethod.DEFAULT) {
            openMethod = MainMenuTree.getDefaultOpenMethod();
        }
        if (openMethod != OpenMethod.NEWTAB) {
            return openMethod;
        }
        return openMethod;
    }

    private static boolean isLessTabNumLimit(IMainUIObject mainUI, int tabNumLimit) {
        return mainUI.getUiManager().getTabUiObjects().size() - mainUI.getBodyUI().getSysTabCount() + 1 <= tabNumLimit;
    }
}

