/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.appframework.syncUI.MonitorDialog;
import com.kingdee.bos.ctrl.swing.ISimpleStatusBarRenderer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.SimpleStatusBarPart;
import com.kingdee.bos.ctrl.swing.SimpleStatusBarRenderer;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.myeas.IMyEasFacade;
import com.kingdee.eas.base.myeas.MyEasFacadeFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.BeautifulKDList;
import com.kingdee.eas.base.uiframe.client.HelpUtils;
import com.kingdee.eas.base.uiframe.client.MainFrameCallBack;
import com.kingdee.eas.base.uiframe.client.MainStatusBar;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.MultiOrgSwitchUtils;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class MainStatusBarManager {
    private static final Logger logger = Logger.getLogger(MainStatusBarManager.class);
    private WeakHashMap vecStatusBar = new WeakHashMap();
    private static MainStatusBarManager instance;
    StatusBarListener statusBarListener = new StatusBarListener();

    MainStatusBarManager() {
        this.initListener();
    }

    public void initListener() {
        MainFrameCallBack.addPropertyChangeListener("ReLogin", this.statusBarListener);
        MainFrameCallBack.addPropertyChangeListener("HRSwitchOrg", this.statusBarListener);
        MainFrameCallBack.addPropertyChangeListener("MCUnReadTask", this.statusBarListener);
        MainFrameCallBack.addPropertyChangeListener("MonitorTask", this.statusBarListener);
    }

    protected MainStatusBar createMainStatusBar() {
        StatusBarBuilder statusBarBuilder = new StatusBarBuilder();
        MainStatusBar mainStatusBar = new MainStatusBar(statusBarBuilder.getStatusBar(), statusBarBuilder.getLabelMsg());
        mainStatusBar.lblCompanyforPopupPane = statusBarBuilder.lblCompanyforPopupPane;
        this.vecStatusBar.put(mainStatusBar, 1);
        mainStatusBar.setStatusBarBuilder(statusBarBuilder);
        return mainStatusBar;
    }

    MainStatusBar getMainStatusBar() {
        return this.createMainStatusBar();
    }

    private static String getString(String strKey) {
        return UIFrameResource.getString(strKey);
    }

    private static Icon getIcon(String strKey) {
        return UIFrameResource.getCommonIcon(strKey);
    }

    void remove(MainStatusBar mainStatusBar) {
        this.vecStatusBar.remove(mainStatusBar);
    }

    static synchronized MainStatusBarManager getInstance() {
        if (instance == null) {
            instance = new MainStatusBarManager();
        }
        return instance;
    }

    public static boolean isInitedInstance() {
        return instance != null;
    }

    private static void clearInstance() {
        instance = null;
    }

    public static void clearStatus() {
        StatusBarData.clearData();
        MainStatusBarManager.clearInstance();
    }

    class StatusBarListener
    implements PropertyChangeListener {
        StatusBarListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String source = evt.getPropertyName();
            if (StringUtils.equals((String)source, (String)"HRSwitchOrg")) {
                this.performSwitchOrg(evt);
            } else if (StringUtils.equals((String)source, (String)"MCUnReadTask")) {
                this.performUnreadTask(evt);
            } else if (StringUtils.equals((String)source, (String)"ReLogin")) {
                this.performReLogin(evt);
            } else if (StringUtils.equals((String)source, (String)"MonitorTask")) {
                this.performNewTask(evt);
            }
        }

        private void performSwitchOrg(PropertyChangeEvent evt) {
            for (MainStatusBar sb : MainStatusBarManager.this.vecStatusBar.keySet()) {
                if (sb == null) continue;
                sb.switchOrg();
            }
        }

        private void performUnreadTask(PropertyChangeEvent evt) {
            boolean hasUnreadTask = (Boolean)evt.getNewValue();
            StatusBarData.getStatusBarData().setHasUnreadTask(hasUnreadTask);
            for (MainStatusBar sb : MainStatusBarManager.this.vecStatusBar.keySet()) {
                if (sb == null) continue;
                MessageButton btnMessage = (MessageButton)((Object)sb.getBtnMessage());
                btnMessage.setHasUnreadTask(hasUnreadTask);
            }
        }

        private void performReLogin(PropertyChangeEvent evt) {
            MainStatusBarManager.this.vecStatusBar.clear();
            StatusBarData.clearData();
            MainStatusBarManager.clearInstance();
        }

        private void performNewTask(PropertyChangeEvent evt) {
            boolean hasNewTask = (Boolean)evt.getNewValue();
            StatusBarData.getStatusBarData().setHasNewTask(hasNewTask);
            for (MainStatusBar sb : MainStatusBarManager.this.vecStatusBar.keySet()) {
                if (sb == null) continue;
                MonitorButton btnWork = (MonitorButton)((Object)sb.getBtnMonitor());
                btnWork.setHasMonitor(hasNewTask);
            }
        }
    }

    static class MessageButton
    extends KDWorkButton {
        private Icon iconUnredeTask;
        private Icon iconNormal;
        private boolean hasUnreadTask = false;

        public MessageButton(boolean pHasUnreadTask) {
            this.hasUnreadTask = pHasUnreadTask;
            this.iconUnredeTask = UIManager.getIcon("eas.statusbar.msg.dynamic");
            this.iconNormal = UIManager.getIcon("eas.statusbar.msg.static");
            if (pHasUnreadTask) {
                this.setIcon(this.iconUnredeTask);
            } else {
                this.setIcon(this.iconNormal);
            }
            this.setFocusable(false);
        }

        public boolean isHasUnreadTask() {
            return this.hasUnreadTask;
        }

        public void setHasUnreadTask(boolean b) {
            this.hasUnreadTask = b;
            if (this.hasUnreadTask) {
                this.setIcon(this.iconUnredeTask);
            } else {
                this.setIcon(this.iconNormal);
            }
        }
    }

    static class MonitorButton
    extends KDWorkButton {
        private Icon iconHasTask;
        private Icon iconNormal = UIManager.getIcon("eas.statusbar.monitor");
        private boolean hasMonitor = false;

        public MonitorButton(boolean hasTask) {
            this.iconHasTask = UIManager.getIcon("eas.statusbar.monitor");
            this.setHasMonitor(hasTask);
            this.setFocusable(false);
        }

        public boolean isHasMonitor() {
            return this.hasMonitor;
        }

        public void setHasMonitor(boolean b) {
            this.hasMonitor = b;
            if (this.hasMonitor) {
                this.setIcon(this.iconHasTask);
            } else {
                this.setIcon(this.iconNormal);
            }
        }
    }

    static class StatusBarBuilder {
        private KDStatusBar statusBar;
        private KDProgressBar progressBar;
        private KDLabel lblMsg;
        private JLabel lblCompanyforPopupPane;
        private JLabel lblAdminforPopupPane;
        private static final int ELEMENT_HEIGHT = 25;
        private static final int POP_WIDTH = 200;
        private static final int HGRAP = 8;
        public static final int USER_PANEL_HEIGHT = 131;
        public static final int USER_PANEL_WIDTH = 220;
        private static final int ICON_BUTTON_WIDTH = 30;

        StatusBarBuilder() {
        }

        public JLabel getLblAdminforPopupPane() {
            return this.lblAdminforPopupPane;
        }

        public void setLblAdminforPopupPane(JLabel lblAdminforPopupPane) {
            this.lblAdminforPopupPane = lblAdminforPopupPane;
        }

        public JLabel getLblCompanyforPopupPane() {
            return this.lblCompanyforPopupPane;
        }

        public void setLblCompanyforPopupPane(JLabel lblCompanyforPopupPane) {
            this.lblCompanyforPopupPane = lblCompanyforPopupPane;
        }

        public KDProgressBar getProgressBar() {
            if (this.progressBar == null) {
                this.progressBar = new KDProgressBar();
                this.progressBar.setMinimum(0);
                this.progressBar.setMaximum(100);
                this.progressBar.setValue(0);
                this.progressBar.setStringPainted(true);
                this.progressBar.setString("");
            }
            return this.progressBar;
        }

        public KDLabel getLabelMsg() {
            if (this.lblMsg == null) {
                this.lblMsg = new KDLabel();
                this.lblMsg.setBounds(0, 0, 400, 21);
                this.lblMsg.setOpaque(false);
                this.lblMsg.setForeground(Color.WHITE);
                this.getProgressBar().add((Component)this.lblMsg);
            }
            return this.lblMsg;
        }

        private SimpleStatusBarPart buildPartBtn() {
            SimpleStatusBarPart partBtn = this.createStatusBarPart();
            ((FlowLayout)partBtn.getLayout()).setHgap(0);
            ((FlowLayout)partBtn.getLayout()).setVgap(1);
            partBtn.setOpaque(false);
            partBtn.addRenderer((ISimpleStatusBarRenderer)this.getUserInfoRender(), (Object)"info");
            partBtn.addRenderer((ISimpleStatusBarRenderer)this.getRenderMsg(), (Object)"BtnMessage");
            partBtn.addRenderer((ISimpleStatusBarRenderer)this.getMonitorRender(), (Object)"monitor");
            partBtn.addRenderer((ISimpleStatusBarRenderer)this.getRenderHelp(), (Object)"help");
            return partBtn;
        }

        private SimpleStatusBarPart buildPartOrg() {
            final SimpleStatusBarPart partOrg = new SimpleStatusBarPart(this.statusBar){

                public Insets getInsets() {
                    return new Insets(0, 0, 0, 0);
                }
            };
            partOrg.setHgrap(0);
            partOrg.setOpaque(false);
            partOrg.setBorder(BorderFactory.createEmptyBorder());
            SimpleStatusBarRenderer orgRender = this.getTextRender(MainStatusBar.getOrgText());
            partOrg.addRenderer((ISimpleStatusBarRenderer)orgRender, (Object)"OrgText");
            orgRender.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.showSwitchOrgPopup((Component)partOrg);
                }
            });
            KDLabel orgLbl = (KDLabel)orgRender.getComponent(this.statusBar);
            this.setOrgForeground((Component)orgLbl);
            orgLbl.addMouseListener((MouseListener)new LabelMouseMotionAdapter());
            return partOrg;
        }

        public void setOrgForeground(Component comp) {
            if (StatusBarData.getStatusBarData().isBizUnit()) {
                comp.setForeground(UIManager.getColor("eas.statusbar.entity"));
            } else {
                comp.setForeground(UIManager.getColor("eas.statusbar.nonentity"));
            }
        }

        public void performSwitch(Component partOrg, JPopupMenu orgSwitchPopup, KDList orgKDList) {
            Object selectedObj = orgKDList.getSelectedValue();
            Frame owner = (Frame)SwingUtilities.getWindowAncestor(partOrg);
            if (!(selectedObj instanceof FastSwitchOrgInfo)) {
                SystemEntry.instance.switchOrg(owner);
            } else {
                FastSwitchOrgInfo fastOrgInfo = (FastSwitchOrgInfo)orgKDList.getSelectedValue();
                String orgId = fastOrgInfo.getOrgInfo().getId().toString();
                if (!MultiOrgSwitchUtils.checkBeforeSwitch((Component)partOrg)) {
                    return;
                }
                MultiOrgSwitchUtils.switchOrgForClient((Component)owner, (String)orgId);
            }
            orgSwitchPopup.setVisible(false);
        }

        public void showSwitchOrgPopup(final Component partOrg) {
            final JPopupMenu orgSwitchPopup = new JPopupMenu();
            final BeautifulKDList orgKDList = new BeautifulKDList();
            orgKDList.setFixedCellHeight(25);
            try {
                IMyEasFacade myEas = MyEasFacadeFactory.getRemoteInstance();
                FullOrgUnitCollection orgCol = myEas.getFastSwitchOrgs();
                Object[] orgArr = new Object[orgCol.size() + 1];
                FastSwitchOrgInfo fastSwitchOrgInfo = null;
                int size = orgCol.size();
                for (int i = 0; i < size; ++i) {
                    fastSwitchOrgInfo = new FastSwitchOrgInfo();
                    FullOrgUnitInfo orgInfo = orgCol.get(i);
                    fastSwitchOrgInfo.setOrgInfo(orgInfo);
                    orgArr[i] = fastSwitchOrgInfo;
                }
                orgArr[orgArr.length - 1] = UIFrameResource.getString("more");
                orgKDList.setListData(orgArr);
                if (orgArr.length > 0) {
                    orgKDList.setSelectedIndex(0);
                }
                orgKDList.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        this.performSwitch(partOrg, orgSwitchPopup, orgKDList);
                    }
                });
                orgKDList.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            this.performSwitch(partOrg, orgSwitchPopup, orgKDList);
                        }
                    }
                });
                orgKDList.setVisibleRowCount(orgArr.length);
                CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)((Object)orgKDList), (KeyStroke)KeyStroke.getKeyStroke(10, 0));
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                ExceptionHandler.handle((Throwable)e);
            }
            orgKDList.setFixedCellWidth(200);
            KDScrollPane scrollPanel = new KDScrollPane();
            scrollPanel.getViewport().add((Component)((Object)orgKDList));
            orgSwitchPopup.add((Component)scrollPanel);
            int elementsHeight = orgKDList.getElementCount() * 25;
            int y = 0 - elementsHeight - 10;
            orgSwitchPopup.show(partOrg, 0, y);
            orgKDList.requestFocus();
        }

        private SimpleStatusBarPart buildPartUser() {
            final SimpleStatusBarPart partUser = new SimpleStatusBarPart(this.statusBar){

                public Insets getInsets() {
                    return new Insets(0, 0, 0, 0);
                }
            };
            partUser.setHgrap(8);
            partUser.setOpaque(false);
            partUser.setBorder(BorderFactory.createEmptyBorder());
            SimpleStatusBarRenderer userRender = this.getTextRender(this.getUserText());
            partUser.addRenderer((ISimpleStatusBarRenderer)userRender, (Object)"UserTitle");
            if (!SystemEntry.instance.isWebStart()) {
                userRender.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        Frame owner = (Frame)SwingUtilities.getWindowAncestor((Component)partUser);
                        if (MsgBox.showConfirm2((Component)owner, (String)MainStatusBarManager.getString("MainMenuBar.confirmLogout")) == 0) {
                            try {
                                SystemEntry.instance.relogin();
                            }
                            catch (Exception e1) {
                                logger.error((Object)"", (Throwable)e1);
                                ExceptionHandler.handle((Component)owner, (Throwable)e1);
                            }
                        }
                    }
                });
            }
            KDLabel lblUser = (KDLabel)userRender.getComponent(this.statusBar);
            lblUser.addMouseListener((MouseListener)new LabelMouseMotionAdapter());
            return partUser;
        }

        private String getUserText() {
            return MainStatusBarManager.getString("MainStatusBar.userName") + StatusBarData.getStatusBarData().getUserName() + "  " + MainStatusBarManager.getString("MainStatusBar.userAlias") + StatusBarData.getStatusBarData().getUserAlias();
        }

        private SimpleStatusBarPart buildPartPeriod() {
            SimpleStatusBarPart partPeriod = new SimpleStatusBarPart(this.statusBar){

                public Insets getInsets() {
                    return new Insets(0, 0, 0, 0);
                }
            };
            partPeriod.setHgrap(8);
            ((FlowLayout)partPeriod.getLayout()).setHgap(0);
            ((FlowLayout)partPeriod.getLayout()).setVgap(3);
            partPeriod.setOpaque(false);
            partPeriod.setBorder(BorderFactory.createEmptyBorder());
            partPeriod.addRenderer((ISimpleStatusBarRenderer)this.getTextRender(MainStatusBarManager.getString("MainStatusBar.Period")), (Object)"PeriodTitle");
            partPeriod.addRenderer((ISimpleStatusBarRenderer)this.getTextRender(""), (Object)"PeriodText");
            return partPeriod;
        }

        private SimpleStatusBarRenderer getTextRender(String text) {
            SimpleStatusBarRenderer renderDC = new SimpleStatusBarRenderer();
            renderDC.setText(text);
            JLabel lblDC = (JLabel)renderDC.getComponent(this.statusBar);
            lblDC.setOpaque(false);
            lblDC.setVerticalAlignment(3);
            lblDC.setForeground(UIManager.getColor("eas.statusbar.fg"));
            return renderDC;
        }

        private SimpleStatusBarPart buildPartProgress() {
            SimpleStatusBarPart part = this.createStatusBarPart();
            part.setLayout((LayoutManager)new BorderLayout());
            SimpleStatusBarRenderer render = new SimpleStatusBarRenderer((JComponent)this.getProgressBar(), "");
            part.addRenderer((ISimpleStatusBarRenderer)render, (Object)"ProgressBar");
            part.setBounds(0, 0, 500, 21);
            return part;
        }

        private SimpleStatusBarPart createStatusBarPart() {
            SimpleStatusBarPart part = new SimpleStatusBarPart(this.statusBar);
            part.setBorder(BorderFactory.createEmptyBorder());
            part.setHgrap(0);
            return part;
        }

        protected SimpleStatusBarRenderer getUserInfoRender() {
            final KDWorkButton btnUserInfo = new KDWorkButton();
            btnUserInfo.setName("btnUserInfo" + System.currentTimeMillis());
            btnUserInfo.setFactType(0);
            btnUserInfo.setFocusable(false);
            btnUserInfo.setBorder(BorderFactory.createEmptyBorder());
            btnUserInfo.setIcon(UIManager.getIcon("eas.statusbar.inf"));
            btnUserInfo.setToolTipText(UIFrameResource.getString("MainStatusBar.DCTitle"));
            btnUserInfo.setPreferredSize(new Dimension(30, 21));
            btnUserInfo.setContentAreaFilled(false);
            SimpleStatusBarRenderer render = new SimpleStatusBarRenderer((JButton)btnUserInfo);
            render.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JPopupMenu pop = new JPopupMenu();
                    JPanel userInfoPanel = this.getUserInfoPanel();
                    pop.add(userInfoPanel);
                    pop.show((Component)btnUserInfo, 0, -131);
                }
            });
            return render;
        }

        private JPanel getUserInfoPanel() {
            KDPanel pnlInfo = new KDPanel();
            pnlInfo.setPreferredSize(new Dimension(220, 131));
            pnlInfo.setBorder(BorderFactory.createLineBorder(UIManager.getColor("eas.infopane.border")));
            pnlInfo.setBackground(UIManager.getColor("eas.infopane.border"));
            pnlInfo.setFocusable(false);
            pnlInfo.setLayout(new FlowLayout(1, 0, 0));
            KDPanel pnlTitle = new KDPanel();
            pnlTitle.setLayout(null);
            pnlTitle.setPreferredSize(new Dimension(220, 21));
            JLabel lblDCTitle = new JLabel(" " + MainStatusBarManager.getString("MainStatusBar.DCTitle"));
            lblDCTitle.setBounds(0, 0, 220, 21);
            pnlTitle.add(lblDCTitle);
            pnlTitle.setBackground(UIManager.getColor("eas.infopanel.title.bg"));
            KDPanel pnlText = new KDPanel();
            pnlText.setPreferredSize(new Dimension(220, 108));
            pnlText.setBackground(UIManager.getColor("eas.infopanel.content.bg"));
            pnlText.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridwidth = 1;
            constraints.weightx = 0.0;
            constraints.anchor = 17;
            constraints.fill = 0;
            constraints.insets = new Insets(8, 8, 0, 0);
            pnlText.add((Component)new JLabel(MainStatusBarManager.getString("MainStatusBar.userName")), constraints);
            constraints.insets = new Insets(2, 8, 0, 0);
            ++constraints.gridy;
            pnlText.add((Component)new JLabel(MainStatusBarManager.getString("MainStatusBar.today")), constraints);
            ++constraints.gridy;
            pnlText.add((Component)new JLabel(MainStatusBarManager.getString("MainStatusBar.org")), constraints);
            ++constraints.gridy;
            pnlText.add((Component)new JLabel(MainStatusBarManager.getString("MainStatusBar.orgUnit")), constraints);
            ++constraints.gridy;
            constraints.insets = new Insets(2, 8, 8, 0);
            pnlText.add((Component)new JLabel(MainStatusBarManager.getString("MainStatusBar.position")), constraints);
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridwidth = 1;
            constraints.weightx = 1.0;
            constraints.anchor = 17;
            constraints.fill = 2;
            constraints.insets = new Insets(8, 12, 0, 0);
            pnlText.add((Component)new JLabel(StatusBarData.getStatusBarData().getUserName()), constraints);
            constraints.insets = new Insets(2, 12, 0, 0);
            ++constraints.gridy;
            Date date = new Date(System.currentTimeMillis());
            pnlText.add((Component)new JLabel(DateTimeUtils.format((Date)date, (String)MainStatusBarManager.getString("MainStatusBar.dateFormat"))), constraints);
            ++constraints.gridy;
            this.lblCompanyforPopupPane = new JLabel(StatusBarData.getStatusBarData().getCompanyName());
            pnlText.add((Component)this.lblCompanyforPopupPane, constraints);
            ++constraints.gridy;
            this.lblAdminforPopupPane = new JLabel(StatusBarData.getStatusBarData().getAdminName());
            pnlText.add((Component)this.lblAdminforPopupPane, constraints);
            ++constraints.gridy;
            constraints.insets = new Insets(2, 12, 8, 0);
            pnlText.add((Component)new JLabel(StatusBarData.getStatusBarData().getPositionName()), constraints);
            pnlInfo.add((Component)pnlTitle);
            pnlInfo.add((Component)pnlText);
            return pnlInfo;
        }

        protected SimpleStatusBarRenderer getRenderMsg() {
            MessageButton btn = new MessageButton(StatusBarData.getStatusBarData().isHasUnreadTask());
            btn.setName("msg" + System.currentTimeMillis());
            btn.setFactType(0);
            btn.setBorder(BorderFactory.createEmptyBorder());
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MessageButton messageButton = (MessageButton)((Object)e.getSource());
                    if (!messageButton.hasUnreadTask) {
                        return;
                    }
                    IUIObject[] arrayUI = UIFrameUtil.findUIObject("com.kingdee.eas.base.message.client.MessageCenterUI");
                    IUIObject messageUI = this.findMessageUI(arrayUI);
                    if (messageUI != null) {
                        UIFrameUtil.locateDefaultNode(messageUI);
                        messageUI.getUIWindow().show();
                    } else {
                        SystemEntry.instance.getMainUIObject().getBodyUI().openMessgeCenterUI(1);
                        Component msgUI = SystemEntry.instance.getMainUIObject().getBodyUI().getMessageComponent(1);
                        if (msgUI instanceof IUIObject) {
                            UIFrameUtil.locateDefaultNode((IUIObject)msgUI);
                        }
                        UIFrameUtil.setCurTabToMessageCenter();
                    }
                }
            });
            btn.setPreferredSize(new Dimension(35, 21));
            btn.setBorder(BorderFactory.createEmptyBorder());
            btn.setContentAreaFilled(false);
            btn.setToolTipText(UIFrameResource.getString("MainStatusBar.Msg"));
            SimpleStatusBarRenderer render = new SimpleStatusBarRenderer((JButton)((Object)btn));
            return render;
        }

        public IUIObject findMessageUI(IUIObject[] arrayUI) {
            IUIObject uiObject = null;
            if (arrayUI != null && arrayUI.length > 0) {
                for (int i = 0; i < arrayUI.length; ++i) {
                    if (!"com.kingdee.eas.base.message.client.MessageCenterUI".equals(arrayUI[i].getClass().getName())) continue;
                    uiObject = arrayUI[i];
                    break;
                }
            }
            return uiObject;
        }

        protected SimpleStatusBarRenderer getRenderHelp() {
            KDWorkButton btn = new KDWorkButton();
            btn.setName("help" + System.currentTimeMillis());
            btn.setFactType(0);
            btn.setFocusable(false);
            btn.setBorder(BorderFactory.createEmptyBorder());
            btn.setIcon(UIManager.getIcon("eas.statusbar.help"));
            btn.setPreferredSize(new Dimension(30, 21));
            btn.setToolTipText(UIFrameResource.getString("MainMenuBar.help"));
            btn.setContentAreaFilled(false);
            HelpUtils.addCSHelpforBtn((JButton)btn);
            SimpleStatusBarRenderer render = new SimpleStatusBarRenderer((JButton)btn);
            return render;
        }

        protected SimpleStatusBarRenderer getMonitorRender() {
            final MonitorButton btn = new MonitorButton(false);
            btn.setName("monitor" + System.currentTimeMillis());
            btn.setFactType(0);
            btn.setBorder(BorderFactory.createEmptyBorder());
            btn.setToolTipText(UIFrameResource.getString("MainStatusBar.MonitorTip"));
            btn.setPreferredSize(new Dimension(30, 21));
            btn.setContentAreaFilled(false);
            final SimpleStatusBarRenderer render = new SimpleStatusBarRenderer((JButton)((Object)btn));
            render.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    new MonitorDialog(render, MainStatusBarManager.getIcon("imgState_iconclose_1"));
                    JPopupMenu popupMenu = new JPopupMenu();
                    JPanel monitorPanel = render.getPopupPane();
                    popupMenu.add(monitorPanel);
                    popupMenu.show((Component)((Object)btn), 0, -200);
                }
            });
            return render;
        }

        protected void initStatusBar() {
            this.statusBar.add((Component)this.buildPartProgress(), 0);
            this.statusBar.add((Component)this.buildPartOrg(), 1);
            this.statusBar.add((Component)this.buildPartUser(), 2);
            this.statusBar.add((Component)this.buildPartPeriod(), 3);
            this.statusBar.add((Component)this.buildPartBtn(), 4);
            this.statusBar.setRetractablePart(0, true);
        }

        public KDStatusBar getStatusBar() {
            if (this.statusBar == null) {
                this.statusBar = new KDStatusBar();
                this.statusBar.setPreferredSize(new Dimension(10000, 21));
                this.statusBar.setBorder(BorderFactory.createEmptyBorder());
                this.initStatusBar();
            }
            return this.statusBar;
        }

        class FastSwitchOrgInfo {
            private FullOrgUnitInfo orgInfo;

            FastSwitchOrgInfo() {
            }

            public FullOrgUnitInfo getOrgInfo() {
                return this.orgInfo;
            }

            public void setOrgInfo(FullOrgUnitInfo orgInfo) {
                this.orgInfo = orgInfo;
            }

            public String toString() {
                return this.getOrgInfo().getName() + "(" + this.getOrgInfo().getNumber() + ")";
            }
        }

        class LabelMouseMotionAdapter
        extends MouseAdapter {
            LabelMouseMotionAdapter() {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JComponent source = (JComponent)e.getSource();
                source.setOpaque(true);
                source.repaint();
                source.setBackground(UIManager.getColor(Color.white));
                source.setForeground(Color.black);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JComponent source = (JComponent)e.getSource();
                source.setOpaque(false);
                StatusBarBuilder.this.setOrgForeground(source);
                source.repaint();
            }
        }
    }

    static class StatusBarData {
        private static StatusBarData instance;
        private String userAlias = null;
        private String userName = null;
        private String positionName = null;
        private boolean hasUnreadTask = false;
        private String curPeriod = null;
        private boolean hasNewTask = false;

        public static synchronized StatusBarData getStatusBarData() {
            if (instance == null) {
                instance = new StatusBarData();
            }
            return instance;
        }

        public static void clearData() {
            instance = null;
        }

        protected String getUserName() {
            if (this.userName == null) {
                UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
                this.userName = user != null && user.getNumber() != null ? user.getNumber() : "      ";
            }
            return this.userName;
        }

        protected String getUserAlias() {
            if (this.userAlias == null) {
                UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
                this.userAlias = user != null && user.getName() != null ? user.getName() : "      ";
            }
            return this.userAlias;
        }

        protected String getCurPeriod() {
            return this.curPeriod;
        }

        protected boolean isBizUnit() {
            CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
            if (company == null) {
                return false;
            }
            return company.isIsBizUnit();
        }

        protected String getCompanyName() {
            CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
            String companyName = "      ";
            if (company != null) {
                companyName = company.getName();
            }
            return companyName;
        }

        protected String getPositionName() {
            if (this.positionName == null) {
                try {
                    PositionInfo positionInfo;
                    IPerson iPerson = PersonFactory.getRemoteInstance();
                    this.positionName = this.getCurrPersonID() != null ? ((positionInfo = iPerson.getPrimaryPosition(this.getCurrPersonID())) != null ? positionInfo.getName() : "      ") : "      ";
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
            return this.positionName;
        }

        protected BOSUuid getCurrPersonID() {
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            assert (user != null);
            if (user.getPerson() != null) {
                return user.getPerson().getId();
            }
            return null;
        }

        public String getAdminName() {
            AdminOrgUnitInfo admin = SysContext.getSysContext().getCurrentAdminUnit();
            String adminName = "      ";
            if (admin != null) {
                adminName = admin.getName();
            }
            return adminName;
        }

        public void setCurPeriod(String period) {
            this.curPeriod = period;
        }

        public boolean isHasUnreadTask() {
            return this.hasUnreadTask;
        }

        public void setHasUnreadTask(boolean b) {
            this.hasUnreadTask = b;
        }

        public boolean isHasNewTask() {
            return this.hasNewTask;
        }

        public void setHasNewTask(boolean b) {
            this.hasNewTask = b;
        }
    }
}

