/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uiframe.client.AbstractMyConcernBillPanel;
import com.kingdee.eas.base.uiframe.client.BillDoublePanel;
import com.kingdee.eas.base.uiframe.client.PageButton;
import com.kingdee.eas.base.uiframe.client.PageButtonActionListener;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MyConcernBillPanel
extends AbstractMyConcernBillPanel {
    private static final Logger logger = CoreUIObject.getLogger(MyConcernBillPanel.class);
    private static final int BILL_WIDTH = 200;
    private static final int BILL_HEIGHT = 25;
    private static final int BILL_COUNT = 30;
    int billPageSize;
    int billPageCount;
    int billNumber;
    List billColl = new ArrayList();

    public void load() {
        this.initBillColl();
        this.addOnBillPanel(this.billPanel);
        this.billPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                KDPanel panel = (KDPanel)e.getSource();
                MyConcernBillPanel.this.addOnBillPanel(panel);
            }
        });
    }

    private void addOnBillPanel(KDPanel panel) {
        this.billPageSize = this.getPageSize(panel, 230, 40);
        this.addBillPageButton();
    }

    private void addBillPageButton() {
        if (this.billPageSize == 0) {
            return;
        }
        this.billPageCount = 30 % this.billPageSize > 0 ? 30 / this.billPageSize + 1 : 30 / this.billPageSize;
        this.billNumber = 1;
        this.addBillLabel(this.billPanel);
        this.billPagePanel.removeAll();
        this.addPageButtons(this.billPagePanel, this.billPageCount);
    }

    private void addPageButtons(KDPanel pagePanel, int count) {
        for (int i = 1; i <= count; ++i) {
            this.addPageButton(pagePanel, i);
        }
    }

    private void addPageButton(KDPanel pagePanel, int number) {
        PageButton button = new PageButton(number);
        button.addActionListener(new BillPageButtonActionListener());
        pagePanel.add((Component)button);
    }

    private void addBillLabel(KDPanel parentPanel) {
        int startNumber;
        parentPanel.removeAll();
        int maxNumber = this.billNumber * this.billPageSize > this.billColl.size() ? this.billColl.size() : this.billNumber * this.billPageSize;
        for (int i = startNumber = (this.billNumber - 1) * this.billPageSize; i < maxNumber; ++i) {
            String o = (String)this.billColl.get(i);
            BillDoublePanel billLc = new BillDoublePanel();
            billLc.setBackground(this.billPanel.getBackground());
            billLc.installMouseListener(new AbstractMyConcernBillPanel.BillDoublePanelMouseListener());
            billLc.installMouseMotionListener(new AbstractMyConcernBillPanel.BillDoublePanelMouseMotionListener());
            billLc.setText(o);
            billLc.setPreferredSize(new Dimension(200, 25));
            this.billPanel.add((Component)((Object)billLc));
        }
        parentPanel.revalidate();
        parentPanel.repaint();
    }

    private int getPageSize(KDPanel panel, int w, int h) {
        int panelWidth = panel.getWidth();
        int panelHeight = panel.getHeight();
        int cols = panelWidth / w;
        int rows = panelHeight / h;
        return cols * rows;
    }

    private void initBillColl() {
        for (int i = 0; i < 30; ++i) {
            this.billColl.add(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"64_MyConcernBillPanel") + i);
        }
    }

    @Override
    protected void removeBill(BillDoublePanel pane) {
        Container parent = pane.getParent();
        parent.remove((Component)((Object)pane));
        parent.validate();
        parent.repaint();
    }

    class BillPageButtonActionListener
    extends PageButtonActionListener {
        BillPageButtonActionListener() {
        }

        @Override
        public void processEvent(ActionEvent e) {
            PageButton button = (PageButton)e.getSource();
            MyConcernBillPanel.this.billNumber = button.getNumber();
            MyConcernBillPanel.this.addBillLabel(MyConcernBillPanel.this.billPanel);
        }
    }
}

