/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.myeas.ComMenuFunctionCollection;
import com.kingdee.eas.base.myeas.ComMenuFunctionInfo;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class NewEASMainMenuCacheUtil {
    private static final Logger logger = Logger.getLogger(NewEASMainMenuCacheUtil.class);
    private static final String ID = "id";
    private static final String LONG_NUMBER = "longnumber";
    private static final String NAME = "name_";
    private static final String IMAGE_PATH = "imagePath";
    private static final String IS_LEAF = "isLeaf";
    private static final String ENABLE = "enable";
    private static final String UI_CLASS_NAME = "uiclassname";
    private static final String OPEN_METHOD = "openMethod";
    private static final String SHORTCUT_CODE = "shortCutCode";
    private static final String FUNCTION = "function";
    private static final String NUMBER = "number";
    private static final String UI_CLASS_PARAM = "uiclassparam";
    private static final String UI_OPRT = "uioprt";
    private static final String DIR = "dir";
    private static final String MenuFunctionID = "mfi";
    private static final String MENUITEMNAME = "mn_";
    private static final String LEVEL = "lv";
    private static final String ORDER = "o";

    static Map<String, List<MainMenuItemInfo>> readCacheMenu(String fileName, Locale locale) throws BOSException {
        if (StringUtils.isEmpty((String)fileName)) {
            throw new BOSException("fileName cannot be null");
        }
        HashMap<String, List<MainMenuItemInfo>> result = new HashMap<String, List<MainMenuItemInfo>>();
        long t1 = System.currentTimeMillis();
        SAXBuilder sb = new SAXBuilder();
        File file = new File(fileName);
        Document doc = null;
        try {
            doc = sb.build(file);
        }
        catch (JDOMException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        Element root = doc.getRootElement();
        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"66_NewEASMainMenuCacheUtil") + (System.currentTimeMillis() - t1)));
        List allParentNodes = root.getChildren("PARENT");
        Element parent = null;
        List menus = null;
        int j = allParentNodes.size();
        for (int i = 0; i < j; ++i) {
            ArrayList<MainMenuItemInfo> subNodes = new ArrayList<MainMenuItemInfo>();
            parent = (Element)allParentNodes.get(i);
            String parentId = parent.getAttributeValue(ID);
            menus = parent.getChildren("MENU");
            if (menus != null || menus.size() > 0) {
                int q = menus.size();
                for (int p = 0; p < q; ++p) {
                    subNodes.add(NewEASMainMenuCacheUtil.createMenuItemInfo((Element)menus.get(p), locale));
                }
            }
            result.put(parentId, subNodes);
        }
        return result;
    }

    private static MainMenuItemInfo createMenuItemInfo(Element menuElement, Locale locale) {
        MainMenuItemInfo menuInfo = new MainMenuItemInfo();
        menuInfo.setId(BOSUuid.read((String)menuElement.getChild(ID).getText()));
        menuInfo.setName(menuElement.getChild(NAME + locale.toString()).getText(), locale);
        menuInfo.setLongNumber(menuElement.getChild(LONG_NUMBER).getText());
        menuInfo.setIsLeaf(Boolean.valueOf(menuElement.getChild(IS_LEAF).getText()).booleanValue());
        if (menuElement.getChild(SHORTCUT_CODE) != null) {
            menuInfo.setShortcutCode(menuElement.getChild(SHORTCUT_CODE).getText());
        }
        if (menuElement.getChild(OPEN_METHOD) != null) {
            menuInfo.setOpenMethod(OpenMethod.getEnum(new Integer(menuElement.getChild(OPEN_METHOD).getText())));
        }
        if (menuElement.getChild(UI_CLASS_NAME) != null) {
            menuInfo.setUiClassName(menuElement.getChild(UI_CLASS_NAME).getText());
        }
        menuInfo.setImagePath(menuElement.getChild(IMAGE_PATH).getText());
        menuInfo.setEnabled(Boolean.valueOf(menuElement.getChild(ENABLE).getText()).booleanValue());
        if (menuElement.getChild(FUNCTION) != null) {
            PermItemInfo itemInfo = new PermItemInfo();
            itemInfo.setId(BOSUuid.read((String)menuElement.getChild(FUNCTION).getText()));
            menuInfo.setFunction(itemInfo);
        }
        if (menuElement.getChild(NUMBER) != null) {
            menuInfo.setNumber(menuElement.getChild(NUMBER).getText());
        }
        if (menuElement.getChild(UI_CLASS_PARAM) != null) {
            menuInfo.setUiClassParam(menuElement.getChild(UI_CLASS_PARAM).getText());
        }
        if (menuElement.getChild(UI_OPRT) != null) {
            menuInfo.setUiOprt(menuElement.getChild(UI_OPRT).getText());
        }
        return menuInfo;
    }

    static void writeCacheMenu(String fileName, Locale locale, Map<String, List<MainMenuItemInfo>> menuCache) throws BOSException {
        if (StringUtils.isEmpty((String)fileName)) {
            throw new BOSException("fileName cannot be null");
        }
        if (locale == null) {
            locale = LocaleUtils.getDefaultLocale();
        }
        if (menuCache == null || menuCache.size() == 0) {
            return;
        }
        String dirName = fileName.substring(0, fileName.lastIndexOf("/"));
        File dir = new File(dirName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Document doc = new Document();
        Element root = new Element("EAS_MainMenu");
        doc.setRootElement(root);
        for (Map.Entry<String, List<MainMenuItemInfo>> entry : menuCache.entrySet()) {
            String parentId = entry.getKey();
            List<MainMenuItemInfo> subNodes = entry.getValue();
            Element parent = new Element("PARENT");
            parent.setAttribute(ID, parentId);
            root.addContent((Content)parent);
            if (subNodes == null || subNodes.size() <= 0) continue;
            int j = subNodes.size();
            for (int i = 0; i < j; ++i) {
                MainMenuItemInfo info = subNodes.get(i);
                parent.addContent((Content)NewEASMainMenuCacheUtil.createMenuElement(info, locale));
            }
        }
        XMLOutputter outp = null;
        FileOutputStream out = null;
        try {
            Format format = Format.getCompactFormat();
            format.setEncoding("utf-8");
            format.setIndent("   ");
            outp = new XMLOutputter(format);
            File f = new File(fileName);
            out = new FileOutputStream(f);
            outp.output(doc, (OutputStream)out);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            if (outp != null) {
                outp.clone();
            }
        }
    }

    private static Element createMenuElement(MainMenuItemInfo menuInfo, Locale locale) {
        Element field = new Element("MENU");
        field.addContent((Content)new Element(ID).setText(menuInfo.getId().toString()));
        field.addContent((Content)new Element(LONG_NUMBER).setText(menuInfo.getLongNumber()));
        field.addContent((Content)new Element(NAME + locale.toString()).setText(menuInfo.getName(locale)));
        field.addContent((Content)new Element(IMAGE_PATH).setText(menuInfo.getImagePath()));
        field.addContent((Content)new Element(IS_LEAF).setText(Boolean.toString(menuInfo.isIsLeaf())));
        field.addContent((Content)new Element(ENABLE).setText(Boolean.toString(menuInfo.isEnabled())));
        if (!StringUtils.isEmpty((String)menuInfo.getUiClassName())) {
            field.addContent((Content)new Element(UI_CLASS_NAME).setText(menuInfo.getUiClassName()));
        }
        field.addContent((Content)new Element(OPEN_METHOD).setText(new Integer(menuInfo.getOpenMethod().getValue()).toString()));
        if (!StringUtils.isEmpty((String)menuInfo.getShortcutCode())) {
            field.addContent((Content)new Element(SHORTCUT_CODE).setText(menuInfo.getShortcutCode()));
        }
        if (menuInfo.getFunction() != null && menuInfo.getFunction().getId() != null) {
            field.addContent((Content)new Element(FUNCTION).setText(menuInfo.getFunction().getId().toString()));
        }
        if (!StringUtils.isEmpty((String)menuInfo.getNumber())) {
            field.addContent((Content)new Element(NUMBER).setText(menuInfo.getNumber()));
        }
        if (!StringUtils.isEmpty((String)menuInfo.getUiClassParam())) {
            field.addContent((Content)new Element(UI_CLASS_PARAM).setText(menuInfo.getUiClassParam()));
        }
        if (!StringUtils.isEmpty((String)menuInfo.getUiOprt())) {
            field.addContent((Content)new Element(UI_OPRT).setText(menuInfo.getUiOprt()));
        }
        return field;
    }

    public static Map<String, ComMenuFunctionCollection> readComFuncCache(String fileName, Locale l) throws Exception {
        long t1 = System.currentTimeMillis();
        SAXBuilder sb = new SAXBuilder();
        Document doc = null;
        File file = null;
        file = new File(fileName);
        doc = sb.build(file);
        HashMap<String, ComMenuFunctionCollection> comMenu = new HashMap<String, ComMenuFunctionCollection>();
        Element root = doc.getRootElement();
        logger.debug((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"66_NewEASMainMenuCacheUtil") + (System.currentTimeMillis() - t1)));
        List allParentNodes = root.getChildren("PARENT");
        Element parent = null;
        List menus = null;
        int j = allParentNodes.size();
        for (int i = 0; i < j; ++i) {
            ComMenuFunctionCollection coll = new ComMenuFunctionCollection();
            parent = (Element)allParentNodes.get(i);
            String parentId = parent.getAttributeValue(ID);
            menus = parent.getChildren("comMenu");
            if (menus != null || menus.size() > 0) {
                int q = menus.size();
                for (int p = 0; p < q; ++p) {
                    ComMenuFunctionInfo functionInfo = NewEASMainMenuCacheUtil.createConFuncMenuItemInfo((Element)menus.get(p), l);
                    ComMenuFunctionInfo parentFunctionInfo = new ComMenuFunctionInfo();
                    parentFunctionInfo.setId(BOSUuid.read((String)parentId));
                    functionInfo.setParent(parentFunctionInfo);
                    coll.add(functionInfo);
                }
            }
            comMenu.put(parentId, coll);
        }
        return comMenu;
    }

    private static ComMenuFunctionInfo createConFuncMenuItemInfo(Element comMenuElement, Locale l) {
        ComMenuFunctionInfo confuncInfo = new ComMenuFunctionInfo();
        confuncInfo.setId(BOSUuid.read((String)comMenuElement.getChild(ID).getText()));
        confuncInfo.setLongNumber(comMenuElement.getChild(LONG_NUMBER).getText());
        confuncInfo.setNumber(comMenuElement.getChild(NUMBER).getText());
        confuncInfo.setName(comMenuElement.getChild("name_l1").getText(), new Locale("l1"));
        confuncInfo.setName(comMenuElement.getChild("name_l2").getText(), new Locale("l2"));
        confuncInfo.setName(comMenuElement.getChild("name_l3").getText(), new Locale("l3"));
        confuncInfo.setIsLeaf(Boolean.valueOf(comMenuElement.getChild(IS_LEAF).getText()).booleanValue());
        confuncInfo.setLevel(new Integer(comMenuElement.getChild(LEVEL).getText()).intValue());
        confuncInfo.setOrder(new Integer(comMenuElement.getChild(ORDER).getText()).intValue());
        confuncInfo.setDir(Boolean.valueOf(comMenuElement.getChild(DIR).getText()).booleanValue());
        MainMenuItemInfo menuItem = new MainMenuItemInfo();
        menuItem.setId(BOSUuid.read((String)comMenuElement.getChild(MenuFunctionID).getText()));
        if (comMenuElement.getChild(MENUITEMNAME) != null) {
            menuItem.setName(comMenuElement.getChild(MENUITEMNAME).getText());
        }
        if (comMenuElement.getChild(UI_CLASS_NAME) != null) {
            menuItem.setUiClassName(comMenuElement.getChild(UI_CLASS_NAME).getText());
        }
        if (comMenuElement.getChild(UI_CLASS_PARAM) != null) {
            menuItem.setUiClassParam(comMenuElement.getChild(UI_CLASS_PARAM).getText());
        }
        if (comMenuElement.getChild(IMAGE_PATH) != null) {
            menuItem.setImagePath(comMenuElement.getChild(IMAGE_PATH).getText());
        }
        if (comMenuElement.getChild(UI_OPRT) != null) {
            menuItem.setUiOprt(comMenuElement.getChild(UI_OPRT).getText());
        }
        if (comMenuElement.getChild(OPEN_METHOD) != null) {
            menuItem.setOpenMethod(OpenMethod.getEnum(Integer.parseInt(comMenuElement.getChild(OPEN_METHOD).getText())));
        }
        if (comMenuElement.getChild(ENABLE) != null) {
            menuItem.setEnabled(Boolean.valueOf(comMenuElement.getChild(ENABLE).getText()).booleanValue());
        }
        confuncInfo.setMenuFunction(menuItem);
        return confuncInfo;
    }

    public static void writeComFuncCache(Map<String, ComMenuFunctionCollection> comMenu, String fileName, Locale l) throws IOException {
        if (comMenu == null) {
            return;
        }
        String dirName = fileName.substring(0, fileName.lastIndexOf("/"));
        File dir = new File(dirName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Document doc = new Document();
        Element root = new Element("EAS_ComMenu");
        doc.setRootElement(root);
        for (String parentId : comMenu.keySet()) {
            ComMenuFunctionCollection coll = comMenu.get(parentId);
            if (coll == null || coll.size() <= 0) continue;
            Element parent = new Element("PARENT");
            parent.setAttribute(ID, parentId);
            root.addContent((Content)parent);
            for (int i = 0; i < coll.size(); ++i) {
                Element child = NewEASMainMenuCacheUtil.createComMenuElement(coll.get(i), l);
                parent.addContent((Content)child);
            }
        }
        XMLOutputter outp = null;
        FileOutputStream out = null;
        try {
            Format format = Format.getCompactFormat();
            format.setEncoding("utf-8");
            format.setIndent("   ");
            outp = new XMLOutputter(format);
            File f = new File(fileName);
            out = new FileOutputStream(f);
            outp.output(doc, (OutputStream)out);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (outp != null) {
                outp.clone();
            }
        }
    }

    private static Element createComMenuElement(ComMenuFunctionInfo comMenuInfo, Locale l) {
        Element field = new Element("comMenu");
        field.addContent((Content)new Element(ID).setText(comMenuInfo.getId().toString()));
        field.addContent((Content)new Element(LONG_NUMBER).setText(comMenuInfo.getLongNumber()));
        field.addContent((Content)new Element(NUMBER).setText(comMenuInfo.getNumber()));
        field.addContent((Content)new Element("name_l1").setText(comMenuInfo.getName(new Locale("l1"))));
        field.addContent((Content)new Element("name_l2").setText(comMenuInfo.getName(new Locale("l2"))));
        field.addContent((Content)new Element("name_l3").setText(comMenuInfo.getName(new Locale("l3"))));
        field.addContent((Content)new Element(IS_LEAF).setText(Boolean.toString(comMenuInfo.isIsLeaf())));
        field.addContent((Content)new Element(LEVEL).setText(new Integer(comMenuInfo.getLevel()).toString()));
        field.addContent((Content)new Element(ORDER).setText(new Integer(comMenuInfo.getOrder()).toString()));
        field.addContent((Content)new Element(DIR).setText(String.valueOf(comMenuInfo.isDir())));
        field.addContent((Content)new Element(MenuFunctionID).setText(comMenuInfo.getMenuFunction().getId().toString()));
        if (!StringUtils.isEmpty((String)comMenuInfo.getMenuFunction().getImagePath())) {
            field.addContent((Content)new Element(IMAGE_PATH).setText(comMenuInfo.getMenuFunction().getImagePath()));
        }
        if (!StringUtils.isEmpty((String)comMenuInfo.getMenuFunction().getUiClassName())) {
            field.addContent((Content)new Element(UI_CLASS_NAME).setText(comMenuInfo.getMenuFunction().getUiClassName()));
        }
        if (!StringUtils.isEmpty((String)comMenuInfo.getMenuFunction().getUiClassParam())) {
            field.addContent((Content)new Element(UI_CLASS_PARAM).setText(comMenuInfo.getMenuFunction().getUiClassParam()));
        }
        if (comMenuInfo.getMenuFunction().getOpenMethod() != null) {
            field.addContent((Content)new Element(OPEN_METHOD).setText(new Integer(comMenuInfo.getMenuFunction().getOpenMethod().getValue()).toString()));
        }
        String uiOprt = StringUtils.cnulls((String)comMenuInfo.getMenuFunction().getUiOprt());
        field.addContent((Content)new Element(UI_OPRT).setText(uiOprt));
        field.addContent((Content)new Element(ENABLE).setText(Boolean.toString(comMenuInfo.getMenuFunction().isEnabled())));
        field.addContent((Content)new Element(MENUITEMNAME).setText(comMenuInfo.getMenuFunction().getName()));
        return field;
    }
}

