/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.client.AbstractNewMainFunctionMenuUI;
import com.kingdee.eas.base.uiframe.client.BodyUI;
import com.kingdee.eas.base.uiframe.client.GroupPanel;
import com.kingdee.eas.base.uiframe.client.LeafMenuCellPane;
import com.kingdee.eas.base.uiframe.client.LeafMenuLabelContainer;
import com.kingdee.eas.base.uiframe.client.LeafMenuLayout;
import com.kingdee.eas.base.uiframe.client.MainMenuConstants;
import com.kingdee.eas.base.uiframe.client.MainMenuList;
import com.kingdee.eas.base.uiframe.client.MainMenuListCellRenderer2;
import com.kingdee.eas.base.uiframe.client.MsgPanelUtil;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.NewMenuVisitorHelper;
import com.kingdee.eas.base.uiframe.client.NextGuideMsgPanel;
import com.kingdee.eas.base.uiframe.client.NonRulePanel;
import com.kingdee.eas.base.uiframe.client.UIFrameContext;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.base.uiframe.client.UIShowHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import org.apache.log4j.Logger;

public class NewMainFunctionMenuUI
extends AbstractNewMainFunctionMenuUI {
    private static final Logger logger = Logger.getLogger(NewMainFunctionMenuUI.class);
    private static final String msgAwokeManager = "com.kingdee.eas.base.message.client.MsgAwokeManager";
    private GroupPanel groupPanel = null;
    private MainMenuList level3List = null;
    private KDPanel level4Pane = null;
    private static String msgCenterUI = "com.kingdee.eas.base.message.client.MessageCenterUI";
    Color level4BgColor = MainMenuConstants.getDefaultSelectedColor();

    public NewMainFunctionMenuUI() throws Exception {
        NewMenuVisitorHelper.initMenuCache();
        this.groupPanel = new GroupPanel(this){
            private static final long serialVersionUID = 1L;

            @Override
            public void level2SelectionChanged(ListSelectionEvent e) throws BOSException {
                KDList subMenuList = (KDList)e.getSource();
                int index = subMenuList.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                MainMenuItemInfo selectedInfo = (MainMenuItemInfo)subMenuList.getElement(index);
                List<MainMenuItemInfo> level3Colls = NewMenuVisitorHelper.buildSubNodesByParentId(selectedInfo.getId().toString());
                NewMainFunctionMenuUI.this.initLevel3List(level3Colls);
            }
        };
        this.leftScrollPane1.getViewport().setView((Component)((Object)this.groupPanel));
        this.initMsgAwoke();
    }

    private void initMsgAwoke() {
        Object refreshTime = null;
        try {
            refreshTime = UIFrameContext.getInstance().getProperty("MsgRefreshInfo");
            if (refreshTime == null) {
                logger.warn((Object)"get MsgRefreshInfo is null,msgCenter won't refresh !");
            }
        }
        catch (Exception e) {
            logger.error((Object)"get MsgRefreshInfo err! ", (Throwable)e);
        }
        if (this.containsMsgCenterUI() && refreshTime != null && !refreshTime.toString().equals("0")) {
            try {
                Class<?> clazz = Class.forName(msgAwokeManager);
                Method init = clazz.getMethod("init", null);
                Method getInstance = clazz.getMethod("getInstance", null);
                Object obj = getInstance.invoke(clazz, null);
                init.invoke(obj, null);
            }
            catch (Exception ee) {
                logger.warn((Object)"init msgAwokeManager err!", (Throwable)ee);
            }
        }
    }

    private boolean containsMsgCenterUI() {
        for (int i = 0; i < BodyUI.SYS_TAB_CLASSNAME_LIST.length; ++i) {
            if (BodyUI.SYS_TAB_CLASSNAME_LIST[i].indexOf(msgCenterUI) < 0) continue;
            return true;
        }
        return false;
    }

    private void initLevel3List(List<MainMenuItemInfo> level3Colls) {
        if (this.level3List == null) {
            this.buildLevel3List();
        }
        if (level3Colls == null) {
            return;
        }
        this.level3List.removeListSelectionListener();
        this.level3List.removeAllElements();
        for (int i = 0; i < level3Colls.size(); ++i) {
            this.level3List.addElement(level3Colls.get(i));
        }
        this.level3List.addListSelectionListener();
        if (level3Colls.size() == 0 && this.level4Pane != null) {
            this.level4Pane.removeAll();
            this.level4Pane.revalidate();
            this.level4Pane.repaint();
        } else {
            this.level3List.setSelectedIndex(0);
        }
    }

    private void buildLevel3List() {
        this.level3List = new MainMenuList(){

            @Override
            protected void listSelectionChanged(ListSelectionEvent e) throws BOSException {
                NewMainFunctionMenuUI.this.level3SelectionChanged(e);
            }
        };
        this.level3List.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    int index = NewMainFunctionMenuUI.this.level3List.locationToIndex(e.getPoint());
                    MainMenuItemInfo info = (MainMenuItemInfo)NewMainFunctionMenuUI.this.level3List.getElement(index);
                    if (info.isIsLeaf() && !StringUtils.isEmpty((String)info.getUiClassName())) {
                        UIShowHelper.showUI((Component)((Object)NewMainFunctionMenuUI.this), info);
                    }
                }
            }
        });
        this.level3List.setSelectionBackground(MainMenuConstants.getDefaultSelectedColor());
        this.level3List.setSelectionForeground(Color.BLACK);
        this.level3List.setOpaque(false);
        this.level3List.setCellRenderer((ListCellRenderer)((Object)new MainMenuListCellRenderer2(50, 26)));
        this.level3List.setSelectionMode(0);
        this.level3List.setFixedCellHeight(31);
        this.level3ScrollPanel.getViewport().setView((Component)((Object)this.level3List));
    }

    private void level3SelectionChanged(ListSelectionEvent e) throws BOSException {
        KDList list = (KDList)e.getSource();
        int index = list.getSelectedIndex();
        if (index == -1) {
            return;
        }
        MainMenuItemInfo selectedInfo = (MainMenuItemInfo)this.level3List.getElement(index);
        List<MainMenuItemInfo> level4Colls = NewMenuVisitorHelper.buildSubNodesByParentId(selectedInfo.getId().toString());
        if (selectedInfo.isIsLeaf()) {
            level4Colls = new ArrayList<MainMenuItemInfo>();
            level4Colls.add(selectedInfo);
        }
        if ("4menuLicenseMonitor".equals(selectedInfo.getNumber())) {
            boolean isRegister = false;
            try {
                isRegister = LicenseSrvAgentFactory.getRemoteInstance().isRegister();
            }
            catch (LicenseException e1) {
                logger.error((Object)"\u83b7\u53d6license\u6a21\u5f0f\u5f02\u5e38---");
            }
            if (isRegister) {
                int j = level4Colls.size();
                for (int i = 0; i < j; ++i) {
                    MainMenuItemInfo info = level4Colls.get(i);
                    if (!"menuLicenseBase".equals(info.getNumber())) continue;
                    level4Colls.clear();
                    level4Colls.add(info);
                    break;
                }
            }
        }
        if (this.level4Pane == null) {
            this.level4Pane = new KDPanel();
            this.level4Pane.setCustomInsets(new Insets(22, 0, 22, 0));
            this.level4Pane.setBackground(MainMenuConstants.BACKGROUND_COLOR);
            this.level4Pane.setLayout((LayoutManager)new LeafMenuLayout());
            this.level4Pane.setBorder(BorderFactory.createEmptyBorder());
            this.level4ScrollPanel.getViewport().setView((Component)this.level4Pane);
        }
        if (level4Colls == null) {
            return;
        }
        this.level4Pane.removeAll();
        int j = level4Colls.size();
        for (int i = 0; i < j; ++i) {
            MainMenuItemInfo info = level4Colls.get(i);
            LeafMenuCellPane label = new LeafMenuCellPane(this, info);
            this.level4Pane.add((Component)((Object)label));
        }
        if (level4Colls.size() > 0) {
            LeafMenuLabelContainer preSelectedMenu = ((LeafMenuCellPane)((Object)this.level4Pane.getComponent(0))).getLeafMenuLabelContainer();
            preSelectedMenu.setHover(true);
            preSelectedMenu.setButtonVisible(true);
            if (MsgPanelUtil.isAddFunctionVisible()) {
                preSelectedMenu.getBoundButton().addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentMoved(ComponentEvent e) {
                        if (!MsgPanelUtil.isAddFunctionVisible()) {
                            return;
                        }
                        Component c = (Component)e.getSource();
                        Frame frame = UIFrameUtil.getCurrMainFrame(c);
                        if (frame instanceof NewMainFrame) {
                            NewMainFrame mainframe = (NewMainFrame)((Object)frame);
                            if (mainframe.getGuideMsgPanel() == null || mainframe.getGuideMsgPanel() instanceof NewMainFrame.CreateDirMsgPanel || mainframe.getGuideMsgPanel() instanceof NewMainFrame.PinYinMsgPanel || mainframe.getGuideMsgPanel() instanceof NewMainFrame.SwitchOrgMsgPanel) {
                                NewMainFunctionMenuUI.this.createAddFunctionMsgPanel(mainframe);
                            }
                            Point p = SwingUtilities.convertPoint(c.getParent(), c.getLocation(), (Component)((Object)mainframe));
                            mainframe.showGuideMsgLocation(p.x - 395, p.y);
                        }
                    }
                });
            }
            this.level4Pane.setUserObject((Object)preSelectedMenu);
        }
        this.level4Pane.revalidate();
        this.level4Pane.repaint();
    }

    private void createAddFunctionMsgPanel(NewMainFrame mainframe) {
        NonRulePanel nonRulePanel = mainframe.getNonRulePanel();
        nonRulePanel.setX1(390);
        nonRulePanel.setX2(410);
        nonRulePanel.setH(15);
        nonRulePanel.setPolygonAlignment(0);
        nonRulePanel.removeAll();
        NextGuideMsgPanel addFunctionMsgPanel = new NextGuideMsgPanel(EASResource.getIcon((String)"image_addFunction")){

            @Override
            protected void closeMouseClicked(MouseEvent e) {
                MsgPanelUtil.closeAddFunction((Component)e.getSource());
            }
        };
        addFunctionMsgPanel.setAllBackground(new Color(242, 242, 242));
        addFunctionMsgPanel.getNextLabel().setVisible(false);
        addFunctionMsgPanel.getCloseLabel().setVisible(true);
        nonRulePanel.addComponent((Component)((Object)addFunctionMsgPanel));
    }

    static void saveMenuCacheToLocalFile() {
        NewMenuVisitorHelper.updateLocalCache();
        NewMenuVisitorHelper.clearCache();
    }

    public void refreshMessage() {
        this.workBenchPanel.refreshMessage();
    }

    public void cleanLeve3AndLeve4List() {
        if (this.level3List != null) {
            this.level3List.removeListSelectionListener();
            this.level3List.removeAllElements();
        }
        if (this.level4Pane != null) {
            this.level4Pane.removeAll();
            this.level4Pane.revalidate();
            this.level4Pane.repaint();
        }
    }
}

