/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.apploader.message.MessageHandler;
import com.kingdee.bos.ctrl.common.WinSystemProxy;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.spi.SPInfo;
import com.kingdee.bos.spi.SPManager;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.monitor.client.BasicShowWfDefinePanel;
import com.kingdee.bos.workflow.report.client.util.ReportUtil;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.message.BMCMessageHistoryInfo;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.MessageViewConfig;
import com.kingdee.eas.base.message.client.MessageServiceProvider;
import com.kingdee.eas.base.message.client.MessageUtil;
import com.kingdee.eas.base.message.client.TempMsgManager;
import com.kingdee.eas.base.myeas.client.MySettingUI;
import com.kingdee.eas.base.myeas.client.getpanel.GetMyProcessPanel;
import com.kingdee.eas.base.myeas.client.getpanel.GetMyReportPanel;
import com.kingdee.eas.base.myeas.client.getpanel.StartProcessProgressDialog;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.EASLoginException;
import com.kingdee.eas.base.uiframe.IBOSManagerPlatProvider;
import com.kingdee.eas.base.uiframe.IBOSReportHandle;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.AppletUtil;
import com.kingdee.eas.base.uiframe.client.CommonUILifeCycleListener;
import com.kingdee.eas.base.uiframe.client.DlgShowListener;
import com.kingdee.eas.base.uiframe.client.HelpUtils;
import com.kingdee.eas.base.uiframe.client.IWebListener;
import com.kingdee.eas.base.uiframe.client.InvokeProgressDialog;
import com.kingdee.eas.base.uiframe.client.InvokeProgressTaskAdapter;
import com.kingdee.eas.base.uiframe.client.LicenseHelper;
import com.kingdee.eas.base.uiframe.client.LoginHelper;
import com.kingdee.eas.base.uiframe.client.MainFrame;
import com.kingdee.eas.base.uiframe.client.MainFrameCallBack;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.base.uiframe.client.WebInvoker;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.base.wf.IMyProcess;
import com.kingdee.eas.base.wf.MyProcessCollection;
import com.kingdee.eas.base.wf.MyProcessFactory;
import com.kingdee.eas.base.wf.client.CustomizeUI;
import com.kingdee.eas.base.wf.client.WFClientUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.SwitchOrgF7PromptDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.cp.eip.pc.IProcessServiceFacade;
import com.kingdee.eas.cp.eip.pc.ProcessServiceFacadeFactory;
import com.kingdee.eas.cp.eip.pc.client.AllProStatConditionUI;
import com.kingdee.eas.cp.eip.pc.client.OrgEfficencyStatConditionUI;
import com.kingdee.eas.cp.eip.pc.client.PersonStatConditionUI;
import com.kingdee.eas.cp.eip.pc.client.ProEfficencyStatConditionUI;
import com.kingdee.eas.cp.eip.pc.client.ProcConditionSearchUI;
import com.kingdee.eas.cp.eip.pc.client.ProcessClientUtil;
import com.kingdee.eas.cp.eip.pc.client.ProcessFindUI;
import com.kingdee.eas.cp.eip.sso.UserCountLimitedException;
import com.kingdee.eas.cp.mc.client.MyLinkPortletListUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IUILifeCycleListener;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.framework.client.workflow.TempBizProcRelationListenter;
import com.kingdee.eas.portal.IPortalFacade;
import com.kingdee.eas.portal.PortalFacadeFactory;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ServiceProvider {
    private static Logger logger = Logger.getLogger(ServiceProvider.class);
    private static final String APPLETFRAMEFACTORY = "com.kingdee.eas.base.uiframe.client.UIAppletFrameFactory";
    private static final String STAT_RESOURCE = "com.kingdee.eas.cp.eip.pc.client.CPPC";
    private static boolean hasLicence = false;
    private static String portalPackage = "com.kingdee.eas.portal";
    private static final String UICONTEXT_ISFROMWORKFLOW = "isFromWorkflow";
    private CommonQueryDialog processFindDialog = null;
    private CommonQueryDialog orgEfficencyStatConditionDialog = null;
    private CommonQueryDialog personStatConditionDialog = null;
    private CommonQueryDialog allProStatConditionDialog = null;
    private CommonQueryDialog proEfficencyStatConditionDialog = null;
    private CommonQueryDialog procConditionSearchDialog = null;
    private ArrayList<JFrame> defaultFameList = new ArrayList();
    private static JApplet crlApplet;
    private JApplet applet;
    private String sessionId;

    public ServiceProvider() {
        DaemonDefaultFrameThread thread = new DaemonDefaultFrameThread();
        thread.setName("DefaultFrameDaemon");
        thread.setDaemon(true);
        thread.start();
    }

    public void destroy() {
        crlApplet = null;
        if (!StringUtils.isEmpty((String)SysContext.getSysContext().getSessionID())) {
            try {
                MainFrame.clearWebMainFrame();
            }
            catch (EASLoginException eASLoginException) {
                // empty catch block
            }
        }
    }

    public void init(JApplet applet, String appServerUrl) {
        String metaDataPath;
        File metaDataFile;
        this.applet = applet;
        crlApplet = applet;
        if (!StringUtils.isEmpty((String)appServerUrl)) {
            UIConfig.setTempUrl(appServerUrl);
        }
        AppletUtil.isApplet = true;
        String openMethod = applet.getParameter("openMethod");
        if ("NewFrame".equalsIgnoreCase(openMethod)) {
            AppletUtil.isMainFrame = false;
        }
        if ((metaDataFile = new File(metaDataPath = System.getProperty("metadata.dir"))).exists()) {
            logger.debug((Object)("Client metadatapath : " + metaDataPath));
            MetaDataLoaderFactory.setClientMetaDataPath((String)metaDataPath);
        } else {
            logger.warn((Object)("Can't find metadata : " + metaDataPath));
        }
        Thread threadStartInit = new Thread(new Runnable(){

            @Override
            public void run() {
                ServiceProvider.this.startInit();
            }
        });
        threadStartInit.start();
        System.setProperty("sun.awt.exception.handler", ExceptionHandler.class.getName());
        String log4jPath = System.getProperty("easclient.root") + File.separator + "log4j.properties";
        File log4jFile = new File(log4jPath);
        if (log4jFile.exists()) {
            logger.debug((Object)("Log4j path : " + log4jPath));
            PropertyConfigurator.configure((String)log4jPath);
        } else {
            URL url = this.getClass().getClassLoader().getResource("log4j.properties");
            if (url != null) {
                logger.debug((Object)("Log4j path : " + url.toString()));
                PropertyConfigurator.configure((URL)url);
            }
        }
        try {
            WebInvoker webInvoker = WebInvoker.createInstance(applet);
            if (!StringUtils.isEmpty((String)applet.getParameter("WebListener"))) {
                IWebListener webListener = (IWebListener)Class.forName(applet.getParameter("WebListener")).newInstance();
                webInvoker.addListener(webListener);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Init web invoker error!");
        }
        this.clearWhenLogout();
    }

    public boolean myLinkPortalSetting() {
        boolean success = false;
        String uiName = MyLinkPortletListUI.class.getName();
        String uiState = OprtState.VIEW;
        UIContext uiContext = new UIContext((Object)this.getFrame());
        uiContext.put((Object)"checkLicense", (Object)"true");
        IUIWindow iUiWindow = null;
        try {
            iUiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, null);
            iUiWindow.show();
            success = true;
        }
        catch (UIException e) {
            logger.error((Object)UIFrameUtils.getRes("res_62"), (Throwable)e);
        }
        return success;
    }

    public boolean sendUrgentEMail(String assignId) {
        boolean returnValue = false;
        try {
            if (!StringUtils.isEmpty((String)assignId)) {
                returnValue = ProcessClientUtil.sendUrgentEMail((String)assignId, (Object)this.getFrame());
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
        return returnValue;
    }

    public boolean openBillByAssignID(String assignId) {
        try {
            if (MessageServiceProvider.isNotAssignmentId((String)assignId)) {
                this.viewMsgBill(assignId);
            } else {
                IEnactmentService wFService = null;
                wFService = EnactmentServiceFactory.createRemoteEnactService();
                AssignmentInfo info = wFService.getAssignmentById(assignId);
                String[] ids = info.getBizObjectIdArray();
                if (ids != null && ids.length > 0) {
                    this.viewMsgBill(ids[0]);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
        return true;
    }

    public boolean sendUrgentMobile(String assignId) {
        boolean returnValue = false;
        try {
            if (!StringUtils.isEmpty((String)assignId)) {
                returnValue = ProcessClientUtil.sendUrgentMobile((String)assignId, (Object)this.getFrame());
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
        return returnValue;
    }

    public void openCSHelpforPortal() {
        HelpUtils.openCSHelpforPortal(this.getFrame());
    }

    public void startInit() {
        long start = System.currentTimeMillis();
        try {
            UIManager.setLookAndFeel((LookAndFeel)new KingdeeLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e1) {
            logger.error((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)e1));
        }
        CtrlSwingUtilities.resetAppDefaultFocusTraversalKeys();
    }

    public void checkAvailMemory() {
        long availMemory = 0L;
        try {
            availMemory = WinSystemProxy.getInstance().getAvailPhys();
            if (availMemory < 0x4000000L) {
                Object[] variables = new Object[]{new Long(availMemory / 0x100000L)};
                String message1 = EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFrameResource", (String)"isMinMemory");
                String output = MessageFormat.format(message1, variables);
                MsgBox.showWarning((Component)SystemEntry.instance.getApplet(), (String)output);
            }
        }
        catch (Exception e0) {
            logger.error((Object)e0.getMessage(), (Throwable)e0);
        }
        catch (UnsatisfiedLinkError err) {
            logger.error((Object)err.getMessage(), (Throwable)err);
        }
    }

    public String login(String userName, String password, String slnName, String dcName, String locale, int dbType) {
        return this.login(userName, password, slnName, dcName, locale, dbType, "");
    }

    public String login(String userName, String password, String slnName, String dcName, String locale, int dbType, String authPattern) {
        this.checkAvailMemory();
        String strReturn = null;
        logger.debug((Object)("UserName" + userName));
        logger.debug((Object)("Begin login : " + System.currentTimeMillis()));
        try {
            this.sessionId = SystemEntry.instance.login(userName, password, slnName, dcName, new Locale(locale), dbType);
            hasLicence = LicenseHelper.checkLicence(this.getFrame(), "com.kingdee.eas.portal");
            if (!hasLicence) {
                if (this.sessionId != null) {
                    LoginHelper.logout();
                    this.sessionId = null;
                }
            } else {
                TempMsgManager.getInstance();
                TempMsgManager.setParentUI((Component)this.getFrame());
            }
        }
        catch (Exception e) {
            UserCountLimitedException ucle = ServiceProvider.getUserCountLimitedException(e);
            if (ucle != null) {
                MsgBox.showError((Component)this.getFrame(), (String)ucle.getMessage());
            } else if (e instanceof UserException) {
                String code = ((UserException)e).getCode();
                strReturn = code.equals("02-016") ? "-2" : (code.equals("02-007") ? "-1" : "-2");
                ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
            } else {
                ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
            }
            logger.debug((Object)("End login : " + System.currentTimeMillis()));
            return strReturn;
        }
        logger.debug((Object)("End login : " + System.currentTimeMillis()));
        return this.sessionId;
    }

    private static UserCountLimitedException getUserCountLimitedException(Exception e) {
        Throwable ex = null;
        for (ex = e; ex != null && ex.getCause() != ex; ex = ex.getCause()) {
            if (!(ex instanceof UserCountLimitedException)) continue;
            return (UserCountLimitedException)ex;
        }
        return null;
    }

    public void initAfterLogin() {
        logger.debug((Object)("Begin init after login : " + System.currentTimeMillis()));
        try {
            LoginHelper.initAfterLogin();
        }
        catch (EASLoginException e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)((Object)e));
        }
        logger.debug((Object)("End init after login : " + System.currentTimeMillis()));
    }

    public boolean isInit() {
        return LoginHelper.isInited();
    }

    public void logout() {
        try {
            TempMsgManager.stopInspectTimer();
            LicenseHelper.releaseLicense(hasLicence, portalPackage);
            MainFrame.clearWebMainFrame();
        }
        catch (EASLoginException e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)((Object)e));
        }
    }

    public void invokeFunction(String uiClassName, String uiClassParam, String uiOprt, int openMethod) {
        this.invokeFunctionWithExtProp(uiClassName, uiClassParam, uiOprt, null, null, openMethod);
    }

    public void invokeFunctionWithExtProp(String uiClassName, String uiClassParam, String uiOprt, String extPropName, String extPropValue, int openMethod) {
        UIContext uiContext = new UIContext((Object)this.getFrame());
        uiContext.put("checkLicense", "true");
        if (!StringUtils.isEmpty((String)uiClassParam)) {
            uiContext.put("UIClassParam", uiClassParam);
        }
        String uiFactoryName = "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
        if (openMethod == 50) {
            uiFactoryName = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        } else if (openMethod == 80) {
            uiFactoryName = "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)uiFactoryName).create(uiClassName, (Map)uiContext, null, uiOprt);
            CoreUI coreUI = (CoreUI)uiWindow.getUIObject();
            if (extPropName != null && extPropName.length() > 0 && extPropValue != null && extPropValue.length() > 0) {
                CommonUILifeCycleListener listener = new CommonUILifeCycleListener(extPropName, extPropValue);
                coreUI.getUILifeCycleHandler().addRuleListener((IUILifeCycleListener)listener);
                if (coreUI.getDataObject() != null) {
                    coreUI.getDataObject().setExtendedProperty(extPropName, extPropValue);
                }
                if (coreUI instanceof CoreBillEditUI && ((CoreBillEditUI)coreUI).getEditData() != null) {
                    ((CoreBillEditUI)coreUI).getEditData().setExtendedProperty(extPropName, extPropValue);
                }
            }
            uiWindow.show();
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
    }

    public void openMainMenuFunction() {
        try {
            MainFrame.getWebMainFrame().doubleShow();
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
    }

    public boolean checkLogined() {
        return !StringUtils.isEmpty((String)this.sessionId);
    }

    protected Frame getFrame() {
        return this.getFrame("");
    }

    protected Frame getFrame(String methodName) {
        JFrame portalFrame = new JFrame();
        portalFrame.setName("apploader");
        if (methodName != null) {
            portalFrame.setName("apploader_" + methodName);
            portalFrame.setIconImage(EASResource.getImage((String)"imgEas_16"));
            portalFrame.setTitle(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"48_ServiceProvider"));
            portalFrame.setSize(300, 150);
            portalFrame.setResizable(false);
            portalFrame.setLocationRelativeTo(null);
            portalFrame.setLayout(new BorderLayout());
            KDLabel label = new KDLabel(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"48_ServiceProvider"), 0);
            portalFrame.add((Component)label, "Center");
            this.defaultFameList.add(portalFrame);
            portalFrame.setAlwaysOnTop(true);
        }
        return portalFrame;
    }

    public void handleAssignment(String messageId, String assignmentId) {
        MessageServiceProvider.handleAssign((Component)this.getFrame(), (String)messageId, (String)assignmentId);
    }

    public void handleAssignment(String assignmentId) {
        MessageServiceProvider.handleAssignment((Component)this.getFrame(), (String)assignmentId);
    }

    public void showWfDiagramByProcInst(String procInstID) {
        ProcessClientUtil.showWfDiagramByProcInst((Component)this.getFrame(), (String)procInstID);
    }

    public void showWfDiagramByBizObjectID(String bizObjectID) {
        try {
            MessageServiceProvider.showWfDiagramByBizObjectID((Component)this.getFrame(), (String)bizObjectID);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
    }

    public void handleAssignmentByByUserPeronAssign(String userPeronAssign) {
        try {
            String idList = ProcessClientUtil.handleAssignmentByAssignAndPerson((String)userPeronAssign, (Object)this.getFrame());
            if (idList == null) {
                return;
            }
            int douhaoInex = idList.indexOf(",");
            if (douhaoInex > 0) {
                this.handleMultiAssignments(idList);
            } else {
                this.handleAssignment(null, idList);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
    }

    public boolean deleteProcInstByAssignId(String assignIds) {
        try {
            IProcessServiceFacade processService = ProcessServiceFacadeFactory.getRemoteInstance();
            return processService.deleteProcessInstByAssignIds(assignIds);
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)this.getFrame(), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"deleteProcessInstFailure"));
            return false;
        }
    }

    public boolean deleteProcessInst(String processInstIds) {
        try {
            IProcessServiceFacade processService = ProcessServiceFacadeFactory.getRemoteInstance();
            return processService.deleteProcessInst(processInstIds);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
            return false;
        }
    }

    public void addNewMessage() {
        MessageServiceProvider.addNewMessage((Component)this.getFrame());
    }

    public void clickMessage(String messageId, String assignmentId, String nodeType, String ifHistory) {
        MessageHandler.sendCloseDivMsg();
        if (StringUtils.isEmpty((String)assignmentId)) {
            this.viewMessage(messageId, nodeType, ifHistory);
        } else if (MessageServiceProvider.isNotAssignmentId((String)assignmentId)) {
            this.handleSpecialMessage(messageId, assignmentId, nodeType, ifHistory);
        } else if (!this.canHandleAssignment(assignmentId)) {
            this.viewMessage(messageId, nodeType, ifHistory);
        } else {
            this.handleAssignment(messageId, assignmentId);
        }
    }

    private void handleSpecialMessage(String messageId, String assignmentId, String nodeType, String ifHistory) {
        logger.info((Object)("---handleSpecialMessage assignmentId=" + assignmentId));
        if (assignmentId.indexOf("::") > 0) {
            String prefix = assignmentId.substring(0, assignmentId.indexOf("::"));
            Object obj = MessageViewConfig.getInstance((boolean)false).getConfigByPrefix(prefix);
            if (obj != null) {
                HashMap map = (HashMap)obj;
                if (map.get("gui") != null) {
                    try {
                        MessageServiceProvider.viewConfigMessage((Component)this.getFrame(), (String)assignmentId, (HashMap)map);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
                    }
                } else {
                    logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"49_ServiceProvider") + prefix + EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"50_ServiceProvider")));
                    this.viewMessage(messageId, nodeType, ifHistory);
                }
            } else {
                logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"49_ServiceProvider") + prefix + EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"51_ServiceProvider")));
                this.viewMessage(messageId, nodeType, ifHistory);
            }
        } else {
            try {
                String msgSender = "";
                if (!Boolean.valueOf(ifHistory).booleanValue()) {
                    BMCMessageInfo info = MessageUtil.getBMCMessageInfo((IObjectPK)new ObjectUuidPK(messageId));
                    msgSender = info.getSender().toString();
                } else {
                    BMCMessageHistoryInfo info = MessageUtil.getBMCMessageHstInfo((IObjectPK)new ObjectUuidPK(messageId));
                    msgSender = info.getSender().toString();
                }
                MessageServiceProvider.invokePassCommentUI((String)assignmentId, (String)msgSender);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
            }
        }
    }

    public void handleMultiAssignments(String assignmentIds) {
        logger.debug((Object)("AssignmentIds : " + assignmentIds));
        MessageServiceProvider.handleMultiAssignments((Component)this.getFrame(), (String)assignmentIds);
        MessageHandler.sendCloseDivMsg();
    }

    public boolean canHandleAssignment(String assignmentId) {
        return MessageServiceProvider.canHandleAssignment((Component)this.getFrame(), (String)assignmentId);
    }

    public void rollbackAssignment(String assignmentId) {
        MessageServiceProvider.rollbackAssignment((Component)this.getFrame(), (String)assignmentId);
    }

    public boolean canRollbackAssignment(String assignmentId) {
        return MessageServiceProvider.canRollbackAssignment((Component)this.getFrame(), (String)assignmentId);
    }

    public void forwardAssignment(String assignmentId) {
        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"52_ServiceProvider") + assignmentId + "-------------"));
        MessageServiceProvider.forwardAssignment((Component)this.getFrame(), (String)assignmentId);
    }

    public boolean canForwardAssignment(String assignmentId) {
        return MessageServiceProvider.canForwardAssignment((Component)this.getFrame(), (String)assignmentId);
    }

    public void rejectAssignment(String assignmentId) {
        MessageServiceProvider.rejectAssignment((Component)this.getFrame(), (String)assignmentId);
    }

    public boolean canRejectAssignment(String assignmentId) {
        return MessageServiceProvider.canRejectAssignment((Component)this.getFrame(), (String)assignmentId);
    }

    public void showWfDiagram(String assignmentId) {
        MessageServiceProvider.showWfDiagram((Component)this.getFrame(), (String)assignmentId);
    }

    public void readMessage(String messageId) {
    }

    public void viewMessage(String messageId, String nodeType, String ifHistory) {
        MessageServiceProvider.viewMessage((Component)this.getFrame(), (String)messageId, (String)nodeType, (String)ifHistory);
    }

    public String showOrgEfficencyStatDialog() {
        this.clearWhenLogout();
        String strSql = "";
        try {
            OrgEfficencyStatConditionUI filterPanel = null;
            if (this.orgEfficencyStatConditionDialog == null) {
                filterPanel = new OrgEfficencyStatConditionUI();
                this.orgEfficencyStatConditionDialog = new CommonQueryDialog();
                this.orgEfficencyStatConditionDialog.setOwner((Component)this.getFrame());
                MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.pc.app", "OrgEfficencyProcessQuery");
                this.orgEfficencyStatConditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPK);
                this.orgEfficencyStatConditionDialog.setShowFilter(false);
                this.orgEfficencyStatConditionDialog.setShowSorter(false);
                this.orgEfficencyStatConditionDialog.setWidth(320);
                this.orgEfficencyStatConditionDialog.setHeight(220);
                this.orgEfficencyStatConditionDialog.addUserPanel((KDPanel)filterPanel);
                this.orgEfficencyStatConditionDialog.setParentUIClassName(this.getFrame().getClass().toString());
            }
            filterPanel = (OrgEfficencyStatConditionUI)this.orgEfficencyStatConditionDialog.getCommonQueryParam().getPanels().get(0);
            if (this.orgEfficencyStatConditionDialog.show()) {
                strSql = filterPanel.getQuerySql();
                return strSql;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
        return strSql;
    }

    public void deleteMessage(String messageId) {
        MessageServiceProvider.deleteMessage((Component)this.getFrame(), (String)messageId);
    }

    public boolean canDeleteMessage(String messageId) {
        return MessageServiceProvider.canDeleteMessage((Component)this.getFrame(), (String)messageId);
    }

    public ProcessDefInfo[] getProcessOrientData(String userId) {
        return GetMyProcessPanel.getProcessOrientData((String)userId, (Component)this.getFrame());
    }

    public boolean startProcess1(String procDefId, String userId) {
        try {
            EASWfServiceClient ormClient = new EASWfServiceClient();
            ormClient.init(UIConfig.getUrl(), SysContext.getSysContext().getSessionID());
            ProcessDefInfo procDefInfo = ormClient.getProcessDefInfo(procDefId);
            UserInfo userInfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)userId)));
            return GetMyProcessPanel.startProcess((ProcessDefInfo)procDefInfo, (Component)this.getFrame(), (UserInfo)userInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
            return false;
        }
    }

    public boolean startProcess(String procDefId, String userId) {
        StartProcessProgressDialog dlg = null;
        dlg = new StartProcessProgressDialog(this.getFrame());
        DlgShowListener listener = new DlgShowListener((Component)dlg);
        dlg.addWindowListener((WindowListener)listener);
        dlg.setProcDefId(procDefId);
        dlg.setUserId(userId);
        dlg.show();
        return dlg.isBReturn();
    }

    public boolean editProcess(String userId) {
        try {
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            userId = userInfo.getId().toString();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("Owner", this.getFrame());
            map.put("userInfo", userInfo);
            EASWfServiceClient ormClient = new EASWfServiceClient();
            ormClient.init(UIConfig.getUrl(), SysContext.getSysContext().getSessionID());
            ProcessDefInfo[] procDefArray = null;
            try {
                procDefArray = ormClient.getProcDefArrayDistinctByUserID(userId);
            }
            catch (IllegalArgumentException ex) {
                logger.error((Object)"User has not person!");
            }
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("userID", (Object)userId, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            IMyProcess iMyProcess = MyProcessFactory.getRemoteInstance();
            MyProcessCollection myProCollection = null;
            try {
                myProCollection = iMyProcess.getMyProcessCollection(viewInfo);
            }
            catch (BOSException e) {
                logger.error((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)e));
            }
            map.put("procDefArray", procDefArray);
            map.put("client", ormClient);
            map.put("iMyProcess", iMyProcess);
            map.put("myProCollection", myProCollection);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CustomizeUI.class.getName(), map, null, null);
            uiWindow.show();
            return ((CustomizeUI)uiWindow.getUIObject()).returnValue;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
            return false;
        }
    }

    public void showProcDefDiagram(String procDefID) {
        try {
            if (procDefID != null && procDefID.length() > 0) {
                ProcessDefInfo processDefInfo = ReportUtil.getServiceClient().getProcessDefInfo(procDefID);
                Locale currentLocale = SysContext.getSysContext().getLocale();
                ProcessDef processDef = EnactmentServiceFactory.createRemoteEnactService().getProcessDefByDefineHashValue(processDefInfo.getMd5HashValue());
                String procDefDiagramTitle = processDef.getName(currentLocale);
                UIContext uiContext = new UIContext((Object)this.getFrame());
                uiContext.put((Object)"define", (Object)processDef);
                uiContext.put((Object)"title", (Object)procDefDiagramTitle);
                String className = BasicShowWfDefinePanel.class.getName();
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
                IUIWindow uiWindow = uiFactory.create(className, (Map)uiContext);
                uiWindow.show();
            }
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)this.getFrame(), (String)"UIException", (Throwable)e);
        }
        catch (WfException e) {
            ExceptionHandler.handle((Component)this.getFrame(), (String)"WfException", (Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)this.getFrame(), (String)"WfException", (Throwable)e);
        }
    }

    public void openProcCatalogSetting() {
        try {
            UIContext uiContext = new UIContext((Object)this.getFrame());
            uiContext.put((Object)"ID", null);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.cp.eip.pc.client.ProcCatalogUI", (Map)uiContext);
            uiWindow.show();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
    }

    public String showPersonStatDialog() {
        this.clearWhenLogout();
        String strSql = "";
        try {
            PersonStatConditionUI filterPanel = null;
            if (this.personStatConditionDialog == null) {
                filterPanel = new PersonStatConditionUI();
                this.personStatConditionDialog = new CommonQueryDialog();
                this.personStatConditionDialog.setOwner((Component)this.getFrame());
                MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.pc.app", "Person_PendingProcessQuery");
                this.personStatConditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPK);
                this.personStatConditionDialog.setShowFilter(false);
                this.personStatConditionDialog.setShowSorter(false);
                this.personStatConditionDialog.setWidth(320);
                this.personStatConditionDialog.setHeight(220);
                this.personStatConditionDialog.addUserPanel((KDPanel)filterPanel);
                logger.info((Object)(UIFrameUtils.getRes("res_63") + "UI TITLE" + UIFrameUtils.getRes("res_1") + filterPanel.getUITitle()));
                this.personStatConditionDialog.setTitle(EASResource.getString((String)STAT_RESOURCE, (String)"PERSON_STATE_TITLE"));
                this.personStatConditionDialog.setParentUIClassName(this.getFrame().getClass().toString());
            }
            filterPanel = (PersonStatConditionUI)this.personStatConditionDialog.getCommonQueryParam().getPanels().get(0);
            if (this.personStatConditionDialog.show()) {
                strSql = filterPanel.getQuerySql();
                return strSql;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
        return strSql;
    }

    public String showAllProcessStatDialog() {
        this.clearWhenLogout();
        String strSql = "";
        try {
            AllProStatConditionUI filterPanel = null;
            if (this.allProStatConditionDialog == null) {
                filterPanel = new AllProStatConditionUI();
                this.allProStatConditionDialog = new CommonQueryDialog();
                this.allProStatConditionDialog.setOwner((Component)this.getFrame());
                MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.pc.app", "ALL_PendingProcessQuery");
                this.allProStatConditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPK);
                this.allProStatConditionDialog.setShowFilter(false);
                this.allProStatConditionDialog.setShowSorter(false);
                this.allProStatConditionDialog.setWidth(320);
                this.allProStatConditionDialog.setHeight(220);
                this.allProStatConditionDialog.addUserPanel((KDPanel)filterPanel);
                this.allProStatConditionDialog.setTitle(EASResource.getString((String)STAT_RESOURCE, (String)"ALL_STATE_TITLE"));
                this.allProStatConditionDialog.setParentUIClassName(this.getFrame().getClass().toString());
            }
            filterPanel = (AllProStatConditionUI)this.allProStatConditionDialog.getCommonQueryParam().getPanels().get(0);
            if (this.allProStatConditionDialog.show()) {
                strSql = filterPanel.getQuerySql();
                return strSql;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
        return strSql;
    }

    public String showEfficencyStatDialog() {
        this.clearWhenLogout();
        String strSql = "";
        try {
            ProEfficencyStatConditionUI filterPanel = null;
            if (this.proEfficencyStatConditionDialog == null) {
                filterPanel = new ProEfficencyStatConditionUI();
                this.proEfficencyStatConditionDialog = new CommonQueryDialog();
                this.proEfficencyStatConditionDialog.setOwner((Component)this.getFrame());
                MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.pc.app", "Efficency_PendingProcessQuery");
                this.proEfficencyStatConditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPK);
                this.proEfficencyStatConditionDialog.setShowFilter(false);
                this.proEfficencyStatConditionDialog.setShowSorter(false);
                this.proEfficencyStatConditionDialog.setWidth(320);
                this.proEfficencyStatConditionDialog.setHeight(220);
                this.proEfficencyStatConditionDialog.addUserPanel((KDPanel)filterPanel);
                this.proEfficencyStatConditionDialog.setTitle(EASResource.getString((String)STAT_RESOURCE, (String)"EFFICENCY_STATE_TITLE"));
                this.proEfficencyStatConditionDialog.setParentUIClassName(this.getFrame().getClass().toString());
            }
            filterPanel = (ProEfficencyStatConditionUI)this.proEfficencyStatConditionDialog.getCommonQueryParam().getPanels().get(0);
            if (this.proEfficencyStatConditionDialog.show()) {
                strSql = filterPanel.getQuerySql();
                return strSql;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
        return strSql;
    }

    public void viewProcess(String procDefId) {
        try {
            EASWfServiceClient ormClient = new EASWfServiceClient();
            ormClient.init(UIConfig.getUrl(), SysContext.getSysContext().getSessionID());
            ProcessDefInfo procDefInfo = ormClient.getProcessDefInfo(procDefId);
            WFClientUtil cu = new WFClientUtil();
            cu.transferWfDefinePanel((Component)this.getFrame(), procDefInfo);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
    }

    public QuerySolutionCollection getMyReportColl() throws Exception {
        return GetMyReportPanel.getMyReportColl();
    }

    public void showReportUI(String queryId, boolean isCommSearch) {
        QuerySolutionInfo queryInfo;
        try {
            queryInfo = QuerySolutionFactory.getRemoteInstance().getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)queryId)));
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
            return;
        }
        GetMyReportPanel.showReportUI((QuerySolutionInfo)queryInfo, (boolean)isCommSearch, (Component)this.getFrame());
    }

    public void editReport() {
        GetMyReportPanel.showReportUI(null, (boolean)true, (Component)this.getFrame());
    }

    public boolean viewBillByProcInst(String procInstID) {
        int len;
        boolean isIncludeHst = false;
        boolean isCanUrgent = false;
        if (procInstID.startsWith("nIncludeHis~!~")) {
            isIncludeHst = true;
            procInstID = procInstID.substring(14);
        }
        if (procInstID.endsWith("~!~1")) {
            isCanUrgent = true;
            len = procInstID.length();
            procInstID = procInstID.substring(0, len - 4);
        } else if (procInstID.endsWith("~!~0")) {
            isCanUrgent = false;
            len = procInstID.length();
            procInstID = procInstID.substring(0, len - 4);
        }
        try {
            String objID = ProcessClientUtil.viewBillByProcInst((boolean)isCanUrgent, (boolean)isIncludeHst, (String)procInstID, (Object)this.getFrame());
            if (objID != null) {
                this.viewMsgBill(objID);
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)UIFrameUtils.getRes("res_64"), (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
        return false;
    }

    private void viewMsgBill(String billId) {
        try {
            logger.debug((Object)("Bill ID : " + billId));
            BOSObjectType bosType = BOSUuid.getBOSObjectType((String)billId, (boolean)true);
            if (bosType == null) {
                throw new RuntimeException(UIFrameUtils.getRes("res_65"));
            }
            EntityObjectInfo entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bosType);
            String editUIName = entity.getExtendedProperty("editUI");
            if (StringUtils.isEmpty((String)editUIName) || editUIName.equals("com.kingdee.eas.cp.eip.cm.client.CMPublishUI") || editUIName.equals("com.kingdee.eas.cp.mc.client.DatePlanEventAuditUI")) {
                MsgBox.showInfo((Component)this.getFrame(), (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"can.not.surrport.open"));
                return;
            }
            logger.debug((Object)("Edit UI Name : " + editUIName));
            if (StringUtils.isEmpty((String)editUIName)) {
                throw new RuntimeException("Entity [" + entity.getName() + "] is not set extended property editUI!");
            }
            UIContext uiContext = new UIContext((Object)this.getFrame());
            uiContext.put((Object)"ID", (Object)billId);
            uiContext.put((Object)"canResize", (Object)"true");
            uiContext.put((Object)UICONTEXT_ISFROMWORKFLOW, (Object)new Boolean(true));
            MessageHandler.sendCloseDivMsg();
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(editUIName, (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
    }

    public void viewBill(String billId) {
        this.commonViewBill(billId, null, null, null);
    }

    public void commonViewBill(String billID, String extPropName, String extPropValue) {
        this.commonEditBill(billID, extPropName, extPropValue, null);
    }

    private void commonViewBill(String billId, String extPropName, String extPropValue, IUILifeCycleListener listener) {
        this.commonViewOrEditBill(billId, extPropName, extPropValue, listener, OprtState.VIEW);
    }

    public boolean sendUrgentMessageByUserPeronAssign(String userPeronAssign) {
        boolean returnValue = false;
        char msgType = userPeronAssign.charAt(0);
        userPeronAssign = userPeronAssign.substring(1);
        String assignid = null;
        int success = 0;
        int length = 0;
        try {
            assignid = ProcessClientUtil.sendUrgent((String)userPeronAssign, (Object)this.getFrame());
            String[] assign = null;
            if (assignid != null && !assignid.trim().equals("")) {
                assign = assignid.split(",");
            }
            if (assign != null && assign.length > 0) {
                length = assign.length;
                for (int i = 0; i < length; ++i) {
                    if (msgType == '1') {
                        if (!this.sendUrgentEMail(assign[i])) continue;
                        ++success;
                        continue;
                    }
                    if (msgType == '2') {
                        if (!this.sendUrgentMobile(assign[i])) continue;
                        ++success;
                        continue;
                    }
                    if (!this.sendUrgentMessage(assign[i])) continue;
                    ++success;
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
        return returnValue;
    }

    public boolean sendUrgentMessage(String assignId) {
        boolean returnValue = false;
        try {
            returnValue = ProcessClientUtil.sendUrgentMessage((String)assignId, (Object)this.getFrame());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
        return returnValue;
    }

    public String showProcessFindDialog() {
        this.clearWhenLogout();
        String strSql = "";
        try {
            ProcessFindUI filterPanel = null;
            if (this.processFindDialog == null) {
                filterPanel = new ProcessFindUI();
                this.processFindDialog = new CommonQueryDialog();
                this.processFindDialog.setOwner((Component)this.getFrame());
                MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.pc.app", "PendingProcessQuery");
                this.processFindDialog.setQueryObjectPK((IMetaDataPK)mainQueryPK);
                this.processFindDialog.setShowFilter(false);
                this.processFindDialog.setShowSorter(false);
                this.processFindDialog.setWidth(320);
                this.processFindDialog.setHeight(220);
                this.processFindDialog.addUserPanel((KDPanel)filterPanel);
                this.processFindDialog.setTitle(filterPanel.getUITitle());
                this.processFindDialog.setParentUIClassName(this.getFrame().getClass().toString());
            }
            filterPanel = (ProcessFindUI)this.processFindDialog.getCommonQueryParam().getPanels().get(0);
            if (this.processFindDialog.show()) {
                filterPanel.setCacheMap();
                strSql = filterPanel.getQuerySql();
                return strSql;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
        return strSql;
    }

    public String showProcessConditionDialog() {
        this.clearWhenLogout();
        String strSql = "";
        try {
            ProcConditionSearchUI filterPanel = null;
            if (this.procConditionSearchDialog == null) {
                filterPanel = new ProcConditionSearchUI();
                this.procConditionSearchDialog = new CommonQueryDialog();
                this.procConditionSearchDialog.setOwner((Component)this.getFrame());
                MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.pc.app", "PendingProcessQuery");
                this.procConditionSearchDialog.setQueryObjectPK((IMetaDataPK)mainQueryPK);
                this.procConditionSearchDialog.setShowFilter(false);
                this.procConditionSearchDialog.setShowSorter(false);
                this.procConditionSearchDialog.setWidth(320);
                this.procConditionSearchDialog.setHeight(220);
                this.procConditionSearchDialog.addUserPanel((KDPanel)filterPanel);
                this.procConditionSearchDialog.setTitle(filterPanel.getUITitle());
                this.procConditionSearchDialog.setParentUIClassName(this.getFrame().getClass().toString());
            }
            filterPanel = (ProcConditionSearchUI)this.procConditionSearchDialog.getCommonQueryParam().getPanels().get(0);
            if (this.procConditionSearchDialog.show()) {
                strSql = filterPanel.getQuerySql();
                return strSql;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
        return strSql;
    }

    public String popupPromptDialog(String promptDialogName) {
        try {
            Object[] d;
            Class<?> selectorClass = Class.forName(promptDialogName);
            Constructor<?> constructor = selectorClass.getConstructor(Frame.class);
            KDPromptSelector selector = (KDPromptSelector)constructor.newInstance(this.getFrame());
            selector.show();
            if (selector.isCanceled()) {
                return "";
            }
            Object result = selector.getData();
            logger.info((Object)("F7 return value : " + result));
            if (result == null) {
                return "";
            }
            if (selector instanceof KDCommonPromptDialog && (d = (Object[])result) != null && d.length > 0) {
                result = d[0];
            }
            if (result instanceof DataBaseInfo) {
                DataBaseInfo dbInfo = (DataBaseInfo)result;
                return dbInfo.getId().toString() + "&" + dbInfo.getName();
            }
            if (result instanceof CoreBaseInfo) {
                CoreBaseInfo cbInfo = (CoreBaseInfo)result;
                return cbInfo.getId().toString();
            }
            return result.toString();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
            return "";
        }
    }

    public String getCurrentOrgUnitId(int orgTypeValue) {
        OrgType orgType = OrgType.getEnum((int)orgTypeValue);
        OrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentOrgUnit(orgType);
        if (orgUnit != null) {
            return orgUnit.getId().toString();
        }
        return "";
    }

    public String getSessionId() {
        return SysContext.getSysContext().getSessionID();
    }

    public void showOrgPersonalQuery() {
        UIContext uiContext = new UIContext((Object)this.getFrame());
        if (SPManager.isSPInstalled((String)"BOSManagerPlatProviderImpl")) {
            SPInfo spInfo = SPManager.getInstance().getSeviceProvider("BOSManagerPlatProviderImpl");
            try {
                Object object = spInfo.getProviderClass().newInstance();
                IBOSManagerPlatProvider impl = (IBOSManagerPlatProvider)object;
                impl.showOrgPersonalQuery(uiContext);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
            }
        }
    }

    public void showMyProcess() {
        UIContext uiContext = new UIContext((Object)this.getFrame());
        if (SPManager.isSPInstalled((String)"BOSManagerPlatProviderImpl")) {
            SPInfo spInfo = SPManager.getInstance().getSeviceProvider("BOSManagerPlatProviderImpl");
            try {
                Object object = spInfo.getProviderClass().newInstance();
                IBOSManagerPlatProvider impl = (IBOSManagerPlatProvider)object;
                impl.showMyProcess(uiContext);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
            }
        }
    }

    public void showMyReport() {
        UIContext uiContext = new UIContext((Object)this.getFrame());
        if (SPManager.isSPInstalled((String)"BOSManagerPlatProviderImpl")) {
            SPInfo spInfo = SPManager.getInstance().getSeviceProvider("BOSManagerPlatProviderImpl");
            try {
                Object object = spInfo.getProviderClass().newInstance();
                IBOSManagerPlatProvider impl = (IBOSManagerPlatProvider)object;
                impl.showMyReport(uiContext);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
            }
        }
    }

    public void showMyProfile() {
        UIContext uiContext = new UIContext((Object)this.getFrame());
        if (SPManager.isSPInstalled((String)"BOSManagerPlatProviderImpl")) {
            SPInfo spInfo = SPManager.getInstance().getSeviceProvider("BOSManagerPlatProviderImpl");
            try {
                Object object = spInfo.getProviderClass().newInstance();
                IBOSManagerPlatProvider impl = (IBOSManagerPlatProvider)object;
                impl.showMyProfile(uiContext);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
            }
        }
    }

    public void showMyPerformance() {
        UIContext uiContext = new UIContext((Object)this.getFrame());
        if (SPManager.isSPInstalled((String)"BOSManagerPlatProviderImpl")) {
            SPInfo spInfo = SPManager.getInstance().getSeviceProvider("BOSManagerPlatProviderImpl");
            try {
                Object object = spInfo.getProviderClass().newInstance();
                IBOSManagerPlatProvider impl = (IBOSManagerPlatProvider)object;
                impl.showMyPerformance(uiContext);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
            }
        }
    }

    public void showMyTrain() {
        UIContext uiContext = new UIContext((Object)this.getFrame());
        if (SPManager.isSPInstalled((String)"BOSManagerPlatProviderImpl")) {
            SPInfo spInfo = SPManager.getInstance().getSeviceProvider("BOSManagerPlatProviderImpl");
            try {
                Object object = spInfo.getProviderClass().newInstance();
                IBOSManagerPlatProvider impl = (IBOSManagerPlatProvider)object;
                impl.showMyTrain(uiContext);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
            }
        }
    }

    public void showMyEasSetting() {
        try {
            UIContext uiContext = new UIContext((Object)this.getFrame());
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MySettingUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException e1) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e1);
        }
    }

    public String showMyEasSetting_new() {
        String colorStyle = "";
        try {
            UIContext uiContext = new UIContext((Object)this.getFrame());
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MySettingUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            Object obj = uiContext.get((Object)"EasWebColorStyle");
            if (obj != null) {
                colorStyle = (String)obj;
            }
        }
        catch (UIException e1) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e1);
        }
        return colorStyle;
    }

    public void switchOrg() {
        try {
            boolean isOpenMainFrm = MainFrame.isOpenWebMainFrame();
            if (isOpenMainFrm) {
                if (MsgBox.showConfirm2((Component)this.getFrame(), (String)EASResource.getString((String)UIFrameResource.class.getName(), (String)"MainMenuBar.switchOrgConfirm")) == 2) {
                    return;
                }
                if (!MainFrame.getWebMainFrame().closeAllNonSysApp()) {
                    return;
                }
            }
            SwitchOrgF7PromptDialog f7ui = new SwitchOrgF7PromptDialog(this.getFrame());
            f7ui.show();
        }
        catch (UIException e1) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e1);
        }
    }

    public void closeWebMainFrame() {
        try {
            if (MainFrame.isOpenWebMainFrame()) {
                MainFrame.clearWebMainFrame();
            }
        }
        catch (Exception e) {
            logger.error((Object)(UIFrameUtils.getRes("res_66") + "mainFrame " + UIFrameUtils.getRes("res_67") + e.getMessage()));
        }
    }

    public void openAdminPageManager() {
        try {
            UIContext uiContext = new UIContext((Object)this.getFrame());
            uiContext.put((Object)"checkLicense", (Object)"true");
            uiContext.put((Object)"tabManageType", (Object)"1");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.portal.client.TabUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException e1) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e1);
        }
    }

    public void openAdminPortletManager() {
        InvokeProgressDialog dlg = null;
        dlg = new InvokeProgressDialog(this.getFrame());
        dlg.setGetDataTask(new InvokeProgressTaskAdapter(){

            @Override
            public Object exec() throws Exception {
                return ServiceProvider.this.openAdminPortletManager1();
            }
        });
        dlg.show();
    }

    public void openUserPageManager() {
        try {
            UIContext uiContext = new UIContext((Object)this.getFrame());
            uiContext.put((Object)"checkLicense", (Object)"true");
            uiContext.put((Object)"tabManageType", (Object)"0");
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.portal.client.TabUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException e1) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e1);
        }
    }

    public void openPersonPageManager() {
        try {
            UIContext uiContext = new UIContext((Object)this.getFrame());
            uiContext.put((Object)"checkLicense", (Object)"true");
            uiContext.put((Object)"tabManageType", (Object)"2");
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.portal.client.TabUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException e1) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e1);
        }
    }

    public IUIWindow openAdminPortletManager1() {
        IUIWindow uiWindow = null;
        try {
            UIContext uiContext = new UIContext((Object)this.getFrame());
            uiContext.put((Object)"checkLicense", (Object)"true");
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.portal.client.PortletListUI", (Map)uiContext, null, OprtState.VIEW);
        }
        catch (UIException e1) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e1);
        }
        return uiWindow;
    }

    public static Frame getCrlFrame() {
        return JOptionPane.getFrameForComponent(SystemEntry.instance.getApplet());
    }

    public String checkChangePassword() {
        String pass = null;
        try {
            pass = LoginHelper.checkChangePassword(this.getFrame());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
            this.logout();
        }
        if (pass == null) {
            pass = "null";
        }
        return pass;
    }

    public void showMyWorkPlan() {
        UIContext uiContext = new UIContext((Object)this.getFrame());
        if (SPManager.isSPInstalled((String)"BOSManagerPlatProviderImpl")) {
            SPInfo spInfo = SPManager.getInstance().getSeviceProvider("BOSManagerPlatProviderImpl");
            try {
                Object object = spInfo.getProviderClass().newInstance();
                IBOSManagerPlatProvider impl = (IBOSManagerPlatProvider)object;
                impl.showMyWorkPlan(uiContext);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
            }
        }
    }

    public void portalDataAsys() {
        boolean bFlag = true;
        try {
            IPortalFacade iPortalFacade = PortalFacadeFactory.getRemoteInstance();
            iPortalFacade.synchPortalData();
        }
        catch (Exception e) {
            bFlag = false;
            ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
        }
        if (bFlag) {
            MsgBox.showInfo((Component)this.getFrame(), (String)EASResource.getString((String)"com.kingdee.eas.portal.portalPublic", (String)"synchSuccess"));
        }
    }

    public void showPersonMsgUI() {
        try {
            UIContext uiContext = new UIContext((Object)this.getFrame());
            uiContext.put((Object)"stemFromPorlet", (Object)"");
            uiContext.put((Object)"applet", (Object)SystemEntry.instance.getApplet());
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.base.message.client.MsgPersonF7UI", (Map)uiContext);
            uiWindow.show();
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)this.getFrame(), (String)"UIException", (Throwable)e);
        }
    }

    public void openPortletGraphicsMrg() {
        try {
            UIContext uiContext = new UIContext((Object)this.getFrame());
            uiContext.put((Object)"checkLicense", (Object)"true");
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.cp.mc.client.GraphicsPortletListUI", (Map)uiContext);
            uiWindow.show();
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)this.getFrame(), (String)"UIException", (Throwable)e);
        }
    }

    public void openUserSyncPageManager() {
        try {
            UIContext uiContext = new UIContext((Object)this.getFrame());
            uiContext.put((Object)"stemFromPorlet", (Object)"");
            uiContext.put((Object)"applet", (Object)SystemEntry.instance.getApplet());
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.cp.eip.sso.client.UserControlSyncListUI", (Map)uiContext);
            uiWindow.show();
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)this.getFrame(), (String)"UIException", (Throwable)e);
        }
    }

    public void handleLinkedReport(String reportID) {
        if (reportID == null || reportID.equals("")) {
            return;
        }
        if (SPManager.isSPInstalled((String)"BOSReportHandleImpl")) {
            SPInfo spInfo = SPManager.getInstance().getSeviceProvider("BOSReportHandleImpl");
            try {
                Object object = spInfo.getProviderClass().newInstance();
                IBOSReportHandle impl = (IBOSReportHandle)object;
                UIContext uiContext = new UIContext((Object)this.getFrame());
                impl.viewReport(uiContext, reportID, SysContext.getSysContext().getLocale(), this.getFrame());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
            }
        }
    }

    private void clearWhenLogout() {
        MainFrameCallBack.addPropertyChangeListener("ReLogin", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ServiceProvider.this.processFindDialog = null;
                ServiceProvider.this.orgEfficencyStatConditionDialog = null;
                ServiceProvider.this.personStatConditionDialog = null;
                ServiceProvider.this.allProStatConditionDialog = null;
                ServiceProvider.this.proEfficencyStatConditionDialog = null;
                ServiceProvider.this.procConditionSearchDialog = null;
            }
        });
    }

    public void editBill(String billID) {
        this.commonEditBill(billID, null, null);
    }

    public void commonEditBill(String billID, String extPropName, String extPropValue) {
        this.commonEditBill(billID, extPropName, extPropValue, null);
    }

    public void dealSketchEditBill(String billId, String procDefId) {
        TempBizProcRelationListenter listener = new TempBizProcRelationListenter(procDefId);
        this.commonEditBill(billId, "TBPR_ProcDefID", procDefId, (IUILifeCycleListener)listener);
    }

    private void commonEditBill(String billId, String extPropName, String extPropValue, IUILifeCycleListener listener) {
        this.commonViewOrEditBill(billId, extPropName, extPropValue, listener, OprtState.EDIT);
    }

    private String getRealBillID(String billId) {
        if (!StringUtils.isEmpty((String)billId)) {
            billId = billId.replaceAll("888", "/");
            billId = billId.replaceAll("999", "\\+");
        }
        return billId;
    }

    private void commonViewOrEditBill(String billId, String extPropName, String extPropValue, IUILifeCycleListener listener, String opr) {
        block11: {
            try {
                logger.debug((Object)("Bill ID : " + billId));
                billId = this.getRealBillID(billId);
                logger.info((Object)("RealBillID=" + billId));
                BOSUuid uuid = BOSUuid.read((String)billId);
                String billType = uuid.getType().toString();
                EntityObjectInfo entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(new BOSObjectType(billType));
                String editUIName = entity.getExtendedProperty("editUI");
                logger.debug((Object)("Edit UI Name : " + editUIName));
                if (StringUtils.isEmpty((String)editUIName)) {
                    throw new RuntimeException("Entity [" + entity.getName() + "] is not set extended property editUI!");
                }
                UIContext uiContext = new UIContext((Object)this.getFrame());
                uiContext.put((Object)"checkLicense", (Object)"true");
                uiContext.put((Object)"ID", (Object)billId);
                uiContext.put((Object)"canResize", (Object)"true");
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(editUIName, (Map)uiContext, null, opr);
                CoreUI coreUI = (CoreUI)uiWindow.getUIObject();
                if (listener != null) {
                    coreUI.getUILifeCycleHandler().addRuleListener(listener);
                }
                if (extPropName != null && extPropName.length() > 0 && extPropValue != null && extPropValue.length() > 0) {
                    if (listener == null) {
                        listener = new CommonUILifeCycleListener(extPropName, extPropValue);
                        coreUI.getUILifeCycleHandler().addRuleListener(listener);
                    }
                    if (coreUI.getDataObject() != null) {
                        coreUI.getDataObject().setExtendedProperty(extPropName, extPropValue);
                    }
                    if (coreUI instanceof CoreBillEditUI && ((CoreBillEditUI)coreUI).getEditData() != null) {
                        ((CoreBillEditUI)coreUI).getEditData().setExtendedProperty(extPropName, extPropValue);
                    }
                }
                uiWindow.show();
                if (!OprtState.EDIT.equals(opr)) break block11;
                try {
                    if (uiWindow instanceof Window) {
                        Window win = (Window)uiWindow;
                        win.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosed(WindowEvent e) {
                                try {
                                    Method sendRefreshIServiceMsg = MessageHandler.class.getMethod("sendRefreshIServiceMsg", new Class[0]);
                                    sendRefreshIServiceMsg.invoke(null, new Object[0]);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        });
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (UIException e) {
                ExceptionHandler.handle((Component)this.getFrame(), (Throwable)e);
            }
        }
    }

    class DaemonDefaultFrameThread
    extends Thread {
        private HashMap<JFrame, Long> map = new HashMap();
        private HashMap<JFrame, Long> jFrameMapAlwaysOnTopTime = new HashMap();
        private long timeout = 300000L;
        private long idlesseTime = -1L;

        DaemonDefaultFrameThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ArrayList arrayList = ServiceProvider.this.defaultFameList;
                        synchronized (arrayList) {
                            if (ServiceProvider.this.defaultFameList != null && ServiceProvider.this.defaultFameList.size() > 0) {
                                for (int i = ServiceProvider.this.defaultFameList.size() - 1; i >= 0; --i) {
                                    JFrame fm = (JFrame)ServiceProvider.this.defaultFameList.get(i);
                                    if (fm == null) continue;
                                    Window[] ownedWin = fm.getOwnedWindows();
                                    if (ownedWin != null && ownedWin.length > 0) {
                                        Window window = ownedWin[0];
                                        if (Dialog.class.isInstance(window)) {
                                            fm.setTitle(((Dialog)window).getTitle());
                                        } else if (Frame.class.isInstance(window)) {
                                            fm.setTitle(((Frame)window).getTitle());
                                        }
                                        boolean visible = window.isVisible();
                                        if (!visible) {
                                            for (int j = 1; j < ownedWin.length; ++j) {
                                                if (ownedWin[j] == null || !ownedWin[j].isVisible()) continue;
                                                visible = true;
                                                break;
                                            }
                                        }
                                        if (fm.isVisible() != visible) {
                                            fm.setVisible(visible);
                                        }
                                        if (visible) {
                                            Long time = this.jFrameMapAlwaysOnTopTime.get(fm);
                                            if (time != null) {
                                                if (System.currentTimeMillis() - time <= 10000L) continue;
                                                for (Window win : ownedWin) {
                                                    win.setAlwaysOnTop(false);
                                                }
                                                fm.setAlwaysOnTop(false);
                                                continue;
                                            }
                                            this.jFrameMapAlwaysOnTopTime.put(fm, System.currentTimeMillis());
                                            continue;
                                        }
                                        Long startTime = this.map.get(fm);
                                        if (startTime != null) {
                                            if (System.currentTimeMillis() - startTime <= this.timeout) continue;
                                            ServiceProvider.this.defaultFameList.remove(fm);
                                            fm = null;
                                            this.idlesseTime = 0L;
                                            continue;
                                        }
                                        this.map.put(fm, System.currentTimeMillis());
                                        continue;
                                    }
                                    fm.setVisible(false);
                                    Long startTime = this.map.get(fm);
                                    if (startTime != null) {
                                        if (System.currentTimeMillis() - startTime <= this.timeout) continue;
                                        ServiceProvider.this.defaultFameList.remove(fm);
                                        fm = null;
                                        this.idlesseTime = 0L;
                                        continue;
                                    }
                                    this.map.put(fm, System.currentTimeMillis());
                                }
                            }
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

