/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.client.MainMenuConstants;
import com.kingdee.eas.base.uiframe.client.MainMenuList;
import com.kingdee.eas.base.uiframe.client.MainMenuListCellRenderer2;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UIShowHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLayeredPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import org.apache.log4j.Logger;

public abstract class SubMenuPanel
extends KDPanel {
    private static final Logger logger = Logger.getLogger(SubMenuPanel.class);
    private KDLabel upArrowLabel;
    private KDScrollPane centerScrollPanel;
    private KDLabel downArrowLabel;
    private MainMenuList subMenuList = null;
    private JLayeredPane layeredPane = null;
    private static final Icon upIcon = EASResource.getIcon((String)"image_subpane_upArrow");
    private static final Icon downIcon = EASResource.getIcon((String)"image_subpane_downArrow");
    private static final int SCROLL_PER_TIME = 26;
    private static final int HOLD_ON_DELAY = 400;
    private KDLabel activeArrow = null;
    private Timer runTimer = null;

    public SubMenuPanel() {
        this.initLayerdPane();
        this.initSubMenuList();
        this.setBorder(new LineBorder(Color.LIGHT_GRAY));
        this.upArrowLabel = this.createArrowLabel(upIcon);
        if (this.layeredPane != null) {
            this.layeredPane.add((Component)this.upArrowLabel, new Integer(2));
            this.downArrowLabel = this.createArrowLabel(downIcon);
            this.layeredPane.add((Component)this.downArrowLabel, new Integer(2));
            this.setLayout(new BorderLayout());
            this.add(this.layeredPane, "Center");
        }
    }

    private void initSubMenuList() {
        this.subMenuList = new MainMenuList(){

            @Override
            protected void listSelectionChanged(ListSelectionEvent e) throws BOSException {
                SubMenuPanel.this.level2MenuSelectionChanged(e);
            }
        };
        this.subMenuList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    int index = SubMenuPanel.this.subMenuList.locationToIndex(e.getPoint());
                    MainMenuItemInfo info = (MainMenuItemInfo)SubMenuPanel.this.subMenuList.getElement(index);
                    if (info.isIsLeaf() && !StringUtils.isEmpty((String)info.getUiClassName())) {
                        UIShowHelper.showUI((Component)((Object)SubMenuPanel.this), info);
                    }
                }
            }
        });
        this.subMenuList.setSelectionBackground(MainMenuConstants.getLevel2SelectedColor());
        this.subMenuList.setSelectionForeground(Color.WHITE);
        this.subMenuList.setOpaque(false);
        this.subMenuList.setCellRenderer((ListCellRenderer)((Object)new MainMenuListCellRenderer2()));
        this.subMenuList.setFixedCellHeight(27);
        this.centerScrollPanel = new KDScrollPane();
        this.centerScrollPanel.setBackground(MainMenuConstants.BACKGROUND_COLOR);
        this.centerScrollPanel.setCustomInsets(new Insets(5, 0, 5, 0));
        this.centerScrollPanel.getViewport().setBackground(MainMenuConstants.BACKGROUND_COLOR);
        this.centerScrollPanel.getViewport().setView((Component)((Object)this.subMenuList));
        this.centerScrollPanel.getHorizontalScrollBar().setPreferredSize(new Dimension(0, 0));
        this.centerScrollPanel.getVerticalScrollBar().setPreferredSize(new Dimension(0, 0));
        this.layeredPane.add((Component)this.centerScrollPanel, new Integer(1));
    }

    protected void displayArrow() {
        this.upArrowLabel.setVisible(true);
        this.downArrowLabel.setVisible(true);
    }

    protected void hideArrow() {
        this.upArrowLabel.setVisible(false);
        this.downArrowLabel.setVisible(false);
    }

    protected abstract void level2MenuSelectionChanged(ListSelectionEvent var1) throws BOSException;

    private void initLayerdPane() {
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setOpaque(true);
        this.layeredPane.setBackground(new Color(241, 243, 245));
        this.layeredPane.setBorder(BorderFactory.createEmptyBorder());
    }

    private KDLabel createArrowLabel(Icon icon) {
        KDLabel label = new KDLabel(icon);
        label.setOpaque(true);
        label.setBorder(BorderFactory.createEmptyBorder());
        label.setVisible(false);
        label.addMouseListener((MouseListener)new ArrowMouseAdapter());
        return label;
    }

    protected void replaceAllElements(List<MainMenuItemInfo> level2MenuColls) {
        if (level2MenuColls == null || level2MenuColls.size() == 0) {
            this.subMenuList.removeListSelectionListener();
            this.subMenuList.removeAllElements();
            return;
        }
        this.subMenuList.removeListSelectionListener();
        this.subMenuList.removeAllElements();
        for (int i = 0; i < level2MenuColls.size(); ++i) {
            this.subMenuList.addElement(level2MenuColls.get(i));
        }
        this.subMenuList.addListSelectionListener();
        this.subMenuList.setSelectedIndex(0);
    }

    private void permformScrolling(MouseEvent e) {
        if (this.runTimer == null) {
            this.runTimer = new Timer(400, new RunTimerHandler());
        }
        this.runTimer.setRepeats(true);
        this.runTimer.stop();
        this.runTimer.start();
    }

    private void stopScrolling(MouseEvent e) {
        if (this.runTimer != null) {
            this.runTimer.stop();
        }
    }

    private void runTimerOprt() {
        int delta = 1;
        int scrollPerTime = this.activeArrow == this.upArrowLabel ? -26 : 26;
        JViewport viewPort = this.centerScrollPanel.getViewport();
        Point oldViewPosition = viewPort.getViewPosition();
        Point newViewPosition = new Point(oldViewPosition.x, oldViewPosition.y + (delta += scrollPerTime));
        Dimension realRect = viewPort.getViewSize();
        if (delta > 0) {
            if (newViewPosition.y > realRect.height) {
                newViewPosition.y = realRect.height;
            }
        } else if (delta < 0 && newViewPosition.y < 0) {
            newViewPosition.y = 0;
        }
        this.centerScrollPanel.getViewport().setViewPosition(newViewPosition);
        this.centerScrollPanel.revalidate();
        this.centerScrollPanel.repaint();
    }

    public void paint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        this.updatePrefersize(w, h);
        super.paint(g);
    }

    private void updatePrefersize(int width, int height) {
        this.upArrowLabel.setBounds(width / 2 - upIcon.getIconWidth() / 2, 0, upIcon.getIconWidth(), upIcon.getIconHeight());
        this.downArrowLabel.setBounds(width / 2 - downIcon.getIconWidth() / 2, height - downIcon.getIconHeight(), downIcon.getIconWidth(), downIcon.getIconHeight());
        this.centerScrollPanel.setBounds(0, 0, width, height);
        SystemEntry.instance.getMainUIObject().getBodyUI().setCurTabIndex(0);
    }

    private class RunTimerHandler
    implements ActionListener {
        private RunTimerHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent a) {
            SubMenuPanel.this.runTimerOprt();
        }
    }

    private class ArrowMouseAdapter
    extends MouseAdapter {
        private ArrowMouseAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SubMenuPanel.this.activeArrow = (KDLabel)e.getSource();
            SubMenuPanel.this.permformScrolling(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SubMenuPanel.this.activeArrow = (KDLabel)e.getSource();
            SubMenuPanel.this.stopScrolling(e);
        }
    }
}

