/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.uiframe.client.AppletBodyUI;
import com.kingdee.eas.base.uiframe.client.IUIManager;
import com.kingdee.eas.base.uiframe.client.MainUIObjectManager;
import com.kingdee.eas.base.uiframe.client.UIFindCond;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UIAppletManager
implements IUIManager {
    static Logger logger = Logger.getLogger(UIAppletManager.class);
    ArrayList tabUiObjects = new ArrayList();
    ArrayList winUiObjects = new ArrayList();
    AppletBodyUI body;

    public UIAppletManager(AppletBodyUI body) {
        this.body = body;
    }

    private boolean closeUiObjects(ArrayList uiObjects) {
        for (int i = uiObjects.size() - 1; i >= 0; --i) {
            IUIObject uiObject = (IUIObject)uiObjects.get(i);
            if (uiObject.getUIWindow().close()) continue;
            return false;
        }
        return true;
    }

    private static int getIndexByUiObject(ArrayList uiList, IUIObject uiObject) {
        return UIAppletManager.getIndexInArrays(uiList, new UIFindCond(uiObject));
    }

    private static IUIObject getUIObjectInArrays(ArrayList uiList, UIFindCond cond) {
        int index = UIAppletManager.getIndexInArrays(uiList, cond);
        if (index != -1) {
            return (IUIObject)uiList.get(index);
        }
        return null;
    }

    private static int getIndexInArrays(ArrayList uiList, UIFindCond cond) {
        for (int i = 0; i < uiList.size(); ++i) {
            IUIObject uiObject = (IUIObject)uiList.get(i);
            if (!new UIFindCond(uiObject).checkCondition(cond)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addNewWin(IUIObject uiObject) {
        this.winUiObjects.add(uiObject);
    }

    @Override
    public void addTab(IUIObject uiObject) {
        this.tabUiObjects.add(uiObject);
        this.body.addTab(uiObject);
    }

    public void addTab(IUIObject uiObject, int index) {
        this.tabUiObjects.add(index, uiObject);
        this.body.addTab(uiObject, index);
    }

    @Override
    public void changeTab(int index) {
        this.body.setCurTabIndex(index);
    }

    @Override
    public void changeTab(IUIObject uiObject) {
        int index = this.getTabIndexByUiObject(uiObject);
        this.changeTab(index);
    }

    void changeNewWin(int index) {
        ((IUIObject)this.winUiObjects.get(index)).getUIWindow().show();
    }

    @Override
    public void removeNewWin(IUIObject uiObject) {
        this.winUiObjects.remove(uiObject);
    }

    @Override
    public void removeTab(IUIObject uiObject) {
        this.tabUiObjects.remove(uiObject);
        this.body.removeTab(uiObject);
    }

    @Override
    public boolean closeTab(IUIObject uiObject) {
        boolean result = true;
        int index = this.getTabIndexByUiObject(uiObject);
        if (uiObject.destroyWindow()) {
            if (uiObject.getUIMenuBar() != null) {
                uiObject.getUIMenuBar().removeAll();
            }
            if (uiObject.getUIToolBar() != null) {
                uiObject.getUIToolBar().removeAll();
            }
            this.removeTab(uiObject);
            if (this.tabUiObjects.size() > 0) {
                this.switchToNeighborUserTab(index);
            } else {
                this.body.resetUI();
            }
            result = true;
        }
        return result;
    }

    private void switchToNeighborUserTab(int index) {
        int neighborTabIdx = 0;
        neighborTabIdx = this.getNeighborUserTab(index);
        if (index == neighborTabIdx) {
            this.body.changeTab();
        } else {
            this.changeTab(neighborTabIdx);
        }
    }

    private int getNeighborUserTab(int index) {
        int nextTabIdx = -1;
        if (index >= this.tabUiObjects.size()) {
            index = this.tabUiObjects.size() - 1;
        }
        IUIObject tab = null;
        int i = index;
        if (i < this.tabUiObjects.size()) {
            tab = this.getTabByIndex(i);
            nextTabIdx = i;
        }
        if (nextTabIdx == -1 && (i = index) >= 0) {
            tab = this.getTabByIndex(i);
            nextTabIdx = i;
        }
        return nextTabIdx;
    }

    @Override
    public boolean closeAllTab() {
        return this.closeUiObjects(this.tabUiObjects);
    }

    @Override
    public boolean closeAllWin() {
        return this.closeUiObjects(this.winUiObjects);
    }

    @Override
    public IUIObject findUIObject(String uiClassName, Map uiContext, Map dataObjects, String oprt) {
        UIFindCond cond = new UIFindCond(uiClassName, uiContext, dataObjects, oprt);
        if ("ADDNEW".equals(oprt)) {
            cond.enableCond(false, false, true);
        }
        return this.findUIObject(cond);
    }

    @Override
    public IUIObject findUIObject(UIFindCond cond) {
        IUIObject uiObject = UIAppletManager.getUIObjectInArrays(this.tabUiObjects, cond);
        if (uiObject == null) {
            uiObject = UIAppletManager.getUIObjectInArrays(this.winUiObjects, cond);
        }
        return uiObject;
    }

    @Override
    public IUIObject[] findUIObject(String uiName) {
        ArrayList uiList = new ArrayList();
        UIFindCond cond = new UIFindCond();
        cond.uiClassName = uiName;
        cond.enableCond(false, false, false);
        this.getUIObjects(uiList, cond);
        return (IUIObject[])uiList.toArray();
    }

    private void getUIObjects(List uiList, UIFindCond cond) {
        IUIObject uiObject;
        int i;
        if (uiList == null) {
            uiList = new ArrayList<IUIObject>();
        }
        for (i = 0; i < this.tabUiObjects.size(); ++i) {
            uiObject = (IUIObject)uiList.get(i);
            if (!new UIFindCond(uiObject).checkCondition(cond)) continue;
            uiList.add(uiObject);
        }
        for (i = 0; i < this.winUiObjects.size(); ++i) {
            uiObject = (IUIObject)uiList.get(i);
            if (!new UIFindCond(uiObject).checkCondition(cond)) continue;
            uiList.add(uiObject);
        }
        if (MainUIObjectManager.getInstance().getUiDialog() != null) {
            uiList.add(MainUIObjectManager.getInstance().getUiDialog().getUIObject());
        }
    }

    IUIObject getNewWinByIndex(int index) {
        return (IUIObject)this.winUiObjects.get(index);
    }

    IUIObject getTabByIndex(int index) {
        return (IUIObject)this.tabUiObjects.get(index);
    }

    @Override
    public int getTabIndexByUiObject(IUIObject uiObject) {
        return UIAppletManager.getIndexByUiObject(this.tabUiObjects, uiObject);
    }

    int getWinIndexByUiObject(IUIObject uiObject) {
        return UIAppletManager.getIndexByUiObject(this.winUiObjects, uiObject);
    }

    @Override
    public List getTabUiObjects() {
        return this.tabUiObjects;
    }

    @Override
    public List getWinUiObjects() {
        return this.winUiObjects;
    }

    @Override
    public void replaceDefaultSysTab(IUIObject uiObject, int tabIdx) {
    }

    @Override
    public void replaceTab(IUIObject uiObject) {
    }
}

