/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.appframework.uistatemanage.ActionManager;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.cache.UIActionMonitor;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.ui.IMainUIContainer;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.Item;
import com.kingdee.eas.base.uiframe.client.MainFunctionMenuUI;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UICacheItem;
import com.kingdee.eas.base.uiframe.client.UIReleaseUtil;
import com.kingdee.eas.base.uiframe.client.ui.IMainUIObject;
import com.kingdee.eas.base.uiframe.client.ui.gpt.ChatgptFunction;
import com.kingdee.eas.base.uiframe.utils.PropertiesUtils;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ep.client.PlugInProxyFactory;
import com.kingdee.eas.ep.client.UIParam;
import com.kingdee.eas.ep.client.UIParamUtil;
import com.kingdee.eas.ep.client.util.CustomUI;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.customized.PlatformParam;
import com.kingdee.eas.util.AbortException;
import com.kingdee.util.LRUMap;
import com.kingdee.util.StringUtils;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.JApplet;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;

public class UIFactoryHelper {
    private static Logger logger = Logger.getLogger(UIFactoryHelper.class);
    private static Map<String, UICacheItem> cacheMap = null;
    private static Properties prop = null;
    private static UIFactoryHelperThread UIFactoryHelperThread = new UIFactoryHelperThread("UIFactoryHelperThread");

    public static UIFactoryHelperThread getUIFactoryHelperThread() {
        return UIFactoryHelperThread;
    }

    public static boolean isCacheUI(String uiName) {
        if (prop == null) {
            UIFactoryHelper.loadExtCacheUI();
        }
        return !prop.containsKey(uiName);
    }

    public static void addExtCacheUI(String uiName) {
        if (prop == null) {
            UIFactoryHelper.loadExtCacheUI();
        }
        prop.put(uiName, "");
    }

    public static void loadExtCacheUI() {
        String cachePath = System.getProperty("easclient.root");
        prop = PropertiesUtils.load(cachePath, "cacheUIList.properties");
        if (prop == null) {
            prop = new Properties();
        }
        prop.put("com.kingdee.eas.basedata.org.client.OUEditUI", "");
        prop.put("com.kingdee.eas.base.uiframe.client.NewMainFunctionMenuUI", "");
        prop.put("com.kingdee.eas.fm.common.client.FMIsqlUI", "");
        prop.put("com.kingdee.eas.base.botp.client.BOTPConfigUI", "");
        prop.put("com.kingdee.eas.csinterface.billmapping.client.FMIsqlUI", "");
        prop.put("com.kingdee.eas.csinterface.reportmapping.client.FMIsqlUI", "");
        prop.put("com.kingdee.eas.mobile.client.BizConfigUI", "");
        prop.put("com.kingdee.eas.mobile.client.MailServerConfigUI", "");
        prop.put("com.kingdee.eas.base.form.ide.MainUI", "");
    }

    public static boolean isFromCache(String name, Object oprt, Map uiContext, String key) {
        if (prop == null) {
            String cachePath = System.getProperty("easclient.root");
            prop = PropertiesUtils.load(cachePath, "cacheUIList.properties");
        }
        if (prop == null) {
            return false;
        }
        if (oprt == null) {
            oprt = "";
        }
        String ui = null;
        if (prop.containsKey(name + "#" + oprt)) {
            ui = prop.getProperty(name + "#" + oprt);
            String[] uis = ui.split("#");
            if (uis.length <= 1) {
                return true;
            }
            return uiContext != null && uiContext.containsKey(uis[1]);
        }
        return false;
    }

    private static String getTempClassName(String name) {
        String tempClass;
        IMetaDataLoader loader;
        UIObjectInfo uiModel;
        MetaDataPK pk = MetaDataPK.create((String)name);
        boolean isCustomized = MDContextFactory.getRemoteInstance().pkIndexs.isExistInDB(MetaDataTypeList.UIOBJECT, (IMetaDataPK)pk, null);
        if (isCustomized && (uiModel = (UIObjectInfo)(loader = MetaDataLoaderFactory.getRemoteMetaDataLoader()).get(MetaDataTypeList.UIOBJECT, (IMetaDataPK)pk)) != null && uiModel.isDynamic() && !StringUtils.isEmpty((String)(tempClass = uiModel.getExtendedProperty("template_ui_class")))) {
            return tempClass.trim();
        }
        return null;
    }

    public static String[] getMetaDataPkAndClassName(String name, Map uiContext) {
        int index = name.indexOf("$$");
        String metaPK = null;
        if (index > 0 && name.length() > index + 2) {
            metaPK = name.substring(0, index);
            name = name.substring(index + 2, name.length());
            uiContext.put("UIClassParam", "uipk=" + metaPK);
        } else {
            String tempClassName = UIFactoryHelper.getTempClassName(name);
            if (tempClassName != null) {
                metaPK = name;
                name = tempClassName;
                uiContext.put("UIClassParam", "uipk=" + metaPK);
            } else {
                Map params;
                if (uiContext.get("UIClassParam") != null && (params = CustomUI.getUIParam((String)((String)uiContext.get("UIClassParam")))) != null) {
                    metaPK = (String)params.get("uipk");
                }
                if (metaPK == null) {
                    metaPK = name;
                }
            }
        }
        return new String[]{metaPK, name};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IUIObject initUIObject(String name, Map uiContext, Map dataObjects, String oprt) throws UIException {
        String[] pkAndClassName = UIFactoryHelper.getMetaDataPkAndClassName(name, uiContext);
        String metaPK = pkAndClassName[0];
        name = pkAndClassName[1];
        UIActionMonitor.startAction((String)name, (String)"initUIObject()");
        long start = System.currentTimeMillis();
        IUIObject uiObject = null;
        uiContext.put("sysContext", SysContext.getSysContext());
        UIParam pluginParam = null;
        try {
            Frame frame = SystemEntry.instance.getOwnerFrame();
            frame.setCursor(Cursor.getPredefinedCursor(3));
            logger.debug((Object)("Begin initUIObject " + name + " : " + start + "!"));
            String key0 = UIFactoryHelper.createKey0(metaPK, name);
            uiContext.put("WINDOWOPENTIME", System.currentTimeMillis());
            if (ChatgptFunction.gptContext != null && ChatgptFunction.gptContext.get() != null) {
                uiContext.put("CHATGPT", ChatgptFunction.gptContext.get());
            }
            try {
                UICacheItem uiCacheItem = cacheMap.remove(key0);
                if (uiCacheItem == null) {
                    pluginParam = new UIParam();
                    pluginParam.setMetaPK(metaPK);
                    uiObject = PlugInProxyFactory.createUIObject((String)name, (UIParam)pluginParam);
                } else {
                    uiObject = uiCacheItem.getUiObject();
                    pluginParam = uiCacheItem.getPluginParam();
                }
                if (uiObject != null && !uiObject.getClass().getName().equals(name)) {
                    uiContext.put("originalMenuClassName", name);
                }
                long instanceCost = System.currentTimeMillis() - start;
                logger.info((Object)("UIObject " + name + " new instance : " + instanceCost + " ms."));
                IUIObject ui = uiObject.getInstance(uiContext);
                if (ui != null && !(uiObject = ui).getClass().getName().equals(name)) {
                    uiContext.put("originalMenuClassName", name);
                }
                if (dataObjects != null && dataObjects.size() > 0) {
                    for (String key : dataObjects.keySet()) {
                        uiObject.setDataObject(key, (IObjectValue)((AbstractObjectValue)dataObjects.get(key)));
                    }
                }
                if (uiContext != null && uiContext.size() > 0) {
                    for (String key : uiContext.keySet()) {
                        uiObject.getUIContext().put(key, uiContext.get(key));
                    }
                }
                if (oprt != null && !oprt.equals("")) {
                    uiObject.setOprtState(oprt);
                }
                if (uiObject instanceof CoreUIObject) {
                    CoreUIObject coreUIObj = (CoreUIObject)uiObject;
                    coreUIObj.initLayout();
                    UIParamUtil.createUIParam((Container)coreUIObj, (UIParam)pluginParam, (boolean)true);
                    ActionManager am = ((CoreUIObject)uiObject).getActionManager();
                    am.setUIParam((Object)pluginParam);
                    if (uiObject instanceof MainFunctionMenuUI) {
                        MainFunctionMenuUI.setCurrentMainFunctionMenuUI((MainFunctionMenuUI)uiObject);
                        if (UIFrameUtils.isLogged()) {
                            logger.info((Object)UIFrameUtils.getLogText("MainFunctionMenuUI.setCurrentMainFunctionMenuUI() is ok!"));
                        }
                    }
                }
            }
            catch (Exception exc) {
                if (exc instanceof AbortException) {
                    throw (AbortException)((Object)exc);
                }
                throw new UIException(UIFrameResource.getString("UIFactoryHelper_createUIError"), (Throwable)exc);
            }
            try {
                CoreUIObject core;
                if (uiObject instanceof CoreUIObject && UtilRequest.isPrepare((String)"Init", (CoreUIObject)(core = (CoreUIObject)uiObject))) {
                    long t1 = System.currentTimeMillis();
                    IUIActionPostman actionPost = core.prepareInit();
                    if (actionPost != null) {
                        actionPost.callHandler();
                    } else {
                        logger.error((Object)("actionPost is null,uiObject's name=" + uiObject.getClass()));
                    }
                    logger.info((Object)("UIObject " + name + " handInit handler spent: " + (System.currentTimeMillis() - t1) + " ms."));
                }
                long onLoadStart = System.currentTimeMillis();
                uiObject.onLoad();
                long onLoadCost = System.currentTimeMillis() - onLoadStart;
                UIFactoryHelperThread.add(new Item(key0, metaPK, name));
                logger.info((Object)("UIObject " + name + " onLoad spent: " + onLoadCost + " ms."));
            }
            catch (Throwable exc) {
                try {
                    boolean b = uiObject.destroyWindow();
                    if (b) {
                        UIReleaseUtil.freeSwingObject(uiObject);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)("destory window error:" + ex));
                }
                throw new UIException(UIFrameResource.getString("UIFactoryHelper_onLoadError"), exc);
            }
            if (uiObject.isBindWorkFlow()) {
                uiObject.checkWfAssignment();
            }
            long end = System.currentTimeMillis();
            logger.debug((Object)("End initUIObject " + name + " : " + end + "!"));
            long cost = end - start;
            logger.info((Object)("InitUIObject " + name + " : " + cost + " ms!"));
            SystemEntry.instance.getOwnerFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
        finally {
            try {
                UIActionMonitor.endAction((String)name, (String)"initUIObject()", (long)(System.currentTimeMillis() - start));
                SystemEntry.instance.getOwnerFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
            catch (Throwable e) {
                logger.error((Object)"UIActionMonitor.endAction:", e);
            }
        }
        return uiObject;
    }

    public static String createKey0(String metaPK, String name) {
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        OrgUnitInfo ou = SysContext.getSysContext().getCurrentOrgUnit();
        String key_userid = user == null ? "" : user.getId().toString();
        String key_cu = user == null ? "" : cu.getId().toString();
        String key_ou = user == null ? "" : ou.getId().toString();
        String key_isExtended = null;
        try {
            key_isExtended = !PlatformParam.useCustomizedPlatform() || !PlugInProxyFactory.isExtended((String)metaPK) ? "0" : "1";
        }
        catch (UIException e) {
            logger.error((Object)e);
        }
        String key0 = name + metaPK + key_userid + key_cu + key_ou + key_isExtended;
        return key0;
    }

    public static void buildUIContext(Map uiContext) {
        Object owner = uiContext.get("Owner");
        NewMainFrame mainFrame = null;
        if (owner instanceof IMainUIContainer) {
            if (owner instanceof NewMainFrame) {
                mainFrame = (NewMainFrame)((Object)owner);
                uiContext.put("OwnerWindow", mainFrame);
            } else {
                uiContext.put("OwnerWindow", SystemEntry.instance.getOwnerFrame());
            }
        } else if (owner instanceof IUIObject) {
            IUIObject ownerUiObject = (IUIObject)owner;
            Map ownerContext = ownerUiObject.getUIContext();
            Object ownersOwner = ownerContext.get("OwnerWindow");
            if (ownersOwner != null && ownersOwner instanceof NewMainFrame) {
                mainFrame = (NewMainFrame)((Object)ownersOwner);
                uiContext.put("OwnerWindow", mainFrame);
            } else if (ownersOwner != null && ownersOwner instanceof Frame) {
                uiContext.put("OwnerWindow", mainFrame);
            } else {
                uiContext.put("OwnerWindow", SystemEntry.instance.getOwnerFrame());
            }
        } else {
            uiContext.put("Owner", SystemEntry.instance.getOwnerFrame());
            uiContext.put("OwnerWindow", SystemEntry.instance.getOwnerFrame());
        }
        IMainUIObject mainObject = null;
        mainObject = (IMainUIObject)uiContext.get("IMainUIObject");
        if (mainObject == null) {
            mainObject = owner instanceof NewMainFrame ? ((NewMainFrame)((Object)owner)).getMainUI() : SystemEntry.instance.getMainUIObject();
            uiContext.put("IMainUIObject", mainObject);
        }
    }

    public static IMainUIObject getMainUIObject(Map uiContext) throws UIException {
        IMainUIObject mainObject = null;
        if (uiContext == null) {
            return SystemEntry.instance.getMainUIObject();
        }
        mainObject = (IMainUIObject)uiContext.get("IMainUIObject");
        Object owner = uiContext.get("Owner");
        if (mainObject == null) {
            mainObject = SystemEntry.instance.getMainUIObject();
            uiContext.put("IMainUIObject", mainObject);
        }
        if (owner instanceof IMainUIContainer) {
            uiContext.put("OwnerWindow", owner);
        } else if (owner instanceof IUIObject) {
            IUIObject ownerUiObject = (IUIObject)owner;
            Map ownerContext = ownerUiObject.getUIContext();
            Object ownersOwner = ownerContext.get("OwnerWindow");
            if (ownersOwner != null && ownersOwner instanceof IMainUIContainer) {
                uiContext.put("OwnerWindow", ownersOwner);
            } else if (ownersOwner == null) {
                if (mainObject == null) {
                    mainObject = SystemEntry.instance.startApplication(null);
                }
                uiContext.put("OwnerWindow", mainObject.getUIContainer());
                uiContext.put("IMainUIObject", mainObject);
            }
        } else if (mainObject != null) {
            uiContext.put("OwnerWindow", mainObject.getUIContainer());
        } else if (mainObject == null) {
            mainObject = SystemEntry.instance.startApplication(null);
            uiContext.put("OwnerWindow", mainObject.getUIContainer());
            uiContext.put("IMainUIObject", mainObject);
        }
        return mainObject;
    }

    public static Frame getMainFrame(Map uiContext) throws UIException {
        Object mainFrame = null;
        Object owner = uiContext.get("Owner");
        if (owner == null) {
            throw new UIException(UIFrameResource.getString("UIFactoryHelper_ownerNotNull"));
        }
        mainFrame = SystemEntry.instance.getOwnerFrame();
        if (owner instanceof NewMainFrame) {
            mainFrame = (NewMainFrame)((Object)owner);
            uiContext.put("OwnerWindow", mainFrame);
        } else if (owner instanceof JApplet) {
            mainFrame = SystemEntry.instance.getOwnerFrame();
            uiContext.put("OwnerWindow", mainFrame);
        } else if (owner instanceof IUIObject) {
            IUIObject ownerUiObject = (IUIObject)owner;
            Map ownerContext = ownerUiObject.getUIContext();
            Object ownersOwner = ownerContext.get("OwnerWindow");
            if (ownersOwner != null && ownersOwner instanceof NewMainFrame) {
                mainFrame = (NewMainFrame)((Object)ownersOwner);
                uiContext.put("OwnerWindow", mainFrame);
            } else if (ownersOwner != null && ownersOwner instanceof Frame) {
                uiContext.put("OwnerWindow", mainFrame);
            }
        } else {
            uiContext.put("OwnerWindow", SystemEntry.instance.getOwnerFrame());
        }
        return mainFrame;
    }

    public static boolean isAddSeparatorBtn(JToolBar toolBar) {
        if (toolBar == null) {
            return false;
        }
        int count = toolBar.getComponentCount();
        if (count == 0) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < count; ++i) {
            if (!toolBar.getComponent(i).isVisible() || !(toolBar.getComponent(i) instanceof KDWorkButton)) continue;
            ++result;
        }
        return result > 0 && !(toolBar.getComponent(count - 1) instanceof KDSeparator);
    }

    public static int getVisibleComponentCount(JToolBar toolBar) {
        if (toolBar == null) {
            return 0;
        }
        int count = toolBar.getComponentCount();
        int result = 0;
        for (int i = 0; i < count; ++i) {
            if (!toolBar.getComponent(i).isVisible() || !(toolBar.getComponent(i) instanceof KDWorkButton)) continue;
            ++result;
        }
        return result;
    }

    public static int getVisibleComponentCount(JMenuBar menuBar) {
        if (menuBar == null) {
            return 0;
        }
        int count = menuBar.getMenuCount();
        int result = 0;
        for (int i = 0; i < count; ++i) {
            if (menuBar.getMenu(i) == null || !menuBar.getMenu(i).isVisible()) continue;
            ++result;
        }
        return result;
    }

    static {
        LRUMap map = new LRUMap();
        map.setMaxSize(10);
        cacheMap = Collections.synchronizedMap(map);
        UIFactoryHelperThread.setDaemon(true);
        UIFactoryHelperThread.start();
    }

    static class UIFactoryHelperThread
    extends Thread {
        private BlockingQueue<Item> queue = new LinkedBlockingQueue<Item>();

        public UIFactoryHelperThread(String name) {
            super(name);
        }

        public synchronized void add(Item item) {
            if (UIFactoryHelper.isCacheUI(item.getMetaPK())) {
                try {
                    this.queue.put(item);
                }
                catch (InterruptedException e) {
                    logger.error((Object)e);
                }
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Item item = this.queue.take();
                        UIParam pluginParam = new UIParam();
                        pluginParam.setMetaPK(item.getMetaPK());
                        IUIObject uiObject = PlugInProxyFactory.createUIObject((String)item.getUiName(), (UIParam)pluginParam);
                        cacheMap.put(item.getKey0(), new UICacheItem(pluginParam, uiObject));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"fail to PlugInProxyFactory.createUIObject and uiName", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

