/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.eas.base.myeas.DefaultOpenMenuCollection;
import com.kingdee.eas.base.myeas.IMyEasInvokeEntry;
import com.kingdee.eas.base.myeas.MyEasInvokeEntryFactory;
import com.kingdee.eas.base.myeas.OpenModelInfo;
import com.kingdee.eas.base.myeas.ToolBarStyleEnum;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.common.client.SysContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class UIFrameContext
implements Serializable {
    protected static final Logger logger = Logger.getLogger(UIFrameContext.class);
    private static UIFrameContext instance;
    private Map extProperties = new HashMap();
    public static final String MYEAS_OPENMODEL = "OpenModel";
    public static final String MYEAS_DEFAULTOPENMENU = "DefOpenMenu";
    public static final String MYEAS_MSGREFRESH = "MsgRefreshInfo";
    public static final String MYEAS_LASTUSEDFUNCTION = "LastUsedFunction";
    public static final String MYEAS_UISTYLE = "UIStyle";
    public static final String MYEAS_TOOLBARSTYLE = "ToolbarStyle";
    public static final String MYEAS_PRESENTIMENT = "presentiment";
    public static final String MYEAS_MSGAWOKE = "msgawoke";
    private static final String ELEGANCE_BLUE = "01b278d3-00fd-1000-e000-0005c0a813b2A8506915";
    private static final String CRYSTAL_BLUE = "01b278d3-00fd-1000-e000-0004c0a813b2A8506915";
    private static final String DIAMON_BLUE_THEME = "01b278d3-00fd-1000-e000-0006c0a813b2A8506915";
    private static final String RED_THEME = "01b278d3-00fd-1000-e000-0003c0a813b2A8506915";

    private UIFrameContext() {
    }

    public static synchronized UIFrameContext getInstance() {
        if (instance == null) {
            instance = new UIFrameContext();
            instance.setProperty(MYEAS_MSGREFRESH, Integer.valueOf("5"));
            instance.setProperty(MYEAS_PRESENTIMENT, "0");
            instance.setProperty(MYEAS_MSGAWOKE, new Boolean(false));
        }
        return instance;
    }

    public Object getProperty(Object key) {
        return this.extProperties.get(key);
    }

    public void setProperty(Object key, Object value) {
        this.extProperties.put(key, value);
    }

    public void removeProperty(Object key) {
        this.extProperties.remove(key);
    }

    public void clearAll() {
        this.extProperties.clear();
    }

    public static UIFrameContext getCacheData() {
        return UIFrameContext.getCacheData(SysContext.getSysContext().getUserName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UIFrameContext getCacheData(String pathName) {
        String fileName = UIFrameContext.getCacheFileName(pathName);
        Object fInfo = null;
        FileInputStream fi = null;
        ObjectInputStream si = null;
        try {
            fi = new FileInputStream(fileName);
            si = new ObjectInputStream(fi);
            instance = (UIFrameContext)si.readObject();
        }
        catch (FileNotFoundException fe) {
            logger.info((Object)"menu cache file not found:", (Throwable)fe);
            UIFrameContext uIFrameContext = null;
            return uIFrameContext;
        }
        catch (Exception e) {
            logger.info((Object)"get menu cache file error:", (Throwable)e);
            UIFrameContext uIFrameContext = null;
            return uIFrameContext;
        }
        finally {
            try {
                if (si != null) {
                    si.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (Exception exception) {}
        }
        return instance;
    }

    public static void witeCacheData() {
        UIFrameContext.witeCacheData(SysContext.getSysContext().getUserName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void witeCacheData(String pathName) {
        String fileName = UIFrameContext.getCacheFileName(pathName);
        FileOutputStream fo = null;
        ObjectOutputStream so = null;
        File cacheFile = null;
        String cacheDir = fileName.substring(0, fileName.lastIndexOf("/"));
        try {
            cacheFile = new File(cacheDir);
            if (!cacheFile.exists()) {
                cacheFile.mkdirs();
            }
            fo = new FileOutputStream(fileName);
            so = new ObjectOutputStream(fo);
            so.writeObject(instance);
        }
        catch (FileNotFoundException fe) {
            logger.info((Object)"write menu cache file not found:", (Throwable)fe);
        }
        catch (Exception e) {
            logger.info((Object)"write menu cache file error:", (Throwable)e);
        }
        finally {
            try {
                if (so != null) {
                    so.close();
                }
            }
            catch (Exception fe) {}
            try {
                if (fo != null) {
                    fo.close();
                }
            }
            catch (Exception fe) {}
        }
    }

    private static String getCacheFileName() {
        return UIFrameContext.getCacheFileName(SysContext.getSysContext().getUserName());
    }

    private static String getCacheFileName(String pathName) {
        StringBuffer cacheFb = new StringBuffer();
        String dcNumber = SysContext.getSysContext().getDCNumber();
        String appserver = UIConfig.getUrl();
        if (appserver.startsWith("tcp")) {
            appserver = appserver.substring(6, appserver.length());
        } else if (appserver.startsWith("http")) {
            appserver = appserver.substring(7, appserver.length());
        }
        int index = appserver.lastIndexOf(":");
        if (index > 0) {
            appserver = appserver.substring(0, index);
        }
        String easclientRoot = System.getProperty("java.io.tmpdir");
        cacheFb.append(easclientRoot);
        cacheFb.append("/cache/");
        cacheFb.append(appserver);
        cacheFb.append("/");
        cacheFb.append(dcNumber);
        cacheFb.append("/");
        cacheFb.append(pathName);
        cacheFb.append("/personalSetCache.dat");
        return cacheFb.toString();
    }

    public static void getPersonalSetDataFromServer() throws Exception {
        UIFrameContext.getPersonalSetDataFromServer(SysContext.getSysContext().getUserName());
    }

    public static void getPersonalSetDataFromServer(String pathName) throws Exception {
        if (UIConfig.isLocalStorePersonalizedSetting()) {
            String userID = null;
            IMyEasInvokeEntry iMyeasInvoke = null;
            OpenModelInfo openModelInfo = null;
            DefaultOpenMenuCollection defaultOpenColl = null;
            String uiStyleID = "";
            ToolBarStyleEnum userStyle = ToolBarStyleEnum.IconText;
            int refreshTime = UIConfig.getMsgRefresh();
            int colorStyle = 5;
            userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            iMyeasInvoke = MyEasInvokeEntryFactory.getRemoteInstance();
            HashMap map = iMyeasInvoke.getMyEasSetting(userID);
            if (map.get("openModel") != null) {
                openModelInfo = (OpenModelInfo)map.get("openModel");
            }
            if (map.get("defaultOpenMenu") != null) {
                defaultOpenColl = (DefaultOpenMenuCollection)map.get("defaultOpenMenu");
            }
            if (map.get("uiStyle") != null) {
                uiStyleID = (String)map.get("uiStyle");
            }
            if (map.get("usedToolStyle") != null) {
                userStyle = (ToolBarStyleEnum)map.get("usedToolStyle");
            }
            colorStyle = uiStyleID.equals(ELEGANCE_BLUE) ? 2 : (uiStyleID.equals(CRYSTAL_BLUE) ? 0 : (uiStyleID.equals(DIAMON_BLUE_THEME) ? 5 : (uiStyleID.equals(RED_THEME) ? 4 : 5)));
            UIFrameContext.getInstance().setProperty(MYEAS_OPENMODEL, openModelInfo);
            UIFrameContext.getInstance().setProperty(MYEAS_DEFAULTOPENMENU, defaultOpenColl);
            UIFrameContext.getInstance().setProperty(MYEAS_MSGREFRESH, new Integer(refreshTime));
            UIFrameContext.getInstance().setProperty(MYEAS_UISTYLE, new Integer(colorStyle));
            UIFrameContext.getInstance().setProperty(MYEAS_TOOLBARSTYLE, userStyle);
            UIFrameContext.witeCacheData(pathName);
        }
    }

    public static int getColorStyleByUiStyleID(String uiStyleID) {
        int colorStyle = 5;
        colorStyle = uiStyleID.equals(ELEGANCE_BLUE) ? 2 : (uiStyleID.equals(CRYSTAL_BLUE) ? 0 : (uiStyleID.equals(DIAMON_BLUE_THEME) ? 5 : (uiStyleID.equals(RED_THEME) ? 4 : 5)));
        return colorStyle;
    }
}

