/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.uiframe.client.BodyUI;
import com.kingdee.eas.base.uiframe.client.IUIManager;
import com.kingdee.eas.base.uiframe.client.MainUIObjectManager;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.base.uiframe.client.UIFindCond;
import com.kingdee.eas.base.uiframe.client.UIReleaseUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UIObjectManager
implements IUIManager {
    static Logger logger = Logger.getLogger(UIObjectManager.class);
    ArrayList tabUiObjects = new ArrayList();
    ArrayList winUiObjects = new ArrayList();
    BodyUI body;
    private IUIObject preObject = null;

    public UIObjectManager() {
    }

    public UIObjectManager(BodyUI body) {
        this.body = body;
    }

    private static boolean closeUiObjects(ArrayList uiObjects) {
        for (int i = uiObjects.size() - 1; i >= 0; --i) {
            IUIObject uiObject = (IUIObject)uiObjects.get(i);
            if (uiObject.getUIWindow().close()) continue;
            return false;
        }
        return true;
    }

    private static int getIndexByUiObject(ArrayList uiList, IUIObject uiObject) {
        return UIObjectManager.getIndexInArrays(uiList, new UIFindCond(uiObject));
    }

    private static IUIObject getUIObjectInArrays(ArrayList uiList, UIFindCond cond) {
        int index = UIObjectManager.getIndexInArrays(uiList, cond);
        if (index != -1) {
            return (IUIObject)uiList.get(index);
        }
        return null;
    }

    private static int getIndexInArrays(ArrayList uiList, UIFindCond cond) {
        for (int i = 0; i < uiList.size(); ++i) {
            IUIObject uiObject = (IUIObject)uiList.get(i);
            if (!new UIFindCond(uiObject).checkCondition(cond)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addNewWin(IUIObject uiObject) {
        this.winUiObjects.add(uiObject);
    }

    @Override
    public void addTab(IUIObject uiObject) {
        if (BodyUI.SYS_TAB_CLASSNAME_LIST.length == 0 && this.tabUiObjects.size() == 0 && this.body.getMainUIObject() != null) {
            this.body.getMainUIObject().getUIContainer().setInit(true);
        }
        this.tabUiObjects.add(uiObject);
        this.body.addTab(uiObject);
    }

    public void addTab(IUIObject uiObject, int index) {
        this.tabUiObjects.add(index, uiObject);
        this.body.addTab(uiObject, index);
    }

    @Override
    public void changeTab(int index) {
        this.body.setCurTabIndex(index);
    }

    @Override
    public void changeTab(IUIObject uiObject) {
        int index = this.getTabIndexByUiObject(uiObject);
        this.changeTab(index);
    }

    void changeNewWin(int index) {
        ((IUIObject)this.winUiObjects.get(index)).getUIWindow().show();
    }

    @Override
    public void removeNewWin(IUIObject uiObject) {
        this.winUiObjects.remove(uiObject);
    }

    @Override
    public void removeTab(IUIObject uiObject) {
        this.tabUiObjects.remove(uiObject);
        this.body.removeTab(uiObject);
    }

    @Override
    public void replaceDefaultSysTab(IUIObject uiObject, int tabIdx) {
        if (tabIdx >= this.tabUiObjects.size() || tabIdx < 0) {
            return;
        }
        try {
            this.tabUiObjects.set(tabIdx, uiObject);
            if (tabIdx == BodyUI.DEFAULT_TAB_INDEX) {
                if (this.body.getMainUIObject() != null) {
                    this.body.getMainUIObject().getUIContainer().setInit(true);
                }
                this.body.curUIObject = uiObject;
            }
            this.body.uiObjects.set(tabIdx, uiObject);
            this.body.tabbedPane.setComponentAt(tabIdx, (Component)uiObject.getUIContentPane());
            this.body.tabbedPane.setTitleAt(tabIdx, uiObject.getUITitle());
            if (this.body.tabbedPane.getSelectedIndex() <= this.body.getSysTabCount() - 1 && tabIdx == BodyUI.DEFAULT_TAB_INDEX) {
                this.body.setCurTabIndex(tabIdx);
                this.body.getMainUIObject().changeMenuToolBar(tabIdx);
            }
        }
        catch (Exception e0) {
            logger.info((Object)"", (Throwable)e0);
        }
    }

    @Override
    public void replaceTab(IUIObject uiObject) {
        if (this.tabUiObjects.size() == this.body.getSysTabCount()) {
            this.addTab(uiObject);
        } else {
            int idx = this.body.getLastSysTabIndex(this.tabUiObjects);
            idx = Math.max(this.tabUiObjects.size() - 1, idx);
            IUIObject lastTabUiObject = (IUIObject)this.tabUiObjects.get(idx);
            if (!this.isSysTab(lastTabUiObject) && lastTabUiObject.getUIWindow().close()) {
                this.addTab(uiObject, idx);
            } else {
                this.addTab(uiObject, idx + 1);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean closeTab(IUIObject uiObject) {
        boolean result = true;
        int index = this.getTabIndexByUiObject(uiObject);
        if (this.isSysTab(uiObject)) return true;
        if (!uiObject.destroyWindow()) return false;
        boolean isCache = UIFactoryHelper.isFromCache(uiObject.getClass().getName(), uiObject.getUIContext().get("cacheState"), uiObject.getUIContext(), null);
        if (uiObject.getUIMenuBar() != null && !isCache) {
            uiObject.getUIMenuBar().removeAll();
        }
        if (uiObject.getUIToolBar() != null) {
            uiObject.getUIToolBar().removeAll();
        }
        this.preObject = this.body.oldUIObject;
        this.removeTab(uiObject);
        this.switchToNeighborUserTab(index);
        if (isCache) return true;
        UIReleaseUtil.freeSwingObject(uiObject);
        return true;
    }

    private void switchToNeighborUserTab(int index) {
        int neighborTabIdx = 0;
        if (this.preObject != null) {
            neighborTabIdx = this.getTabIndexByUiObject(this.preObject);
        }
        if (neighborTabIdx == -1) {
            neighborTabIdx = BodyUI.DEFAULT_TAB_INDEX;
        }
        if (index == neighborTabIdx) {
            this.body.changeTab();
        } else {
            this.changeTab(neighborTabIdx);
        }
    }

    private boolean isSysTab(IUIObject uiObject) {
        return this.body.isSysTab(uiObject);
    }

    @Override
    public boolean closeAllTab() {
        try {
            return UIObjectManager.closeUiObjects(this.tabUiObjects);
        }
        catch (Exception e) {
            logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"70_UIObjectManager") + e));
            return true;
        }
    }

    @Override
    public boolean closeAllWin() {
        return UIObjectManager.closeUiObjects(this.winUiObjects);
    }

    @Override
    public IUIObject findUIObject(String uiClassName, Map uiContext, Map dataObjects, String oprt) {
        UIFindCond cond = new UIFindCond(uiClassName, uiContext, dataObjects, oprt, uiContext == null ? null : (String)uiContext.get("UIClassParam"));
        if ("ADDNEW".equals(oprt)) {
            cond.enableCond(false, false, true);
        }
        return this.findUIObject(cond);
    }

    @Override
    public IUIObject findUIObject(UIFindCond cond) {
        IUIObject uiObject = UIObjectManager.getUIObjectInArrays(this.tabUiObjects, cond);
        if (uiObject == null) {
            uiObject = UIObjectManager.getUIObjectInArrays(this.winUiObjects, cond);
        }
        return uiObject;
    }

    @Override
    public IUIObject[] findUIObject(String uiName) {
        ArrayList uiList = new ArrayList();
        UIFindCond cond = new UIFindCond();
        cond.uiClassName = uiName;
        cond.enableCond(false, false, false);
        this.getUIObjects(uiList, cond);
        if (uiList.size() < 1) {
            return null;
        }
        return uiList.toArray(new IUIObject[0]);
    }

    private void getUIObjects(List uiList, UIFindCond cond) {
        IUIObject uiObject;
        int i;
        if (uiList == null) {
            uiList = new ArrayList<IUIObject>();
        }
        for (i = 0; i < this.tabUiObjects.size(); ++i) {
            uiObject = (IUIObject)this.tabUiObjects.get(i);
            if (!new UIFindCond(uiObject).checkCondition(cond)) continue;
            uiList.add(uiObject);
        }
        for (i = 0; i < this.winUiObjects.size(); ++i) {
            uiObject = (IUIObject)this.winUiObjects.get(i);
            if (!new UIFindCond(uiObject).checkCondition(cond)) continue;
            uiList.add(uiObject);
        }
        if (MainUIObjectManager.getInstance().getUiDialog() != null && StringUtils.equals((String)((Object)((Object)MainUIObjectManager.getInstance().getUiDialog())).getClass().getName(), (String)cond.uiClassName)) {
            uiList.add(MainUIObjectManager.getInstance().getUiDialog().getUIObject());
        }
    }

    IUIObject getNewWinByIndex(int index) {
        return (IUIObject)this.winUiObjects.get(index);
    }

    IUIObject getTabByIndex(int index) {
        return (IUIObject)this.tabUiObjects.get(index);
    }

    @Override
    public int getTabIndexByUiObject(IUIObject uiObject) {
        return UIObjectManager.getIndexByUiObject(this.tabUiObjects, uiObject);
    }

    int getWinIndexByUiObject(IUIObject uiObject) {
        return UIObjectManager.getIndexByUiObject(this.winUiObjects, uiObject);
    }

    @Override
    public List getTabUiObjects() {
        return this.tabUiObjects;
    }

    @Override
    public List getWinUiObjects() {
        return this.winUiObjects;
    }

    public void setBody(BodyUI body) {
        this.body = body;
    }
}

