/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ui.face.IUIObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class UIObjectManager2 {
    private static UIObjectManager2 instance = new UIObjectManager2();
    ArrayList winUiObjects = new ArrayList();

    public static UIObjectManager2 getInstance() {
        return instance;
    }

    private UIObjectManager2() {
    }

    private static boolean closeUiObjects(ArrayList uiObjects) {
        for (int i = uiObjects.size() - 1; i >= 0; --i) {
            IUIObject uiObject = (IUIObject)uiObjects.get(i);
            if (uiObject.getUIWindow().close()) continue;
            return false;
        }
        return true;
    }

    private static int getIndexByUiObject(ArrayList uiList, IUIObject uiObject) {
        return UIObjectManager2.getIndexInArrays(uiList, new UIFindCond(uiObject));
    }

    private static IUIObject getUIObjectInArrays(ArrayList uiList, UIFindCond cond) {
        int index = UIObjectManager2.getIndexInArrays(uiList, cond);
        if (index != -1) {
            return (IUIObject)uiList.get(index);
        }
        return null;
    }

    private static int getIndexInArrays(ArrayList uiList, UIFindCond cond) {
        for (int i = 0; i < uiList.size(); ++i) {
            IUIObject uiObject = (IUIObject)uiList.get(i);
            if (!new UIFindCond(uiObject).checkCondition(cond)) continue;
            return i;
        }
        return -1;
    }

    void addNewWin(IUIObject uiObject) {
        this.winUiObjects.add(uiObject);
    }

    void changeNewWin(int index) {
        ((IUIObject)this.winUiObjects.get(index)).getUIWindow().show();
    }

    void removeNewWin(IUIObject uiObject) {
        this.winUiObjects.remove(uiObject);
    }

    boolean closeAllWin() {
        return UIObjectManager2.closeUiObjects(this.winUiObjects);
    }

    IUIObject findUIObject(String uiClassName, Map uiContext, Map dataObjects, String oprt) {
        UIFindCond cond = new UIFindCond(uiClassName, uiContext, dataObjects, oprt);
        return this.findUIObject(cond);
    }

    IUIObject findUIObject(UIFindCond cond) {
        IUIObject uiObject = UIObjectManager2.getUIObjectInArrays(this.winUiObjects, cond);
        return uiObject;
    }

    IUIObject getNewWinByIndex(int index) {
        return (IUIObject)this.winUiObjects.get(index);
    }

    int getWinIndexByUiObject(IUIObject uiObject) {
        return UIObjectManager2.getIndexByUiObject(this.winUiObjects, uiObject);
    }

    static class UIFindCond {
        String uiClassName = null;
        Map uiContext = null;
        Map dataObjects = null;
        String oprt = null;
        boolean onUIContext = true;
        boolean onDataObject = true;
        boolean onOprt = true;

        UIFindCond() {
        }

        UIFindCond(IUIObject ui) {
            this.uiClassName = ui.getClass().getName();
            this.uiContext = ui.getUIContext();
            this.dataObjects = ui.getDataObjects();
            this.oprt = ui.getOprtState();
        }

        UIFindCond(String uiClassName, Map uiContext, Map dataObjects, String oprt) {
            this.uiClassName = uiClassName;
            this.uiContext = uiContext;
            this.dataObjects = dataObjects;
            this.oprt = oprt;
        }

        void enableCond(boolean onUIContext, boolean onDataObject, boolean onOprt) {
            this.onUIContext = onUIContext;
            this.onDataObject = onDataObject;
            this.onOprt = onOprt;
        }

        private static boolean checkDataObjectsEqual(Map source, Map target) {
            return true;
        }

        private static boolean checkUIContextEqual(Map source, Map target) {
            if (source == null) {
                source = new HashMap();
            }
            if (target == null) {
                target = new HashMap();
            }
            if (source.size() != target.size()) {
                return false;
            }
            for (Map.Entry sourceEntry : source.entrySet()) {
                if (!target.containsKey(sourceEntry.getKey())) {
                    return false;
                }
                Object targetValue = target.get(sourceEntry.getKey());
                if (sourceEntry.getValue() == targetValue) continue;
                if (sourceEntry.getValue() != null && targetValue != null) {
                    if (!(sourceEntry.getValue() instanceof String) || !(targetValue instanceof String) || sourceEntry.getValue().equals(targetValue)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        private static boolean checkStringEqual(String source, String target) {
            if (source == target) {
                return true;
            }
            if (source != null && target != null) {
                return source.equals(target);
            }
            return false;
        }

        boolean checkCondition(UIFindCond cond) {
            return !(!UIFindCond.checkStringEqual(this.uiClassName, cond.uiClassName) || cond.onUIContext && !UIFindCond.checkUIContextEqual(this.uiContext, cond.uiContext) || cond.onDataObject && !UIFindCond.checkDataObjectsEqual(this.dataObjects, cond.dataObjects));
        }
    }
}

