/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.myeas.OpenModelInfo;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.ui.IMainUIContainer;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.eas.base.uiframe.client.MyUI;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UIFrameContext;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.Map;

public class UIShowHelper {
    static void showUI(Component owner, MainMenuItemInfo menuItem) {
        UIShowHelper.showUI(owner, menuItem, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void showUI(Component owner, MainMenuItemInfo menuItem, OpenMethod openMethod) {
        if (StringUtils.isEmpty((String)menuItem.getUiClassName()) || menuItem.getUiClassName().equals(MyUI.class.getName()) || !menuItem.isEnabled()) {
            return;
        }
        IMainUIContainer ui = SystemEntry.instance.getCurrenContainer();
        NewMainFrame mainFrame = null;
        if (ui != null && ui instanceof NewMainFrame && (mainFrame = (NewMainFrame)ui) != null) {
            mainFrame.setCursor(Cursor.getPredefinedCursor(3));
        }
        try {
            IUIWindow uiWindow = UIShowHelper.createUI(owner, menuItem, openMethod);
            if (uiWindow != null) {
                uiWindow.show();
            }
        }
        finally {
            if (mainFrame != null) {
                mainFrame.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private static IUIWindow createUI(Component owner, MainMenuItemInfo menuItem, OpenMethod openMethod) {
        if (owner == null || menuItem == null) {
            return null;
        }
        IUIWindow uiWindow = null;
        if (openMethod == null) {
            openMethod = menuItem.getOpenMethod();
        }
        Frame mainFrame = UIFrameUtil.getCurrMainFrame(owner);
        try {
            uiWindow = UIShowHelper.passCreateUI(mainFrame, menuItem.getUiClassName(), menuItem.getUiClassParam(), openMethod, menuItem.getUiOprt(), menuItem.getName());
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)owner, (Throwable)e);
        }
        return uiWindow;
    }

    private static IUIWindow passCreateUI(Frame mainFrame, String uiClassName, String uiClassParam, OpenMethod openMethod, String oprt, String uiTitle) throws UIException {
        OpenMethod finalOpenMethod = UIShowHelper.getFinalOpenMethod(mainFrame, openMethod);
        if (finalOpenMethod == null) {
            return null;
        }
        String uiFactory = UIShowHelper.transOpenMethodToUIFactory(finalOpenMethod);
        return UIShowHelper.innerCreateUI(mainFrame, uiClassName, uiClassParam, uiFactory, oprt, uiTitle);
    }

    private static OpenMethod getFinalOpenMethod(Frame mainFrame, OpenMethod openMethod) {
        if (openMethod == OpenMethod.DEFAULT) {
            openMethod = UIShowHelper.getDefaultOpenMethod();
        }
        if (openMethod != OpenMethod.NEWTAB) {
            return openMethod;
        }
        return openMethod;
    }

    private static IUIWindow innerCreateUI(Frame mainFrame, String uiClassName, String uiClassParam, String factoryName, String oprt, String uiTitle) throws UIException {
        IUIFactory uiFactory = UIFactory.createUIFactory((String)factoryName);
        UIContext uiContext = new UIContext((Object)mainFrame);
        uiContext.put("checkLicense", "true");
        if (uiClassParam != null && uiClassParam.length() != 0) {
            uiContext.put("UIClassParam", uiClassParam);
        }
        if (uiTitle != null && !"".equals(uiTitle.trim())) {
            uiContext.put("MainMenuName", uiTitle);
        }
        IUIWindow uiWindow = uiFactory.create(uiClassName.trim(), (Map)uiContext, null, oprt);
        return uiWindow;
    }

    private static OpenMethod getDefaultOpenMethod() {
        OpenModelInfo openModelInfo = (OpenModelInfo)UIFrameContext.getInstance().getProperty("OpenModel");
        if (openModelInfo != null) {
            if (openModelInfo.isIsOpenInFour()) {
                return OpenMethod.FIXTAB;
            }
            if (openModelInfo.isIsOpenInNewTab()) {
                return OpenMethod.NEWTAB;
            }
            if (openModelInfo.isIsOpenInWindow()) {
                return OpenMethod.NEWWIN;
            }
        }
        return OpenMethod.FIXTAB;
    }

    private static String transOpenMethodToUIFactory(OpenMethod finalOpenMethod) {
        String uiFactory = null;
        switch (finalOpenMethod.getValue()) {
            case 10: {
                uiFactory = "com.kingdee.eas.base.uiframe.client.UIFixTabFactory";
                break;
            }
            case 20: {
                uiFactory = "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
                break;
            }
            case 30: {
                uiFactory = "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
                break;
            }
            case 40: {
                uiFactory = "com.kingdee.eas.base.uiframe.client.UINewSessionFactory";
                break;
            }
            case 50: {
                uiFactory = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
            }
        }
        return uiFactory;
    }
}

