/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.apploader.message.MessageHandler;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.base.myeas.util.ClientPersonalSetUtil;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.uiframe.EASLoginException;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.eas.base.uiframe.client.CommonUILifeCycleListener;
import com.kingdee.eas.base.uiframe.client.ILoginInitStrategy;
import com.kingdee.eas.base.uiframe.client.LoginInitBaseStrategy;
import com.kingdee.eas.base.uiframe.client.LoginInitWEBStrategy;
import com.kingdee.eas.base.uiframe.client.LoginParamCacheUtil;
import com.kingdee.eas.base.uiframe.client.MainFunctionMenuUI;
import com.kingdee.eas.base.uiframe.client.MainMenuTree;
import com.kingdee.eas.base.uiframe.client.MenuVisitorHelper;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.base.uiframe.utils.NationConfigUtils;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.sso.UserCountLimitedException;
import com.kingdee.eas.cp.eip.sso.client.service.IUserLoginHelper;
import com.kingdee.eas.cp.eip.sso.client.service.UserLoginHelperFactroy;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IUILifeCycleListener;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JApplet;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class WebManagerProxy {
    private static Logger logger = Logger.getLogger(WebManagerProxy.class);
    private static JApplet applet = new JApplet();
    private ArrayList<JFrame> defaultFameList = new ArrayList();

    public WebManagerProxy() {
        DaemonDefaultFrameThread thread = new DaemonDefaultFrameThread();
        thread.setName("DefaultFrameDaemon");
        thread.setDaemon(true);
        thread.start();
    }

    public void init4Start(String appServerUrl) {
        applet.setName("apploader");
        SystemEntry.instance.setApplet(applet);
        String embed = "";
        if (embed != null && "embed".equals(embed)) {
            SystemEntry.instance.setStartMode(2);
        } else {
            SystemEntry.instance.setStartMode(1);
        }
        try {
            ILoginInitStrategy loginInitStrategy = LoginInitBaseStrategy.getInstance();
            loginInitStrategy.init(appServerUrl);
            UIFrameUtils.marked();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getOwnerFrame(), (Throwable)e);
        }
    }

    public void init(String appServerUrl) {
        applet.setName("apploader");
        SystemEntry.instance.setApplet(applet);
        String embed = "";
        if (embed != null && "embed".equals(embed)) {
            SystemEntry.instance.setStartMode(2);
        } else {
            SystemEntry.instance.setStartMode(1);
        }
        try {
            ILoginInitStrategy loginInitStrategy = LoginInitWEBStrategy.getInstance();
            loginInitStrategy.init(appServerUrl);
            UIFrameUtils.marked();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getOwnerFrame(), (Throwable)e);
        }
    }

    public String login(String userName, String password, String slnName, String dcName, String locale, int dbType) {
        return this.login(userName, password, slnName, dcName, locale, dbType, "", "");
    }

    public String login(String userName, String password, String slnName, String dcName, String locale, int dbType, String authPattern) {
        return this.login(userName, password, slnName, dcName, locale, dbType, authPattern, "");
    }

    public String login(String userName, String password, String slnName, String dcName, String locale, int dbType, String authPattern, String appServerUrl) {
        if (appServerUrl != null && appServerUrl.length() > 0) {
            this.init(appServerUrl);
        }
        String session = null;
        try {
            if (authPattern != null && authPattern.length() != 0 && authPattern.equals("ReginAutoLogin")) {
                IUserLoginHelper iUserLogin = UserLoginHelperFactroy.getUserLoginHelp();
                userName = iUserLogin.getUserName();
            }
            ContextUtils.setLocaleToEnv((Locale)LocaleUtils.getLocale((String)locale));
            session = SystemEntry.instance.login(userName, password, slnName, dcName, LocaleUtils.getLocale((String)locale), dbType, authPattern);
            try {
                System.out.println("Try to setContextLocale......");
                this.setContextLocale(new Locale(locale));
            }
            catch (Exception e) {
                logger.error((Object)"don't have plan for  nationalization  please check nationaldata", (Throwable)e);
            }
            UIConfig.setLocaleStr(locale.toString());
            ClientPersonalSetUtil.setloginlanguageInpro((String)locale.toString());
        }
        catch (Exception e) {
            UserCountLimitedException ucle = this.getUserCountLimitedException(e);
            if (ucle != null) {
                MsgBox.showError((Component)this.getOwnerFrame(), (String)ucle.getMessage());
            } else if (e instanceof UserException) {
                String code = ((UserException)e).getCode();
                session = code.equals("02-016") ? "-2" : (code.equals("02-007") ? "-1" : "-2");
                ExceptionHandler.handle((Component)this.getOwnerFrame(), (Throwable)e);
            } else {
                ExceptionHandler.handle((Component)this.getOwnerFrame(), (Throwable)e);
            }
            logger.debug((Object)("End login : " + System.currentTimeMillis()));
            return session;
        }
        return session + ";" + userName;
    }

    private void setContextLocale(Locale locale) throws EASBizException, BOSException {
        String userid = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String orgid = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        NationConfigUtils.setNationConfig(null, userid, orgid, locale);
    }

    public void initAfterLogin() {
        logger.debug((Object)("Begin init after login : " + System.currentTimeMillis()));
        SystemEntry.instance.initAfterLogin();
        logger.debug((Object)("End init after login : " + System.currentTimeMillis()));
    }

    public String logout() {
        try {
            SystemEntry.instance.closeApplication(false);
        }
        catch (AbortException e) {
            return "0";
        }
        catch (EASLoginException e0) {
            logger.info((Object)"loutout error", (Throwable)((Object)e0));
            ExceptionHandler.handle((Component)this.getOwnerFrame(), (Throwable)((Object)e0));
        }
        catch (Exception e1) {
            logger.info((Object)"loutout error", (Throwable)e1);
            return "-1";
        }
        return "1";
    }

    public void destory() {
        try {
            if (!StringUtils.isEmpty((String)SysContext.getSysContext().getSessionID())) {
                SystemEntry.instance.closeApplication(false);
            }
        }
        catch (Exception e0) {
            logger.info((Object)"", (Throwable)e0);
        }
    }

    public void openMainMenuFunction() {
        LoginParamCacheUtil.clearParamCache();
        MenuVisitorHelper.setMenuCacheParam();
        MainFunctionMenuUI.clearMap();
        this.webEntryStart(null);
    }

    public void invokeFunction(String uiClassName, String uiClassParam, String uiOprt, int openMethod) {
        this.invokeFunctionWithExtProp(uiClassName, uiClassParam, uiOprt, null, null, openMethod);
    }

    public void invokeFunctionWithExtProp(String uiClassName, String uiClassParam, String uiOprt, String extPropName, String extPropValue, int openMethod) {
        try {
            Frame frame = null;
            IUIWindow uiWindow = null;
            frame = this.getOwnerFrame();
            OpenMethod opeMethod = this.parseOpenMethod(openMethod);
            uiWindow = MainMenuTree.passCreateUI(frame, uiClassName, uiClassParam, opeMethod, uiOprt, null);
            if (extPropName != null && extPropName.length() > 0 && extPropValue != null && extPropValue.length() > 0) {
                CoreUI coreUI = (CoreUI)uiWindow.getUIObject();
                CommonUILifeCycleListener listener = new CommonUILifeCycleListener(extPropName, extPropValue);
                coreUI.getUILifeCycleHandler().addRuleListener((IUILifeCycleListener)listener);
                if (coreUI.getDataObject() != null) {
                    coreUI.getDataObject().setExtendedProperty(extPropName, extPropValue);
                }
                if (coreUI instanceof CoreBillEditUI && ((CoreBillEditUI)coreUI).getEditData() != null) {
                    ((CoreBillEditUI)coreUI).getEditData().setExtendedProperty(extPropName, extPropValue);
                }
            }
            uiWindow.show();
            if (uiWindow instanceof KDFrame) {
                KDFrame ui = (KDFrame)uiWindow;
                ui.toFront();
                ui.setExtendedState(6);
            }
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)this.getOwnerFrame(), (Throwable)e);
        }
    }

    private OpenMethod parseOpenMethod(int op) {
        if (op == 20) {
            return OpenMethod.NEWTAB;
        }
        if (op == 30) {
            return OpenMethod.NEWWIN;
        }
        if (op == 50) {
            return OpenMethod.MODEL;
        }
        return OpenMethod.FIXTAB;
    }

    public void webEntryStart(IUIObject uiObject) {
        try {
            SystemEntry.instance.startApplication(uiObject);
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)this.getOwnerFrame(), (Throwable)e);
        }
    }

    public void switchOrg() {
        SystemEntry.instance.switchOrg(this.getOwnerFrame());
    }

    protected Frame getOwnerFrame() {
        JFrame portalFrame = new JFrame();
        portalFrame.setName("apploader");
        portalFrame.setIconImage(EASResource.getImage((String)"imgEas_16"));
        portalFrame.setTitle(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"48_ServiceProvider"));
        portalFrame.setSize(300, 150);
        portalFrame.setResizable(false);
        portalFrame.setLocationRelativeTo(null);
        portalFrame.setLayout(new BorderLayout());
        KDLabel label = new KDLabel(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"48_ServiceProvider"), 0);
        portalFrame.add((Component)label, "Center");
        this.defaultFameList.add(portalFrame);
        portalFrame.setAlwaysOnTop(true);
        return portalFrame;
    }

    private UserCountLimitedException getUserCountLimitedException(Exception e) {
        Throwable ex = null;
        for (ex = e; ex != null && ex.getCause() != ex; ex = ex.getCause()) {
            if (!(ex instanceof UserCountLimitedException)) continue;
            return (UserCountLimitedException)ex;
        }
        return null;
    }

    class DaemonDefaultFrameThread
    extends Thread {
        private HashMap<JFrame, Long> map = new HashMap();
        private HashMap<JFrame, Long> jFrameMapAlwaysOnTopTime = new HashMap();
        private long timeout = 300000L;
        private long idlesseTime = -1L;

        DaemonDefaultFrameThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ArrayList arrayList = WebManagerProxy.this.defaultFameList;
                        synchronized (arrayList) {
                            if (WebManagerProxy.this.defaultFameList != null && WebManagerProxy.this.defaultFameList.size() > 0) {
                                for (int i = WebManagerProxy.this.defaultFameList.size() - 1; i >= 0; --i) {
                                    JFrame fm = (JFrame)WebManagerProxy.this.defaultFameList.get(i);
                                    if (fm == null) continue;
                                    Window[] ownedWin = fm.getOwnedWindows();
                                    if (ownedWin != null && ownedWin.length > 0) {
                                        Window window = ownedWin[0];
                                        if (Dialog.class.isInstance(window)) {
                                            fm.setTitle(((Dialog)window).getTitle());
                                        } else if (Frame.class.isInstance(window)) {
                                            fm.setTitle(((Frame)window).getTitle());
                                        }
                                        boolean visible = window.isVisible();
                                        if (!visible) {
                                            for (int j = 1; j < ownedWin.length; ++j) {
                                                if (ownedWin[j] == null || !ownedWin[j].isVisible()) continue;
                                                visible = true;
                                                break;
                                            }
                                        }
                                        if (fm.isVisible() != visible) {
                                            fm.setVisible(visible);
                                            if (visible) {
                                                try {
                                                    MessageHandler.sendCloseDivMsg();
                                                }
                                                catch (Throwable j) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (visible) {
                                            Long time = this.jFrameMapAlwaysOnTopTime.get(fm);
                                            if (time != null) {
                                                if (System.currentTimeMillis() - time <= 10000L) continue;
                                                for (Window win : ownedWin) {
                                                    win.setAlwaysOnTop(false);
                                                }
                                                fm.setAlwaysOnTop(false);
                                                continue;
                                            }
                                            window.setVisible(true);
                                            this.jFrameMapAlwaysOnTopTime.put(fm, System.currentTimeMillis());
                                            continue;
                                        }
                                        Long startTime = this.map.get(fm);
                                        if (startTime != null) {
                                            if (System.currentTimeMillis() - startTime <= this.timeout) continue;
                                            WebManagerProxy.this.defaultFameList.remove(fm);
                                            fm = null;
                                            this.idlesseTime = 0L;
                                            continue;
                                        }
                                        this.map.put(fm, System.currentTimeMillis());
                                        continue;
                                    }
                                    fm.setVisible(false);
                                    Long startTime = this.map.get(fm);
                                    if (startTime != null) {
                                        if (System.currentTimeMillis() - startTime <= this.timeout) continue;
                                        WebManagerProxy.this.defaultFameList.remove(fm);
                                        fm = null;
                                        this.idlesseTime = 0L;
                                        continue;
                                    }
                                    this.map.put(fm, System.currentTimeMillis());
                                }
                            }
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

