/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.conf;

import com.kingdee.eas.base.uiframe.client.conf.BatFile;
import com.kingdee.eas.base.uiframe.client.conf.KDLabelContainer;
import com.kingdee.eas.base.uiframe.client.conf.KShellFile;
import com.kingdee.eas.base.uiframe.client.conf.ShellFile;
import com.kingdee.eas.base.uiframe.client.conf.XMLElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class FrmClientConfig
extends JFrame {
    private static final Logger logger = Logger.getLogger(FrmClientConfig.class);
    private static final long serialVersionUID = -2114769314239599122L;
    private static final String PROTOCAL_HTTP = "http://";
    private static final String PROTOCAL_TCP = "tcp://";
    private static final String PROTOCAL_SSL = "tcps://";
    private static final String HTTP_CONTEX = "/ormrpc/servlet/OrmrpcHttpServer?internal";
    private JTextField txtEASServerAddr = null;
    private JTextField txtEASServerPort = new JTextField();
    private JRadioButton rbHttpProtocol = new JRadioButton("HTTP");
    private JRadioButton rbTcpProtocol = new JRadioButton("TCP");
    private JRadioButton rbSSLProtocol = new JRadioButton("SSL");
    private JTextField txtUpdateServerPort = new JTextField();
    private JTextField jvmMaxText = new JTextField();
    private JCheckBox chkOndemandUpdate = new JCheckBox(this.getRes("res_14"));
    private JCheckBox chkIsSartloader = new JCheckBox(this.getRes("res_15"));
    private JCheckBox chkIsMultiloader = new JCheckBox(this.getRes("res_16"));
    private JButton btnOK = new JButton(this.getRes("res_17"));
    private JButton btnCancel = new JButton(this.getRes("res_18"));
    private ShellFile envShell;
    private static XMLElement userconfigColorxmlEle;
    private static String uiframeres;
    private static Locale loc;

    public FrmClientConfig() {
        try {
            this.jbInit();
        }
        catch (Exception err) {
            logger.error((Object)err.getMessage(), (Throwable)err);
            System.exit(-1);
        }
    }

    public void jbInit() throws Exception {
        this.setBounds(new Rectangle(10, 10, 400, 280));
        this.setTitle("EAS" + this.getRes("res_19"));
        this.setResizable(false);
        try {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/com/kingdee/eas/base/uiframe/client/conf/icon_serverlink.gif"));
            this.setIconImage(icon.getImage());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.setDefaultCloseOperation(2);
        JPanel pnlMain = (JPanel)this.getContentPane();
        pnlMain.setLayout(new BoxLayout(pnlMain, 1));
        JPanel pnlCenter = new JPanel();
        pnlCenter.setLayout(new BorderLayout());
        JPanel pnlEASServer = new JPanel();
        pnlEASServer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        pnlEASServer.setLayout(new BoxLayout(pnlEASServer, 1));
        JPanel pnlProtocol = new JPanel();
        pnlProtocol.setLayout(new BoxLayout(pnlProtocol, 2));
        JLabel lblcProtocol = new JLabel(this.getRes("res_20"));
        lblcProtocol.setToolTipText(this.getRes("res_20"));
        this.rbTcpProtocol.setSelected(true);
        this.rbTcpProtocol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmClientConfig.this.txtEASServerPort.setText("11034");
            }
        });
        this.rbSSLProtocol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmClientConfig.this.txtEASServerPort.setText("11033");
            }
        });
        pnlProtocol.add(lblcProtocol);
        pnlProtocol.add(Box.createHorizontalStrut(50));
        pnlProtocol.add(this.rbTcpProtocol);
        pnlProtocol.add(this.rbSSLProtocol);
        pnlProtocol.add(this.rbHttpProtocol);
        pnlProtocol.add(Box.createGlue());
        this.rbHttpProtocol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmClientConfig.this.txtEASServerPort.setText("6888");
            }
        });
        pnlProtocol.add(Box.createHorizontalStrut(10));
        pnlEASServer.add(pnlProtocol);
        pnlEASServer.add(Box.createVerticalStrut(6));
        KDLabelContainer lblcServerAddr = new KDLabelContainer(this.getRes("res_21"), 50);
        lblcServerAddr.setToolTipText(this.getRes("res_21"));
        this.txtEASServerAddr = lblcServerAddr.getBoundTextEditor();
        pnlEASServer.add(lblcServerAddr);
        pnlEASServer.add(Box.createVerticalStrut(3));
        KDLabelContainer lblcServerPort = new KDLabelContainer(this.getRes("res_22"), 50);
        lblcServerPort.setToolTipText(this.getRes("res_22"));
        this.txtEASServerPort = lblcServerPort.getBoundTextEditor();
        pnlEASServer.add(lblcServerPort);
        pnlEASServer.add(Box.createVerticalStrut(6));
        ButtonGroup btgProtocol = new ButtonGroup();
        btgProtocol.add(this.rbTcpProtocol);
        btgProtocol.add(this.rbSSLProtocol);
        btgProtocol.add(this.rbHttpProtocol);
        KDLabelContainer lblcUpdateServerPort = new KDLabelContainer(this.getRes("res_23"), 12);
        lblcUpdateServerPort.setToolTipText(this.getRes("res_23"));
        this.txtUpdateServerPort = lblcUpdateServerPort.getBoundTextEditor();
        pnlEASServer.add(lblcUpdateServerPort);
        pnlEASServer.add(Box.createVerticalStrut(3));
        KDLabelContainer JvmMaxSize = new KDLabelContainer(this.getRes("res_24") + "(m)", 6);
        JvmMaxSize.setToolTipText(this.getRes("res_24"));
        this.jvmMaxText = JvmMaxSize.getBoundTextEditor();
        pnlEASServer.add(JvmMaxSize);
        JPanel pnlOndemand = new JPanel();
        pnlOndemand.setLayout(new BorderLayout());
        this.chkOndemandUpdate.setSelected(true);
        this.chkOndemandUpdate.setToolTipText(this.getRes("res_14"));
        this.chkIsSartloader.setSelected(true);
        this.chkIsSartloader.setToolTipText(this.getRes("res_15"));
        this.chkIsMultiloader.setSelected(false);
        this.chkIsMultiloader.setToolTipText(this.getRes("res_16"));
        pnlOndemand.add((Component)this.chkOndemandUpdate, "West");
        pnlOndemand.add((Component)this.chkIsSartloader, "Center");
        pnlOndemand.add((Component)this.chkIsMultiloader, "East");
        pnlEASServer.add(pnlOndemand);
        pnlCenter.add(pnlEASServer);
        JPanel pnlButtons = new JPanel();
        pnlButtons.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        pnlButtons.setLayout(new BoxLayout(pnlButtons, 2));
        pnlButtons.add(Box.createHorizontalGlue());
        pnlButtons.add(this.btnOK);
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmClientConfig.this.saveConf();
            }
        });
        pnlButtons.add(Box.createHorizontalStrut(3));
        pnlButtons.add(this.btnCancel);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        JSeparator sp = new JSeparator();
        pnlMain.add(pnlCenter);
        pnlMain.add(sp);
        pnlMain.add(Box.createVerticalStrut(8));
        pnlMain.add(pnlButtons);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
        this.btnOK.registerKeyboardAction(this.btnOK.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, false)), KeyStroke.getKeyStroke(10, 0, false), 0);
        this.btnOK.registerKeyboardAction(this.btnOK.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, true)), KeyStroke.getKeyStroke(10, 0, true), 0);
        this.btnCancel.registerKeyboardAction(this.btnCancel.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, false)), KeyStroke.getKeyStroke(10, 0, false), 0);
        this.btnCancel.registerKeyboardAction(this.btnCancel.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, true)), KeyStroke.getKeyStroke(10, 0, true), 0);
        this.loadConf();
    }

    private void loadConf() {
        String osName = System.getProperty("os.name");
        this.envShell = osName.toLowerCase().indexOf("windows") >= 0 ? new BatFile("./set-client-env.bat") : new KShellFile("./set-client-env.sh");
        try {
            String jvmMax;
            String[] addr;
            String updateServer;
            String easServer = this.envShell.getParameter("EAS_SERVER");
            logger.info((Object)("Load EAS Server Config: " + easServer));
            if (easServer == null || easServer.length() == 0) {
                easServer = "tcp://0.0.0.0:11034";
            }
            if (easServer.startsWith(PROTOCAL_TCP)) {
                this.rbTcpProtocol.setSelected(true);
                easServer = easServer.substring(PROTOCAL_TCP.length());
            } else if (easServer.startsWith(PROTOCAL_SSL)) {
                this.rbSSLProtocol.setSelected(true);
                easServer = easServer.substring(PROTOCAL_SSL.length());
            } else {
                this.rbHttpProtocol.setSelected(true);
                int len = easServer.length() - HTTP_CONTEX.length();
                easServer = easServer.substring(PROTOCAL_HTTP.length(), len);
            }
            String[] easAddr = easServer.split(":");
            this.txtEASServerAddr.setText(easAddr[0]);
            if (easAddr.length > 1) {
                this.txtEASServerPort.setText(easAddr[1]);
            }
            if ((updateServer = this.envShell.getParameter("UPDATE_SERVER")) == null || updateServer.length() == 0) {
                updateServer = "0.0.0.0:6888";
            }
            if ((addr = updateServer.split(":")).length > 1) {
                this.txtUpdateServerPort.setText(addr[1]);
            }
            if ((jvmMax = this.envShell.getParameter("JVM_MAX_HEAPSIZE")) == null || jvmMax.length() == 0) {
                jvmMax = "256";
            }
            this.jvmMaxText.setText(jvmMax);
            String onDemand = this.envShell.getParameter("ONDEMAND_UPDATE");
            if (onDemand == null || onDemand.length() == 0) {
                onDemand = "true";
            }
            this.chkOndemandUpdate.setSelected("true".equalsIgnoreCase(onDemand));
            String isStart = this.envShell.getParameter("ISSTART_LOADER");
            if (isStart == null || isStart.length() == 0) {
                isStart = "true";
            }
            this.chkIsSartloader.setSelected("true".equalsIgnoreCase(isStart));
            String isMultiloader = this.envShell.getParameter("ISMULTI_LOADER");
            if (isMultiloader == null || isMultiloader.length() == 0) {
                isMultiloader = "false";
            }
            this.chkIsMultiloader.setSelected("true".equalsIgnoreCase(isMultiloader));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            JOptionPane.showMessageDialog(this, this.getRes("res_25"), this.getRes("res_26"), 0);
        }
    }

    private void saveConf() {
        if (null != loc) {
            if ("L1".equalsIgnoreCase(loc.toString())) {
                Locale.setDefault(new Locale("en", "US"));
                System.setProperty("user.language", "en");
                System.setProperty("user.country", "US");
            } else if ("L3".equalsIgnoreCase(loc.toString())) {
                Locale.setDefault(new Locale("zh", "TW"));
                System.setProperty("user.language", "zh");
                System.setProperty("user.country", "TW");
            } else {
                Locale.setDefault(new Locale("zh", "CN"));
                System.setProperty("user.language", "zh");
                System.setProperty("user.country", "CN");
            }
        }
        if (this.txtEASServerAddr.getText().length() < 1) {
            JOptionPane.showMessageDialog(this, this.getRes("res_27"), this.getRes("res_26"), 1);
            return;
        }
        String easServerPort = this.txtEASServerPort.getText().trim();
        if (easServerPort.length() < 1) {
            JOptionPane.showMessageDialog(this, this.getRes("res_28"), this.getRes("res_26"), 1);
            return;
        }
        String urlPort = this.txtUpdateServerPort.getText().trim();
        if (urlPort.length() < 1) {
            JOptionPane.showMessageDialog(this, this.getRes("res_29"), this.getRes("res_26"), 1);
            return;
        }
        String jvmMax = this.jvmMaxText.getText();
        if (jvmMax.length() < 1) {
            JOptionPane.showMessageDialog(this, this.getRes("res_30"), this.getRes("res_26"), 1);
            return;
        }
        int jvmIntValue = 256;
        try {
            jvmIntValue = Integer.parseInt(jvmMax);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, this.getRes("res_31"), this.getRes("res_26"), 1);
            return;
        }
        if (jvmIntValue < 256) {
            JOptionPane.showMessageDialog(this, this.getRes("res_32") + "256M!", this.getRes("res_26"), 1);
            return;
        }
        String value = this.txtEASServerAddr.getText().trim() + ":" + urlPort;
        String server = this.txtEASServerAddr.getText().trim() + ":" + easServerPort;
        server = this.rbTcpProtocol.isSelected() ? PROTOCAL_TCP + server : (this.rbSSLProtocol.isSelected() ? PROTOCAL_SSL + server : PROTOCAL_HTTP + server + HTTP_CONTEX);
        try {
            this.envShell.updateParameter("UPDATE_SERVER", value);
            this.envShell.updateParameter("EAS_SERVER", server);
            this.envShell.updateParameter("JVM_MAX_HEAPSIZE", jvmMax);
            this.envShell.updateParameter("ONDEMAND_UPDATE", String.valueOf(this.chkOndemandUpdate.isSelected()));
            this.envShell.updateParameter("ISSTART_LOADER", String.valueOf(this.chkIsSartloader.isSelected()));
            this.envShell.updateParameter("ISMULTI_LOADER", String.valueOf(this.chkIsMultiloader.isSelected()));
            Preferences sysProfs = Preferences.systemRoot().node("/kingdee/eas");
            String regKey = this.txtEASServerAddr.getText() + "_" + urlPort + "_easclienthome";
            String valueKey = System.getProperty("EAS_HOME").toLowerCase().replace('\\', '/') + "/client";
            sysProfs.put(regKey, valueKey);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            JOptionPane.showMessageDialog(this, this.getRes("res_33"), this.getRes("res_26"), 0);
            return;
        }
        if (this.chkIsSartloader.isSelected()) {
            JOptionPane.showMessageDialog(this, this.getRes("res_34"), this.getRes("res_26"), 1);
        } else {
            JOptionPane.showMessageDialog(this, this.getRes("res_35"), this.getRes("res_26"), 1);
        }
        System.exit(0);
    }

    public String getRes(String key) {
        if (userconfigColorxmlEle != null) {
            logger.info((Object)("userconfigColorxmlEle:" + userconfigColorxmlEle));
        }
        if (loc == null) {
            loc = this.getLocaleFromUseconfig();
        }
        ResourceBundle bundle = ResourceBundle.getBundle(uiframeres, loc);
        return bundle.getObject(key) + "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLElement loadUseConfigFile() {
        XMLElement xml = null;
        String fileName = System.getProperty("user.home").trim();
        File configFile = new File(fileName = fileName + File.separator + "userconfig.xml");
        if (configFile.exists()) {
            xml = new XMLElement(new Hashtable(), false, true, false);
            FileReader reader = null;
            try {
                reader = new FileReader(configFile);
                xml.parseFromReader(reader);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    xml = null;
                }
            }
        } else {
            logger.error((Object)" file is  not exists");
            xml = null;
        }
        return xml;
    }

    public Locale getLocaleFromUseconfig() {
        if (userconfigColorxmlEle == null) {
            userconfigColorxmlEle = this.loadUseConfigFile();
        }
        if (userconfigColorxmlEle == null) {
            return new Locale("L2");
        }
        String language = "";
        Vector listNode = userconfigColorxmlEle.getChildren();
        Iterator it = listNode.iterator();
        if (listNode.size() > 0) {
            for (int nodeSize = 0; nodeSize < listNode.size(); ++nodeSize) {
                Vector listattribute1;
                XMLElement configitem1 = (XMLElement)it.next();
                if (!"configitem".equalsIgnoreCase(configitem1.getName()) || !"uiframe".equalsIgnoreCase(configitem1.getStringAttribute("name")) || (listattribute1 = configitem1.getChildren()).size() <= 0) continue;
                Iterator itattribute = listattribute1.iterator();
                for (int attribute1Size = 0; attribute1Size < listattribute1.size(); ++attribute1Size) {
                    XMLElement attribute1 = (XMLElement)itattribute.next();
                    if (!"attribute".equalsIgnoreCase(attribute1.getName()) || !"localestr".equalsIgnoreCase(attribute1.getStringAttribute("key"))) continue;
                    language = attribute1.getStringAttribute("value", "");
                }
            }
        }
        Locale loc = new Locale("L2");
        if (null != language && !"".equals(language)) {
            if ("L1".equalsIgnoreCase(language)) {
                loc = new Locale("L1");
            } else if ("L3".equalsIgnoreCase(language)) {
                loc = new Locale("L3");
            }
        }
        return loc;
    }

    public static void main(String[] args) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream("./seturl.vmlog");
            PrintStream printOut = new PrintStream((OutputStream)out, true, "UTF-8");
            System.setErr(printOut);
            System.setOut(printOut);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error((Object)"stream close error!");
                }
            }
        }
        if (args.length >= 3) {
            String osName = System.getProperty("os.name");
            ShellFile envShell = osName.toLowerCase().indexOf("windows") >= 0 ? new BatFile("./set-client-env.bat") : new KShellFile("./set-client-env.sh");
            String server = PROTOCAL_TCP + args[0] + ":" + args[1];
            String value = args[0] + ":" + args[2];
            try {
                envShell.updateParameter("UPDATE_SERVER", value);
                envShell.updateParameter("EAS_SERVER", server);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            System.exit(0);
        }
        try {
            UIManager.setLookAndFeel("com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel");
        }
        catch (Exception osName) {
            // empty catch block
        }
        FrmClientConfig frmMain = new FrmClientConfig();
        frmMain.setVisible(true);
    }

    static {
        uiframeres = "com.kingdee.eas.base.uiframe.client.conf.UIFrameRes";
    }
}

