/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.ui.contact;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.base.uiframe.client.AboutInfoUtil;
import com.kingdee.eas.base.uiframe.client.VersionUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.StringUtils;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;

public class KingdeeSupportUtil {
    public static final String SUPPORT_SALES_URL = "https://support.kingdee.com/osp2016/chat/pc/index.php";
    public static final String SUPPORT_SERVICE_URL = "https://support.kingdee.com/productSelect.php";
    private static final String SECRET = "LTAIKzJqfjQ70Jiw";
    private static LicenseBaseInfo baseInfo = null;

    public static void openSalesBefore() throws Exception {
        VersionUtil.gotoSite(KingdeeSupportUtil.buildUrl("Sales"));
    }

    public static void openSalesAfter() throws Exception {
        VersionUtil.gotoSite(KingdeeSupportUtil.buildUrl("Service"));
    }

    public static String buildUrl(String type) throws Exception {
        if (baseInfo == null) {
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
            baseInfo = agent.getLicenseBaseInfo();
        }
        IUser user = UserFactory.getRemoteInstance();
        String _userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        UserInfo userInfo = user.getUserInfo((IObjectPK)new ObjectUuidPK(_userId));
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("vendorID", "8");
        params.put("type", type);
        params.put("source", "EASProduct");
        params.put("clientId", EasCloud.CLIENT_ID);
        String uid = SysContext.getSysContext().getCurrentUserInfo().getUid();
        params.put("kduid", StringUtils.isEmpty((String)uid) ? "unknown" : uid);
        if (!StringUtils.isEmpty((String)uid)) {
            JSONObject rs = EasCloud.cloudErpAccessToken(uid, StringUtils.isEmpty((String)baseInfo.getProductInstanceID()) ? "unknown" : baseInfo.getProductInstanceID());
            if (rs != null && rs.getIntValue("errcode") == 0) {
                String access_token = rs.getJSONObject("data").getString("access_token");
                String username = rs.getJSONObject("data").getString("nickname");
                rs = EasCloud.getUserAuthCode(access_token);
                if (rs != null && rs.getIntValue("errcode") == 0) {
                    params.put("authCode", rs.getJSONObject("data").getString("auth_code"));
                    params.put("username", URLEncoder.encode(username, "UTF-8"));
                } else {
                    System.out.println(rs.toJSONString());
                    if ("Service".equals(type)) {
                        throw new BOSException(EasCloud.getErrorMsg(rs));
                    }
                }
            } else {
                System.out.println(rs.toJSONString());
                if ("Service".equals(type)) {
                    throw new BOSException(EasCloud.getErrorMsg(rs));
                }
            }
        }
        if (!StringUtils.isEmpty((String)((String)params.get("authCode")))) {
            params.put("serviceType", "1");
        } else {
            params.put("serviceType", "2");
        }
        if (params.get("username") == null) {
            params.put("username", URLEncoder.encode(SysContext.getSysContext().getUserName(), "UTF-8"));
        }
        params.put("erpId", URLEncoder.encode(_userId, "UTF-8"));
        params.put("erpName", URLEncoder.encode(SysContext.getSysContext().getUserName(), "UTF-8"));
        String erpPhone = userInfo.getCell();
        params.put("phone", StringUtils.isEmpty((String)erpPhone) ? "unknown" : erpPhone);
        params.put("erpPhone", StringUtils.isEmpty((String)erpPhone) ? "unknown" : erpPhone);
        String erpEmail = userInfo.getEmail();
        params.put("erpEmail", StringUtils.isEmpty((String)erpEmail) ? "unknown" : erpEmail);
        String version = AboutInfoUtil.getEASversion();
        params.put("prodVersion", URLEncoder.encode(StringUtils.isEmpty((String)version) ? "unknown" : version, "UTF-8"));
        params.put("prodCategoryCode", "EAS");
        params.put("prodDeployWay", "Offline");
        params.put("prodInstCode", StringUtils.isEmpty((String)baseInfo.getProductInstanceID()) ? "unknown" : baseInfo.getProductInstanceID());
        params.put("prodSN", StringUtils.isEmpty((String)baseInfo.getSerialNum()) ? "unknown" : baseInfo.getSerialNum());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        params.put("serviceEndDate", baseInfo.getServiceDate() == null ? "unknown" : sdf.format(baseInfo.getServiceDate()));
        params.put("userRole", "Normal");
        String timeStamp = String.valueOf(new Date().getTime());
        params.put("timestamp", timeStamp);
        String nonce = UUID.randomUUID().toString().replace("-", "");
        params.put("nonce", nonce);
        Iterator ite = params.entrySet().iterator();
        Object[] values = new String[params.size()];
        int i = 0;
        while (ite.hasNext()) {
            Map.Entry value = ite.next();
            values[i++] = (String)value.getValue();
        }
        Arrays.sort((Object[])values);
        StringBuilder sb = new StringBuilder();
        for (Object str : values) {
            sb.append((String)str);
        }
        params.put("signature", EasCloud.sha1(SECRET + sb.toString()));
        if ("Sales".equalsIgnoreCase(type)) {
            return "https://support.kingdee.com/osp2016/chat/pc/index.php?" + KingdeeSupportUtil.getQueryString(params);
        }
        return "https://support.kingdee.com/productSelect.php?" + KingdeeSupportUtil.getQueryString(params);
    }

    private static String getQueryString(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        for (String key : params.keySet()) {
            String value = params.get(key);
            if (value != null & value.contains("+")) {
                value = value.replaceAll("\\+", "");
            }
            sb.append(key).append("=").append(value).append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

