/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.ui.gzh;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.MD5Util;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.AboutInfoUtil;
import com.kingdee.eas.base.uiframe.client.VersionUtil;
import com.kingdee.eas.base.uiframe.client.ui.gzh.LocaleTokenStorge;
import com.kingdee.eas.base.uiframe.client.ui.gzh.TLSSocketFactory;
import com.kingdee.eas.base.uiframe.gzh.info.TokenInfo;
import com.kingdee.eas.base.uiframe.gzh.util.HashHmacCrypto;
import com.kingdee.eas.base.uiframe.gzh.util.SinatureUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.log4j.Logger;

public class OfficialAccountUtil {
    private static Logger logger = Logger.getLogger(OfficialAccountUtil.class);
    public static final String SERVER_NAME = "https://api.kingdee.com";
    public static final String SERVICE_TOKEN = "/linkceo/auth/product/token";
    public static final String SERVICE_NOTIFY = "/linkceo/notify/product";
    public static final String SERVICE_INDEX = "/linkceo/home/index";
    private static final String CLIENT_ID = EasCloud.CLIENT_ID;
    private static final String CLIENT_SECRET = EasCloud.CLIENT_SECRET;
    private static LicenseBaseInfo baseInfo = null;

    public static void open() throws Exception {
        VersionUtil.gotoSite("https://robert.kingdee.com/linkceo/home/index" + OfficialAccountUtil.getQueryString());
    }

    public static URI getWssURI() throws Exception {
        String url = "wss://robertnotify.kingdee.com/linkceo/notify/product";
        return new URI(url + OfficialAccountUtil.getQueryString() + "&reconnection=0");
    }

    public static String getQueryString() throws Exception {
        TokenInfo token = OfficialAccountUtil.getToken();
        if (baseInfo == null) {
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
            baseInfo = agent.getLicenseBaseInfo();
        }
        final String clientId = CLIENT_ID;
        String cuid = SysContext.getSysContext().getCurrentUserInfo().getUid();
        final String uid = StringUtils.isEmpty((String)cuid) ? "unknown" : cuid;
        StringBuilder sb = new StringBuilder("?");
        if (StringUtils.isEmpty((String)uid)) {
            sb.append("prodCategoryCode=EAS");
        } else {
            final String erpId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            final String prodSN = baseInfo.getSerialNum();
            final String timestamp = String.valueOf(OfficialAccountUtil.getGMT8Time().getTime());
            String accessToken = SinatureUtil.aesSign(new TreeMap(){
                {
                    this.put("clientid", clientId);
                    this.put("uid", uid);
                    this.put("erpId", erpId);
                    this.put("prodSN", prodSN);
                    this.put("timestamp", timestamp);
                }
            }, token.getAccessToken());
            sb.append("timestamp=").append(timestamp).append("&uid=").append(URLEncoder.encode(uid, "utf-8")).append("&erpId=").append(URLEncoder.encode(erpId, "utf-8")).append("&prodSN=").append(URLEncoder.encode(prodSN, "utf-8")).append("&accessToken=").append(URLEncoder.encode(accessToken, "utf-8"));
        }
        return sb.toString();
    }

    public static synchronized TokenInfo getToken() throws Exception {
        String userPk = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        TokenInfo tokenInfo = LocaleTokenStorge.get(userPk);
        if (tokenInfo == null) {
            tokenInfo = OfficialAccountUtil.refreshToken();
        } else {
            long createTime = tokenInfo.getTimestamp() / 1000L;
            long currentTime = System.currentTimeMillis() / 1000L;
            long expire = tokenInfo.getExpiresIn() - 259200;
            if (createTime + expire < currentTime) {
                tokenInfo = OfficialAccountUtil.refreshToken();
            }
        }
        return tokenInfo;
    }

    public static synchronized TokenInfo refreshToken() throws Exception {
        if (baseInfo == null) {
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
            baseInfo = agent.getLicenseBaseInfo();
        }
        IUser user = UserFactory.getRemoteInstance();
        String _userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        LocaleTokenStorge.delete(_userId);
        UserInfo userInfo = user.getUserInfo((IObjectPK)new ObjectUuidPK(_userId));
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("clientId", CLIENT_ID);
        String uid = SysContext.getSysContext().getCurrentUserInfo().getUid();
        params.put("uid", StringUtils.isEmpty((String)uid) ? "unknown" : uid);
        params.put("dataCenterCode", SysContext.getSysContext().getDCNumber());
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        params.put("erpId", userId);
        params.put("erpName", SysContext.getSysContext().getUserName());
        String erpPhone = userInfo.getCell();
        params.put("erpPhone", StringUtils.isEmpty((String)erpPhone) ? "unknown" : erpPhone);
        String erpEmail = userInfo.getEmail();
        params.put("erpEmail", StringUtils.isEmpty((String)erpEmail) ? "unknown" : erpEmail);
        params.put("prodInstCode", StringUtils.isEmpty((String)baseInfo.getProductInstanceID()) ? "unknown" : baseInfo.getProductInstanceID());
        params.put("prodSN", StringUtils.isEmpty((String)baseInfo.getSerialNum()) ? "unknown" : baseInfo.getSerialNum());
        params.put("prodName", "EAS");
        String version = AboutInfoUtil.getEASversion();
        params.put("prodVersion", StringUtils.isEmpty((String)version) ? "unknown" : version);
        params.put("prodCategoryCode", "EAS");
        params.put("prodDeployWay", "OfflineERP");
        params.put("prodClientType", "GUI");
        params.put("prodSoftcode", StringUtils.isEmpty((String)baseInfo.getMechineCode()) ? "unknown" : baseInfo.getMechineCode());
        params.put("prodDomain", "unknown");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        params.put("serviceEndDate", baseInfo.getServiceDate() == null ? "unknown" : sdf.format(baseInfo.getServiceDate()));
        params.put("userRole", "Normal");
        params.put("userSource", "Product");
        params.put("customerLevel", "unknown");
        String customerName = baseInfo.getLicenseTo();
        if (!StringUtils.isEmpty((String)customerName)) {
            customerName = new String(Base64Encoder.base64ToByteArray((String)customerName), "GBK");
        }
        params.put("customerName", StringUtils.isEmpty((String)customerName) ? "unknown" : customerName);
        params.put("extParam", OfficialAccountUtil.buildExtParam(baseInfo, userInfo));
        HashMap<String, String> headers = new HashMap<String, String>();
        final String timeStamp = String.valueOf(new Date().getTime() / 1000L);
        final String nonce = UUID.randomUUID().toString().replace("-", "");
        headers.put("X-Api-ClientID", CLIENT_ID);
        headers.put("X-Api-Auth-Version", "2.0");
        headers.put("X-Api-TimeStamp", timeStamp);
        headers.put("X-Api-SignHeaders", "X-Api-TimeStamp,X-Api-Nonce");
        headers.put("X-Api-Nonce", nonce);
        try {
            String signature = HashHmacCrypto.sign("POST", SERVICE_TOKEN, params, new TreeMap<String, String>(){
                {
                    this.put("X-Api-Nonce", nonce);
                    this.put("X-Api-TimeStamp", timeStamp);
                }
            }, CLIENT_SECRET);
            headers.put("X-Api-Signature", signature.replaceAll(System.getProperty("line.separator"), ""));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new Exception("Calculate Signature Error", e);
        }
        String url = "https://api.kingdee.com/linkceo/auth/product/token?" + OfficialAccountUtil.concatUrl(params);
        JSONObject rs = OfficialAccountUtil.sendRequest(url, headers, params);
        if (rs.getIntValue("errcode") == 0) {
            TokenInfo token = (TokenInfo)rs.getObject("data", TokenInfo.class);
            LocaleTokenStorge.store(userId, token);
            return token;
        }
        JSONObject body = new JSONObject();
        body.putAll(params);
        logger.error((Object)("request url is:" + url + "\nbody is:" + body.toJSONString()));
        logger.error((Object)rs);
        LocaleTokenStorge.delete(userId);
        StringBuilder sb = new StringBuilder(UIFrameResource.getString("GET_OFFICEACCOUNTTOKEN_FAILED"));
        sb.append("\n").append(UIFrameResource.getString("OFFICEACCOUNT_ERRORCODE")).append(": ").append(rs.getString("errcode"));
        String descKey = null;
        if ("l1".equalsIgnoreCase(SysContext.getSysContext().getLocale().toString())) {
            descKey = "description";
            if (rs.getString(descKey) == null) {
                descKey = "description_cn";
            }
        } else {
            descKey = "description_cn";
        }
        sb.append("\n").append(UIFrameResource.getString("OFFICEACCOUNT_ERRORDES")).append(": ").append(rs.getString(descKey));
        throw new BOSException(sb.toString());
    }

    private static String buildExtParam(LicenseBaseInfo baseInfo, UserInfo userInfo) throws Exception {
        JSONObject rs = new JSONObject();
        JSONObject noneParam = new JSONObject();
        noneParam.put("client_id", (Object)CLIENT_ID);
        JSONObject ksm = new JSONObject();
        ksm.put("client_id", (Object)CLIENT_ID);
        ksm.put("productCode", (Object)baseInfo.getSerialNum());
        ksm.put("userId", (Object)userInfo.getId().toString());
        String account = "";
        if (!StringUtils.isEmpty((String)baseInfo.getLicenseTo())) {
            account = new String(Base64Encoder.base64ToByteArray((String)baseInfo.getLicenseTo()), "GBK");
        }
        ksm.put("account", (Object)account);
        ksm.put("username", (Object)userInfo.getName());
        ksm.put("email", (Object)(userInfo.getEmail() == null ? "" : userInfo.getEmail()));
        ksm.put("telephone", (Object)(userInfo.getCell() == null ? "" : userInfo.getCell()));
        rs.put("EAS_KSM", (Object)ksm);
        rs.put("EAS_KINGDEE_CLUB", (Object)noneParam);
        rs.put("EAS_OPPORTUNITY", (Object)OfficialAccountUtil.buildMyBuiness(userInfo));
        rs.put("EAS_ONLINESERVICE", (Object)noneParam.clone());
        JSONObject os = new JSONObject();
        os.put("client_id", (Object)"200148");
        os.put("productNo", (Object)baseInfo.getSerialNum());
        rs.put("EAS_CLUB_ONLINESERVICE", (Object)os);
        return rs.toJSONString();
    }

    private static JSONObject buildMyBuiness(UserInfo userInfo) {
        JSONObject rs = new JSONObject();
        String key = "5998498670981230171";
        String userNumber = userInfo.getNumber();
        String userName = userInfo.getName();
        String phoneNum = userInfo.getCell();
        if (phoneNum == null) {
            phoneNum = "";
        }
        String source = "\u5916\u90e8\u63a8\u8350-EAS\u4ea7\u54c1\u7aef";
        String hash = MD5Util.getMD5String((String)(phoneNum + key));
        rs.put("cellephone", (Object)phoneNum);
        rs.put("account", (Object)userNumber);
        rs.put("name", (Object)userName);
        rs.put("source", (Object)source);
        rs.put("hash", (Object)hash);
        rs.put("client_id", (Object)CLIENT_ID);
        rs.put("company", (Object)"");
        return rs;
    }

    private static String concatUrl(TreeMap<String, String> parameters) throws UnsupportedEncodingException {
        StringBuffer params = new StringBuffer();
        for (Map.Entry<String, String> element : parameters.entrySet()) {
            params.append(element.getKey());
            params.append("=");
            params.append(URLEncoder.encode(element.getValue(), "utf-8"));
            params.append("&");
        }
        int iLen = params.length();
        if (iLen > 0) {
            params = params.deleteCharAt(iLen - 1);
        }
        return params.toString();
    }

    private static JSONObject sendRequest(String url, Map<String, String> headers, Map body) throws Exception {
        OutputStream ds = null;
        InputStream in = null;
        BufferedReader reader = null;
        try {
            StringBuffer sb;
            URL sendUrl = new URL(url);
            HttpsURLConnection conn = (HttpsURLConnection)sendUrl.openConnection();
            String javaVersion = System.getProperty("java.version");
            if (javaVersion.contains("1.6.")) {
                conn.setSSLSocketFactory(new TLSSocketFactory(SSLContext.getDefault().getSocketFactory()));
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            ds = conn.getOutputStream();
            String str = new JSONObject(body).toJSONString();
            ds.write(str.getBytes("utf-8"));
            ds.flush();
            conn.connect();
            if (conn.getResponseCode() == 200) {
                in = conn.getInputStream();
                sb = new StringBuffer();
                reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                conn.disconnect();
                System.out.println(sb.toString());
                JSONObject jSONObject = JSONObject.parseObject((String)new String(sb.toString().getBytes("UTF-8"), "UTF-8"));
                return jSONObject;
            }
            try {
                in = conn.getErrorStream();
                sb = new StringBuffer();
                reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                conn.disconnect();
                throw new IOException(sb.toString());
            }
            catch (SocketTimeoutException e) {
                logger.error((Object)e);
                throw new IOException("\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6,\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u8bbf\u95ee\u5916\u7f51\u7684\u6743\u9650\uff01");
            }
            catch (IOException e) {
                logger.error((Object)e);
                throw e;
            }
        }
        finally {
            if (ds != null) {
                try {
                    ds.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static Date getGMT8Time() {
        Date gmt8 = null;
        try {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+8"), Locale.CHINESE);
            Calendar day = Calendar.getInstance();
            day.set(1, cal.get(1));
            day.set(2, cal.get(2));
            day.set(5, cal.get(5));
            day.set(11, cal.get(11));
            day.set(12, cal.get(12));
            day.set(13, cal.get(13));
            gmt8 = day.getTime();
        }
        catch (Exception e) {
            System.out.println("getGMT8Time() error !");
            e.printStackTrace();
            gmt8 = null;
        }
        return gmt8;
    }
}

