/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.ui.login;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPasswordField;
import com.kingdee.eas.base.uiframe.client.ui.login.KDRoundRectBorder;
import com.kingdee.eas.base.uiframe.client.ui.login.LoginIconUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.border.Border;

public class LoginPasswordTextField
extends KDPasswordField {
    public static int iconGap = 10;
    private KDLabel searchLabel = new KDLabel((Icon)LoginIconUtil.loadIcon("password.png"));
    private Dimension searchIconSize = new Dimension(16, 16);
    private KDLabel infoLabel = new KDLabel("");
    private CellRendererPane cellRendererPane = new CellRendererPane();
    private Dimension infoSize = new Dimension(220, 20);

    public void paint(Graphics g) {
        Border border = this.getBorder();
        if (border instanceof KDRoundRectBorder) {
            ((KDRoundRectBorder)border).paintClip((Component)((Object)this), g, 0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g);
    }

    public LoginPasswordTextField(String text) {
        super("");
        this.setHorizontalAlignment(2);
        this.infoLabel.setText(text);
        this.infoLabel.setEnabled(false);
        this.searchLabel.setEnabled(false);
        this.setBorder(new KDRoundRectBorder());
        this.addThisFocusListener();
    }

    private void addThisFocusListener() {
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                LoginPasswordTextField.this.repaint();
            }

            @Override
            public void focusGained(FocusEvent e) {
                LoginPasswordTextField.this.repaint();
            }
        });
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        int y = (int)((double)this.getHeight() / 2.0 - this.searchLabel.getPreferredSize().getHeight() / 2.0);
        this.paintSearchLabel(g2d, y);
        this.paintInfoLabel(g2d, y);
    }

    private void paintSearchLabel(Graphics2D g2d, int y) {
        this.cellRendererPane.paintComponent(g2d, (Component)this.searchLabel, (Container)((Object)this), iconGap, y, this.searchIconSize.width, this.searchIconSize.height);
    }

    private void paintInfoLabel(Graphics2D g2d, int y) {
        if (!(this.isFocusOwner() || this.getPassword() != null && this.getPassword().length != 0)) {
            int x = this.searchIconSize.width + iconGap * 2;
            FontMetrics fm = g2d.getFontMetrics();
            int width = fm.stringWidth(this.infoLabel.getText()) + 5;
            y = (int)((double)this.getHeight() / 2.0 - this.infoSize.getHeight() / 2.0);
            this.cellRendererPane.paintComponent(g2d, (Component)this.infoLabel, (Container)((Object)this), x, y, width, this.infoSize.height);
        }
    }

    public Dimension getPreferredSize() {
        Insets s = super.getInsets();
        Insets t = this.getInsets();
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.setSize(preferredSize.width - (t.left + t.right - s.left - s.right), preferredSize.height + 2);
        return preferredSize;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        insets.left += this.searchIconSize.width + iconGap * 2;
        insets.right += iconGap;
        return insets;
    }

    public void setBoundLabelText(String labelText) {
        this.infoLabel.setText(labelText);
    }
}

