/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.ui.login;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.base.uiframe.client.ui.login.KDRoundRectBorder;
import com.kingdee.eas.base.uiframe.client.ui.login.LoginIconUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.border.Border;

public class LoginTextField
extends KDTextField {
    private static final long serialVersionUID = -4361662358234740903L;
    public static int iconGap = 10;
    private KDLabel searchLabel = new KDLabel((Icon)LoginIconUtil.loadIcon("account.png"));
    private Dimension searchIconSize = new Dimension(16, 16);
    private KDLabel infoLabel = new KDLabel("");
    private KDLabel clearLabel = new KDLabel((Icon)LoginIconUtil.loadIcon("right.png"));
    private CellRendererPane cellRendererPane = new CellRendererPane();
    private Dimension infoSize = new Dimension(220, 20);

    public LoginTextField(String text) {
        super("");
        this.infoLabel.setText(text);
        this.infoLabel.setEnabled(false);
        this.searchLabel.setEnabled(false);
        this.clearLabel.setVisible(false);
        this.setBorder(new KDRoundRectBorder());
    }

    public void paint(Graphics g) {
        Border border = this.getBorder();
        if (border instanceof KDRoundRectBorder) {
            ((KDRoundRectBorder)border).paintClip((Component)((Object)this), g, 0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        int y = (int)((double)this.getHeight() / 2.0 - this.searchLabel.getPreferredSize().getHeight() / 2.0);
        this.paintSearchLabel(g2d, y);
        this.paintInfoLabel(g2d, y);
        this.paintClearLabel(g2d, y);
    }

    private void paintSearchLabel(Graphics2D g2d, int y) {
        this.cellRendererPane.paintComponent(g2d, (Component)this.searchLabel, (Container)((Object)this), iconGap, y, this.searchIconSize.width, this.searchIconSize.height);
    }

    private void paintInfoLabel(Graphics2D g2d, int y) {
        if (!(this.isFocusOwner() || this.getText() != null && this.getText().length() != 0)) {
            int x = this.searchIconSize.width + iconGap * 2;
            FontMetrics fm = g2d.getFontMetrics();
            int width = fm.stringWidth(this.infoLabel.getText()) + 5;
            y = (int)((double)this.getHeight() / 2.0 - this.infoSize.getHeight() / 2.0);
            this.cellRendererPane.paintComponent(g2d, (Component)this.infoLabel, (Container)((Object)this), x, y, width, this.infoSize.height);
        }
    }

    public void setShowRightIcon(boolean visible) {
        this.clearLabel.setVisible(visible);
    }

    private void paintClearLabel(Graphics2D g2d, int y) {
        if (!this.clearLabel.isVisible()) {
            return;
        }
        int x = this.getWidth() - this.searchIconSize.width - iconGap;
        this.cellRendererPane.paintComponent(g2d, (Component)this.clearLabel, (Container)((Object)this), x, y, this.searchIconSize.width, this.searchIconSize.height);
    }

    public Dimension getPreferredSize() {
        Insets s = super.getInsets();
        Insets t = this.getInsets();
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.setSize(preferredSize.width - (t.left + t.right - s.left - s.right), preferredSize.height + 2);
        return preferredSize;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        insets.left += this.searchIconSize.width + iconGap * 2;
        insets.right = this.clearLabel.isVisible() ? (insets.right += iconGap * 2 + this.searchIconSize.width) : (insets.right += iconGap);
        return insets;
    }

    public void setBoundLabelText(String labelText) {
        this.infoLabel.setText(labelText);
    }

    public void setIcon(ImageIcon icon) {
        this.searchLabel.setIcon((Icon)icon);
    }
}

