/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.ui.web20.statistics;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.machine.HardwareInfoCollector;
import com.kingdee.eas.base.uiframe.client.AboutInfoUtil;
import com.kingdee.eas.base.uiframe.client.LoginParamCacheUtil;
import com.kingdee.eas.base.uiframe.client.ui.web20.statistics.Web20ServiceState;
import com.kingdee.eas.base.uiframe.client.util.SendStatisticIdleListener;
import com.kingdee.eas.base.uiframe.utils.FileProcessUtil;
import com.kingdee.eas.base.uiframe.utils.StreamUtils;
import com.kingdee.eas.common.ContextManagerFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class StatisticsUtil {
    private static final String USER_ROLE_URL = "http://web20.kingdee.com/easlog/role/{0}/{1}/{2}";
    private static final String NO_USER_ROLE = "none";
    private static final String PUBLIC_USER_ROLE = "Normal";
    private static Logger logger = Logger.getLogger(StatisticsUtil.class);
    private static String requestPrefix;
    private static String kingdee;
    public static String web20Url;
    public static String web20UrlWhenLogin;
    private static String cachedUserId;
    private static String cachedEncodedUserId;
    private static String cachedEncodedSerialNumber;
    private static String cachedEncodedEASVersion;
    private static String cachedEncodedMac;
    private static String cachedEncodedIp;
    private static String cachedEncodedCloudHubUID;
    private static String cachedEncodedUserNickName;
    private static String cachedEncodedTimeZone;
    private static String cachedEncodedUserRole;
    private static int THRELSHOLD;

    public static String getWeb20Url() {
        return web20Url;
    }

    public static void setWeb20Url(String web20Url) {
        StatisticsUtil.web20Url = web20Url;
    }

    private static void clearCaches() {
        cachedUserId = null;
        cachedEncodedUserId = null;
        cachedEncodedSerialNumber = null;
        cachedEncodedEASVersion = null;
        cachedEncodedMac = null;
        cachedEncodedIp = null;
        cachedEncodedCloudHubUID = null;
        cachedEncodedUserNickName = null;
        cachedEncodedTimeZone = null;
        cachedEncodedUserRole = null;
    }

    private static void checkRelogin() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        if (userInfo == null) {
            return;
        }
        String userId = userInfo.getId().toString();
        if (!userId.equals(cachedUserId)) {
            StatisticsUtil.clearCaches();
        }
    }

    public static String getEncodedSerialNum() {
        String encodedSerialNumber;
        if (cachedEncodedSerialNumber != null) {
            return cachedEncodedSerialNumber;
        }
        String serialNumber = AboutInfoUtil.getSerialNum();
        if (serialNumber == null || serialNumber.isEmpty()) {
            serialNumber = "-1";
        }
        cachedEncodedSerialNumber = encodedSerialNumber = StatisticsUtil.urlEncodeUTF8(serialNumber);
        return encodedSerialNumber;
    }

    public static String getEncodedEASVersion() {
        String encodedEASVersion;
        if (cachedEncodedEASVersion != null) {
            return cachedEncodedEASVersion;
        }
        String easVersion = AboutInfoUtil.getEASversion();
        if (StringUtils.isEmpty((String)easVersion)) {
            return null;
        }
        easVersion = easVersion.replaceAll(" ", "");
        cachedEncodedEASVersion = encodedEASVersion = StatisticsUtil.urlEncodeUTF8(easVersion);
        return encodedEASVersion;
    }

    public static String getEncodedMac() {
        String encodedMac;
        if (cachedEncodedMac != null) {
            return cachedEncodedMac;
        }
        cachedEncodedMac = encodedMac = StatisticsUtil.urlEncodeUTF8(HardwareInfoCollector.getCollector().getMACAddress());
        return encodedMac;
    }

    public static String getEncodedIp() {
        String encodedIp;
        if (cachedEncodedIp != null) {
            return cachedEncodedIp;
        }
        Context context = ConfigMDUtil.getContextFromEnv();
        String ip = context.getClientHostIP();
        try {
            if (ip == null || ip.isEmpty()) {
                ip = InetAddress.getLocalHost().toString();
            }
        }
        catch (Exception e) {
            ip = "127.0.0.1";
        }
        cachedEncodedIp = encodedIp = StatisticsUtil.urlEncodeUTF8(ip);
        return encodedIp;
    }

    public static String getEncodedCloudHubUID() throws BOSException {
        String encodedCloudUserId;
        UserInfo userInfo;
        if (cachedEncodedCloudHubUID != null) {
            return cachedEncodedCloudHubUID;
        }
        String cloudUserId = (String)ContextManagerFactory.getRemoteInstance().getContext().get((Object)"cloudUserId");
        if ((cloudUserId == null || cloudUserId.isEmpty()) && (cloudUserId = (userInfo = SysContext.getSysContext().getCurrentUserInfo()).getUid()) == null) {
            cloudUserId = "-1";
        }
        cachedEncodedCloudHubUID = encodedCloudUserId = StatisticsUtil.urlEncodeUTF8(cloudUserId);
        return encodedCloudUserId;
    }

    public static String getEncodedUserId() {
        String encodedUserId;
        String userId;
        if (cachedEncodedUserId != null) {
            return cachedEncodedUserId;
        }
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        if (userInfo == null) {
            return null;
        }
        cachedUserId = userId = userInfo.getId().toString();
        cachedEncodedUserId = encodedUserId = StatisticsUtil.urlEncodeUTF8(userId);
        return encodedUserId;
    }

    public static String getEncodedUserNickName() {
        String encodedUserNickName;
        if (cachedEncodedUserNickName != null) {
            return cachedEncodedUserNickName;
        }
        String nickName = "unknown";
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        if (userInfo != null) {
            nickName = userInfo.getName();
        }
        cachedEncodedUserNickName = encodedUserNickName = StatisticsUtil.urlEncodeUTF8(nickName);
        return encodedUserNickName;
    }

    public static String getEncodedTimeZone() {
        String encodedTimeZone;
        if (cachedEncodedTimeZone != null) {
            return cachedEncodedTimeZone;
        }
        Calendar calendar = Calendar.getInstance();
        int offset = calendar.get(15);
        int hours = offset / 3600000;
        int minutes = offset % 3600000 / 60000;
        String gmt = String.format("GMT%s%02d:%02d", hours >= 0 ? "+" : "-", hours, minutes);
        cachedEncodedTimeZone = encodedTimeZone = StatisticsUtil.urlEncodeUTF8(gmt);
        return encodedTimeZone;
    }

    public static String getEncodedUserRole() {
        String encodedUserRole;
        if (cachedEncodedUserRole != null) {
            return cachedEncodedUserRole;
        }
        String role = StatisticsUtil.getUserRoleInputStream();
        cachedEncodedUserRole = encodedUserRole = StatisticsUtil.urlEncodeUTF8(role);
        return encodedUserRole;
    }

    private static String extractUIAndAction(String message) {
        int pos = message.indexOf(47);
        if (pos < 0) {
            return message;
        }
        String uiAndAction = message.substring(0, pos);
        if (uiAndAction.isEmpty()) {
            return "Unknown";
        }
        uiAndAction = uiAndAction.replace('\\', '.');
        return uiAndAction;
    }

    private static String extractTimeConsumption(String message) {
        int splitPos = message.indexOf(47);
        if (splitPos < 0) {
            return "0";
        }
        int startPos = splitPos + 1;
        int endPos = message.indexOf(47, splitPos + 1);
        if (endPos < 0) {
            endPos = message.length();
        }
        String timeConsumptionStr = message.substring(startPos, endPos);
        try {
            int timeConsumption = Integer.parseInt(timeConsumptionStr);
            if (timeConsumption >= 0) {
                return String.valueOf(timeConsumption);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserRoleInputStream() {
        InputStream l_urlStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader br = null;
        try {
            URL l_url = new URL(MessageFormat.format(USER_ROLE_URL, StatisticsUtil.getEncodedSerialNum(), StatisticsUtil.getEncodedEASVersion(), StatisticsUtil.getEncodedUserId()));
            HttpURLConnection l_connection = (HttpURLConnection)l_url.openConnection();
            l_connection.setConnectTimeout(5000);
            l_connection.connect();
            l_urlStream = l_connection.getInputStream();
            inputStreamReader = new InputStreamReader(l_urlStream, "UTF-8");
            br = new BufferedReader(inputStreamReader);
            StringBuffer sb = new StringBuffer();
            String line = null;
            do {
                sb.append((line = br.readLine()) == null ? "" : line);
            } while (null != line);
            String response = sb.toString();
            if (response == null || NO_USER_ROLE.equals(response)) {
                String string = PUBLIC_USER_ROLE;
                return string;
            }
            String string = "Normal," + response;
            return string;
        }
        catch (Throwable t) {
            t.printStackTrace();
            String string = PUBLIC_USER_ROLE;
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.error((Object)"stream close error!");
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException e) {
                    logger.error((Object)"stream close error!");
                }
            }
            if (l_urlStream != null) {
                try {
                    l_urlStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)"stream close error!");
                }
            }
        }
    }

    private static synchronized String getRequestPrefix() {
        try {
            SendStatisticIdleListener.initRequestPrefix();
            String userId = StatisticsUtil.getEncodedUserId();
            StringBuffer sb = new StringBuffer();
            logger.info((Object)("web20Url:" + web20Url));
            sb.append(web20Url);
            sb.append("/");
            sb.append(StatisticsUtil.getEncodedSerialNum());
            sb.append("/");
            sb.append(StatisticsUtil.getEncodedEASVersion());
            sb.append("/");
            sb.append(userId);
            requestPrefix = sb.toString();
        }
        catch (Throwable t) {
            logger.error((Object)"", t);
        }
        return requestPrefix;
    }

    public static void send(final int level, final String message) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    StatisticsUtil.sendInner(level, StatisticsUtil.getTrimMessage(message));
                }
                catch (Throwable t) {
                    logger.warn((Object)"\u5f02\u6b65\u8c03\u7528\u7684\u5f02\u5e38,\u5fc5\u987bhold\u4f4f", t);
                    Web20ServiceState.fail();
                }
            }
        }).start();
    }

    public static void sendSynch(int level, String message) {
        try {
            StatisticsUtil.sendInner(level, StatisticsUtil.getTrimMessage(message));
        }
        catch (Throwable t) {
            logger.warn((Object)"\u5f02\u6b65\u8c03\u7528\u7684\u5f02\u5e38,\u5fc5\u987bhold\u4f4f", t);
            Web20ServiceState.fail();
        }
    }

    private static String getTrimMessage(String message) {
        String trimedMessage = message;
        if (message != null && message.startsWith(kingdee)) {
            trimedMessage = message.substring(kingdee.length());
        }
        return trimedMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int getLevelThreshold() {
        int n;
        if (THRELSHOLD < 100) {
            return THRELSHOLD;
        }
        InputStream is = null;
        try {
            URL url = new URL(StatisticsUtil.getRequestPrefix());
            URLConnection con = url.openConnection();
            is = con.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String ret = br.readLine();
            n = THRELSHOLD = Integer.parseInt(ret);
        }
        catch (Throwable e) {
            try {
                logger.error((Object)e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                StreamUtils.closeStream(is);
            }
        }
        StreamUtils.closeStream(is);
        return n;
        THRELSHOLD = 10;
        return THRELSHOLD;
    }

    public static boolean isNeedSendCloud() {
        return StatisticsUtil.getLevelThreshold() >= 10;
    }

    public static boolean isNeedSendWeb20(int level) {
        if (StatisticsUtil.getLevelThreshold() < 10) {
            return level < StatisticsUtil.getLevelThreshold();
        }
        return level < StatisticsUtil.getLevelThreshold() - 10;
    }

    private static void saveData(String message) {
        boolean needAdd = false;
        String preData = StatisticsUtil.getEncodedSerialNum() + "/" + StatisticsUtil.getEncodedEASVersion() + "/" + StatisticsUtil.getEncodedUserId();
        try {
            Calendar cl = Calendar.getInstance();
            int year = cl.get(1);
            int month = cl.get(2) + 1;
            int day = cl.get(5);
            String nowDate = String.valueOf(year) + String.valueOf(month) + String.valueOf(day);
            String filePath = System.getProperty("EAS_HOME") + File.separator + "client" + File.separator + "temporary" + File.separator + "userData";
            File fileDir = new File(filePath);
            if (!fileDir.exists()) {
                fileDir.mkdirs();
            }
            File file = new File(filePath + File.separator + nowDate + ".properties");
            String[] msg = message.split("/");
            String realData = null;
            if (!file.exists()) {
                needAdd = false;
                file.createNewFile();
            } else {
                Map<String, String> map = FileProcessUtil.readProperties(filePath + File.separator + nowDate + ".properties");
                if (map.containsKey(msg[0])) {
                    needAdd = true;
                    realData = map.get(msg[0]);
                }
            }
            HashMap<String, String> paramDataMap = new HashMap<String, String>();
            if (needAdd) {
                realData = FileProcessUtil.processData(realData, message);
                paramDataMap.put(msg[0], realData);
                FileProcessUtil.writeProperties(filePath + File.separator + nowDate + ".properties", paramDataMap);
            } else {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                String date = format.format(new Date());
                realData = preData + "/" + 1 + "/" + message + "/" + msg[1] + "/" + msg[1] + "/" + date;
                paramDataMap.put(msg[0], realData);
                FileProcessUtil.writeProperties(filePath + File.separator + nowDate + ".properties", paramDataMap);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    private static boolean sendInner(int level, String message) {
        if ("true".equals(System.getProperty("COLLECT_BEHAVIOR_DATA")) && level == 3) {
            StatisticsUtil.saveData(message);
        }
        if (!LoginParamCacheUtil.isEnableWeb20()) {
            return false;
        }
        if (Web20ServiceState.isClosed()) {
            if (level == 3) {
                StatisticsUtil.saveData(message);
            }
            return false;
        }
        StatisticsUtil.checkRelogin();
        String encodedUserId = StatisticsUtil.getEncodedUserId();
        if (encodedUserId == null || encodedUserId.isEmpty()) {
            return false;
        }
        try {
            SendStatisticIdleListener.initRequestPrefix();
            String encodedSerialNum = StatisticsUtil.getEncodedSerialNum();
            String encodedEASVersion = StatisticsUtil.getEncodedEASVersion();
            String encodedIP = null;
            String encodedCloudHubUID = null;
            String encodedUserRole = StatisticsUtil.getEncodedUserRole();
            String type = String.valueOf(level);
            String encodedMessage = StatisticsUtil.urlEncodeUTF8(StatisticsUtil.extractUIAndAction(message));
            String timeConsumption = StatisticsUtil.urlEncodeUTF8(StatisticsUtil.extractTimeConsumption(message));
            String encodedNickName = null;
            String encodedTimeZone = null;
            StringBuffer request = new StringBuffer();
            request.append(StatisticsUtil.getWeb20Url());
            request.append("/");
            request.append(encodedSerialNum);
            request.append("/");
            request.append(encodedEASVersion);
            request.append("/");
            if ("1".equals(type)) {
                request.append(type);
                request.append("/");
                if (message.contains(",")) {
                    String[] split = message.split(",");
                    request.append(split[1]);
                    request.append("/");
                    request.append(split[0]);
                }
            } else {
                request.append(encodedIP);
                request.append("/");
                request.append(encodedCloudHubUID);
                request.append("/");
                request.append(encodedUserRole);
                request.append("/");
                request.append(type);
                request.append("/");
                request.append(encodedMessage);
                request.append("/");
                request.append(timeConsumption);
                request.append("/");
                request.append(encodedNickName);
                request.append("/");
                request.append(encodedTimeZone);
            }
            logger.info((Object)("+++send web20  request:" + request));
            URL url = new URL(request.toString());
            URLConnection conn = url.openConnection();
            InputStream is = conn.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuffer sb = new StringBuffer();
            String line = null;
            do {
                sb.append((line = br.readLine()) == null ? "" : line);
            } while (null != line);
            String response = sb.toString();
            return true;
        }
        catch (Throwable t) {
            Web20ServiceState.fail();
            if (level == 3) {
                StatisticsUtil.saveData(message);
            }
            return false;
        }
    }

    public static void sendWhenLogin() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    StatisticsUtil.doSendWhenLogin();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doSendWhenLogin() {
        InputStream is = null;
        BufferedReader br = null;
        try {
            String line;
            StatisticsUtil.clearCaches();
            String userId = StatisticsUtil.getEncodedUserId();
            if (StringUtils.isEmpty((String)userId)) {
                return;
            }
            String cloudUserId = StatisticsUtil.getEncodedCloudHubUID();
            StringBuffer theRequest = new StringBuffer(web20UrlWhenLogin);
            theRequest.append("/cloud/passport");
            theRequest.append("/");
            theRequest.append(StatisticsUtil.getEncodedSerialNum());
            theRequest.append("/");
            theRequest.append(StatisticsUtil.getEncodedEASVersion());
            theRequest.append("/");
            theRequest.append(userId);
            URL url = new URL(theRequest.toString());
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(5000);
            is = conn.getInputStream();
            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuffer sb = new StringBuffer();
            do {
                sb.append((line = br.readLine()) == null ? "" : line);
            } while (null != line);
        }
        catch (Throwable t) {
            logger.error((Object)"sendWhenLogin", t);
            Web20ServiceState.fail();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
        }
    }

    private static String urlEncodeUTF8(String str) {
        try {
            if (str.contains("/")) {
                str = str.replaceAll("\\/", "-=*");
            }
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (Exception e) {
            logger.error((Object)e);
            return str;
        }
    }

    public static String urlEncode(String str) {
        StringBuffer ret = new StringBuffer();
        try {
            if (str.indexOf("/") >= 0) {
                String[] splits = str.split("/");
                int size = splits.length;
                for (int i = 0; i < size; ++i) {
                    ret.append(URLEncoder.encode(splits[i], "utf-8"));
                    if (i >= size - 1) continue;
                    ret.append("/");
                }
            } else {
                ret.append(URLEncoder.encode(str, "utf-8"));
            }
            return ret.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "URLEncoder Error";
        }
    }

    static {
        kingdee = "com.kingdee.";
        web20Url = "http://web20.kingdee.com/easlog";
        web20UrlWhenLogin = "http://web20.kingdee.com";
        THRELSHOLD = 100;
    }
}

