/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.log.IStatisticFacade;
import com.kingdee.eas.base.log.StatisticFacadeFactory;
import com.kingdee.eas.base.uiframe.IMainFrameServiceFacade;
import com.kingdee.eas.base.uiframe.MainFrameServiceFacadeFactory;
import com.kingdee.eas.base.uiframe.client.ui.web20.statistics.StatisticsUtil;
import com.kingdee.eas.base.uiframe.client.ui.web20.statistics.Web20ServiceState;
import com.kingdee.eas.base.uiframe.client.util.CloudUtil;
import com.kingdee.eas.base.usermonitor.client.IIdleListener;
import com.kingdee.eas.fm.common.FMCommonFacadeFactory;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class SendStatisticIdleListener
implements IIdleListener {
    private static final Logger logger = Logger.getLogger(SendStatisticIdleListener.class);
    public static String easClientHome = System.getProperty("EAS_HOME");
    public static String easClientPath = easClientHome + File.separator + "client";
    public static String easClientTempPath = easClientPath + File.separator + "temporary";
    private static String customerID = "unknown";
    private static String productVersion = "unknown";
    private static String patchFileName = "systemInfo";
    private static String patchFileFullPath = easClientTempPath + File.separator + patchFileName;
    public static String easClientInatanceInfo = easClientPath + File.separator + "logs" + File.separator + "downrecord";
    private static boolean isDone = false;
    private static boolean isSend = false;
    private static String requestPrefix;
    private static int count;
    private static String SEPARATOR1;
    private static String SEPARATOR2;
    private static String SEPARATOR3;
    private static String SEPARATOR4;
    private static final String CHARSET = "utf-8";
    private static final String MSG = "msg";
    private static int NORMAL_STATUS;
    private static String STRATEGY;

    public void doIdleThing() {
        if (!SendStatisticIdleListener.isRightTime()) {
            return;
        }
        try {
            if (!isDone) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SendStatisticIdleListener.handleServerInfo();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
                isDone = true;
            }
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
        }
    }

    public static synchronized void handleServerInfo() {
        try {
            String serverInfo = SendStatisticIdleListener.getServerInfo();
            if (serverInfo.length() > 0) {
                SendStatisticIdleListener.sendServerInfoToWeb20(serverInfo);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"", t);
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            Date today = new Date();
            today = sdf.parse(sdf.format(today));
            calendar.setTime(today);
            calendar.set(2, calendar.get(2) - 1);
            Date beforeDate = calendar.getTime();
            beforeDate = sdf.parse(sdf.format(beforeDate));
            Map map = FMCommonFacadeFactory.getRemoteInstance().sendFmLog(beforeDate, today);
            JSONObject objectJson = new JSONObject();
            objectJson.put("jsons", (Object)map);
            String str = objectJson.toJSONString();
            String prefix = SendStatisticIdleListener.getInstanceInfoRequestPrefix1();
            StringBuffer infoUrl = new StringBuffer();
            infoUrl.append(prefix);
            SendStatisticIdleListener.sendToweb20Post(infoUrl.toString() + "initData/ttt/", str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendToweb20Post(String url, String data) {
        if (url == null || "".equals(url)) {
            url = "http://web20.kingdee.com/easlog/initData/ttt/";
        }
        CloseableHttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            HttpEntity resEntity;
            httpPost = new HttpPost(url);
            httpClient = HttpClientBuilder.create().build();
            int timeout = Integer.parseInt("100000");
            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
            httpPost.setConfig(config);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("jsons", data));
            UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(params, "UTF-8");
            httpPost.setEntity((HttpEntity)httpEntity);
            System.out.println("httpPost.getEntity()===" + httpPost.getEntity());
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
                System.out.println(result);
            }
        }
        catch (ConnectTimeoutException e) {
            e.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTestPatchInfo() {
        BufferedInputStream bis = null;
        StringBuilder sb = new StringBuilder();
        try {
            bis = new BufferedInputStream(new GZIPInputStream(new FileInputStream(patchFileFullPath)));
            byte[] bs = new byte[1024];
            int byteRead = 0;
            while ((byteRead = bis.read(bs)) != -1) {
                sb.append(new String(bs, 0, byteRead, CHARSET));
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return sb.toString();
    }

    private static int getSendFrequence() throws Exception {
        IMainFrameServiceFacade facade = MainFrameServiceFacadeFactory.getRemoteInstance();
        return facade.getSendFrequence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleInstanceInfo() throws Exception {
        String path;
        File file;
        IMainFrameServiceFacade facade = MainFrameServiceFacadeFactory.getRemoteInstance();
        byte[] instanceInfoBytes = facade.getInstanceNum();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        Date date = new Date();
        String currentdate = dateFormat.format(date);
        String freDate = currentdate + ".trace";
        File fileDir = new File(easClientInatanceInfo);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        if (!(file = new File(path = easClientInatanceInfo + File.separator + freDate)).exists()) {
            file.createNewFile();
        } else {
            file.delete();
        }
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(file, true));
            os.write(instanceInfoBytes);
            os.flush();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        }
        List list = SendStatisticIdleListener.getClientInstanceInfo();
        if (list.size() != 0) {
            SendStatisticIdleListener.sendInstanceInfo2web20();
        }
    }

    private static void sendInstanceInfo2web20() {
        List list = SendStatisticIdleListener.getClientInstanceInfo();
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                String s = (String)list.get(i);
                String lastInfo = SendStatisticIdleListener.sendInstanceInfo2web20(s);
                SendStatisticIdleListener.sendToweb20(lastInfo);
            }
        }
    }

    private static String parseServerInfo(String url) {
        String[] split;
        if (url.contains("||") && (split = url.split("\\|\\|")).length == 7) {
            String dbTypes = "";
            if (split[4].contains(SEPARATOR3)) {
                String[] split2 = split[4].split(SEPARATOR3);
                for (int i = 0; i < split2.length; ++i) {
                    String type = split2[i].split(SEPARATOR1)[0];
                    if (dbTypes.contains(type)) continue;
                    dbTypes = dbTypes + type + (i == split2.length - 1 ? "" : SEPARATOR3);
                }
            } else {
                dbTypes = dbTypes + split[4].split(SEPARATOR1)[0];
            }
            url = split[0] + SEPARATOR2 + split[1] + SEPARATOR2 + dbTypes + SEPARATOR2 + split[5];
        }
        return url;
    }

    private static String getServerInfo() throws Exception {
        IMainFrameServiceFacade facade = MainFrameServiceFacadeFactory.getRemoteInstance();
        String serverInfo = facade.getServiceUrl();
        if (serverInfo.length() > 0) {
            return SendStatisticIdleListener.parseServerInfo(serverInfo);
        }
        return "";
    }

    private static synchronized String getInstanceInfoRequestPrefix() {
        try {
            SendStatisticIdleListener.initRequestPrefix();
            String serverIP = StatisticsUtil.getEncodedIp();
            StringBuffer sb = new StringBuffer();
            sb.append(StatisticsUtil.getWeb20Url());
            sb.append("/");
            sb.append(StatisticsUtil.getEncodedSerialNum());
            sb.append("/");
            sb.append(serverIP);
            requestPrefix = sb.toString();
        }
        catch (Throwable t) {
            logger.error((Object)"", t);
        }
        return requestPrefix;
    }

    private static synchronized String getInstanceInfoRequestPrefix1() {
        try {
            SendStatisticIdleListener.initRequestPrefix();
            String serverIP = StatisticsUtil.getEncodedIp();
            StringBuffer sb = new StringBuffer();
            sb.append(StatisticsUtil.getWeb20Url());
            sb.append("/");
            requestPrefix = sb.toString();
        }
        catch (Throwable t) {
            logger.error((Object)"", t);
        }
        return requestPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendToweb20(String info) {
        if (info == null) {
            return;
        }
        String prefix = SendStatisticIdleListener.getInstanceInfoRequestPrefix();
        StringBuffer infoUrl = new StringBuffer();
        infoUrl.append(prefix);
        infoUrl.append("/");
        infoUrl.append(info);
        InputStream is = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader br = null;
        try {
            URL url = new URL(infoUrl.toString());
            URLConnection conn = url.openConnection();
            conn.connect();
            is = conn.getInputStream();
            inputStreamReader = new InputStreamReader(is, "UTF-8");
            br = new BufferedReader(inputStreamReader);
            StringBuffer sb = new StringBuffer();
            String line = null;
            do {
                sb.append((line = br.readLine()) == null ? "" : line);
            } while (null != line);
        }
        catch (Throwable t) {
            Web20ServiceState.fail();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
        }
    }

    public static String sendInstanceInfo2web20(String ss) {
        String SYMBOL = "/";
        String START = "starting";
        String STOP = "stopped";
        String AUTO = "Auto";
        String YES = "yes";
        String NO = "no";
        String STARTCLUSTER = "startCluster";
        String KILLCLUSTER = "killCluter";
        String result = null;
        if (ss.isEmpty()) {
            return null;
        }
        String[] split = ss.split(" ");
        if (ss.contains(START) && split.length > 4) {
            result = START + SYMBOL + split[1] + SYMBOL + split[2] + SYMBOL + split[3] + SYMBOL + split[4] + SYMBOL + 10 + SYMBOL + 0 + SYMBOL + 0 + SYMBOL + 0 + SYMBOL + 0;
        } else if (ss.contains(STOP) && split.length > 4) {
            result = STOP + SYMBOL + split[1] + SYMBOL + split[2] + SYMBOL + split[3] + SYMBOL + split[4] + SYMBOL + 10 + SYMBOL + 0 + SYMBOL + 0 + SYMBOL + 0 + SYMBOL + 0;
        } else if (ss.contains(STARTCLUSTER)) {
            result = STARTCLUSTER + SYMBOL + split[1] + SYMBOL + split[2] + SYMBOL + split[3] + SYMBOL + 10 + SYMBOL + 0 + SYMBOL + 0 + SYMBOL + 0 + SYMBOL + 0;
        } else if (ss.contains(KILLCLUSTER)) {
            result = KILLCLUSTER + SYMBOL + split[1] + SYMBOL + split[2] + SYMBOL + split[3] + SYMBOL + 10 + SYMBOL + 0 + SYMBOL + 0 + SYMBOL + 0 + SYMBOL + 0;
        } else {
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getClientInstanceInfo() {
        String userDataFileFullPath;
        File datefile;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        Date date = new Date();
        String freDate = dateFormat.format(date);
        File fileDir = new File(easClientInatanceInfo);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        if (!(datefile = new File(userDataFileFullPath = easClientInatanceInfo + File.separator + freDate + ".trace")).exists()) {
            try {
                datefile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        InputStreamReader read = null;
        try {
            read = new InputStreamReader((InputStream)new FileInputStream(datefile), CHARSET);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        ArrayList<String> list = new ArrayList<String>();
        String text = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(read);
            while ((text = bufferedReader.readLine()) != null) {
                list.add(text);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            try {
                if (read != null) {
                    read.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendServerInfoToWeb20(String serverInfo) {
        String[] split;
        String web20Url = StatisticsUtil.web20Url;
        String serialNum = StatisticsUtil.getEncodedSerialNum();
        String version = StatisticsUtil.getEncodedEASVersion();
        StringBuffer request = new StringBuffer();
        request.append(web20Url);
        request.append(SEPARATOR4);
        request.append(serialNum);
        request.append(SEPARATOR4);
        request.append(version);
        request.append(SEPARATOR4);
        if (serverInfo.contains(SEPARATOR2) && (split = serverInfo.split(SEPARATOR2)).length == 4) {
            request.append(split[0]);
            request.append(SEPARATOR4);
            request.append(split[1]);
            request.append(SEPARATOR4);
            request.append(split[2]);
            request.append(SEPARATOR4);
            request.append(split[3]);
        }
        logger.info((Object)("+++sendServerInfoToWeb20  request:" + request));
        InputStream is = null;
        try {
            URL url = new URL(request.toString());
            URLConnection conn = url.openConnection();
            is = conn.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuffer sb = new StringBuffer();
            String line = null;
            do {
                sb.append((line = br.readLine()) == null ? "" : line);
            } while (null != line);
            String string = sb.toString();
        }
        catch (Exception e) {
            logger.warn((Object)("sendServerInfoToWeb20 warn " + e.getMessage()));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.warn((Object)("InputStream closed failed " + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean isRightTime() {
        Calendar now = Calendar.getInstance();
        return now.get(4) == 4 && now.get(11) == 15;
    }

    private static boolean isInstanceTime() {
        Calendar now = Calendar.getInstance();
        return now.get(11) == 18;
    }

    public static void handleStatisticData() {
        try {
            IStatisticFacade statisticFacade = StatisticFacadeFactory.getRemoteInstance();
            Map statisticData = statisticFacade.getStatisticData(SendStatisticIdleListener.getLogStrategy());
            Iterator keyItr = statisticData.keySet().iterator();
            int allStatus = 0;
            while (keyItr.hasNext()) {
                String date = StringUtils.cnulls(keyItr.next());
                String fileName = date.substring(0, 10);
                String data = StringUtils.cnulls(statisticData.get(date));
                String filePath = easClientTempPath + File.separator + fileName;
                SendStatisticIdleListener.zipDataToFile(filePath, data);
                int status = SendStatisticIdleListener.sendData(filePath);
                allStatus += status;
            }
            int size = statisticData.size();
            if (size > 0 && allStatus == NORMAL_STATUS * size) {
                statisticFacade.deleteData();
            }
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
        }
    }

    private static String getLogStrategy() {
        if (STRATEGY != null) {
            return STRATEGY;
        }
        STRATEGY = CloudUtil.getSendPeriod();
        return STRATEGY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int sendData(String filePath) {
        logger.info((Object)"send by zip file");
        HttpClient http = new HttpClient();
        String url = "http://patch.cmcloud.cn/logArrayGZ.do";
        PostMethod filePost = null;
        int status = 0;
        try {
            filePost = new PostMethod(url);
            File f = new File(filePath);
            FilePart filePart = new FilePart("text", f);
            String guid = String.valueOf(System.currentTimeMillis());
            logger.info((Object)("guid:" + guid));
            Part[] parts = new Part[]{new StringPart("guid", guid), filePart};
            filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
            status = http.executeMethod((HttpMethod)filePost);
            logger.info((Object)("SendStatisticIdleListener sendData:status:" + status));
            String response = new String(filePost.getResponseBodyAsString().getBytes(CHARSET));
            logger.info((Object)("SendStatisticIdleListener sendData:response:" + response));
            filePost.releaseConnection();
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
        }
        finally {
            filePost.releaseConnection();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int sendStringData(String data) {
        HttpClient http = new HttpClient();
        String url = "http://patch.cmcloud.cn/logArray.do";
        UTF8PostMethod filePost = null;
        int status = 0;
        try {
            filePost = new UTF8PostMethod(url);
            String guid = String.valueOf(System.currentTimeMillis());
            logger.info((Object)("guid:" + guid));
            NameValuePair[] nameValuePairs = new NameValuePair[]{new NameValuePair("guid", guid), new NameValuePair("text", data)};
            filePost.setRequestBody(nameValuePairs);
            status = http.executeMethod((HttpMethod)filePost);
            logger.info((Object)("SendStatisticIdleListener sendData:status:" + status));
            String response = new String(filePost.getResponseBodyAsString().getBytes(CHARSET));
            logger.info((Object)("SendStatisticIdleListener sendData:response:" + response));
            filePost.releaseConnection();
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
        }
        finally {
            filePost.releaseConnection();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipDataToFile(String filePath, String data) {
        FileOutputStream fos = null;
        DeflaterOutputStream gos = null;
        try {
            fos = new FileOutputStream(filePath);
            gos = new GZIPOutputStream(fos);
            gos.write(data.getBytes(CHARSET));
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
        }
        finally {
            if (gos != null) {
                try {
                    gos.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserBehaviorData() {
        logger.info((Object)"start getUserBehaviorData....");
        BufferedInputStream bis = null;
        StringBuilder dataInfo = new StringBuilder();
        try {
            Calendar cl = Calendar.getInstance();
            cl.set(5, cl.get(5) - 1);
            int year = cl.get(1);
            int month = cl.get(2) + 1;
            int day = cl.get(5);
            String freDate = String.valueOf(year) + String.valueOf(month) + String.valueOf(day);
            logger.info((Object)freDate);
            String userDataFileFullPath = easClientHome + "/client/temporary/userData/" + freDate + ".properties";
            logger.info((Object)userDataFileFullPath);
            File datefile = new File(userDataFileFullPath);
            if (!datefile.exists()) {
                String string = null;
                return string;
            }
            int size = 1024;
            byte[] b = new byte[size];
            bis = new BufferedInputStream(new FileInputStream(userDataFileFullPath));
            int byteRead = 0;
            while ((byteRead = bis.read(b)) != -1) {
                dataInfo.append(new String(b, 0, byteRead));
            }
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return dataInfo.toString();
    }

    public static void saveUserDataToServer() {
        try {
            String data = SendStatisticIdleListener.getUserBehaviorData();
            logger.info((Object)"get userdata file successed!");
            if (data == null) {
                return;
            }
            IMainFrameServiceFacade facade = MainFrameServiceFacadeFactory.getRemoteInstance();
            facade.saveUserBehaviorData(data.getBytes());
            SendStatisticIdleListener.deleteFile();
            logger.info((Object)"delete file successed!");
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
        }
    }

    public static void deleteFile() throws Exception {
        Calendar cl = Calendar.getInstance();
        cl.set(5, cl.get(5) - 1);
        int year = cl.get(1);
        int month = cl.get(2) + 1;
        int day = cl.get(5);
        String freDate = String.valueOf(year) + String.valueOf(month) + String.valueOf(day);
        String userDataFileFullPath = easClientHome + "/client/temporary/userData/" + freDate + ".properties";
        File datefile = new File(userDataFileFullPath);
        if (datefile.exists()) {
            datefile.delete();
        }
    }

    public static void initRequestPrefix() {
        try {
            String serviceUrl = StatisticsUtil.web20UrlWhenLogin;
            if (serviceUrl.length() > 0) {
                StatisticsUtil.setWeb20Url(serviceUrl + "/easlog");
            }
        }
        catch (Throwable t) {
            logger.error((Object)"", t);
        }
    }

    static {
        count = 0;
        SEPARATOR1 = " :";
        SEPARATOR2 = ";#;";
        SEPARATOR3 = ",";
        SEPARATOR4 = "/";
        try {
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            customerID = baseInfo.getSerialNum();
            productVersion = baseInfo.getVersion();
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
        }
        NORMAL_STATUS = 200;
        STRATEGY = null;
    }

    public static class UTF8PostMethod
    extends PostMethod {
        public UTF8PostMethod(String url) {
            super(url);
        }

        public String getRequestCharSet() {
            return SendStatisticIdleListener.CHARSET;
        }
    }
}

