/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.base.xtsync.xtutil.StringUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.sso.util.TransferUtil;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;

public class XiaoYunUtil {
    private static Logger logger = Logger.getLogger(XiaoYunUtil.class);
    public static final String URL_EASKSM = "http://easksm.kingdee.com";
    public static final String URL_KSM4EAS2 = "http://easksm.kingdee.com/ksm4eas2.action";
    public static final String EAS_SOURCE = "eas";
    public static final String key = "fsdoijflajdif";
    private static final String ENCODE = "utf-8";
    private static boolean isKsmConnect = false;

    public static boolean isKsmConnect() {
        isKsmConnect = XiaoYunUtil.checkUrlEasKsm();
        return isKsmConnect;
    }

    public static boolean checkUrlEasKsm() {
        boolean flag = XiaoYunUtil.checkUrlEasKsmWithoutTip();
        if (!flag) {
            MsgBox.showWarning((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53ef\u4ee5\u8fde\u63a5\nhttp://easksm.kingdee.com");
        }
        return flag;
    }

    public static boolean checkUrlEasKsmWithoutTip() {
        boolean flag = false;
        try {
            URL url = new URL(URL_EASKSM);
            HttpURLConnection oc = (HttpURLConnection)url.openConnection();
            oc.setUseCaches(false);
            oc.setConnectTimeout(2000);
            oc.setReadTimeout(2000);
            int state = oc.getResponseCode();
            if (state == 200) {
                flag = true;
            }
        }
        catch (IOException e) {
            flag = false;
        }
        return flag;
    }

    public static String getUrlKsm4Eas2(String productCode, String userId, String userNumber, String email, String telephone, String username, String yzjAccount, String yzjAccessToken) throws Exception {
        String token;
        long timestamp = System.currentTimeMillis();
        StringBuffer sha1Param = new StringBuffer();
        sha1Param.append(productCode);
        sha1Param.append(userId);
        sha1Param.append(userNumber);
        sha1Param.append(key);
        sha1Param.append(timestamp);
        try {
            token = TransferUtil.sha1((String)sha1Param.toString());
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
        StringBuffer bf = new StringBuffer();
        bf.append("http://easksm.kingdee.com/ksm4eas2.action?username=").append(URLEncoder.encode(username, ENCODE)).append("&ts=").append(timestamp).append("&token=").append(token).append("&productCode=").append(productCode).append("&userId=").append(URLEncoder.encode(userId, ENCODE)).append("&account=").append(userNumber);
        if (!StringUtils.isEmpty((String)telephone)) {
            bf.append("&telephone=").append(telephone);
        }
        if (!StringUtils.isEmpty((String)email)) {
            bf.append("&email=").append(email);
        }
        if (!StringUtils.isEmpty((String)yzjAccount) && !StringUtils.isEmpty((String)yzjAccessToken)) {
            bf.append("&yzjAccount=").append(yzjAccount).append("&yzjAccessToken=").append(yzjAccessToken);
        }
        return bf.toString();
    }

    public static JSONObject doGet(String url, String param) throws Exception {
        StringBuffer result = new StringBuffer();
        BufferedReader in = null;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpGet hg = new HttpGet(url + "?" + param);
        try {
            String line;
            HttpResponse res = httpClient.execute((HttpUriRequest)hg);
            HttpEntity entity = res.getEntity();
            in = new BufferedReader(new InputStreamReader(entity.getContent(), ENCODE));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        String s = new String(result.toString().getBytes(ENCODE), ENCODE);
        int beginIndex = s.indexOf("jsonpcallback(") + 14;
        int endIndex = s.lastIndexOf(")");
        return JSONObject.parseObject((String)s.substring(beginIndex, endIndex));
    }

    public static void openKsm4Eas() {
        if (!XiaoYunUtil.isKsmConnect()) {
            return;
        }
        try {
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            String productCode = baseInfo.getSerialNum();
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            UserInfo userInfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(user.getId()));
            String userNumber = userInfo.getNumber();
            String userId = userInfo.getId().toString();
            String email = userInfo.getEmail();
            String telephone = userInfo.getCell();
            String uId = userInfo.getUid();
            String userName = userInfo.getName();
            if (uId == null) {
                MsgBox.showWarning((String)"\u65e0\u91d1\u8776\u4e91\u901a\u884c\u8bc1\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u7533\u8bf7\u4e91\u901a\u884c\u8bc1");
                return;
            }
            String prod_inst_code = baseInfo.getProductInstanceID();
            if (prod_inst_code == null) {
                MsgBox.showWarning((String)"\u4ea7\u54c1\u5b9e\u4f8b\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
                return;
            }
            JSONObject o = EasCloud.cloudErpAccessToken(uId, prod_inst_code);
            if (o.getInteger("errcode") == 0) {
                JSONObject data = JSONObject.parseObject((String)o.getString("data"));
                String yzjAccessToken = data.getString("access_token");
                String yzjAccount = null;
                String sql = "select fcell as cell from t_pm_easxtusermap where fuserid = '" + userId + "'";
                SQLExecutor se = new SQLExecutor(sql);
                IRowSet rows = se.executeSQL();
                while (rows.next()) {
                    yzjAccount = rows.getString("cell");
                }
                if (StringUtil.isEmpty(yzjAccount)) {
                    MsgBox.showWarning((String)"\u7ed1\u5b9a\u4e91\u4e4b\u5bb6\u8d26\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5");
                    return;
                }
                String ksm4Eas2 = XiaoYunUtil.getUrlKsm4Eas2(productCode, userId, userNumber, email, telephone, userName, yzjAccount, yzjAccessToken);
                logger.info((Object)("ksm4Eas2:" + ksm4Eas2));
                FrameWorkUtils.openByDefaultBrowser((String)ksm4Eas2);
            } else {
                String description = o.getString("description_cn");
                if (StringUtil.isEmpty((String)description)) {
                    description = o.getString("description");
                }
                logger.error((Object)("Failed to get AccessToken. " + o));
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            if (RPCException.getErrorCode((Throwable)e1) == 500) {
                MsgBox.showWarning((String)"\u4e0e\u7cfb\u7edf\u7684\u8fde\u63a5\u5df2\u4e2d\u65ad\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u7cfb\u7edf");
            }
            MsgBox.showWarning((String)"Failed to open XiaoYun,please check the logs");
        }
    }
}

