/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.patch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.uiframe.patch.IPushPatchFacade;
import com.kingdee.eas.base.uiframe.patch.RemotePatch;
import com.kingdee.eas.base.uiframe.patch.service.PatchInterfaceImpl;
import com.kingdee.eas.base.uiframe.patch.service.SQLUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PushPatchFacade
implements IPushPatchFacade {
    private final Context ctx;
    private static Logger logger = Logger.getLogger(PushPatchFacade.class);
    private static final String AdministratorId = "00000000-0000-0000-0000-00000000000013B7DE7F";

    public PushPatchFacade(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void dealWithPatch(RemotePatch remotePatch) throws BOSException {
        PatchInterfaceImpl.processPatch(this.ctx, remotePatch);
    }

    @Override
    public void updateMessageId(String id, String msgId) throws BOSException {
        String usql = "update t_bd_patch set fmessageid=?  where fid = ?";
        int[] utypes = new int[]{SQLType.VARCHAR.getSQLType(), SQLType.VARCHAR.getSQLType()};
        Object[] uparams = new Object[]{msgId, id};
        SQL.executeUpdate((Context)this.ctx, (String)usql, (int[])utypes, (Object[])uparams);
    }

    @Override
    public Map<String, Object> returnPatchInfo() {
        return PatchInterfaceImpl.returnPatchInfo(this.ctx);
    }

    @Override
    public boolean isNeedAccessRemote() {
        return PatchInterfaceImpl.isNeedAccessRemote(this.ctx);
    }

    @Override
    public String saveNoticeMsg(String ais, String sessionId, Map<Locale, String> senderMap, Map<Locale, String> msgTopicMap, Map<Locale, String> msgContentMap) throws EASBizException, BOSException {
        SenderAgent senderAgent;
        SessionInfo session = SessionManager.getInstance().getSession(sessionId);
        Context context = null;
        if (session != null) {
            context = session.getContext();
        }
        Message stopMessage = this.createMessage(context, sessionId, senderMap, msgTopicMap, msgContentMap);
        if (context == null) {
            stopMessage.setStringHeader("databaseCenter", ais);
            stopMessage.setStringHeader("solution", "eas");
        }
        if ((senderAgent = SenderAgent.getSenderAgent()).getState() != 1) {
            senderAgent.start();
        }
        senderAgent.sendMessage(stopMessage);
        return stopMessage.getMessageID();
    }

    private Message createMessage(Context context, String sessionid, Map senderMap, Map msgTopicMap, Map msgContentMap) {
        Message message = MessageFactory.newMessage((String)"kingdee.usermonitor");
        if (context != null) {
            message.setStringHeader("databaseCenter", context.getAIS());
            message.setStringHeader("solution", context.getSolution());
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 10);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 20);
        LanguageInfo[] allLanguage = MutilLangeToolForParam.getLanuageInfo();
        for (int i = 0; i < allLanguage.length; ++i) {
            Locale curLocale = allLanguage[i].getLocale();
            message.setLocaleStringHeader("title", StringUtils.cnulls(msgTopicMap.get(curLocale)), curLocale);
            message.setLocaleStringHeader("body", StringUtils.cnulls(msgContentMap.get(curLocale)), curLocale);
            message.setLocaleStringHeader("sender", StringUtils.cnulls(senderMap.get(curLocale)), curLocale);
            message.setLocaleStringHeader("initiatorName", StringUtils.cnulls(senderMap.get(curLocale)), curLocale);
        }
        message.setStringHeader("receiver", AdministratorId);
        message.setStringHeader("sourceID", sessionid);
        return message;
    }

    @Override
    public String getMsgId(String sessionId) throws BOSException {
        String sql = "select fid from T_BAS_MESSAGE where fbiztype=? and fsourceid = ? and fsendtime is not null order by fsendtime desc ";
        int[] types = new int[]{SQLType.INT.getSQLType(), SQLType.VARCHAR.getSQLType()};
        Object[] params = new Object[]{10, sessionId};
        ArrayList queryList = SQLUtil.executeQuery(this.ctx, sql, types, params);
        if (!queryList.isEmpty()) {
            Map map = (Map)queryList.get(0);
            return map.get("fid").toString();
        }
        return null;
    }
}

