/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.patch.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.receiver.BasReceiverCollection;
import com.kingdee.eas.base.receiver.BasReceiverInfo;
import com.kingdee.eas.base.uiframe.patch.IPushPatchFacade;
import com.kingdee.eas.base.uiframe.patch.RemotePatch;
import com.kingdee.eas.base.uiframe.patch.client.RemotePatchInfo;
import com.kingdee.eas.common.client.SysContext;
import java.util.List;
import org.apache.log4j.Logger;

public class PushPatch {
    private static final Logger logger = Logger.getLogger(PushPatch.class);
    private static final String PACKAGE_PATH = "com.kingdee.eas.base.uiframe.patch.PushPatchFacade";

    public static void pushPatch() {
        try {
            IPushPatchFacade facade = (IPushPatchFacade)RpcProxy.wrapRequired(IPushPatchFacade.class, (String)PACKAGE_PATH);
            boolean flag = facade.isNeedAccessRemote();
            if (!flag) {
                logger.info((Object)"\u53c2\u6570\u672a\u5f00\u542f\u6216\u8005\u8bbf\u95ee\u95f4\u9694\u65f6\u95f4\u592a\u77ed");
                return;
            }
            List<RemotePatch> remotePatchList = RemotePatchInfo.getRemotePatchList();
            for (RemotePatch remotePatch : remotePatchList) {
                facade.dealWithPatch(remotePatch);
            }
            facade.returnPatchInfo();
        }
        catch (Exception e) {
            logger.error((Object)"\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
    }

    public static void send() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PushPatch.pushPatch();
                }
                catch (Throwable t) {
                    logger.warn((Object)"\u5f02\u6b65\u8c03\u7528\u7684\u5f02\u5e38,\u5fc5\u987bhold\u4f4f", t);
                }
            }
        }, "PushPatch_Thread").start();
    }

    public static String saveMsg(String title, String content) {
        BMCMessageInfo msgInfo = new BMCMessageInfo();
        UserInfo userInfo = null;
        try {
            IUser iUser = UserFactory.getRemoteInstance();
            userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()));
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u5f97\u7528\u6237\u4fe1\u606f\u62a5\u9519");
        }
        msgInfo.setId(BOSUuid.create((BOSObjectType)msgInfo.getBOSType()));
        msgInfo.setTitle(title);
        msgInfo.setBody(content);
        if (userInfo != null) {
            msgInfo.setSender(userInfo.getName());
            msgInfo.setNreceivers(userInfo.getName());
        }
        msgInfo.setType(MsgType.ONLINE);
        msgInfo.setStatus(MsgStatus.UNREADED);
        msgInfo.setPriority(MsgPriority.HIGH);
        BasReceiverInfo receiverInfo = new BasReceiverInfo();
        receiverInfo.setType("3");
        receiverInfo.setIsShow(true);
        receiverInfo.setValue("00000000-0000-0000-0000-00000000000013B7DE7F");
        BasReceiverCollection receivers = new BasReceiverCollection();
        receivers.add(receiverInfo);
        try {
            IBMCMessage iBMCMessage = BMCMessageFactory.getRemoteInstance();
            iBMCMessage.addHandMsg(msgInfo, (IObjectCollection)receivers);
            return msgInfo.getId().toString();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            return "";
        }
    }
}

