/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class MenuDbUtil {
    private static final Logger logger = Logger.getLogger(MenuDbUtil.class);
    private static final int MAX_DATA_ROW = 8000;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void executeBatch(Connection conn, String[] sqls) throws BOSException {
        if (conn == null || sqls.length == 0) {
            throw new BOSException("connection is null or no sql is available");
        }
        Statement stmt = null;
        try {
            if (conn.getMetaData().supportsBatchUpdates()) {
                stmt = conn.createStatement();
                for (String sql : sqls) {
                    stmt.addBatch(sql);
                }
                stmt.executeBatch();
            } else {
                for (String sql : sqls) {
                    MenuDbUtil.execute(conn, sql);
                }
            }
            if (stmt == null) return;
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (stmt == null) throw throwable;
                SQLUtils.cleanup(stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        return;
    }

    public static void execute(Connection conn, String sql) throws BOSException {
        if (conn == null) {
            throw new BOSException("connection is null");
        }
        Statement statement = null;
        try {
            statement = conn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException exc) {
            logger.error((Object)("sql 1 sql is:" + sql), (Throwable)exc);
            throw new BOSException("Sql1 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            if (statement != null) {
                SQLUtils.cleanup((Statement)statement);
            }
        }
    }

    public static void execute(Connection conn, String sql, Object[] params) throws BOSException {
        if (conn == null) {
            throw new BOSException("connection is null");
        }
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            ps.execute();
        }
        catch (SQLException exc) {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < params.length; ++i) {
                sb.append("param ").append(i).append(" is:").append(params[i]);
            }
            logger.error((Object)("222 sql is:" + sql + " param is:" + sb.toString()), (Throwable)exc);
            throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            if (ps != null) {
                SQLUtils.cleanup((Statement)ps);
            }
        }
    }

    public static IRowSet executeQuery(Connection conn, String sql) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Statement statement;
        block8: {
            if (conn == null) {
                throw new BOSException("connection is null");
            }
            statement = null;
            ResultSet rs = null;
            try {
                statement = conn.createStatement();
                rs = statement.executeQuery(sql);
                JdbcRowSet rowset = new JdbcRowSet();
                rowset.populate(rs);
                jdbcRowSet = rowset;
                if (rs == null) break block8;
            }
            catch (SQLException exc) {
                try {
                    logger.error((Object)("333 sql is:" + sql), (Throwable)exc);
                    throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        SQLUtils.cleanup(rs);
                    }
                    if (statement != null) {
                        SQLUtils.cleanup((Statement)statement);
                    }
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        if (statement != null) {
            SQLUtils.cleanup((Statement)statement);
        }
        return jdbcRowSet;
    }

    public static IRowSet executeQuery(Connection conn, String sql, Object[] params) throws BOSException {
        JdbcRowSet jdbcRowSet;
        PreparedStatement ps;
        block10: {
            if (conn == null) {
                throw new BOSException("connection is null");
            }
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(sql);
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
                rs = ps.executeQuery();
                JdbcRowSet rowset = new JdbcRowSet();
                rowset.populate(rs);
                jdbcRowSet = rowset;
                if (rs == null) break block10;
            }
            catch (SQLException exc) {
                try {
                    StringBuffer sb = new StringBuffer("");
                    for (int i = 0; i < params.length; ++i) {
                        sb.append("param ").append(i).append(" is:").append(params[i]);
                    }
                    logger.error((Object)("sql is:" + sql + " param is:" + sb.toString()));
                    logger.error((Object)"sql error!", (Throwable)exc);
                    throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        SQLUtils.cleanup(rs);
                    }
                    if (ps != null) {
                        SQLUtils.cleanup((Statement)ps);
                    }
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        if (ps != null) {
            SQLUtils.cleanup((Statement)ps);
        }
        return jdbcRowSet;
    }

    public static void executeBatch(Connection conn, String sql, List paramsList) throws BOSException {
        if (conn == null) {
            throw new BOSException("connection is null");
        }
        MenuDbUtil.executeBatchAndReturn(conn, sql, paramsList);
    }

    private static int[] executeBatchAndReturn(Connection conn, String sql, List paramsList) throws BOSException {
        PreparedStatement ps = null;
        String error = "";
        try {
            ps = conn.prepareStatement(sql);
            Object[] params = null;
            int k = 1;
            boolean flag = false;
            for (int i = 0; i < paramsList.size(); ++i) {
                params = (Object[])paramsList.get(i);
                for (int j = 0; j < params.length; ++j) {
                    error = "params[" + j + "]=" + params[j];
                    if (params[j] != null) {
                        ps.setObject(j + 1, params[j]);
                        continue;
                    }
                    ps.setNull(j + 1, 12);
                }
                ps.addBatch();
                if (i == k * 8000) {
                    flag = true;
                }
                if (i <= k * 8000 || !flag) continue;
                ps.executeBatch();
                ++k;
                flag = false;
                ps.clearBatch();
            }
            if (!flag) {
                int[] nArray = ps.executeBatch();
                return nArray;
            }
        }
        catch (SQLException exc) {
            Object sb = null;
            Object params = null;
            throw new BOSException("Sql222 execute exception : " + sql + error, (Throwable)exc);
        }
        finally {
            if (ps != null) {
                SQLUtils.cleanup((Statement)ps);
            }
        }
        return new int[0];
    }
}

