/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.multilanguage.Language;
import com.kingdee.bos.ctrl.swing.DecimalFormatEx;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.base.uiframe.EASLoginException;
import com.kingdee.eas.base.uiframe.client.LoginParamCacheUtil;
import com.kingdee.eas.common.ContextManagerFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IContextManager;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.LocaleUtils;
import java.lang.reflect.Method;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class NationConfigUtils {
    private static Logger logger = Logger.getLogger(NationConfigUtils.class);

    public static void setNationConfig(Context ctx, String userId, String ouId, Locale locale) throws EASBizException, BOSException {
        String languagename = BOSLocaleUtil.getOriginalLocale((Locale)locale).toString();
        HashMap nationmap = new HashMap();
        nationmap = ctx == null ? LoginParamCacheUtil.getNationalConfig(userId, ouId, languagename) : NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(userId, ouId, languagename);
        int tt = nationmap.keySet().size();
        if (tt == 0) {
            throw new EASLoginException(EASLoginException.VERSION_MATCH_ERROR);
        }
        DecimalFormat numberFormat = (DecimalFormat)nationmap.get("numberFormat");
        DecimalFormatSymbols s = numberFormat.getDecimalFormatSymbols();
        DecimalFormat currencyFormat = (DecimalFormat)nationmap.get("currencyFormat");
        TimeZone timezone = TimeZone.getTimeZone((String)nationmap.get("timezone"));
        SimpleDateFormat dateFormat = (SimpleDateFormat)nationmap.get("dateFormat");
        SimpleDateFormat timeFormat = (SimpleDateFormat)nationmap.get("timeFormat");
        SimpleDateFormat dateTimeFormat = (SimpleDateFormat)nationmap.get("dateTimeFormat");
        String numberFormatString = numberFormat.toPattern();
        String currencyFormatString = currencyFormat.toPattern();
        String dateFormatString = dateFormat.toPattern();
        String timeFormatString = timeFormat.toPattern();
        String dateTimeFormatString = dateTimeFormat.toPattern();
        Locale.setDefault(BOSLocaleUtil.getOriginalLocale((Locale)locale));
        LocaleUtils.setDefaultLocale((Locale)locale);
        BOSLocaleUtil.setDefaultLocale((Locale)locale);
        BOSLocaleUtil.setProperty((String)"numberFormat", (Object)numberFormat);
        BOSLocaleUtil.setProperty((String)"currencyFormat", (Object)currencyFormat);
        BOSLocaleUtil.setProperty((String)"dateFormat", (Object)dateFormat);
        BOSLocaleUtil.setProperty((String)"timeFormat", (Object)timeFormat);
        BOSLocaleUtil.setProperty((String)"dateTimeFormat", (Object)dateTimeFormat);
        CtrlFormatUtilities.setFormat((String)"decimalFormat", (Format)numberFormat);
        CtrlFormatUtilities.setFormat((String)"currencyFormat", (Format)currencyFormat);
        CtrlFormatUtilities.setFormat((String)"dateFormat", (Format)dateFormat);
        CtrlFormatUtilities.setFormat((String)"timeFormat", (Format)timeFormat);
        CtrlFormatUtilities.setFormat((String)"dateTimeFormat", (Format)dateTimeFormat);
        CtrlFormatUtilities.setDecimalFormatSymbols((DecimalFormatSymbols)numberFormat.getDecimalFormatSymbols());
        CtrlFormatUtilities.setDateFormatSymbols((DateFormatSymbols)dateFormat.getDateFormatSymbols());
        CtrlFormatUtilities.setTimeZone((TimeZone)timezone);
        CtrlFormatUtilities.setTableFormatString((String)"decimalFormatForTable", (String)numberFormatString);
        CtrlFormatUtilities.setTableFormatString((String)"currencyFormatForTable", (String)currencyFormatString);
        CtrlFormatUtilities.setTableFormatString((String)"dateFormatForTable", (String)dateFormatString);
        CtrlFormatUtilities.setTableFormatString((String)"timeFormatForTable", (String)timeFormatString);
        CtrlFormatUtilities.setTableFormatString((String)"datetimeFormatForTable", (String)dateTimeFormatString);
        CtrlFormatUtilities.setTableFormatString((String)"integerFormatForTable", (String)numberFormatString);
        CtrlFormatUtilities.setEdtDisNumberFormat((DecimalFormatEx)((DecimalFormatEx)nationmap.get("ex1")), (DecimalFormatEx)((DecimalFormatEx)nationmap.get("ex2")));
        if (ctx == null) {
            SysContext.getSysContext().setProperty((Object)"dateFormat", nationmap.get("dateFormat"));
            SysContext.getSysContext().setProperty((Object)"currencyFormat", nationmap.get("currencyFormat"));
            SysContext.getSysContext().setProperty((Object)"numberFormat", nationmap.get("numberFormat"));
            SysContext.getSysContext().setProperty((Object)"timeFormat", nationmap.get("timeFormat"));
            Language.initLanguage();
        } else {
            HashMap mapctx = new HashMap();
            mapctx.put("dateFormat", nationmap.get("dateFormat"));
            mapctx.put("currencyFormat", nationmap.get("currencyFormat"));
            mapctx.put("numberFormat", nationmap.get("numberFormat"));
            mapctx.put("timeFormat", nationmap.get("timeFormat"));
            IContextManager contextManager = ContextManagerFactory.getLocalInstance((Context)ctx);
            contextManager.setContext(mapctx);
        }
        logger.info((Object)"start to check the result of I18N initialization which contains the format of time,currency and number.It's related to com.kingdee.bos.BOSLocaleUtil and com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities");
        NationConfigUtils.checkNationalInitResult(CtrlFormatUtilities.class);
        NationConfigUtils.checkNationalInitResult(BOSLocaleUtil.class);
        logger.info((Object)"end of checking the result of I18N initialization");
        DecimalFormatSymbols s2 = CtrlFormatUtilities.getDecimalFormatSymbols();
        logger.info((Object)(s2.getDecimalSeparator() + "----------"));
        logger.info((Object)(s2.getGroupingSeparator() + "========"));
    }

    private static void checkNationalInitResult(Class clazz) {
        logger.info((Object)("checkNationalInitResult begin:" + clazz.getName()));
        String simpleName = NationConfigUtils.getClassSimpleName(clazz);
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            Class<?>[] parameterTypes = methods[i].getParameterTypes();
            if ("getClass".equals(methodName) || !methodName.startsWith("get") || 0 != parameterTypes.length) continue;
            StringBuffer sb = new StringBuffer();
            sb.append(simpleName);
            sb.append(".");
            sb.append(methodName);
            sb.append("()=");
            try {
                sb.append(methods[i].invoke(CtrlFormatUtilities.class.newInstance(), new Object[0]));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            logger.info((Object)sb.toString());
        }
        logger.info((Object)("checkNationalInitResult end." + clazz.getName()));
    }

    private static String getClassSimpleName(Class clazz) {
        String fullName = clazz.getName();
        int index = fullName.lastIndexOf(46);
        int length = fullName.length();
        return fullName.substring(index + 1, length);
    }
}

